/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.sendto.config;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.dlight.sendto.api.Configuration;
import org.netbeans.modules.dlight.sendto.api.ConfigurationPanel;
import org.netbeans.modules.dlight.sendto.api.ConfigurationsModel;
import org.netbeans.modules.dlight.sendto.api.ConfigurationsRegistry;
import org.netbeans.modules.dlight.sendto.api.Handlers;
import org.netbeans.modules.dlight.sendto.spi.Handler;
import org.netbeans.modules.dlight.sendto.ui.ConfigurationNodes;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.ListView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class OptionsPanel
extends JPanel
implements ExplorerManager.Provider {
    private final ExplorerManager manager = new ExplorerManager();
    private final SelectionChangeListener listener = new SelectionChangeListener();
    private final ConfigurationChangeListener docListener = new ConfigurationChangeListener();
    private Configuration selectedConfiguration;
    private ConfigurationsModel model;
    private boolean modified;
    private JButton btnAdd;
    private JButton btnCopy;
    private JButton btnRemove;
    private JPanel buttonsPanel;
    private JComboBox cbScriptConfigurator;
    private JPanel configPanel;
    private JPanel handlersListPanel;
    private JLabel jLabel1;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel leftPanel;
    private JTextField nameFld;
    private JPanel rightPanel;

    public OptionsPanel() {
        this.initComponents();
        this.manager.addPropertyChangeListener((PropertyChangeListener)this.listener);
        this.cbScriptConfigurator.setModel(new DefaultComboBoxModel<Handler>(Handlers.getHandlers()));
        ListView h_list = new ListView();
        h_list.setSelectionMode(0);
        this.handlersListPanel.add((Component)h_list);
        this.nameFld.getDocument().addDocumentListener(this.docListener);
    }

    private void initComponents() {
        this.leftPanel = new JPanel();
        this.jLabel4 = new JLabel();
        this.handlersListPanel = new JPanel();
        this.buttonsPanel = new JPanel();
        this.btnAdd = new JButton();
        this.btnRemove = new JButton();
        this.btnCopy = new JButton();
        this.rightPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.nameFld = new JTextField();
        this.jLabel5 = new JLabel();
        this.cbScriptConfigurator = new JComboBox();
        this.configPanel = new JPanel();
        this.jLabel4.setLabelFor(this.handlersListPanel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(OptionsPanel.class, (String)"OptionsPanel.jLabel4.text"));
        this.handlersListPanel.setBorder(BorderFactory.createEtchedBorder());
        this.handlersListPanel.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.btnAdd, (String)NbBundle.getMessage(OptionsPanel.class, (String)"OptionsPanel.btnAdd.text"));
        this.btnAdd.setToolTipText(NbBundle.getMessage(OptionsPanel.class, (String)"OptionsPanel.btnAdd.toolTipText"));
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsPanel.this.btnAddActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemove, (String)NbBundle.getMessage(OptionsPanel.class, (String)"OptionsPanel.btnRemove.text"));
        this.btnRemove.setToolTipText(NbBundle.getMessage(OptionsPanel.class, (String)"OptionsPanel.btnRemove.toolTipText"));
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsPanel.this.btnRemoveActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnCopy, (String)NbBundle.getMessage(OptionsPanel.class, (String)"OptionsPanel.btnCopy.text"));
        this.btnCopy.setToolTipText(NbBundle.getMessage(OptionsPanel.class, (String)"OptionsPanel.btnCopy.toolTipText"));
        this.btnCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsPanel.this.btnCopyActionPerformed(evt);
            }
        });
        GroupLayout buttonsPanelLayout = new GroupLayout(this.buttonsPanel);
        this.buttonsPanel.setLayout(buttonsPanelLayout);
        buttonsPanelLayout.setHorizontalGroup(buttonsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(buttonsPanelLayout.createSequentialGroup().addComponent(this.btnAdd, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnRemove, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCopy, -1, -1, Short.MAX_VALUE)));
        buttonsPanelLayout.setVerticalGroup(buttonsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(buttonsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnAdd).addComponent(this.btnRemove).addComponent(this.btnCopy)));
        buttonsPanelLayout.linkSize(1, this.btnAdd, this.btnCopy, this.btnRemove);
        GroupLayout leftPanelLayout = new GroupLayout(this.leftPanel);
        this.leftPanel.setLayout(leftPanelLayout);
        leftPanelLayout.setHorizontalGroup(leftPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(leftPanelLayout.createSequentialGroup().addComponent(this.jLabel4).addContainerGap(160, Short.MAX_VALUE)).addComponent(this.handlersListPanel, -1, -1, Short.MAX_VALUE).addComponent(this.buttonsPanel, -1, -1, Short.MAX_VALUE));
        leftPanelLayout.setVerticalGroup(leftPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(leftPanelLayout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.handlersListPanel, -1, 317, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonsPanel, -2, -1, -2)));
        this.jLabel1.setLabelFor(this.nameFld);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(OptionsPanel.class, (String)"OptionsPanel.jLabel1.text"));
        this.jLabel1.setPreferredSize(new Dimension(100, 18));
        this.nameFld.setText(NbBundle.getMessage(OptionsPanel.class, (String)"OptionsPanel.nameFld.text"));
        this.nameFld.setToolTipText(NbBundle.getMessage(OptionsPanel.class, (String)"OptionsPanel.nameFld.toolTipText"));
        this.jLabel5.setText(NbBundle.getMessage(OptionsPanel.class, (String)"OptionsPanel.jLabel5.text"));
        this.jLabel5.setPreferredSize(new Dimension(100, 18));
        this.cbScriptConfigurator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsPanel.this.cbScriptConfiguratorActionPerformed(evt);
            }
        });
        this.configPanel.setLayout(new BorderLayout());
        GroupLayout rightPanelLayout = new GroupLayout(this.rightPanel);
        this.rightPanel.setLayout(rightPanelLayout);
        rightPanelLayout.setHorizontalGroup(rightPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(rightPanelLayout.createSequentialGroup().addComponent(this.jLabel5, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbScriptConfigurator, 0, 162, Short.MAX_VALUE)).addGroup(rightPanelLayout.createSequentialGroup().addComponent(this.jLabel1, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nameFld)).addComponent(this.configPanel, -1, -1, Short.MAX_VALUE));
        rightPanelLayout.linkSize(0, this.jLabel1, this.jLabel5);
        rightPanelLayout.setVerticalGroup(rightPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(rightPanelLayout.createSequentialGroup().addGroup(rightPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1, -2, -1, -2).addComponent(this.nameFld, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(rightPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5, -2, -1, -2).addComponent(this.cbScriptConfigurator, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.configPanel, -1, -1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.leftPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rightPanel, -1, -1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.leftPanel, -1, -1, Short.MAX_VALUE).addComponent(this.rightPanel, -1, -1, Short.MAX_VALUE));
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        Node[] selectedNodes = this.manager.getSelectedNodes();
        Node nodeToSelect = null;
        if (selectedNodes.length > 0) {
            int i;
            Node n = selectedNodes[0];
            Node[] nodes = this.manager.getRootContext().getChildren().getNodes();
            for (i = 0; i < nodes.length && nodes[i] != n; ++i) {
            }
            int idx = i + 1;
            if (idx >= nodes.length) {
                idx = i - 1;
            }
            nodeToSelect = idx < 0 ? null : nodes[idx];
        }
        this.model.remove(this.getSelectedConfiguration());
        if (nodeToSelect != null) {
            try {
                this.manager.setSelectedNodes(new Node[]{nodeToSelect});
            }
            catch (PropertyVetoException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.modified = true;
    }

    private void btnAddActionPerformed(ActionEvent evt) {
        Configuration newConfiguration = new Configuration();
        this.model.add(newConfiguration);
        this.selectNode(newConfiguration);
        this.cbScriptConfigurator.setSelectedIndex(0);
        this.modified = true;
    }

    private void btnCopyActionPerformed(ActionEvent evt) {
        this.updateSelectedConfiguration();
        Configuration newConfiguration = this.getSelectedConfiguration().copy();
        this.model.add(newConfiguration);
        this.selectNode(newConfiguration);
        this.modified = true;
    }

    private void cbScriptConfiguratorActionPerformed(ActionEvent evt) {
        this.configPanel.removeAll();
        Handler handler = (Handler)this.cbScriptConfigurator.getSelectedItem();
        if (handler != null) {
            Object cfgPanel = handler.getConfigurationPanel();
            ((ConfigurationPanel)cfgPanel).updatePanel(this.selectedConfiguration);
            this.configPanel.add((Component)cfgPanel);
        }
        this.configPanel.revalidate();
        this.configPanel.repaint();
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private Configuration getSelectedConfiguration() {
        Node[] selectedNodes = this.manager.getSelectedNodes();
        if (selectedNodes.length == 1 && selectedNodes[0] instanceof ConfigurationNodes.ConfigurationNode) {
            return ((ConfigurationNodes.ConfigurationNode)selectedNodes[0]).getConfiguration();
        }
        return null;
    }

    boolean isModified() {
        return this.modified;
    }

    boolean isDataValid() {
        return true;
    }

    void cancel() {
    }

    void applyChanges() {
        this.updateSelectedConfiguration();
        for (Configuration configuration : this.model.getConfigurations()) {
            configuration.applyChanges();
        }
        ConfigurationsRegistry.update(this.model);
    }

    void update() {
        this.model = ConfigurationsRegistry.getModelCopy();
        ConfigurationNodes nodes = new ConfigurationNodes(this.model);
        Configuration sc = this.selectedConfiguration;
        this.manager.setRootContext((Node)new AbstractNode((Children)nodes));
        this.modified = false;
        if (sc == null) {
            if (nodes.getNodesCount() > 0) {
                try {
                    this.manager.setSelectedNodes(new Node[]{nodes.getNodeAt(0)});
                }
                catch (PropertyVetoException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                this.listener.propertyChange(new PropertyChangeEvent(this, "selectedNodes", null, null));
            }
        } else {
            this.selectNode(sc);
        }
    }

    private void updateSelectedConfiguration() {
        if (this.selectedConfiguration != null) {
            this.selectedConfiguration.setName(this.nameFld.getText());
            Handler handler = (Handler)this.cbScriptConfigurator.getSelectedItem();
            this.selectedConfiguration.setHandler(handler);
            ((ConfigurationPanel)handler.getConfigurationPanel()).updateConfig(this.selectedConfiguration);
            this.modified |= this.selectedConfiguration.isModified();
        }
    }

    private void enableControls() {
        boolean b = this.selectedConfiguration != null;
        this.btnRemove.setEnabled(b);
        this.btnCopy.setEnabled(b);
        this.nameFld.setEnabled(b);
        this.cbScriptConfigurator.setEnabled(b);
    }

    private void selectNode(Configuration cfg) {
        Children children = this.manager.getRootContext().getChildren();
        for (Node node : children.getNodes()) {
            if (!(node instanceof ConfigurationNodes.ConfigurationNode) || ((ConfigurationNodes.ConfigurationNode)node).getConfiguration().getID().intValue() != cfg.getID().intValue()) continue;
            try {
                this.manager.setSelectedNodes(new Node[]{node});
            }
            catch (PropertyVetoException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            break;
        }
    }

    private final class ConfigurationChangeListener
    implements DocumentListener,
    ActionListener {
        private ConfigurationChangeListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update(e);
        }

        private void update(DocumentEvent e) {
            OptionsPanel.this.modified = true;
            if (e.getDocument() == OptionsPanel.this.nameFld.getDocument() && OptionsPanel.this.selectedConfiguration != null) {
                OptionsPanel.this.selectedConfiguration.setName(OptionsPanel.this.nameFld.getText());
                ((ConfigurationNodes.ConfigurationNode)OptionsPanel.this.manager.getSelectedNodes()[0]).updateName();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OptionsPanel.this.modified = true;
        }
    }

    private final class SelectionChangeListener
    implements PropertyChangeListener {
        private SelectionChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("selectedNodes".equals(evt.getPropertyName())) {
                OptionsPanel.this.updateSelectedConfiguration();
                OptionsPanel.this.selectedConfiguration = OptionsPanel.this.getSelectedConfiguration();
                this.setContent(OptionsPanel.this.selectedConfiguration);
            }
        }

        private void setContent(Configuration cfg) {
            OptionsPanel.this.nameFld.setText(cfg == null ? "" : cfg.getName());
            OptionsPanel.this.cbScriptConfigurator.setSelectedItem(cfg == null ? null : cfg.getHandler());
            OptionsPanel.this.enableControls();
            OptionsPanel.this.modified = false;
        }
    }
}

