/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassForwardDeclaration;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmConstructor;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumForwardDeclaration;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFriend;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmFunctionParameterList;
import org.netbeans.modules.cnd.api.model.CsmFunctionPointerClassifier;
import org.netbeans.modules.cnd.api.model.CsmFunctionPointerType;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameterType;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypeAlias;
import org.netbeans.modules.cnd.api.model.CsmTypeBasedSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmUsingDeclaration;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVariableDefinition;
import org.netbeans.modules.cnd.api.model.CsmVariadicSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.api.model.services.CsmInstantiationProvider;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.ClassImpl;
import org.netbeans.modules.cnd.modelimpl.csm.DeclTypeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionParameterListImpl;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateParameterTypeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateUtils;
import org.netbeans.modules.cnd.modelimpl.csm.TypeFactory;
import org.netbeans.modules.cnd.modelimpl.csm.TypeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableIdentifiableBase;
import org.netbeans.modules.cnd.modelimpl.csm.resolver.Resolver;
import org.netbeans.modules.cnd.modelimpl.csm.resolver.ResolverFactory;
import org.netbeans.modules.cnd.modelimpl.impl.services.InstantiationProviderImpl;
import org.netbeans.modules.cnd.modelimpl.impl.services.MemberResolverImpl;
import org.netbeans.modules.cnd.modelimpl.impl.services.SelectImpl;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDProviderIml;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.modelimpl.util.MapHierarchy;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.netbeans.modules.cnd.utils.CndCollectionUtils;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.openide.util.Pair;

public abstract class Instantiation<T extends CsmOffsetableDeclaration>
extends OffsetableIdentifiableBase<CsmInstantiation>
implements CsmOffsetableDeclaration,
CsmInstantiation,
CsmIdentifiable {
    private static final int MAX_RECURSIVE_INSTANTIATIONS = 10;
    private static final int MAX_INHERITANCE_DEPTH = 20;
    private static final Logger LOG = Logger.getLogger(Instantiation.class.getSimpleName());
    protected final T declaration;
    protected final Map<CsmTemplateParameter, CsmSpecializationParameter> mapping;
    protected int hashCode = 0;

    private Instantiation(T declaration, Map<CsmTemplateParameter, CsmSpecializationParameter> mapping) {
        super(declaration.getContainingFile(), declaration.getStartOffset(), declaration.getEndOffset());
        this.declaration = declaration;
        this.mapping = mapping;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CsmObject)) {
            return false;
        }
        CsmObject csmobj = (CsmObject)obj;
        if (!CsmKindUtilities.isInstantiation((CsmObject)csmobj)) {
            return false;
        }
        CsmInstantiation inst = (CsmInstantiation)csmobj;
        if (inst instanceof Instantiation && this.hashCode != ((Instantiation)inst).hashCode && this.hashCode != 0 && ((Instantiation)inst).hashCode != 0) {
            return false;
        }
        if (!CndCollectionUtils.equals(this.getMapping(), (Map)inst.getMapping())) {
            return false;
        }
        return this.getTemplateDeclaration().equals(inst.getTemplateDeclaration());
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            int hash = 3;
            hash = 31 * hash + (this.declaration != null ? this.declaration.hashCode() : 0);
            this.hashCode = hash = 31 * hash + (this.mapping != null ? CndCollectionUtils.hashCode(this.mapping) : 0);
        }
        return this.hashCode;
    }

    @Override
    public String toString() {
        return this.toString(new StringBuilder(), 0);
    }

    private String toString(StringBuilder out, int indent) {
        Instantiation.indent(out, indent).append("INSTANTIATION OF ");
        String instName = this.getClass().getSimpleName() + "@" + System.identityHashCode(this);
        out.append(instName).append(":\n");
        if (this.declaration instanceof Instantiation) {
            ((Instantiation)this.declaration).toString(out, indent + 2);
        } else {
            Instantiation.indent(out, indent + 2);
            out.append(this.declaration);
        }
        out.append("\n");
        if (!this.mapping.isEmpty()) {
            Instantiation.indent(out, indent).append("WITH MAPPING:\n");
            for (Map.Entry<CsmTemplateParameter, CsmSpecializationParameter> entry : this.mapping.entrySet()) {
                Instantiation.indent(out, indent).append("[").append(entry.getKey()).append("]=>{");
                out.append(entry.getValue()).append("}\n");
            }
        }
        Instantiation.indent(out, indent).append("END OF ").append(instName);
        return out.toString();
    }

    protected static StringBuilder indent(StringBuilder b, int level) {
        for (int i = 0; i < level; ++i) {
            b.append(' ');
        }
        return b;
    }

    private CsmClassForwardDeclaration findCsmClassForwardDeclaration(CsmScope scope, CsmClass cls) {
        if (scope != null) {
            CsmClassForwardDeclaration fdecl;
            CsmOffsetableDeclaration decl;
            Iterator it;
            Iterator declarations;
            CsmSelect.CsmFilter filter;
            if (CsmKindUtilities.isFile((CsmObject)scope)) {
                CsmFile file = (CsmFile)scope;
                filter = CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.CLASS_FORWARD_DECLARATION});
                it = declarations = CsmSelect.getDeclarations((CsmFile)file, (CsmSelect.CsmFilter)filter);
                while (it.hasNext()) {
                    decl = (CsmOffsetableDeclaration)it.next();
                    if (!((CsmClassForwardDeclaration)decl).getCsmClass().equals(cls)) continue;
                    return (CsmClassForwardDeclaration)decl;
                }
                filter = CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.NAMESPACE_DEFINITION});
                it = declarations = CsmSelect.getDeclarations((CsmFile)file, (CsmSelect.CsmFilter)filter);
                while (it.hasNext()) {
                    decl = (CsmOffsetableDeclaration)it.next();
                    fdecl = this.findCsmClassForwardDeclaration((CsmScope)((CsmNamespaceDefinition)decl), cls);
                    if (fdecl == null) continue;
                    return fdecl;
                }
            }
            if (CsmKindUtilities.isNamespaceDefinition((CsmObject)scope)) {
                CsmNamespaceDefinition nsd = (CsmNamespaceDefinition)scope;
                filter = CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.CLASS_FORWARD_DECLARATION});
                it = declarations = CsmSelect.getDeclarations((CsmNamespaceDefinition)nsd, (CsmSelect.CsmFilter)filter);
                while (it.hasNext()) {
                    decl = (CsmOffsetableDeclaration)it.next();
                    if (!((CsmClassForwardDeclaration)decl).getCsmClass().equals(cls)) continue;
                    return (CsmClassForwardDeclaration)decl;
                }
                filter = CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.NAMESPACE_DEFINITION});
                it = declarations = CsmSelect.getDeclarations((CsmNamespaceDefinition)nsd, (CsmSelect.CsmFilter)filter);
                while (it.hasNext()) {
                    decl = (CsmOffsetableDeclaration)it.next();
                    fdecl = this.findCsmClassForwardDeclaration((CsmScope)((CsmNamespaceDefinition)decl), cls);
                    if (fdecl == null) continue;
                    return fdecl;
                }
            }
        }
        return null;
    }

    public T getTemplateDeclaration() {
        return this.declaration;
    }

    public Map<CsmTemplateParameter, CsmSpecializationParameter> getMapping() {
        return this.mapping;
    }

    @Override
    public boolean isValid() {
        return CsmBaseUtilities.isValid(this.declaration);
    }

    public static CsmObject create(CsmTemplate template, Map<CsmTemplateParameter, CsmSpecializationParameter> mapping) {
        if (Instantiation.canSkipInstantiation((CsmObject)template, mapping)) {
            return template;
        }
        if (template instanceof CsmClass) {
            CsmFile file;
            Class newClass = new Class((CsmClass)template, mapping);
            if (UIDProviderIml.isPersistable(newClass.getUID()) && (file = newClass.getContainingFile()) instanceof FileImpl) {
                ((FileImpl)file).addInstantiation(newClass);
            }
            return newClass;
        }
        if (CsmKindUtilities.isFunctionPointerClassifier((CsmObject)template)) {
            return new FunctionPointerClassifier((CsmFunctionPointerClassifier)template, mapping);
        }
        if (template instanceof CsmConstructor) {
            return new Constructor((CsmMethod)((CsmConstructor)template), mapping);
        }
        if (template instanceof CsmMethod) {
            return new Method((CsmMethod)template, mapping);
        }
        if (template instanceof CsmFunction) {
            return new Function((CsmFunction)template, mapping);
        }
        if (template instanceof CsmTypeAlias) {
            CsmTypeAlias alias = (CsmTypeAlias)template;
            return CsmKindUtilities.isClassMember((CsmObject)alias) ? new MemberTypeAlias(alias, mapping) : new TypeAlias(alias, mapping);
        }
        if (CndUtils.isDebugMode()) {
            CndUtils.assertTrueInConsole((boolean)false, (String)("Unknown class " + template.getClass() + " for template instantiation:" + template));
        }
        return template;
    }

    private static boolean canSkipInstantiation(CsmObject template, Map<CsmTemplateParameter, CsmSpecializationParameter> mapping) {
        if (mapping == null || mapping.isEmpty()) {
            return true;
        }
        CsmObject current = template instanceof Inheritance ? ((Inheritance)template).getAncestorType() : template;
        int depth = 0;
        while (CsmKindUtilities.isInstantiation((CsmObject)current) || current instanceof Type) {
            ++depth;
            Map origMapping = null;
            if (CsmKindUtilities.isInstantiation((CsmObject)current)) {
                origMapping = ((CsmInstantiation)current).getMapping();
                current = ((CsmInstantiation)current).getTemplateDeclaration();
            } else {
                if (!(current instanceof Type)) break;
                origMapping = ((Type)current).getInstantiation().getMapping();
                current = ((Type)current).originalType;
            }
            if (origMapping != mapping) continue;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "REFUSE TO INSTANTITATE:\n{0}\n", new Object[]{template});
            }
            return true;
        }
        return depth > 10 && Instantiation.isRecursiveInstantiation(template, mapping, 10);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isRecursiveInstantiation(CsmObject template, Map<CsmTemplateParameter, CsmSpecializationParameter> mapping, int recursionLimit) {
        CsmObject current = template instanceof Inheritance ? ((Inheritance)template).getAncestorType() : template;
        HashMap<TemplateMapKey, Integer> repeatings = new HashMap<TemplateMapKey, Integer>();
        if (mapping != null) {
            repeatings.put(new TemplateMapKey(mapping), 1);
        }
        while (CsmKindUtilities.isInstantiation((CsmObject)current) || current instanceof Type) {
            Map origMapping = null;
            if (CsmKindUtilities.isInstantiation((CsmObject)current)) {
                origMapping = ((CsmInstantiation)current).getMapping();
                current = ((CsmInstantiation)current).getTemplateDeclaration();
            } else {
                if (!(current instanceof Type)) return false;
                origMapping = ((Type)current).getInstantiation().getMapping();
                current = ((Type)current).originalType;
            }
            TemplateMapKey mapKey = new TemplateMapKey(origMapping);
            Integer counter = (Integer)repeatings.get(mapKey);
            if (counter != null) {
                if (counter >= recursionLimit) return true;
                counter = counter + 1;
            } else {
                counter = 1;
            }
            repeatings.put(mapKey, counter);
        }
        return false;
    }

    @Override
    public CsmFile getContainingFile() {
        return this.getTemplateDeclaration().getContainingFile();
    }

    @Override
    public CharSequence getText() {
        return this.getTemplateDeclaration().getText();
    }

    public CsmDeclaration.Kind getKind() {
        return this.getTemplateDeclaration().getKind();
    }

    public CharSequence getUniqueName() {
        return this.getTemplateDeclaration().getUniqueName();
    }

    public CharSequence getQualifiedName() {
        return this.getTemplateDeclaration().getQualifiedName();
    }

    public CharSequence getName() {
        return this.getTemplateDeclaration().getName();
    }

    public CsmScope getScope() {
        return this.getTemplateDeclaration().getScope();
    }

    @Override
    protected CsmUID<?> createUID() {
        return Instantiation.createInstantiationUID(this);
    }

    public static <T extends CsmInstantiation> CsmUID<?> createInstantiationUID(CsmInstantiation inst) {
        if (CsmKindUtilities.isClass((CsmObject)inst) && inst.getTemplateDeclaration() instanceof ClassImpl) {
            boolean persistable;
            Map mapping = inst.getMapping();
            boolean bl = persistable = !mapping.isEmpty();
            if (persistable) {
                for (Map.Entry param : mapping.entrySet()) {
                    CsmSpecializationParameter specParam = (CsmSpecializationParameter)param.getValue();
                    if (CsmKindUtilities.isTypeBasedSpecalizationParameter((CsmObject)specParam)) {
                        if (!PersistentUtils.isPersistable(((CsmTypeBasedSpecializationParameter)specParam).getType())) {
                            persistable = false;
                            break;
                        }
                        if (Instantiation.isScopePersistable(specParam.getScope())) continue;
                        persistable = false;
                        break;
                    }
                    persistable = false;
                    break;
                }
            }
            if (persistable) {
                return UIDUtilities.createInstantiationUID(inst);
            }
        }
        return new InstantiationSelfUID((Instantiation)inst);
    }

    private static boolean isScopePersistable(CsmScope scope) {
        if (scope != null) {
            if (scope instanceof CsmIdentifiable) {
                return UIDProviderIml.isPersistable(((CsmIdentifiable)scope).getUID());
            }
            return false;
        }
        return true;
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        assert (this.declaration instanceof ClassImpl);
        UIDObjectFactory factory = UIDObjectFactory.getDefaultFactory();
        factory.writeUID(UIDCsmConverter.declarationToUID(this.declaration), output);
        ArrayList keys = new ArrayList();
        ArrayList<CsmSpecializationParameter> vals = new ArrayList<CsmSpecializationParameter>();
        for (CsmTemplateParameter key : this.mapping.keySet()) {
            keys.add(UIDCsmConverter.declarationToUID(key));
            vals.add(this.mapping.get(key));
        }
        factory.writeUIDCollection(keys, output, true);
        PersistentUtils.writeSpecializationParameters(vals, output);
    }

    public Instantiation(RepositoryDataInput input) throws IOException {
        super(input);
        UIDObjectFactory factory = UIDObjectFactory.getDefaultFactory();
        CsmUID declUID = factory.readUID(input);
        this.declaration = (CsmOffsetableDeclaration)declUID.getObject();
        ArrayList keys = new ArrayList();
        ArrayList<CsmSpecializationParameter> vals = new ArrayList<CsmSpecializationParameter>();
        factory.readUIDCollection(keys, input);
        PersistentUtils.readSpecializationParameters(vals, input);
        this.mapping = new HashMap<CsmTemplateParameter, CsmSpecializationParameter>();
        for (int i = 0; i < keys.size() && i < vals.size(); ++i) {
            this.mapping.put((CsmTemplateParameter)((CsmUID)keys.get(i)).getObject(), (CsmSpecializationParameter)vals.get(i));
        }
    }

    public static CsmType createType(CsmType type, CsmInstantiation instantiation) {
        return Instantiation.createType(type, instantiation, new TemplateParameterResolver());
    }

    public static CsmType createType(CsmType type, List<CsmInstantiation> instantiations) {
        CsmType result = type;
        for (CsmInstantiation instantiation : instantiations) {
            result = Instantiation.createType(result, instantiation);
        }
        return result;
    }

    private static CsmType createType(CsmType type, CsmInstantiation instantiation, TemplateParameterResolver templateParamResolver) {
        if (type == null) {
            throw new NullPointerException("no type for " + instantiation);
        }
        if (Instantiation.canSkipInstantiation((CsmObject)type, instantiation.getMapping())) {
            return type;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Instantiation.createType {0}; inst:{1}\n", new Object[]{type.getText(), instantiation.getTemplateDeclaration().getName()});
        }
        if (CsmKindUtilities.isTemplateParameterType((CsmObject)type)) {
            CsmType instantiatedType = templateParamResolver.clone().resolveTemplateParameterType(type, instantiation);
            if (instantiatedType == null) {
                return new TemplateParameterType(type, instantiation, templateParamResolver);
            }
            if (CsmKindUtilities.isTemplateParameterType((CsmObject)instantiatedType)) {
                if (instantiatedType != type) {
                    return new TemplateParameterType(type, instantiation, templateParamResolver);
                }
                return type;
            }
            if (instantiatedType instanceof org.netbeans.modules.cnd.modelimpl.csm.NestedType) {
                return new NestedTemplateParameterType(type, instantiation, templateParamResolver);
            }
            if (CsmKindUtilities.isFunctionPointerType((CsmObject)instantiatedType)) {
                return new FunPtrTemplateParameterType(type, instantiation, templateParamResolver);
            }
        }
        if (type instanceof NestedTemplateParameterType) {
            return new NestedTemplateParameterType(type, instantiation, templateParamResolver);
        }
        if (type instanceof FunPtrTemplateParameterType) {
            return new FunPtrTemplateParameterType(type, instantiation, templateParamResolver);
        }
        if (Instantiation.isNestedType(type)) {
            return new NestedType(type, instantiation, templateParamResolver);
        }
        if (type instanceof DeclTypeImpl || type instanceof Decltype) {
            return new Decltype(type, instantiation, templateParamResolver);
        }
        if (CsmKindUtilities.isFunctionPointerType((CsmObject)type)) {
            return new TypeFunPtr((CsmFunctionPointerType)type, instantiation, templateParamResolver);
        }
        return new Type(type, instantiation, templateParamResolver);
    }

    public static boolean isRecursiveInstantiation(CsmObject instantiation) {
        return Instantiation.isRecursiveInstantiation(instantiation, null, 9);
    }

    public static CsmType unfoldInstantiatedType(CsmType type) {
        return Instantiation.unfoldInstantiatedType(type, Integer.MAX_VALUE);
    }

    public static CsmType unfoldInstantiatedType(CsmType type, int iterations) {
        CsmType result = type;
        while (result instanceof Type && iterations > 0) {
            result = ((Type)result).instantiatedType;
            --iterations;
        }
        return result;
    }

    public static CsmType unfoldOriginalType(CsmType type) {
        return Instantiation.unfoldOriginalType(type, Integer.MAX_VALUE);
    }

    public static CsmType unfoldOriginalType(CsmType type, int iterations) {
        CsmType result = type;
        while (result instanceof Type && iterations > 0) {
            result = ((Type)result).originalType;
            --iterations;
        }
        return result;
    }

    public static boolean isInstantiatedType(CsmType type) {
        return type instanceof Type;
    }

    public static int getInstantiationDepth(CsmType type) {
        int depth = 0;
        while (type instanceof Type) {
            ++depth;
            type = ((Type)type).originalType;
        }
        return depth;
    }

    public static CsmInstantiation getInstantiatedTypeInstantiation(CsmType type) {
        if (Instantiation.isInstantiatedType(type)) {
            return ((Type)type).getInstantiation();
        }
        return null;
    }

    public static List<CsmInstantiation> getInstantiatedTypeInstantiations(CsmType type) {
        if (Instantiation.isInstantiatedType(type)) {
            ArrayList<CsmInstantiation> insts = new ArrayList<CsmInstantiation>();
            while (type instanceof Type) {
                insts.add(((Type)type).getInstantiation());
                type = ((Type)type).originalType;
            }
            return insts;
        }
        return null;
    }

    public static boolean isNestedType(CsmType type) {
        return type instanceof org.netbeans.modules.cnd.modelimpl.csm.NestedType || type instanceof NestedType;
    }

    public static boolean isTemplateBasedInstantiation(CsmInstantiation inst) {
        return Instantiation.isTemplateBasedInstantiation(inst, new IdentityHashMap<CsmInstantiation, Boolean>(2));
    }

    private static boolean isTemplateBasedInstantiation(CsmInstantiation inst, Map<CsmInstantiation, Boolean> visited) {
        if (!visited.containsKey(inst)) {
            visited.put(inst, Boolean.TRUE);
            for (CsmSpecializationParameter param : inst.getMapping().values()) {
                if (!Instantiation.isTemplateBasedParameter(param, visited)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isTemplateBasedParameter(CsmSpecializationParameter param, Map<CsmInstantiation, Boolean> visited) {
        if (CsmKindUtilities.isTypeBasedSpecalizationParameter((CsmObject)param)) {
            CsmType type = ((CsmTypeBasedSpecializationParameter)param).getType();
            if (CsmKindUtilities.isTemplateParameterType((CsmObject)type)) {
                return true;
            }
            if (type instanceof Type) {
                return Instantiation.isTemplateBasedInstantiation(((Type)type).getInstantiation(), visited);
            }
        } else if (CsmKindUtilities.isVariadicSpecalizationParameter((CsmObject)param)) {
            for (CsmSpecializationParameter inner : ((CsmVariadicSpecializationParameter)param).getArgs()) {
                if (!Instantiation.isTemplateBasedParameter(inner, visited)) continue;
                return true;
            }
        }
        return false;
    }

    private static CsmClassifier getNestedClassifier(MemberResolverImpl memberResolver, CsmClassifier parentClassifier, CharSequence ownText) {
        return org.netbeans.modules.cnd.modelimpl.csm.NestedType.getNestedClassifier(memberResolver, parentClassifier, ownText);
    }

    public static CharSequence getOriginalText(CsmType type) {
        if (type instanceof Type) {
            return Instantiation.getOriginalText(((Type)type).originalType);
        }
        return type.getText();
    }

    public static CharSequence getInstantiatedText(CsmType type) {
        if (type instanceof Type) {
            return ((Type)type).getInstantiatedText();
        }
        return type.getText();
    }

    public static CharSequence getInstantiationCanonicalText(List<CsmSpecializationParameter> params) {
        return Instantiation.getInstantiationCanonicalText(new SimpleInstantiationParamsInfo(params), new DefaultSpecParamTextProvider());
    }

    public static CharSequence getInstantiationCanonicalText(InstantiationProviderImpl.InstantiationParametersInfo paramsInfo, CsmSpecializationParamTextProvider specParamTextProvider) {
        List<Pair<CsmSpecializationParameter, List<CsmInstantiation>>> params = paramsInfo.getExpandedParams();
        List<CsmType> types = paramsInfo.getParamsTypes();
        if (params == null || params.isEmpty()) {
            return "";
        }
        assert (params.size() == types.size()) : "Arrays of params and their types must have equal sizes!";
        Iterator<Pair<CsmSpecializationParameter, List<CsmInstantiation>>> paramsIter = params.iterator();
        Iterator<CsmType> typesIter = types.iterator();
        StringBuilder sb = new StringBuilder();
        sb.append('<');
        boolean first = true;
        while (paramsIter.hasNext() && typesIter.hasNext()) {
            Pair<CsmSpecializationParameter, List<CsmInstantiation>> pair = paramsIter.next();
            CsmSpecializationParameter param = (CsmSpecializationParameter)pair.first();
            List context = (List)pair.second();
            CsmType paramType = typesIter.next();
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(specParamTextProvider.getSpecParamText(param, paramType, context));
        }
        TemplateUtils.addGREATERTHAN(sb);
        return sb;
    }

    public static CsmSpecializationParameter resolveTemplateParameter(CsmTemplateParameter templateParameter, MapHierarchy<CsmTemplateParameter, CsmSpecializationParameter> mapping) {
        return new TemplateParameterResolver().resolveTemplateParameter(templateParameter, mapping);
    }

    /* synthetic */ Instantiation(CsmOffsetableDeclaration x0, Map x1, 1 x2) {
        this(x0, x1);
    }

    private static class SimpleInstantiationParamsInfo
    implements InstantiationProviderImpl.InstantiationParametersInfo {
        private final List<Pair<CsmSpecializationParameter, List<CsmInstantiation>>> parameters;
        private final List<CsmType> types;

        public SimpleInstantiationParamsInfo(List<CsmSpecializationParameter> parameters) {
            this.parameters = new ArrayList<Pair<CsmSpecializationParameter, List<CsmInstantiation>>>(parameters.size());
            this.types = new ArrayList<CsmType>(parameters.size());
            for (CsmSpecializationParameter param : parameters) {
                this.parameters.add((Pair<CsmSpecializationParameter, List<CsmInstantiation>>)Pair.of((Object)param, Collections.emptyList()));
                if (CsmKindUtilities.isTypeBasedSpecalizationParameter((CsmObject)param)) {
                    this.types.add(((CsmTypeBasedSpecializationParameter)param).getType());
                    continue;
                }
                this.types.add(null);
            }
        }

        @Override
        public List<Pair<CsmSpecializationParameter, List<CsmInstantiation>>> getOriginalParams() {
            return this.parameters;
        }

        @Override
        public List<Pair<CsmSpecializationParameter, List<CsmInstantiation>>> getExpandedParams() {
            return this.parameters;
        }

        @Override
        public List<CsmType> getParamsTypes() {
            return this.types;
        }

        @Override
        public boolean isVariadic() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public List<CsmSpecializationParameter> getInstParams() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public List<String> getParamsTexts() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    public static class TemplateParameterResolver
    implements Cloneable {
        private static final int RESOLVED_LIMIT = 32;
        private final Set<CsmTemplateParameter> lastResolvedParameters = new HashSet<CsmTemplateParameter>();

        public TemplateParameterResolver() {
            this(Collections.emptySet());
        }

        public TemplateParameterResolver(Set<CsmTemplateParameter> lastResolvedParameters) {
            this.lastResolvedParameters.addAll(lastResolvedParameters);
        }

        public CsmType resolveTemplateParameterType(CsmType type, CsmInstantiation instantiation) {
            if (CsmKindUtilities.isTemplateParameterType((CsmObject)type)) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Instantiation.resolveTemplateParameter {0}; mapping={1}\n", new Object[]{type.getText(), instantiation.getTemplateDeclaration().getName()});
                }
                MapHierarchy<CsmTemplateParameter, CsmSpecializationParameter> mapping = new MapHierarchy<CsmTemplateParameter, CsmSpecializationParameter>(instantiation.getMapping());
                CsmTemplateParameter param = ((CsmTemplateParameterType)type).getParameter();
                if (param != null) {
                    CsmType resolvedType = this.resolveTemplateParameterType(param, mapping);
                    if (resolvedType != null) {
                        return resolvedType;
                    }
                } else {
                    LOG.log(Level.INFO, "no param for " + type + " and \n" + instantiation, new IllegalStateException());
                }
            }
            return type;
        }

        public CsmType resolveTemplateParameterType(CsmTemplateParameter templateParameter, MapHierarchy<CsmTemplateParameter, CsmSpecializationParameter> mapping) {
            CsmSpecializationParameter resolvedParam = this.resolveTemplateParameter(templateParameter, mapping);
            if (resolvedParam != null && resolvedParam instanceof CsmTypeBasedSpecializationParameter) {
                return ((CsmTypeBasedSpecializationParameter)resolvedParam).getType();
            }
            return null;
        }

        public CsmSpecializationParameter resolveTemplateParameter(CsmTemplateParameter templateParameter, MapHierarchy<CsmTemplateParameter, CsmSpecializationParameter> mapping) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Instantiation.resolveTemplateParameter {0}; mapping={1}\n", new Object[]{templateParameter.getName(), mapping.size()});
            }
            if (this.lastResolvedParameters.size() > 32) {
                return null;
            }
            CsmSpecializationParameter instantiatedParam = mapping.get(templateParameter);
            for (int iteration = 20; CsmKindUtilities.isTypeBasedSpecalizationParameter((CsmObject)instantiatedParam) && CsmKindUtilities.isTemplateParameterType((CsmObject)((CsmTypeBasedSpecializationParameter)instantiatedParam).getType()) && iteration != 0; --iteration) {
                CsmTemplateParameter nextTemplateParameter = ((CsmTemplateParameterType)((CsmTypeBasedSpecializationParameter)instantiatedParam).getType()).getParameter();
                CsmSpecializationParameter nextInstantiatedParam = mapping.get(templateParameter);
                if (nextInstantiatedParam == null) break;
                instantiatedParam = nextInstantiatedParam;
                templateParameter = nextTemplateParameter;
            }
            if (instantiatedParam != null) {
                for (CsmTemplateParameter alreadyResolvedParam : this.lastResolvedParameters) {
                    if (alreadyResolvedParam.getScope() != templateParameter.getScope() || alreadyResolvedParam.getStartOffset() > templateParameter.getStartOffset()) continue;
                    return null;
                }
                this.lastResolvedParameters.add(templateParameter);
                return instantiatedParam;
            }
            return null;
        }

        public CsmInstantiation alterInstantiation(CsmInstantiation instantiation) {
            if (!this.lastResolvedParameters.isEmpty() && CsmKindUtilities.isTemplate((CsmObject)instantiation.getTemplateDeclaration())) {
                Object firstResolved = null;
                Object firstParam = null;
                Map mapping = instantiation.getMapping();
                for (Object templateParam : mapping.keySet()) {
                    if (this.lastResolvedParameters.contains(templateParam)) {
                        if (firstResolved == null) {
                            firstResolved = templateParam;
                        } else if (templateParam.getStartOffset() <= firstResolved.getStartOffset()) {
                            firstResolved = templateParam;
                        }
                    }
                    if (firstParam == null) {
                        firstParam = templateParam;
                        continue;
                    }
                    if (templateParam.getStartOffset() > firstParam.getStartOffset()) continue;
                    firstParam = templateParam;
                }
                if (firstResolved == null) {
                    return instantiation;
                }
                if (firstResolved != firstParam) {
                    HashMap<CsmTemplateParameter, CsmSpecializationParameter> newMapping = new HashMap<CsmTemplateParameter, CsmSpecializationParameter>();
                    for (Map.Entry entry : mapping.entrySet()) {
                        if (((CsmTemplateParameter)entry.getKey()).getStartOffset() >= firstResolved.getStartOffset()) continue;
                        newMapping.put((CsmTemplateParameter)entry.getKey(), (CsmSpecializationParameter)entry.getValue());
                    }
                    CsmObject instantiated = Instantiation.create((CsmTemplate)instantiation.getTemplateDeclaration(), newMapping);
                    if (CsmKindUtilities.isInstantiation((CsmObject)instantiated)) {
                        return (CsmInstantiation)instantiated;
                    }
                } else {
                    return null;
                }
            }
            return instantiation;
        }

        protected TemplateParameterResolver clone() {
            return new TemplateParameterResolver(this.lastResolvedParameters);
        }
    }

    public static class DefaultSpecParamTextProvider
    implements CsmSpecializationParamTextProvider {
        @Override
        public CharSequence getSpecParamText(CsmSpecializationParameter param, CsmType paramType, List<CsmInstantiation> context) {
            if (CsmKindUtilities.isTypeBasedSpecalizationParameter((CsmObject)param)) {
                return TypeImpl.getCanonicalText(paramType);
            }
            if (CsmKindUtilities.isExpressionBasedSpecalizationParameter((CsmObject)param)) {
                return param.getText();
            }
            if (CsmKindUtilities.isVariadicSpecalizationParameter((CsmObject)param)) {
                return param.getText();
            }
            return "";
        }
    }

    public static interface CsmSpecializationParamTextProvider {
        public CharSequence getSpecParamText(CsmSpecializationParameter var1, CsmType var2, List<CsmInstantiation> var3);
    }

    public static final class InstantiationSelfUID
    implements CsmUID<CsmInstantiation>,
    SelfPersistent {
        private final Instantiation ref;

        private InstantiationSelfUID(Instantiation ref) {
            this.ref = ref;
        }

        public Instantiation getObject() {
            return this.ref;
        }

        public void write(RepositoryDataOutput output) throws IOException {
        }

        public InstantiationSelfUID(RepositoryDataInput input) throws IOException {
            this.ref = null;
        }
    }

    private static class NestedType
    extends Type {
        private final CsmType parentType;

        private NestedType(CsmType type, CsmInstantiation instantiation, TemplateParameterResolver templateParamResolver) {
            super(type, instantiation, templateParamResolver);
            if (type instanceof org.netbeans.modules.cnd.modelimpl.csm.NestedType) {
                org.netbeans.modules.cnd.modelimpl.csm.NestedType t = (org.netbeans.modules.cnd.modelimpl.csm.NestedType)type;
                CsmType parent = t.getParent();
                this.parentType = parent != null ? Instantiation.createType(parent, instantiation, templateParamResolver) : null;
            } else if (type instanceof NestedType) {
                NestedType t = (NestedType)type;
                CsmType parent = t.parentType;
                this.parentType = parent != null ? Instantiation.createType(parent, instantiation, templateParamResolver) : null;
            } else {
                this.parentType = null;
            }
        }

        @Override
        public CsmClassifier getClassifier() {
            return this.getClassifier(new ArrayList<CsmInstantiation>(), false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CsmClassifier getClassifier(List<CsmInstantiation> instantiations, boolean specialize) {
            instantiations.add(this.instantiation);
            Object resolved = this.getCachedResolved(instantiations);
            if (resolved == null) {
                Resolver resolver;
                CsmObject obj;
                CsmInstantiationProvider ip;
                if (!this.instantiationHappened()) {
                    CsmClassifier parentClassifier;
                    if (this.parentType != null && CsmBaseUtilities.isValid((CsmObject)(parentClassifier = this.parentType instanceof TypeImpl ? ((TypeImpl)this.parentType).getClassifier(instantiations, false) : this.parentType.getClassifier()))) {
                        MemberResolverImpl memberResolver = new MemberResolverImpl();
                        if (this.instantiatedType instanceof org.netbeans.modules.cnd.modelimpl.csm.NestedType) {
                            resolved = Instantiation.getNestedClassifier(memberResolver, parentClassifier, ((org.netbeans.modules.cnd.modelimpl.csm.NestedType)this.instantiatedType).getOwnText());
                        } else if (this.instantiatedType instanceof NestedType) {
                            resolved = Instantiation.getNestedClassifier(memberResolver, parentClassifier, ((NestedType)this.instantiatedType).getOwnText());
                        }
                    }
                    if (this.isInstantiation() && CsmKindUtilities.isTemplate((CsmObject)resolved) && !((CsmTemplate)resolved).getTemplateParameters().isEmpty()) {
                        block25: {
                            ip = CsmInstantiationProvider.getDefault();
                            obj = null;
                            if (ip instanceof InstantiationProviderImpl) {
                                resolver = ResolverFactory.createResolver((CsmOffsetable)this);
                                try {
                                    if (!resolver.isRecursionOnResolving(200)) {
                                        obj = this.instantiateResolved((InstantiationProviderImpl)ip, (CsmClassifier)resolved, specialize);
                                        break block25;
                                    }
                                    CsmClassifier csmClassifier = null;
                                    return csmClassifier;
                                }
                                finally {
                                    ResolverFactory.releaseResolver(resolver);
                                }
                            }
                            obj = ip.instantiate((CsmTemplate)resolved, (CsmType)this);
                        }
                        if (CsmKindUtilities.isClassifier((CsmObject)obj)) {
                            resolved = (CsmClassifier)obj;
                        }
                    }
                }
                if (resolved == null) {
                    resolved = this.instantiatedType instanceof TypeImpl ? ((TypeImpl)this.instantiatedType).getClassifier(instantiations, false) : (this.instantiatedType instanceof Type ? ((Type)this.instantiatedType).getClassifier(instantiations, false) : this.instantiatedType.getClassifier());
                    if (this.isInstantiation() && CsmKindUtilities.isTemplate((CsmObject)resolved) && !((CsmTemplate)resolved).getTemplateParameters().isEmpty()) {
                        block26: {
                            ip = CsmInstantiationProvider.getDefault();
                            obj = null;
                            if (ip instanceof InstantiationProviderImpl) {
                                resolver = ResolverFactory.createResolver((CsmOffsetable)this);
                                try {
                                    if (!resolver.isRecursionOnResolving(200)) {
                                        obj = ((InstantiationProviderImpl)ip).instantiate((CsmTemplate)resolved, this.instantiation, specialize);
                                        break block26;
                                    }
                                    CsmClassifier csmClassifier = null;
                                    return csmClassifier;
                                }
                                finally {
                                    ResolverFactory.releaseResolver(resolver);
                                }
                            }
                            obj = ip.instantiate((CsmTemplate)resolved, (CsmType)this);
                        }
                        if (CsmKindUtilities.isClassifier((CsmObject)obj)) {
                            resolved = (CsmClassifier)obj;
                        }
                    }
                }
                if (this.instantiation != null && !Instantiation.canSkipInstantiation((CsmObject)resolved, this.instantiation.getMapping())) {
                    CsmMember taMember;
                    CsmMember tdMember;
                    if (CsmKindUtilities.isTypedef((CsmObject)resolved) && CsmKindUtilities.isClassMember((CsmObject)resolved) && CsmKindUtilities.isTemplate((CsmObject)(tdMember = (CsmMember)resolved).getContainingClass())) {
                        resolved = new Typedef((CsmTypedef)resolved, this.instantiation);
                        return this.cacheResolved(instantiations, (CsmClassifier)resolved);
                    }
                    if (CsmKindUtilities.isTypeAlias((CsmObject)resolved) && CsmKindUtilities.isClassMember((CsmObject)resolved) && CsmKindUtilities.isTemplate((CsmObject)(taMember = (CsmMember)resolved).getContainingClass())) {
                        resolved = new MemberTypeAlias((CsmTypeAlias)resolved, this.instantiation);
                        return this.cacheResolved(instantiations, (CsmClassifier)resolved);
                    }
                    if (CsmKindUtilities.isClass((CsmObject)resolved) && CsmKindUtilities.isClassMember((CsmObject)resolved) && CsmKindUtilities.isTemplate((CsmObject)(tdMember = (CsmMember)resolved).getContainingClass())) {
                        resolved = new Class((CsmClass)resolved, (Map<CsmTemplateParameter, CsmSpecializationParameter>)this.instantiation.getMapping());
                        return this.cacheResolved(instantiations, (CsmClassifier)resolved);
                    }
                }
            }
            return this.cacheResolved(instantiations, (CsmClassifier)resolved);
        }

        @Override
        public boolean isInstantiation() {
            return this.parentType != null && this.parentType.isInstantiation() || super.isInstantiation();
        }

        private CsmObject instantiateResolved(InstantiationProviderImpl ip, CsmClassifier resolved, boolean specialize) {
            CsmClassifier obj = resolved;
            ArrayList<CsmInstantiation> parentInstantiations = new ArrayList<CsmInstantiation>();
            while (CsmKindUtilities.isInstantiation((CsmObject)obj)) {
                parentInstantiations.add((CsmInstantiation)obj);
                obj = (CsmClassifier)((CsmInstantiation)obj).getTemplateDeclaration();
            }
            ArrayList<Object> contextInstantiations = new ArrayList<Object>();
            NestedType contextType = this;
            while (contextType instanceof Type) {
                contextInstantiations.add(((Type)contextType).getInstantiation());
                contextType = ((Type)contextType).originalType;
            }
            if (!parentInstantiations.isEmpty()) {
                int n;
                CsmInstantiation firstInst = (CsmInstantiation)parentInstantiations.get(0);
                int n2 = -1;
                for (int ctxIndex = 0; ctxIndex < contextInstantiations.size(); ++ctxIndex) {
                    if (firstInst.getMapping() != ((CsmInstantiation)contextInstantiations.get(ctxIndex)).getMapping()) continue;
                    n = ctxIndex;
                    break;
                }
                if (n >= 0) {
                    int matchNumber;
                    for (matchNumber = 0; matchNumber < parentInstantiations.size() && matchNumber + n < contextInstantiations.size() && ((CsmInstantiation)parentInstantiations.get(matchNumber)).getMapping() == ((CsmInstantiation)contextInstantiations.get(matchNumber + n)).getMapping(); ++matchNumber) {
                    }
                    void insertIndex = n + matchNumber;
                    for (int i = matchNumber; i < parentInstantiations.size(); ++i) {
                        contextInstantiations.add((int)insertIndex++, parentInstantiations.get(i));
                    }
                }
            }
            Collections.reverse(contextInstantiations);
            obj = ip.instantiate((CsmTemplate)obj, contextType, false);
            for (CsmInstantiation csmInstantiation : contextInstantiations) {
                obj = ip.instantiate((CsmTemplate)obj, csmInstantiation, specialize);
            }
            return obj;
        }
    }

    private static class Decltype
    extends Type {
        public Decltype(CsmType type, CsmInstantiation instantiation, TemplateParameterResolver templateParamResolver) {
            super(type, instantiation, templateParamResolver);
        }

        @Override
        public boolean isPointer() {
            return this.isPointer(new ArrayList<CsmInstantiation>());
        }

        public boolean isPointer(List<CsmInstantiation> instantiations) {
            instantiations.add(this.instantiation);
            return Decltype.isPointerImpl(this.originalType, instantiations);
        }

        @Override
        public boolean isReference() {
            return this.isReference(new ArrayList<CsmInstantiation>());
        }

        public boolean isReference(List<CsmInstantiation> instantiations) {
            instantiations.add(this.instantiation);
            return Decltype.isReferenceImpl(this.originalType, instantiations);
        }

        @Override
        public boolean isConst() {
            return this.isConst(new ArrayList<CsmInstantiation>());
        }

        public boolean isConst(List<CsmInstantiation> instantiations) {
            instantiations.add(this.instantiation);
            return Decltype.isConstImpl(this.originalType, instantiations);
        }

        @Override
        public boolean isRValueReference() {
            return this.isRValueReference(new ArrayList<CsmInstantiation>());
        }

        public boolean isRValueReference(List<CsmInstantiation> instantiations) {
            instantiations.add(this.instantiation);
            return Decltype.isRValueReferenceImpl(this.originalType, instantiations);
        }

        private static boolean isPointerImpl(CsmType type, List<CsmInstantiation> instantiations) {
            if (type instanceof Decltype) {
                return ((Decltype)type).isPointer(instantiations);
            }
            if (type instanceof DeclTypeImpl) {
                return ((DeclTypeImpl)type).isPointer(instantiations);
            }
            return type.isPointer();
        }

        private static boolean isReferenceImpl(CsmType type, List<CsmInstantiation> instantiations) {
            if (type instanceof Decltype) {
                return ((Decltype)type).isReference(instantiations);
            }
            if (type instanceof DeclTypeImpl) {
                return ((DeclTypeImpl)type).isReference(instantiations);
            }
            return type.isReference();
        }

        private static boolean isConstImpl(CsmType type, List<CsmInstantiation> instantiations) {
            if (type instanceof Decltype) {
                return ((Decltype)type).isConst(instantiations);
            }
            if (type instanceof DeclTypeImpl) {
                return ((DeclTypeImpl)type).isConst(instantiations);
            }
            return type.isConst();
        }

        private static boolean isRValueReferenceImpl(CsmType type, List<CsmInstantiation> instantiations) {
            if (type instanceof Decltype) {
                return ((Decltype)type).isRValueReference(instantiations);
            }
            if (type instanceof DeclTypeImpl) {
                return ((DeclTypeImpl)type).isRValueReference(instantiations);
            }
            return type.isRValueReference();
        }
    }

    private static class TypeFunPtr
    extends Type
    implements CsmFunctionPointerType {
        public TypeFunPtr(CsmFunctionPointerType type, CsmInstantiation instantiation, TemplateParameterResolver templateParamResolver) {
            super((CsmType)type, instantiation, templateParamResolver);
        }

        public CsmType getReturnType() {
            return Instantiation.createType(((CsmFunctionPointerType)this.originalType).getReturnType(), this.instantiation);
        }

        public CsmScope getScope() {
            return ((CsmFunctionPointerType)this.originalType).getScope();
        }

        public Collection<CsmScopeElement> getScopeElements() {
            return ((CsmFunctionPointerType)this.originalType).getScopeElements();
        }

        public Collection<CsmParameter> getParameters() {
            return ((CsmFunctionPointerType)this.originalType).getParameters();
        }
    }

    private static class Type
    implements CsmType,
    Resolver.SafeTemplateBasedProvider {
        protected final CsmType originalType;
        protected final CsmInstantiation instantiation;
        protected final boolean inst;
        protected CsmType instantiatedType;
        protected CsmTemplateParameter parameter;
        protected CachedResolved cachedResolved;

        private Type(CsmType type, CsmInstantiation instantiation, TemplateParameterResolver templateParamResolver) {
            this.instantiation = instantiation;
            CsmType origType = type;
            CsmType newType = type;
            this.parameter = null;
            if (CsmKindUtilities.isTemplateParameterType((CsmObject)type)) {
                CsmTemplateParameterType paramType = (CsmTemplateParameterType)type;
                this.parameter = paramType.getParameter();
                TemplateParameterResolver paramsResolver = null;
                if (CsmKindUtilities.isTemplate((CsmObject)this.parameter) && paramType.getTemplateType().hasInstantiationParams()) {
                    paramsResolver = templateParamResolver.clone();
                }
                if ((newType = templateParamResolver.resolveTemplateParameterType(type, instantiation)) != null) {
                    List paramInstParams;
                    CsmType paramTemplateType;
                    int pointerDepth = newType != origType ? newType.getPointerDepth() + origType.getPointerDepth() : origType.getPointerDepth();
                    int arrayDepth = newType != origType ? newType.getArrayDepth() + origType.getArrayDepth() : origType.getArrayDepth();
                    newType = TypeFactory.createType(newType, pointerDepth, TypeFactory.getReferenceValue(origType), arrayDepth, origType.isConst(), origType.isVolatile());
                    CsmTemplateParameter p = paramType.getParameter();
                    if (CsmKindUtilities.isTemplate((CsmObject)p) && (paramTemplateType = paramType.getTemplateType()) != null && !(paramInstParams = paramTemplateType.getInstantiationParams()).isEmpty()) {
                        ArrayList<CsmSpecializationParameter> newInstParams = new ArrayList<CsmSpecializationParameter>(newType.getInstantiationParams());
                        boolean updateInstParams = false;
                        for (CsmSpecializationParameter param : paramInstParams) {
                            if (newInstParams.contains(param)) continue;
                            this.fillNewInstantiationParams(paramsResolver, param, newInstParams);
                            updateInstParams = true;
                        }
                        if (updateInstParams) {
                            newType = TypeFactory.createType(newType, newInstParams);
                        }
                    }
                    origType = paramType.getTemplateType();
                } else {
                    newType = type;
                }
            }
            if (!this.isRecursion(this, 20)) {
                this.originalType = origType;
                this.instantiatedType = newType;
            } else {
                CndUtils.assertTrueInConsole((boolean)false, (String)("Infinite recursion in file " + this.getContainingFile() + " type " + this.toString()));
                this.originalType = origType;
                this.instantiatedType = origType;
            }
            this.inst = this.instantiationHappened() ? newType.isInstantiation() : origType.isInstantiation();
        }

        private void fillNewInstantiationParams(TemplateParameterResolver paramsResolver, CsmSpecializationParameter param, List<CsmSpecializationParameter> newInstParams) {
            if (CsmKindUtilities.isTypeBasedSpecalizationParameter((CsmObject)param)) {
                CsmSpecializationParameter specParam;
                CsmTypeBasedSpecializationParameter typeInstParam = (CsmTypeBasedSpecializationParameter)param;
                boolean paramAdded = false;
                if (paramsResolver != null && CsmKindUtilities.isTemplateParameterType((CsmObject)typeInstParam.getType()) && CsmKindUtilities.isVariadicSpecalizationParameter((CsmObject)(specParam = (paramsResolver = paramsResolver.clone()).resolveTemplateParameter(((CsmTemplateParameterType)typeInstParam.getType()).getParameter(), new MapHierarchy<CsmTemplateParameter, CsmSpecializationParameter>(this.instantiation.getMapping()))))) {
                    CsmVariadicSpecializationParameter variadic = (CsmVariadicSpecializationParameter)specParam;
                    for (CsmSpecializationParameter fromVariadic : variadic.getArgs()) {
                        newInstParams.add(fromVariadic);
                    }
                    paramAdded = true;
                }
                if (!paramAdded) {
                    CsmType newParamType = Instantiation.createType(typeInstParam.getType(), this.instantiation, paramsResolver);
                    newInstParams.add((CsmSpecializationParameter)CsmInstantiationProvider.getDefault().createTypeBasedSpecializationParameter(newParamType, param.getScope()));
                }
            } else {
                newInstParams.add(param);
            }
        }

        public final boolean instantiationHappened() {
            return this.originalType != this.instantiatedType;
        }

        public CharSequence getClassifierText() {
            if (Instantiation.isInstantiatedType(this.instantiatedType)) {
                return this.instantiatedType.getClassifierText();
            }
            return CharSequenceUtils.concatenate((CharSequence)this.instantiatedType.getClassifierText(), (CharSequence)TypeImpl.getInstantiationText(this));
        }

        private CharSequence getInstantiatedText() {
            return this.getTextImpl(true);
        }

        public CharSequence getText() {
            return this.getTextImpl(false);
        }

        private CharSequence getTextImpl(boolean instantiate) {
            if (this.originalType instanceof org.netbeans.modules.cnd.modelimpl.csm.NestedType) {
                return ((org.netbeans.modules.cnd.modelimpl.csm.NestedType)this.originalType).getOwnText();
            }
            if (this.originalType instanceof NestedType) {
                return ((NestedType)this.originalType).getOwnText();
            }
            if (this.originalType instanceof TypeImpl) {
                CsmClassifier classifier = null;
                if (instantiate && (classifier = this.getClassifier()) != null) {
                    classifier = CsmBaseUtilities.getOriginalClassifier((CsmClassifier)classifier, (CsmFile)this.getContainingFile());
                }
                CharSequence clsText = classifier == null || CsmKindUtilities.isInstantiation((CsmObject)classifier) ? this.getClassifierText() : classifier.getName();
                return ((TypeImpl)this.originalType).decorateText(clsText, this, false, null);
            }
            return this.originalType.getText();
        }

        public CharSequence getOwnText() {
            if (this.originalType instanceof TypeImpl) {
                return ((TypeImpl)this.originalType).getOwnText();
            }
            return this.originalType.getText();
        }

        public CsmOffsetable.Position getStartPosition() {
            return this.instantiatedType.getStartPosition();
        }

        public int getStartOffset() {
            return this.instantiatedType.getStartOffset();
        }

        public CsmOffsetable.Position getEndPosition() {
            return this.instantiatedType.getEndPosition();
        }

        public int getEndOffset() {
            return this.instantiatedType.getEndOffset();
        }

        public CsmFile getContainingFile() {
            return this.instantiatedType.getContainingFile();
        }

        public boolean isInstantiation() {
            return this.instantiatedType.isInstantiation();
        }

        public boolean isPackExpansion() {
            return this.instantiatedType.isPackExpansion();
        }

        public boolean hasInstantiationParams() {
            return this.instantiatedType.hasInstantiationParams();
        }

        private boolean isRecursion(CsmType type, int i) {
            if (i == 0) {
                return true;
            }
            if (type instanceof NestedType) {
                NestedType t = (NestedType)type;
                if (t.parentType != null) {
                    return this.isRecursion(t.parentType, i - 1);
                }
                return this.isRecursion(t.instantiatedType, i - 1);
            }
            if (type instanceof Type) {
                return this.isRecursion(((Type)type).instantiatedType, i - 1);
            }
            if (type instanceof org.netbeans.modules.cnd.modelimpl.csm.NestedType) {
                org.netbeans.modules.cnd.modelimpl.csm.NestedType t = (org.netbeans.modules.cnd.modelimpl.csm.NestedType)type;
                if (t.getParent() != null) {
                    return this.isRecursion(t.getParent(), i - 1);
                }
                return false;
            }
            if (type instanceof TypeImpl) {
                return false;
            }
            if (type instanceof TemplateParameterTypeImpl) {
                return this.isRecursion(((TemplateParameterTypeImpl)type).getTemplateType(), i - 1);
            }
            return false;
        }

        public boolean isTemplateBased() {
            return this.isTemplateBased(new HashSet<CsmType>());
        }

        @Override
        public boolean isTemplateBased(Set<CsmType> visited) {
            if (this.instantiatedType == null) {
                return true;
            }
            if (visited.contains(this)) {
                return false;
            }
            visited.add(this);
            if (this.instantiatedType instanceof Resolver.SafeTemplateBasedProvider) {
                return ((Resolver.SafeTemplateBasedProvider)this.instantiatedType).isTemplateBased(visited);
            }
            return this.instantiatedType.isTemplateBased();
        }

        public boolean isReference() {
            if (this.instantiationHappened()) {
                return this.originalType.isReference() || this.instantiatedType.isReference();
            }
            return this.originalType.isReference();
        }

        public boolean isRValueReference() {
            if (this.instantiationHappened()) {
                return this.originalType.isRValueReference() || this.instantiatedType.isRValueReference();
            }
            return this.originalType.isRValueReference();
        }

        public boolean isPointer() {
            if (this.instantiationHappened()) {
                return this.originalType.isPointer() || this.instantiatedType.isPointer();
            }
            return this.originalType.isPointer();
        }

        public boolean isConst() {
            if (this.instantiationHappened()) {
                return this.originalType.isConst() || this.instantiatedType.isConst();
            }
            return this.originalType.isConst();
        }

        public boolean isVolatile() {
            if (this.instantiationHappened()) {
                return this.originalType.isVolatile() || this.instantiatedType.isVolatile();
            }
            return this.originalType.isVolatile();
        }

        public boolean isBuiltInBased(boolean resolveTypeChain) {
            return this.instantiatedType.isBuiltInBased(resolveTypeChain);
        }

        public List<CsmSpecializationParameter> getInstantiationParams() {
            if (!this.originalType.isInstantiation()) {
                return Collections.emptyList();
            }
            ArrayList<CsmSpecializationParameter> res = new ArrayList<CsmSpecializationParameter>();
            for (CsmSpecializationParameter instParam : this.originalType.getInstantiationParams()) {
                if (CsmKindUtilities.isTypeBasedSpecalizationParameter((CsmObject)instParam) && CsmKindUtilities.isTemplateParameterType((CsmObject)((CsmTypeBasedSpecializationParameter)instParam).getType())) {
                    CsmTemplateParameterType paramType = (CsmTemplateParameterType)((CsmTypeBasedSpecializationParameter)instParam).getType();
                    CsmSpecializationParameter newTp = (CsmSpecializationParameter)this.instantiation.getMapping().get(paramType.getParameter());
                    if (newTp != null && newTp != instParam) {
                        res.add(newTp);
                        continue;
                    }
                    res.add(instParam);
                    continue;
                }
                res.add(instParam);
            }
            return res;
        }

        public int getPointerDepth() {
            if (this.instantiationHappened()) {
                return this.instantiatedType.getPointerDepth();
            }
            return this.originalType.getPointerDepth();
        }

        public CsmClassifier getClassifier() {
            return this.getClassifier(new ArrayList<CsmInstantiation>(), false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        public CsmClassifier getClassifier(List<CsmInstantiation> instantiations, boolean specialize) {
            instantiations.add(this.instantiation);
            resolved /* !! */  = this.getCachedResolved(instantiations);
            if (resolved /* !! */  == null) {
                if (!this.instantiationHappened()) {
                    classifier = this.originalType instanceof TypeImpl != false ? ((TypeImpl)this.originalType).getClassifier(instantiations, false) : (this.originalType instanceof Type != false ? ((Type)this.originalType).getClassifier(instantiations, false) : this.originalType.getClassifier());
                    resolved /* !! */  = classifier;
                } else {
                    resolved /* !! */  = this.instantiatedType instanceof TypeImpl != false ? ((TypeImpl)this.instantiatedType).getClassifier(instantiations, false) : (this.instantiatedType instanceof Type != false ? ((Type)this.instantiatedType).getClassifier(instantiations, false) : this.instantiatedType.getClassifier());
                }
                if (this.inst && CsmKindUtilities.isTemplate((CsmObject)resolved /* !! */ )) {
                    ip = CsmInstantiationProvider.getDefault();
                    obj = null;
                    if (ip instanceof InstantiationProviderImpl) {
                        resolver = ResolverFactory.createResolver((CsmOffsetable)this);
                        try {
                            if (!resolver.isRecursionOnResolving(200)) {
                                if (this.isTemplateParameterTypeBased() && this.instantiation.getMapping().keySet().contains(this.getResolvedTemplateParameter())) ** GOTO lbl26
                                obj = ((InstantiationProviderImpl)ip).instantiate((CsmTemplate)resolved /* !! */ , this.instantiation, specialize);
                            }
                            var7_7 = null;
                            return var7_7;
                        }
                        finally {
                            ResolverFactory.releaseResolver(resolver);
                        }
                    } else {
                        obj = ip.instantiate((CsmTemplate)resolved /* !! */ , this.instantiation);
                    }
lbl26:
                    // 3 sources

                    if (CsmKindUtilities.isClassifier((CsmObject)obj)) {
                        resolved /* !! */  = (CsmClassifier)obj;
                        return this.cacheResolved(instantiations, resolved /* !! */ );
                    }
                }
                if (this.instantiation != null && !Instantiation.access$200((CsmObject)resolved /* !! */ , this.instantiation.getMapping())) {
                    if (CsmKindUtilities.isTypedef((CsmObject)resolved /* !! */ ) && CsmKindUtilities.isClassMember((CsmObject)resolved /* !! */ ) && this.isTemplateScope((tdMember = (CsmMember)resolved /* !! */ ).getContainingClass())) {
                        resolved /* !! */  = new Typedef((CsmTypedef)resolved /* !! */ , this.instantiation);
                        return this.cacheResolved(instantiations, resolved /* !! */ );
                    }
                    if (CsmKindUtilities.isTypeAlias((CsmObject)resolved /* !! */ ) && CsmKindUtilities.isClassMember((CsmObject)resolved /* !! */ ) && this.isTemplateScope((taMember = (CsmMember)resolved /* !! */ ).getContainingClass())) {
                        resolved /* !! */  = new MemberTypeAlias((CsmTypeAlias)resolved /* !! */ , this.instantiation);
                        return this.cacheResolved(instantiations, resolved /* !! */ );
                    }
                    if (CsmKindUtilities.isClass((CsmObject)resolved /* !! */ ) && CsmKindUtilities.isClassMember((CsmObject)resolved /* !! */ ) && this.isTemplateScope((tdMember = (CsmMember)resolved /* !! */ ).getContainingClass())) {
                        resolved /* !! */  = new Class((CsmClass)resolved /* !! */ , (Map<CsmTemplateParameter, CsmSpecializationParameter>)this.instantiation.getMapping());
                        return this.cacheResolved(instantiations, resolved /* !! */ );
                    }
                }
            }
            return this.cacheResolved(instantiations, resolved /* !! */ );
        }

        public CharSequence getCanonicalText() {
            return this.originalType.getCanonicalText();
        }

        public int getArrayDepth() {
            if (this.instantiationHappened()) {
                return this.originalType.getArrayDepth() + this.instantiatedType.getArrayDepth();
            }
            return this.originalType.getArrayDepth();
        }

        public CsmInstantiation getInstantiation() {
            return this.instantiation;
        }

        public boolean isTemplateParameterTypeBased() {
            CsmType baseType = this.originalType;
            while (baseType instanceof Type) {
                if (((Type)baseType).instantiationHappened()) {
                    return true;
                }
                baseType = ((Type)baseType).originalType;
            }
            return false;
        }

        public CsmTemplateParameter getResolvedTemplateParameter() {
            CsmType baseType = this.originalType;
            while (baseType instanceof Type) {
                if (((Type)baseType).parameter != null) {
                    return ((Type)baseType).parameter;
                }
                baseType = ((Type)baseType).originalType;
            }
            return null;
        }

        protected CsmClassifier getCachedResolved(List<CsmInstantiation> instantiations) {
            if (this.cachedResolved != null) {
                if (!this.cachedResolved.fromTemplateContext) {
                    return this.cachedResolved.classifier;
                }
                if (!instantiations.isEmpty() && Instantiation.isTemplateBasedInstantiation(instantiations.get(0))) {
                    return this.cachedResolved.classifier;
                }
            }
            return null;
        }

        protected CsmClassifier cacheResolved(List<CsmInstantiation> instantiations, CsmClassifier resolved) {
            if (resolved != null && this.getCachedResolved(instantiations) == null && !instantiations.isEmpty()) {
                boolean fromTemplateContext = Instantiation.isTemplateBasedInstantiation(instantiations.get(0));
                if (instantiations.get(0) == this.instantiation && !fromTemplateContext) {
                    this.cachedResolved = new CachedResolved(resolved, false);
                } else if (fromTemplateContext) {
                    this.cachedResolved = new CachedResolved(resolved, true);
                }
            }
            return resolved;
        }

        public String toString() {
            return this.toString(new StringBuilder(), 0);
        }

        private String toString(StringBuilder out, int indent) {
            Instantiation.indent(out, indent).append("INSTANTIATION OF ");
            String instName = this.getClass().getSimpleName() + "@" + System.identityHashCode(this);
            out.append(instName).append(":\n");
            if (this.originalType instanceof Type) {
                ((Type)this.originalType).toString(out, indent + 2);
            } else {
                Instantiation.indent(out, indent + 2);
                out.append(this.originalType);
            }
            out.append("\n");
            if (!this.instantiation.getMapping().isEmpty()) {
                Instantiation.indent(out, indent).append("WITH MAPPING:\n");
                for (Map.Entry entry : this.instantiation.getMapping().entrySet()) {
                    Instantiation.indent(out, indent).append("[").append(entry.getKey()).append("]=>{");
                    if (CsmKindUtilities.isTypeBasedSpecalizationParameter((CsmObject)((CsmObject)entry.getValue()))) {
                        CsmType mappedType = ((CsmTypeBasedSpecializationParameter)entry.getValue()).getType();
                        if (Instantiation.isInstantiatedType(mappedType)) {
                            CsmType unfoldedType = Instantiation.unfoldOriginalType(mappedType);
                            out.append("INSTANTIATED ").append(unfoldedType).append("}\n");
                            continue;
                        }
                        out.append(mappedType).append("}\n");
                        continue;
                    }
                    out.append(entry.getValue()).append("}\n");
                }
            }
            if (this.instantiationHappened()) {
                Instantiation.indent(out, indent).append(" BECOME ").append(this.instantiatedType);
            }
            Instantiation.indent(out, indent).append("END OF ").append(instName);
            return out.toString();
        }

        private boolean isTemplateScope(CsmClass cls) {
            while (!CsmKindUtilities.isTemplate((CsmObject)cls)) {
                if (!CsmKindUtilities.isClassMember((CsmObject)cls)) {
                    return false;
                }
                cls = ((CsmMember)cls).getContainingClass();
            }
            return true;
        }

        protected static class CachedResolved {
            public final CsmClassifier classifier;
            public final boolean fromTemplateContext;

            public CachedResolved(CsmClassifier classifier, boolean fromTemplateContext) {
                this.classifier = classifier;
                this.fromTemplateContext = fromTemplateContext;
            }
        }
    }

    private static class FunPtrTemplateParameterType
    extends Type
    implements CsmFunctionPointerType {
        public FunPtrTemplateParameterType(CsmType type, CsmInstantiation instantiation, TemplateParameterResolver templateParamResolver) {
            super(type, instantiation, templateParamResolver);
            if (CsmKindUtilities.isTemplateParameterType((CsmObject)type)) {
                CsmInstantiation alteredInstantiation;
                if (this.instantiationHappened() && CsmKindUtilities.isFunctionPointerType((CsmObject)this.instantiatedType) && (alteredInstantiation = templateParamResolver.alterInstantiation(instantiation)) != null) {
                    this.instantiatedType = Instantiation.createType(this.instantiatedType, alteredInstantiation, templateParamResolver);
                }
            } else if (type instanceof FunPtrTemplateParameterType) {
                CsmInstantiation alteredInstantiation;
                FunPtrTemplateParameterType prev = (FunPtrTemplateParameterType)type;
                if (!this.instantiationHappened() && CsmKindUtilities.isFunctionPointerType((CsmObject)prev.instantiatedType) && (alteredInstantiation = templateParamResolver.alterInstantiation(instantiation)) != null) {
                    this.instantiatedType = Instantiation.createType(prev.instantiatedType, alteredInstantiation, templateParamResolver);
                }
            }
        }

        public Collection<CsmParameter> getParameters() {
            return ((CsmFunctionPointerType)this.instantiatedType).getParameters();
        }

        public CsmType getReturnType() {
            return ((CsmFunctionPointerType)this.instantiatedType).getReturnType();
        }

        public Collection<CsmScopeElement> getScopeElements() {
            return ((CsmFunctionPointerType)this.instantiatedType).getScopeElements();
        }

        public CsmScope getScope() {
            return ((CsmFunctionPointerType)this.instantiatedType).getScope();
        }
    }

    private static class NestedTemplateParameterType
    extends Type {
        public NestedTemplateParameterType(CsmType type, CsmInstantiation instantiation, TemplateParameterResolver templateParamResolver) {
            super(type, instantiation, templateParamResolver);
            if (CsmKindUtilities.isTemplateParameterType((CsmObject)type)) {
                CsmInstantiation alteredInstantiation;
                if (this.instantiationHappened() && Instantiation.isNestedType(this.instantiatedType) && (alteredInstantiation = templateParamResolver.alterInstantiation(instantiation)) != null) {
                    this.instantiatedType = Instantiation.createType(this.instantiatedType, alteredInstantiation, templateParamResolver);
                }
            } else if (type instanceof NestedTemplateParameterType) {
                CsmInstantiation alteredInstantiation;
                NestedTemplateParameterType prev = (NestedTemplateParameterType)type;
                if (!this.instantiationHappened() && Instantiation.isNestedType(prev.instantiatedType) && (alteredInstantiation = templateParamResolver.alterInstantiation(instantiation)) != null) {
                    this.instantiatedType = Instantiation.createType(prev.instantiatedType, alteredInstantiation, templateParamResolver);
                }
            }
        }
    }

    private static class TemplateParameterType
    extends Type
    implements CsmTemplateParameterType {
        public TemplateParameterType(CsmType type, CsmInstantiation instantiation, TemplateParameterResolver templateParamResolver) {
            super(type, instantiation, templateParamResolver);
        }

        public CsmTemplateParameter getParameter() {
            return ((CsmTemplateParameterType)this.instantiatedType).getParameter();
        }

        public CsmType getTemplateType() {
            return ((CsmTemplateParameterType)this.instantiatedType).getTemplateType();
        }
    }

    private static class Parameter
    extends Instantiation<CsmParameter>
    implements CsmParameter {
        private final CsmType type;

        public Parameter(CsmParameter parameter, CsmInstantiation instantiation) {
            super((CsmOffsetableDeclaration)parameter, instantiation.getMapping(), null);
            this.type = parameter.isVarArgs() ? TypeFactory.getVarArgType() : Parameter.createType(parameter.getType(), instantiation);
        }

        public boolean isExtern() {
            return ((CsmParameter)this.declaration).isExtern();
        }

        public CsmType getType() {
            return this.type;
        }

        public CsmExpression getInitialValue() {
            return ((CsmParameter)this.declaration).getInitialValue();
        }

        public CharSequence getDisplayText() {
            return ((CsmParameter)this.declaration).getDisplayText();
        }

        public CsmVariableDefinition getDefinition() {
            return ((CsmParameter)this.declaration).getDefinition();
        }

        public CharSequence getDeclarationText() {
            return ((CsmParameter)this.declaration).getDeclarationText();
        }

        public boolean isVarArgs() {
            return ((CsmParameter)this.declaration).isVarArgs();
        }
    }

    private static class Constructor
    extends Method
    implements CsmConstructor {
        public Constructor(CsmMethod method, Map<CsmTemplateParameter, CsmSpecializationParameter> mapping) {
            super(method, mapping);
        }

        public Constructor(CsmConstructor method, CsmInstantiation instantiation) {
            super((CsmMethod)method, instantiation);
        }

        public Collection<CsmExpression> getInitializerList() {
            return ((CsmConstructor)this.declaration).getInitializerList();
        }
    }

    private static class Method
    extends Instantiation<CsmMethod>
    implements CsmMethod,
    CsmFunctionDefinition,
    CsmTemplate {
        private CsmType retType;
        private CsmFunctionDefinition definition = null;
        private CsmClass containingClass = null;

        public Method(CsmMethod method, Map<CsmTemplateParameter, CsmSpecializationParameter> mapping) {
            super((CsmOffsetableDeclaration)method, mapping, null);
        }

        public Method(CsmMethod method, CsmInstantiation instantiation) {
            super((CsmOffsetableDeclaration)method, instantiation.getMapping(), null);
        }

        public CsmFunctionDefinition.DefinitionKind getDefinitionKind() {
            if (CsmKindUtilities.isFunctionDefinition((CsmObject)this.declaration)) {
                return ((CsmFunctionDefinition)this.declaration).getDefinitionKind();
            }
            return null;
        }

        public Collection<CsmScopeElement> getScopeElements() {
            return ((CsmMethod)this.declaration).getScopeElements();
        }

        public boolean isStatic() {
            return ((CsmMethod)this.declaration).isStatic();
        }

        public CsmVisibility getVisibility() {
            return ((CsmMethod)this.declaration).getVisibility();
        }

        public CsmClass getContainingClass() {
            if (this.containingClass == null) {
                this.containingClass = this._getContainingClass();
            }
            return this.containingClass;
        }

        public CsmClass _getContainingClass() {
            CsmObject inst;
            CsmInstantiationProvider p;
            CsmClass containingClass = ((CsmMethod)this.declaration).getContainingClass();
            if (CsmKindUtilities.isTemplate((CsmObject)containingClass) && (p = CsmInstantiationProvider.getDefault()) instanceof InstantiationProviderImpl && (inst = ((InstantiationProviderImpl)p).instantiate((CsmTemplate)containingClass, this)) instanceof CsmClass) {
                return (CsmClass)inst;
            }
            return containingClass;
        }

        public boolean isSpecialization() {
            return ((CsmTemplate)this.declaration).isSpecialization();
        }

        public boolean isExplicitSpecialization() {
            return ((CsmTemplate)this.declaration).isExplicitSpecialization();
        }

        public List<CsmTemplateParameter> getTemplateParameters() {
            return ((CsmTemplate)this.declaration).getTemplateParameters();
        }

        public CharSequence getDisplayName() {
            return ((CsmTemplate)this.declaration).getDisplayName();
        }

        public boolean isTemplate() {
            return ((CsmTemplate)this.declaration).isTemplate();
        }

        public boolean isInline() {
            return ((CsmMethod)this.declaration).isInline();
        }

        public CharSequence getSignature() {
            return ((CsmMethod)this.declaration).getSignature();
        }

        public CsmType getReturnType() {
            if (this.retType == null) {
                this.retType = Method.createType(((CsmMethod)this.declaration).getReturnType(), this);
            }
            return this.retType;
        }

        public CsmFunctionParameterList getParameterList() {
            ArrayList<CsmParameter> res = new ArrayList<CsmParameter>();
            Collection parameters = ((CsmFunction)this.declaration).getParameterList().getParameters();
            for (CsmParameter param : parameters) {
                res.add(new Parameter(param, this));
            }
            return FunctionParameterListImpl.create(((CsmFunction)this.declaration).getParameterList(), res);
        }

        public Collection<CsmParameter> getParameters() {
            ArrayList<CsmParameter> res = new ArrayList<CsmParameter>();
            Collection parameters = ((CsmMethod)this.declaration).getParameters();
            for (CsmParameter param : parameters) {
                res.add(new Parameter(param, this));
            }
            return res;
        }

        public CsmFunctionDefinition getDefinition() {
            if (this.definition == null) {
                this.definition = this._getDefinition();
            }
            return this.definition;
        }

        public CsmFunctionDefinition _getDefinition() {
            CsmClass cls = this.getContainingClass();
            if (CsmKindUtilities.isSpecialization((CsmObject)cls) && this.declaration instanceof FunctionImpl) {
                FunctionImpl decl = (FunctionImpl)this.declaration;
                return decl.getDefinition(cls);
            }
            return ((CsmMethod)this.declaration).getDefinition();
        }

        public CharSequence getDeclarationText() {
            return ((CsmMethod)this.declaration).getDeclarationText();
        }

        public boolean isVirtual() {
            return ((CsmMethod)this.declaration).isVirtual();
        }

        public boolean isOverride() {
            return ((CsmMethod)this.declaration).isOverride();
        }

        public boolean isFinal() {
            return ((CsmMethod)this.declaration).isFinal();
        }

        public boolean isExplicit() {
            return ((CsmMethod)this.declaration).isExplicit();
        }

        public boolean isConst() {
            return ((CsmMethod)this.declaration).isConst();
        }

        public boolean isAbstract() {
            return ((CsmMethod)this.declaration).isAbstract();
        }

        public boolean isOperator() {
            return ((CsmMethod)this.declaration).isOperator();
        }

        public CsmFunction.OperatorKind getOperatorKind() {
            return ((CsmMethod)this.declaration).getOperatorKind();
        }

        public CsmCompoundStatement getBody() {
            if (CsmKindUtilities.isFunctionDefinition((CsmObject)this.declaration)) {
                return ((CsmFunctionDefinition)this.declaration).getBody();
            }
            return null;
        }

        public CsmFunction getDeclaration() {
            if (CsmKindUtilities.isFunctionDefinition((CsmObject)this.declaration)) {
                return ((CsmFunctionDefinition)this.declaration).getDeclaration();
            }
            return this;
        }
    }

    private static class EnumForward
    extends Instantiation<CsmEnumForwardDeclaration>
    implements CsmEnumForwardDeclaration,
    CsmMember {
        private CsmEnum csmEnum = null;

        public EnumForward(CsmEnumForwardDeclaration forward, Map<CsmTemplateParameter, CsmSpecializationParameter> mapping) {
            super((CsmOffsetableDeclaration)forward, mapping, null);
        }

        public CsmClass getContainingClass() {
            return ((CsmMember)this.declaration).getContainingClass();
        }

        public CsmVisibility getVisibility() {
            return ((CsmMember)this.declaration).getVisibility();
        }

        public boolean isStatic() {
            return ((CsmMember)this.declaration).isStatic();
        }

        public CsmEnum getCsmEnum() {
            if (this.csmEnum == null) {
                CsmEnum declClassifier = ((CsmEnumForwardDeclaration)this.declaration).getCsmEnum();
                this.csmEnum = CsmKindUtilities.isTemplate((CsmObject)declClassifier) ? (CsmEnum)Instantiation.create((CsmTemplate)declClassifier, this.getMapping()) : declClassifier;
            }
            return this.csmEnum;
        }
    }

    private static class ClassForward
    extends Instantiation<CsmClassForwardDeclaration>
    implements CsmClassForwardDeclaration,
    CsmMember {
        private CsmClass csmClass = null;

        public ClassForward(CsmClassForwardDeclaration forward, Map<CsmTemplateParameter, CsmSpecializationParameter> mapping) {
            super((CsmOffsetableDeclaration)forward, mapping, null);
        }

        public Collection<CsmScopeElement> getScopeElements() {
            return ((CsmClassForwardDeclaration)this.declaration).getScopeElements();
        }

        public CsmClass getContainingClass() {
            return ((CsmMember)this.declaration).getContainingClass();
        }

        public CsmVisibility getVisibility() {
            return ((CsmMember)this.declaration).getVisibility();
        }

        public boolean isStatic() {
            return ((CsmMember)this.declaration).isStatic();
        }

        public CsmClass getCsmClass() {
            if (this.csmClass == null) {
                CsmClass declClassifier = ((CsmClassForwardDeclaration)this.declaration).getCsmClass();
                this.csmClass = CsmKindUtilities.isTemplate((CsmObject)declClassifier) ? (CsmClass)Instantiation.create((CsmTemplate)declClassifier, this.getMapping()) : declClassifier;
            }
            return this.csmClass;
        }
    }

    private static class MemberTypeAlias
    extends TypeAlias
    implements CsmMember {
        public MemberTypeAlias(CsmTypeAlias typeAlias, Map<CsmTemplateParameter, CsmSpecializationParameter> mapping) {
            super(typeAlias, mapping);
            assert (CsmKindUtilities.isClassMember((CsmObject)typeAlias)) : "Attempt to instantiate member typealias from " + typeAlias;
        }

        public MemberTypeAlias(CsmTypeAlias typeAlias, CsmInstantiation instantiation) {
            super(typeAlias, (Map<CsmTemplateParameter, CsmSpecializationParameter>)instantiation.getMapping());
            assert (CsmKindUtilities.isClassMember((CsmObject)typeAlias)) : "Attempt to instantiate member typealias from " + typeAlias;
        }

        public CsmClass getContainingClass() {
            return ((CsmMember)this.declaration).getContainingClass();
        }

        public CsmVisibility getVisibility() {
            return ((CsmMember)this.declaration).getVisibility();
        }

        public boolean isStatic() {
            return ((CsmMember)this.declaration).isStatic();
        }
    }

    private static class TypeAlias
    extends Instantiation<CsmTypeAlias>
    implements CsmTypeAlias {
        private final CsmType type;

        public TypeAlias(CsmTypeAlias typeAlias, Map<CsmTemplateParameter, CsmSpecializationParameter> mapping) {
            super((CsmOffsetableDeclaration)typeAlias, mapping, null);
            this.type = TypeAlias.createType(typeAlias.getType(), this);
        }

        public TypeAlias(CsmTypeAlias typeAlias, CsmInstantiation instantiation) {
            super((CsmOffsetableDeclaration)typeAlias, instantiation.getMapping(), null);
            this.type = TypeAlias.createType(typeAlias.getType(), instantiation);
        }

        public boolean isTypeUnnamed() {
            return ((CsmTypeAlias)this.declaration).isTypeUnnamed();
        }

        public CsmType getType() {
            return this.type;
        }

        public boolean isTemplate() {
            return ((CsmTypeAlias)this.declaration).isTemplate();
        }

        public boolean isSpecialization() {
            return ((CsmTypeAlias)this.declaration).isSpecialization();
        }

        public boolean isExplicitSpecialization() {
            return ((CsmTypeAlias)this.declaration).isExplicitSpecialization();
        }

        public List<CsmTemplateParameter> getTemplateParameters() {
            return ((CsmTypeAlias)this.declaration).getTemplateParameters();
        }

        public CharSequence getDisplayName() {
            return ((CsmTypeAlias)this.declaration).getDisplayName();
        }
    }

    private static class UsingDeclaration
    extends Instantiation<CsmUsingDeclaration>
    implements CsmUsingDeclaration,
    CsmMember {
        public UsingDeclaration(CsmUsingDeclaration usingDeclaration, CsmInstantiation instantiation) {
            super((CsmOffsetableDeclaration)usingDeclaration, instantiation.getMapping(), null);
        }

        public CsmDeclaration getReferencedDeclaration() {
            CsmDeclaration referenced = ((CsmUsingDeclaration)this.getTemplateDeclaration()).getReferencedDeclaration();
            if (referenced instanceof CsmTemplate) {
                return (CsmDeclaration)Instantiation.create((CsmTemplate)referenced, this.getMapping());
            }
            return referenced;
        }

        public CsmClass getContainingClass() {
            return ((CsmMember)this.declaration).getContainingClass();
        }

        public CsmVisibility getVisibility() {
            return ((CsmMember)this.declaration).getVisibility();
        }

        public boolean isStatic() {
            return ((CsmMember)this.declaration).isStatic();
        }
    }

    private static class Typedef
    extends Instantiation<CsmTypedef>
    implements CsmTypedef,
    CsmMember {
        private final CsmType type;

        public Typedef(CsmTypedef typedef, CsmInstantiation instantiation) {
            super((CsmOffsetableDeclaration)typedef, instantiation.getMapping(), null);
            this.type = Typedef.createType(typedef.getType(), instantiation);
        }

        public boolean isTypeUnnamed() {
            return ((CsmTypedef)this.declaration).isTypeUnnamed();
        }

        public CsmType getType() {
            return this.type;
        }

        public CsmClass getContainingClass() {
            return ((CsmMember)this.declaration).getContainingClass();
        }

        public CsmVisibility getVisibility() {
            return ((CsmMember)this.declaration).getVisibility();
        }

        public boolean isStatic() {
            return ((CsmMember)this.declaration).isStatic();
        }
    }

    private static class Field
    extends Instantiation<CsmField>
    implements CsmField {
        private final CsmType type;

        public Field(CsmField field, CsmInstantiation instantiation) {
            super((CsmOffsetableDeclaration)field, instantiation.getMapping(), null);
            this.type = Field.createType(field.getType(), instantiation);
        }

        public boolean isExtern() {
            return ((CsmField)this.declaration).isExtern();
        }

        public CsmType getType() {
            return this.type;
        }

        public CsmExpression getInitialValue() {
            return ((CsmField)this.declaration).getInitialValue();
        }

        public CharSequence getDisplayText() {
            return ((CsmField)this.declaration).getDisplayText();
        }

        public CsmVariableDefinition getDefinition() {
            return ((CsmField)this.declaration).getDefinition();
        }

        public CharSequence getDeclarationText() {
            return ((CsmField)this.declaration).getDeclarationText();
        }

        public boolean isStatic() {
            return ((CsmField)this.declaration).isStatic();
        }

        public CsmVisibility getVisibility() {
            return ((CsmField)this.declaration).getVisibility();
        }

        public CsmClass getContainingClass() {
            return ((CsmField)this.declaration).getContainingClass();
        }
    }

    private static class FunctionPointerClassifier
    extends Instantiation<CsmFunctionPointerClassifier>
    implements CsmFunctionPointerClassifier,
    CsmTemplate {
        private final CsmType retType;

        public FunctionPointerClassifier(CsmFunctionPointerClassifier function, Map<CsmTemplateParameter, CsmSpecializationParameter> mapping) {
            super((CsmOffsetableDeclaration)function, mapping, null);
            this.retType = FunctionPointerClassifier.createType(function.getReturnType(), this);
        }

        public Collection<CsmScopeElement> getScopeElements() {
            return ((CsmFunctionPointerClassifier)this.declaration).getScopeElements();
        }

        public CharSequence getSignature() {
            return ((CsmFunctionPointerClassifier)this.declaration).getSignature();
        }

        public CsmType getReturnType() {
            return this.retType;
        }

        public Collection<CsmParameter> getParameters() {
            ArrayList<CsmParameter> res = new ArrayList<CsmParameter>();
            Collection parameters = ((CsmFunctionPointerClassifier)this.declaration).getParameters();
            for (CsmParameter param : parameters) {
                res.add(new Parameter(param, this));
            }
            return res;
        }

        public boolean isTemplate() {
            return ((CsmTemplate)this.declaration).isTemplate();
        }

        public boolean isSpecialization() {
            return ((CsmTemplate)this.declaration).isSpecialization();
        }

        public boolean isExplicitSpecialization() {
            return ((CsmTemplate)this.declaration).isExplicitSpecialization();
        }

        public List<CsmTemplateParameter> getTemplateParameters() {
            return ((CsmTemplate)this.declaration).getTemplateParameters();
        }

        public CharSequence getDisplayName() {
            return ((CsmTemplate)this.declaration).getDisplayName();
        }
    }

    private static class Function
    extends Instantiation<CsmFunction>
    implements CsmFunction,
    CsmTemplate {
        private final CsmType retType;

        public Function(CsmFunction function, Map<CsmTemplateParameter, CsmSpecializationParameter> mapping) {
            super((CsmOffsetableDeclaration)function, mapping, null);
            this.retType = Function.createType(function.getReturnType(), this);
        }

        public Collection<CsmScopeElement> getScopeElements() {
            return ((CsmFunction)this.declaration).getScopeElements();
        }

        public boolean isTemplate() {
            return ((CsmTemplate)this.declaration).isTemplate();
        }

        public boolean isInline() {
            return ((CsmFunction)this.declaration).isInline();
        }

        public boolean isOperator() {
            return ((CsmFunction)this.declaration).isOperator();
        }

        public CsmFunction.OperatorKind getOperatorKind() {
            return ((CsmFunction)this.declaration).getOperatorKind();
        }

        public CharSequence getSignature() {
            return ((CsmFunction)this.declaration).getSignature();
        }

        public CsmType getReturnType() {
            return this.retType;
        }

        public CsmFunctionParameterList getParameterList() {
            ArrayList<CsmParameter> res = new ArrayList<CsmParameter>();
            Collection parameters = ((CsmFunction)this.declaration).getParameterList().getParameters();
            for (CsmParameter param : parameters) {
                res.add(new Parameter(param, this));
            }
            res.trimToSize();
            return FunctionParameterListImpl.create(((CsmFunction)this.declaration).getParameterList(), res);
        }

        public Collection<CsmParameter> getParameters() {
            ArrayList<CsmParameter> res = new ArrayList<CsmParameter>();
            Collection parameters = ((CsmFunction)this.declaration).getParameters();
            for (CsmParameter param : parameters) {
                res.add(new Parameter(param, this));
            }
            return res;
        }

        public CsmFunctionDefinition getDefinition() {
            return ((CsmFunction)this.declaration).getDefinition();
        }

        public CsmFunction getDeclaration() {
            return ((CsmFunction)this.declaration).getDeclaration();
        }

        public CharSequence getDeclarationText() {
            return ((CsmFunction)this.declaration).getDeclarationText();
        }

        public boolean isStatic() {
            return false;
        }

        public boolean isSpecialization() {
            return ((CsmTemplate)this.declaration).isSpecialization();
        }

        public boolean isExplicitSpecialization() {
            return ((CsmTemplate)this.declaration).isExplicitSpecialization();
        }

        public List<CsmTemplateParameter> getTemplateParameters() {
            return ((CsmTemplate)this.declaration).getTemplateParameters();
        }

        public CharSequence getDisplayName() {
            return ((CsmTemplate)this.declaration).getDisplayName();
        }
    }

    private static class Inheritance
    implements CsmInheritance {
        private final CsmInheritance inheritance;
        private final CsmType type;
        private CsmClassifier resolvedClassifier;

        public Inheritance(CsmInheritance inheritance, Instantiation instantiation) {
            this.inheritance = inheritance;
            this.type = Instantiation.createType(inheritance.getAncestorType(), instantiation);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Inheritance for\n{0}\n=>INHERITANCE TYPE=>\n{1}", new Object[]{this, this.type});
            }
        }

        public CsmType getAncestorType() {
            return this.type;
        }

        public CharSequence getText() {
            return this.inheritance.getText();
        }

        public CsmOffsetable.Position getStartPosition() {
            return this.inheritance.getStartPosition();
        }

        public int getStartOffset() {
            return this.inheritance.getStartOffset();
        }

        public CsmOffsetable.Position getEndPosition() {
            return this.inheritance.getEndPosition();
        }

        public int getEndOffset() {
            return this.inheritance.getEndOffset();
        }

        public CsmFile getContainingFile() {
            return this.inheritance.getContainingFile();
        }

        public boolean isVirtual() {
            return this.inheritance.isVirtual();
        }

        public CsmVisibility getVisibility() {
            return this.inheritance.getVisibility();
        }

        public CsmClassifier getClassifier() {
            if (this.resolvedClassifier == null) {
                CsmType t = this.getAncestorType();
                this.resolvedClassifier = t.getClassifier();
            }
            return this.resolvedClassifier;
        }

        public CsmScope getScope() {
            return this.inheritance.getScope();
        }

        public String toString() {
            return this.toString(new StringBuilder(), 0);
        }

        private String toString(StringBuilder out, int indent) {
            String instName = this.getClass().getSimpleName() + "@" + System.identityHashCode(this);
            Instantiation.indent(out, indent).append("INSTANTIATION OF INHERITANCE ").append(instName).append("WITH TYPE:\n");
            ((Type)this.type).toString(out, indent + 2);
            out.append("\n");
            return out.toString();
        }
    }

    public static class Class
    extends Instantiation<CsmClass>
    implements CsmClass,
    CsmMember,
    CsmTemplate,
    SelectImpl.FilterableMembers {
        private volatile List<CsmInheritance> inheritances;

        public Class(CsmClass clazz, Map<CsmTemplateParameter, CsmSpecializationParameter> mapping) {
            super((CsmOffsetableDeclaration)clazz, mapping, null);
        }

        public Collection<CsmScopeElement> getScopeElements() {
            return ((CsmClass)this.declaration).getScopeElements();
        }

        public Collection<CsmTypedef> getEnclosingTypedefs() {
            return ((CsmClass)this.declaration).getEnclosingTypedefs();
        }

        public Collection<CsmVariable> getEnclosingVariables() {
            return ((CsmClass)this.declaration).getEnclosingVariables();
        }

        public boolean isTemplate() {
            return ((CsmTemplate)this.declaration).isTemplate();
        }

        public boolean isSpecialization() {
            return ((CsmTemplate)this.declaration).isSpecialization();
        }

        public boolean isExplicitSpecialization() {
            return ((CsmTemplate)this.declaration).isExplicitSpecialization();
        }

        private boolean isRecursion(CsmTemplate type, int i) {
            if (i == 0) {
                return true;
            }
            if (type instanceof Class) {
                Class t = (Class)type;
                return this.isRecursion((CsmTemplate)t.declaration, i - 1);
            }
            return false;
        }

        private CsmMember createMember(CsmMember member) {
            if (member instanceof CsmField) {
                return new Field((CsmField)member, this);
            }
            if (member instanceof CsmConstructor) {
                return new Constructor((CsmConstructor)member, (CsmInstantiation)this);
            }
            if (member instanceof CsmMethod) {
                return new Method((CsmMethod)member, this);
            }
            if (member instanceof CsmTypeAlias) {
                return new MemberTypeAlias((CsmTypeAlias)member, this);
            }
            if (member instanceof CsmTypedef) {
                return new Typedef((CsmTypedef)member, this);
            }
            if (member instanceof CsmClass) {
                CsmFile file;
                Class newClass = new Class((CsmClass)member, this.getMapping());
                if (UIDProviderIml.isPersistable(newClass.getUID()) && (file = newClass.getContainingFile()) instanceof FileImpl) {
                    ((FileImpl)file).addInstantiation(newClass);
                }
                return newClass;
            }
            if (member instanceof CsmClassForwardDeclaration) {
                return new ClassForward((CsmClassForwardDeclaration)member, this.getMapping());
            }
            if (member instanceof CsmEnumForwardDeclaration) {
                return new EnumForward((CsmEnumForwardDeclaration)member, this.getMapping());
            }
            if (member instanceof CsmEnum) {
                return member;
            }
            if (member instanceof CsmUsingDeclaration) {
                return new UsingDeclaration((CsmUsingDeclaration)member, this);
            }
            assert (false) : "Unknown class for member instantiation:" + member + " of class:" + member.getClass();
            return member;
        }

        public Collection<CsmMember> getMembers() {
            ArrayList<CsmMember> res = new ArrayList<CsmMember>();
            for (CsmMember member : ((CsmClass)this.declaration).getMembers()) {
                res.add(this.createMember(member));
            }
            return res;
        }

        @Override
        public Iterator<CsmMember> getMembers(CsmSelect.CsmFilter filter) {
            ArrayList<CsmMember> res = new ArrayList<CsmMember>();
            Iterator it = CsmSelect.getClassMembers((CsmClass)((CsmClass)this.declaration), (CsmSelect.CsmFilter)filter);
            while (it.hasNext()) {
                res.add(this.createMember((CsmMember)it.next()));
            }
            return res.iterator();
        }

        public int getLeftBracketOffset() {
            return ((CsmClass)this.declaration).getLeftBracketOffset();
        }

        public Collection<CsmFriend> getFriends() {
            return ((CsmClass)this.declaration).getFriends();
        }

        public Collection<CsmInheritance> getBaseClasses() {
            if (this.inheritances == null) {
                ArrayList res = new ArrayList(1);
                for (CsmInheritance inh : ((CsmClass)this.declaration).getBaseClasses()) {
                    if (Instantiation.canSkipInstantiation((CsmObject)inh, this.mapping)) {
                        res.add(inh);
                        continue;
                    }
                    res.add(new Inheritance(inh, this));
                }
                this.inheritances = res.isEmpty() ? Collections.emptyList() : res;
            }
            return this.inheritances;
        }

        public CsmClass getContainingClass() {
            return ((CsmMember)this.declaration).getContainingClass();
        }

        public CsmVisibility getVisibility() {
            return ((CsmMember)this.declaration).getVisibility();
        }

        public boolean isStatic() {
            return ((CsmMember)this.declaration).isStatic();
        }

        public CharSequence getDisplayName() {
            return ((CsmTemplate)this.declaration).getDisplayName();
        }

        public List<CsmTemplateParameter> getTemplateParameters() {
            return ((CsmTemplate)this.declaration).getTemplateParameters();
        }

        @Override
        public void write(RepositoryDataOutput output) throws IOException {
            super.write(output);
        }

        public Class(RepositoryDataInput input) throws IOException {
            super(input);
        }
    }

    private static final class TemplateMapKey {
        private final Map<CsmTemplateParameter, CsmSpecializationParameter> map;

        public TemplateMapKey(Map<CsmTemplateParameter, CsmSpecializationParameter> map) {
            this.map = map;
        }

        public int hashCode() {
            int hash = 3;
            for (CsmTemplateParameter templateParam : this.map.keySet()) {
                hash = 79 * hash + Objects.hashCode(templateParam);
            }
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TemplateMapKey other = (TemplateMapKey)obj;
            if (this.map.size() != other.map.size()) {
                return false;
            }
            for (CsmTemplateParameter templateParam : this.map.keySet()) {
                if (other.map.containsKey(templateParam)) continue;
                return false;
            }
            return true;
        }
    }
}

