/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.IOException;
import java.util.ArrayList;
import org.netbeans.modules.cnd.modelimpl.platform.ModelSupport;

public class Line2Offset {
    private String text;
    private char[] buffer;
    private final int[] lines;

    Line2Offset(String text) {
        this.text = text;
        this.lines = this.init();
    }

    public Line2Offset(char[] buffer) {
        this.buffer = buffer;
        this.lines = this.init();
    }

    Line2Offset(char[] buffer, int[] lines) {
        this.buffer = buffer;
        this.lines = lines;
    }

    public int getLineCount() {
        return this.lines.length;
    }

    public int[] getLineColumnByOffset(int offset) throws IOException {
        int[] lineCol = new int[]{1, 1};
        if (offset >= 0) {
            int line = this._getLineByOffset(offset);
            int start = this._getStartLineOffset(line);
            lineCol[0] = line;
            int TABSIZE = ModelSupport.getTabSize();
            int length = this.getLength();
            block4: for (int curOffset = start; curOffset < offset && curOffset < length; ++curOffset) {
                char curChar = this.getCharAt(curOffset);
                switch (curChar) {
                    case '\n': {
                        lineCol[0] = lineCol[0] + 1;
                        lineCol[1] = 1;
                        continue block4;
                    }
                    case '\t': {
                        int newCol;
                        int col = lineCol[1];
                        lineCol[1] = newCol = ((col - 1) / TABSIZE + 1) * TABSIZE + 1;
                        continue block4;
                    }
                    default: {
                        lineCol[1] = lineCol[1] + 1;
                    }
                }
            }
        }
        return lineCol;
    }

    public int getOffsetByLineColumn(int line, int column) throws IOException {
        int outOffset;
        int startOffset = this._getStartLineOffset(line);
        int TABSIZE = ModelSupport.getTabSize();
        int currCol = 1;
        int length = this.getLength();
        block4: for (outOffset = startOffset; outOffset < length && currCol < column; ++outOffset) {
            char curChar = this.getCharAt(outOffset);
            switch (curChar) {
                case '\n': {
                    break block4;
                }
                case '\t': {
                    int newCol;
                    int col = currCol;
                    currCol = newCol = ((col - 1) / TABSIZE + 1) * TABSIZE + 1;
                    continue block4;
                }
                default: {
                    ++currCol;
                }
            }
        }
        return outOffset;
    }

    private int[] init() {
        int length = this.getLength();
        ArrayList<Integer> list = new ArrayList<Integer>(length / 10);
        list.add(0);
        for (int curOffset = 0; curOffset < length; ++curOffset) {
            if (this.getCharAt(curOffset) != '\n') continue;
            list.add(curOffset + 1);
        }
        int[] aLines = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            aLines[i] = (Integer)list.get(i);
        }
        return aLines;
    }

    private char getCharAt(int pos) {
        if (this.text != null) {
            return this.text.charAt(pos);
        }
        return this.buffer[pos];
    }

    private int getLength() {
        if (this.text != null) {
            return this.text.length();
        }
        return this.buffer.length;
    }

    private int _getStartLineOffset(int line) throws IOException {
        if (--line < this.lines.length) {
            return this.lines[line];
        }
        return this.lines[this.lines.length - 1];
    }

    private int _getLineByOffset(int offset) throws IOException {
        int low = 0;
        int high = this.lines.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = this.lines[mid];
            if (midVal < offset) {
                if (low == high) {
                    return low + 1;
                }
                low = mid + 1;
                continue;
            }
            if (midVal > offset) {
                if (low == high) {
                    return low;
                }
                high = mid - 1;
                continue;
            }
            return mid + 1;
        }
        return low;
    }
}

