/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.karma.preferences;

import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.karma.preferences.Bundle;
import org.netbeans.modules.javascript.karma.preferences.KarmaPreferences;
import org.netbeans.modules.javascript.karma.util.FileUtils;
import org.netbeans.modules.web.common.api.ValidationResult;

public final class KarmaPreferencesValidator {
    private final ValidationResult result = new ValidationResult();

    public ValidationResult getResult() {
        return this.result;
    }

    public KarmaPreferencesValidator validate(Project project) {
        this.validateConfig(KarmaPreferences.getConfig(project));
        this.validateDebug(KarmaPreferences.isDebug(project), KarmaPreferences.getDebugBrowserId(project));
        return this;
    }

    public KarmaPreferencesValidator validateConfig(String config) {
        String warning = FileUtils.validateFile(Bundle.KarmaPreferencesValidator_config_name(), config, false);
        if (warning != null) {
            this.result.addWarning(new ValidationResult.Message((Object)"config", warning));
        }
        return this;
    }

    public KarmaPreferencesValidator validateDebug(boolean debug, String debugBrowserId) {
        if (debug && debugBrowserId == null) {
            this.result.addWarning(new ValidationResult.Message((Object)"debugBrowser", Bundle.KarmaPreferencesValidator_debug_browser()));
        }
        return this;
    }
}

