/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.issue;

import java.awt.EventQueue;
import java.io.File;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JTable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaOperation;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaTaskDataHandler;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaVersion;
import org.eclipse.mylyn.internal.tasks.core.data.FileTaskAttachmentSource;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskOperation;
import org.netbeans.modules.bugtracking.commons.AttachmentsPanel;
import org.netbeans.modules.bugtracking.commons.NBBugzillaUtils;
import org.netbeans.modules.bugtracking.commons.UIUtils;
import org.netbeans.modules.bugtracking.issuetable.ColumnDescriptor;
import org.netbeans.modules.bugtracking.issuetable.IssueNode;
import org.netbeans.modules.bugtracking.spi.IssueController;
import org.netbeans.modules.bugtracking.spi.IssueScheduleInfo;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.BugzillaConfig;
import org.netbeans.modules.bugzilla.commands.AddAttachmentCommand;
import org.netbeans.modules.bugzilla.commands.GetAttachmentCommand;
import org.netbeans.modules.bugzilla.issue.BugzillaIssueController;
import org.netbeans.modules.bugzilla.issue.BugzillaIssueNode;
import org.netbeans.modules.bugzilla.issue.Bundle;
import org.netbeans.modules.bugzilla.issue.IssuePanel;
import org.netbeans.modules.bugzilla.repository.BugzillaConfiguration;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.netbeans.modules.bugzilla.repository.IssueField;
import org.netbeans.modules.bugzilla.util.BugzillaUtil;
import org.netbeans.modules.mylyn.util.AbstractNbTaskWrapper;
import org.netbeans.modules.mylyn.util.BugtrackingCommand;
import org.netbeans.modules.mylyn.util.MylynSupport;
import org.netbeans.modules.mylyn.util.NbTask;
import org.netbeans.modules.mylyn.util.NbTaskDataModel;
import org.netbeans.modules.mylyn.util.NbTaskDataState;
import org.netbeans.modules.mylyn.util.commands.SynchronizeTasksCommand;
import org.netbeans.modules.team.spi.OwnerInfo;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Places;
import org.openide.util.NbBundle;

public class BugzillaIssue
extends AbstractNbTaskWrapper {
    public static final String RESOLVE_FIXED = "FIXED";
    public static final String RESOLVE_DUPLICATE = "DUPLICATE";
    public static final String VCSHOOK_BUGZILLA_FIELD = "netbeans.vcshook.bugzilla.";
    private static final SimpleDateFormat CC_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    static final SimpleDateFormat DUE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private final BugzillaRepository repository;
    private BugzillaIssueController controller;
    private WeakReference<BugzillaIssueNode> nodeRef;
    private OwnerInfo info;
    static final String LABEL_NAME_ID = "bugzilla.issue.id";
    static final String LABEL_NAME_SEVERITY = "bugzilla.issue.severity";
    static final String LABEL_NAME_ISSUE_TYPE = "bugzilla.issue.issue_type";
    static final String LABEL_NAME_PRIORITY = "bugzilla.issue.priority";
    static final String LABEL_NAME_STATUS = "bugzilla.issue.status";
    static final String LABEL_NAME_RESOLUTION = "bugzilla.issue.resolution";
    static final String LABEL_NAME_ASSIGNED_TO = "bugzilla.issue.assigned";
    static final String LABEL_NAME_PRODUCT = "bugzilla.issue.product";
    static final String LABEL_NAME_COMPONENT = "bugzilla.issue.component";
    static final String LABEL_NAME_VERSION = "bugzilla.issue.version";
    static final String LABEL_NAME_OS = "bugzilla.issue.os";
    static final String LABEL_NAME_PLATFORM = "bugzilla.issue.platform";
    static final String LABEL_NAME_MILESTONE = "bugzilla.issue.milestone";
    static final String LABEL_NAME_REPORTER = "bugzilla.issue.reporter";
    static final String LABEL_NAME_MODIFICATION = "bugzilla.issue.modified";
    static final String LABEL_NAME_QA_CONTACT = "bugzilla.issue.qa_contact";
    static final String LABEL_NAME_KEYWORDS = "bugzilla.issue.keywords";
    static final String LABEL_NAME_WHITEBOARD = "bugzilla.issue.whiteboard";
    static final int FIELD_STATUS_IRELEVANT = -1;
    static final int FIELD_STATUS_UPTODATE = 1;
    static final int FIELD_STATUS_MODIFIED = 2;
    static final int FIELD_STATUS_OUTGOING = 4;
    static final int FIELD_STATUS_CONFLICT = 6;
    private String initialProduct = null;
    private Map<String, TaskOperation> availableOperations;
    private String recentChanges = "";
    private String tooltip = "";
    private static final URL ICON_REMOTE_PATH = IssuePanel.class.getClassLoader().getResource("org/netbeans/modules/bugzilla/resources/remote.png");
    private static final URL ICON_CONFLICT_PATH = IssuePanel.class.getClassLoader().getResource("org/netbeans/modules/bugzilla/resources/conflict.png");
    private static final URL ICON_UNSUBMITTED_PATH = IssuePanel.class.getClassLoader().getResource("org/netbeans/modules/bugzilla/resources/unsubmitted.png");
    private boolean loading;
    private boolean wasDuplicated;

    public BugzillaIssue(NbTask task, BugzillaRepository repo) {
        super(task);
        this.repository = repo;
        this.updateRecentChanges();
        this.updateTooltip();
    }

    protected void taskDeleted(NbTask task) {
        this.getRepository().taskDeleted(BugzillaIssue.getID((NbTask)task));
    }

    void markUserChange() {
        if (this.isMarkedNewUnread()) {
            this.markNewRead();
        }
    }

    void delete() {
        this.deleteTask();
    }

    public void opened() {
        if (Bugzilla.LOG.isLoggable(Level.FINE)) {
            Bugzilla.LOG.log(Level.FINE, "issue {0} open start", new Object[]{this.getID()});
        }
        this.loading = true;
        Bugzilla.getInstance().getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                if (BugzillaIssue.this.editorOpened()) {
                    BugzillaIssue.this.ensureConfigurationUptodate();
                    BugzillaIssue.this.loading = false;
                    BugzillaIssue.this.refreshViewData(true);
                }
            }
        });
        String refresh = System.getProperty("org.netbeans.modules.bugzilla.noIssueRefresh");
        if (refresh != null && refresh.equals("true")) {
            return;
        }
        if (Bugzilla.LOG.isLoggable(Level.FINE)) {
            Bugzilla.LOG.log(Level.FINE, "issue {0} open finish", new Object[]{this.getID()});
        }
    }

    public void closed() {
        if (Bugzilla.LOG.isLoggable(Level.FINE)) {
            Bugzilla.LOG.log(Level.FINE, "issue {0} close start", new Object[]{this.getID()});
        }
        Bugzilla.getInstance().getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                BugzillaIssue.this.editorClosed();
            }
        });
        if (Bugzilla.LOG.isLoggable(Level.FINE)) {
            Bugzilla.LOG.log(Level.FINE, "issue {0} close finish", new Object[]{this.getID()});
        }
    }

    public String getDisplayName() {
        return BugzillaIssue.getDisplayName(this.getNbTask());
    }

    public static String getDisplayName(NbTask task) {
        return task.getSynchronizationState() == NbTask.SynchronizationState.OUTGOING_NEW ? task.getSummary() : NbBundle.getMessage(BugzillaIssue.class, (String)"CTL_Issue", (Object[])new Object[]{BugzillaIssue.getID((NbTask)task), task.getSummary()});
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public static ColumnDescriptor[] getColumnDescriptors(BugzillaRepository repository) {
        ResourceBundle loc = NbBundle.getBundle(BugzillaIssue.class);
        JTable t = new JTable();
        LinkedList<ColumnDescriptor> ret = new LinkedList<ColumnDescriptor>();
        ret.add(new ColumnDescriptor(LABEL_NAME_ID, String.class, loc.getString("CTL_Issue_ID_Title"), loc.getString("CTL_Issue_ID_Desc"), UIUtils.getColumnWidthInPixels((int)6, (JComponent)t)));
        ret.add(new ColumnDescriptor("issue.summary", String.class, loc.getString("CTL_Issue_Summary_Title"), loc.getString("CTL_Issue_Summary_Desc")));
        ret.add(NBBugzillaUtils.isNbRepository((String)repository.getUrl()) ? new ColumnDescriptor(LABEL_NAME_ISSUE_TYPE, String.class, loc.getString("CTL_Issue_Issue_Type_Title"), loc.getString("CTL_Issue_Issue_Type_Desc"), 0) : new ColumnDescriptor(LABEL_NAME_SEVERITY, String.class, loc.getString("CTL_Issue_Severity_Title"), loc.getString("CTL_Issue_Severity_Desc"), 0));
        ret.add(new ColumnDescriptor(LABEL_NAME_PRIORITY, String.class, loc.getString("CTL_Issue_Priority_Title"), loc.getString("CTL_Issue_Priority_Desc"), 0));
        ret.add(new ColumnDescriptor(LABEL_NAME_STATUS, String.class, loc.getString("CTL_Issue_Status_Title"), loc.getString("CTL_Issue_Status_Desc"), 0));
        ret.add(new ColumnDescriptor(LABEL_NAME_RESOLUTION, String.class, loc.getString("CTL_Issue_Resolution_Title"), loc.getString("CTL_Issue_Resolution_Desc"), 0));
        ret.add(new ColumnDescriptor(LABEL_NAME_ASSIGNED_TO, String.class, loc.getString("CTL_Issue_Assigned_Title"), loc.getString("CTL_Issue_Assigned_Desc"), 0));
        ret.add(new ColumnDescriptor(LABEL_NAME_PRODUCT, String.class, loc.getString("CTL_Issue_Product_Title"), loc.getString("CTL_Issue_Product_Desc"), 0, false));
        ret.add(new ColumnDescriptor(LABEL_NAME_COMPONENT, String.class, loc.getString("CTL_Issue_Component_Title"), loc.getString("CTL_Issue_Component_Desc"), 0, false));
        ret.add(new ColumnDescriptor(LABEL_NAME_VERSION, String.class, loc.getString("CTL_Issue_Version_Title"), loc.getString("CTL_Issue_Version_Desc"), 0, false));
        ret.add(new ColumnDescriptor(LABEL_NAME_OS, String.class, loc.getString("CTL_Issue_OS_Title"), loc.getString("CTL_Issue_OS_Desc"), 0, false));
        ret.add(new ColumnDescriptor(LABEL_NAME_PLATFORM, String.class, loc.getString("CTL_Issue_Platform_Title"), loc.getString("CTL_Issue_Platform_Desc"), 0, false));
        ret.add(new ColumnDescriptor(LABEL_NAME_MILESTONE, String.class, loc.getString("CTL_Issue_Milestone_Title"), loc.getString("CTL_Issue_Milestone_Desc"), 0, false));
        ret.add(new ColumnDescriptor(LABEL_NAME_REPORTER, String.class, loc.getString("CTL_Issue_Reporter_Title"), loc.getString("CTL_Issue_Reporter_Desc"), 0, false));
        ret.add(new ColumnDescriptor(LABEL_NAME_MODIFICATION, String.class, loc.getString("CTL_Issue_Modification_Title"), loc.getString("CTL_Issue_Modification_Desc"), 0, false));
        if (BugzillaUtil.showQAContact(repository)) {
            ret.add(new ColumnDescriptor(LABEL_NAME_QA_CONTACT, String.class, loc.getString("CTL_Issue_QA_Contact_Title"), loc.getString("CTL_Issue_QA_Contact_Desc"), 0, false));
        }
        ret.add(new ColumnDescriptor(LABEL_NAME_KEYWORDS, String.class, loc.getString("CTL_Issue_Keywords_Title"), loc.getString("CTL_Issue_Keywords_Desc"), 0, false));
        if (BugzillaUtil.showStatusWhiteboard(repository)) {
            ret.add(new ColumnDescriptor(LABEL_NAME_WHITEBOARD, String.class, loc.getString("CTL_Issue_Whiteboard_Title"), loc.getString("CTL_Issue_Whiteboard_Desc"), 0, false));
        }
        return ret.toArray(new ColumnDescriptor[ret.size()]);
    }

    public IssueController getController() {
        if (this.controller == null) {
            this.controller = new BugzillaIssueController(this);
        }
        return this.controller;
    }

    public String toString() {
        String str = this.getID() + " : " + this.getSummary();
        return str;
    }

    public IssueNode getNode() {
        BugzillaIssueNode n;
        BugzillaIssueNode bugzillaIssueNode = n = this.nodeRef != null ? (BugzillaIssueNode)((Object)this.nodeRef.get()) : null;
        if (n == null) {
            n = this.createNode();
            this.nodeRef = new WeakReference<BugzillaIssueNode>(n);
        }
        if (!EventQueue.isDispatchThread()) {
            this.getRepositoryTaskData();
        }
        return n;
    }

    public void setOwnerInfo(OwnerInfo info) {
        this.info = info;
    }

    public OwnerInfo getOwnerInfo() {
        return this.info;
    }

    public String getRecentChanges() {
        return this.recentChanges;
    }

    public BugzillaRepository getRepository() {
        return this.repository;
    }

    private void ensureConfigurationUptodate() {
        BugzillaConfiguration conf = this.getRepository().getConfiguration();
        NbTaskDataState taskDataState = null;
        try {
            taskDataState = this.getNbTask().getTaskDataState();
        }
        catch (CoreException ex) {
            Bugzilla.LOG.log(Level.INFO, null, ex);
        }
        boolean needsRefresh = false;
        if (taskDataState != null && !this.isNew()) {
            for (TaskData taskData : new TaskData[]{taskDataState.getLastReadData(), taskDataState.getLocalData(), taskDataState.getRepositoryData()}) {
                String product = BugzillaIssue.getFieldValue(taskData, IssueField.PRODUCT);
                String resolution = BugzillaIssue.getFieldValue(taskData, IssueField.RESOLUTION);
                String severity = BugzillaIssue.getFieldValue(taskData, IssueField.SEVERITY);
                String milestone = BugzillaIssue.getFieldValue(taskData, IssueField.MILESTONE);
                String version = BugzillaIssue.getFieldValue(taskData, IssueField.VERSION);
                String priority = BugzillaIssue.getFieldValue(taskData, IssueField.PRIORITY);
                String platform = BugzillaIssue.getFieldValue(taskData, IssueField.PLATFORM);
                String status = BugzillaIssue.getFieldValue(taskData, IssueField.STATUS);
                String os = BugzillaIssue.getFieldValue(taskData, IssueField.OS);
                String component = BugzillaIssue.getFieldValue(taskData, IssueField.COMPONENT);
                if (!(!component.isEmpty() && !conf.getComponents(product).contains(component) || !os.isEmpty() && !conf.getOSs().contains(os) || !status.isEmpty() && !conf.getStatusValues().contains(status) || !platform.isEmpty() && !conf.getPlatforms().contains(platform) || !priority.isEmpty() && !conf.getPriorities().contains(priority) || !product.isEmpty() && !conf.getProducts().contains(product) || !resolution.isEmpty() && !conf.getResolutions().contains(resolution) || !severity.isEmpty() && !conf.getSeverities().contains(severity) || !milestone.isEmpty() && !conf.getTargetMilestones(product).contains(milestone)) && (version.isEmpty() || conf.getVersions(product).contains(version))) continue;
                needsRefresh = true;
                break;
            }
        }
        if (needsRefresh) {
            this.getRepository().refreshConfiguration();
        }
    }

    protected void repositoryTaskDataLoaded(TaskData repositoryTaskData) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (BugzillaIssue.this.updateTooltip()) {
                    BugzillaIssue.this.fireDataChanged();
                }
            }
        });
    }

    public String getRepositoryFieldValue(IssueField f) {
        TaskData td;
        NbTaskDataModel m = this.getModel();
        if (m == null) {
            td = this.getRepositoryTaskData();
            if (td == null) {
                return "...";
            }
        } else {
            td = m.getRepositoryTaskData();
        }
        return BugzillaIssue.getFieldValue(td, f);
    }

    public String getFieldValue(IssueField f) {
        NbTaskDataModel m = this.getModel();
        return BugzillaIssue.getFieldValue(m == null ? null : m.getLocalTaskData(), f);
    }

    String getLastSeenFieldValue(IssueField f) {
        NbTaskDataModel m = this.getModel();
        return BugzillaIssue.getFieldValue(m == null ? null : m.getLastReadTaskData(), f);
    }

    private static String getFieldValue(TaskData taskData, IssueField f) {
        if (taskData == null) {
            return "";
        }
        if (f.isSingleAttribute()) {
            TaskAttribute a = taskData.getRoot().getMappedAttribute(f.getKey());
            if (a != null && a.getValues().size() > 1) {
                return BugzillaIssue.listValues(a);
            }
            return a != null ? a.getValue() : "";
        }
        List attrs = taskData.getAttributeMapper().getAttributesByType(taskData, f.getKey());
        return "" + (attrs != null && attrs.size() > 0 ? Integer.valueOf(attrs.size()) : "");
    }

    private static String listValues(TaskAttribute a) {
        if (a == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        List l = a.getValues();
        for (int i = 0; i < l.size(); ++i) {
            String s = (String)l.get(i);
            sb.append(s);
            if (i >= l.size() - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    void setFieldValue(IssueField f, String value) {
        if (f.isReadOnly()) {
            assert (false) : "can't set value into IssueField " + f.getKey();
            return;
        }
        NbTaskDataModel m = this.getModel();
        boolean isshowing = this.getController().getComponent().isShowing();
        assert (m != null || !isshowing) : "isShowing=" + isshowing + ", model=" + m;
        if (m != null) {
            TaskData taskData = m.getLocalTaskData();
            TaskAttribute a = taskData.getRoot().getMappedAttribute(f.getKey());
            if (a == null) {
                if (f == IssueField.REASSIGN_TO_DEFAULT) {
                    this.setOperation(BugzillaOperation.reassignbycomponent);
                    return;
                }
                a = new TaskAttribute(taskData.getRoot(), f.getKey());
            }
            if (f == IssueField.PRODUCT) {
                this.handleProductChange(a);
            }
            Bugzilla.LOG.log(Level.FINER, "setting value [{0}] on field [{1}]", new Object[]{value, f.getKey()});
            if (!value.equals(a.getValue())) {
                this.setValue(m, a, value);
            }
        }
    }

    void setFieldValues(IssueField f, List<String> ccs) {
        NbTaskDataModel m = this.getModel();
        assert (m != null || !this.getController().getComponent().isShowing());
        if (m != null) {
            TaskData taskData = m.getLocalTaskData();
            TaskAttribute a = taskData.getRoot().getMappedAttribute(f.getKey());
            if (a == null) {
                a = new TaskAttribute(taskData.getRoot(), f.getKey());
            }
            a.setValues(ccs);
            m.attributeChanged(a);
        }
    }

    public List<String> getRepositoryFieldValues(IssueField f) {
        NbTaskDataModel m = this.getModel();
        return BugzillaIssue.getFieldValues(m == null ? this.getRepositoryTaskData() : m.getRepositoryTaskData(), f);
    }

    public List<String> getFieldValues(IssueField f) {
        NbTaskDataModel m = this.getModel();
        return BugzillaIssue.getFieldValues(m == null ? null : m.getLocalTaskData(), f);
    }

    List<String> getLastSeenFieldValues(IssueField f) {
        NbTaskDataModel m = this.getModel();
        return BugzillaIssue.getFieldValues(m == null ? null : m.getLastReadTaskData(), f);
    }

    private static List<String> getFieldValues(TaskData taskData, IssueField f) {
        if (taskData == null) {
            return Collections.emptyList();
        }
        if (f.isSingleAttribute()) {
            TaskAttribute a = taskData.getRoot().getMappedAttribute(f.getKey());
            if (a != null) {
                return a.getValues();
            }
            return Collections.emptyList();
        }
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(BugzillaIssue.getFieldValue(taskData, f));
        return ret;
    }

    public int getFieldStatus(IssueField f) {
        boolean outgoing;
        NbTaskDataModel m = this.getModel();
        if (m == null) {
            return 1;
        }
        TaskAttribute ta = m.getLocalTaskData().getRoot().getMappedAttribute(f.getKey());
        boolean incoming = ta != null && m.hasIncomingChanges(ta, true);
        boolean bl = outgoing = ta != null && m.hasOutgoingChanges(ta);
        if (ta == null) {
            return 1;
        }
        if (incoming & outgoing) {
            return 6;
        }
        if (incoming) {
            return 2;
        }
        if (outgoing) {
            return 4;
        }
        return 1;
    }

    private BugzillaIssueNode createNode() {
        return new BugzillaIssueNode(this);
    }

    private void handleProductChange(TaskAttribute a) {
        if (!this.isNew() && this.initialProduct == null) {
            this.initialProduct = a.getValue();
        }
    }

    public void resolve(final String resolution) {
        assert (!this.isNew());
        this.runWithModelLoaded(new Runnable(){

            @Override
            public void run() {
                String value = BugzillaIssue.this.getFieldValue(IssueField.STATUS);
                if (!value.equals("RESOLVED") || !resolution.equals(BugzillaIssue.this.getFieldValue(IssueField.RESOLUTION))) {
                    BugzillaIssue.this.setOperation(BugzillaOperation.resolve);
                    TaskAttribute rta = BugzillaIssue.this.getModel().getLocalTaskData().getRoot();
                    TaskAttribute ta = rta.getMappedAttribute(BugzillaOperation.resolve.getInputId());
                    if (ta != null) {
                        BugzillaIssue.this.setValue(BugzillaIssue.this.getModel(), ta, resolution);
                    }
                }
            }
        });
    }

    void accept() {
        this.setOperation(BugzillaOperation.accept);
    }

    void duplicate(String id) {
        NbTaskDataModel m = this.getModel();
        this.setOperation(BugzillaOperation.duplicate);
        TaskAttribute rta = m.getLocalTaskData().getRoot();
        TaskAttribute ta = rta.getMappedAttribute(BugzillaOperation.duplicate.getInputId());
        this.setValue(m, ta, id);
        this.wasDuplicated = true;
    }

    boolean canReassign() {
        boolean oldRepository;
        BugzillaVersion installedVersion;
        NbTaskDataModel m = this.getModel();
        if (m == null) {
            return false;
        }
        BugzillaConfiguration rc = this.getRepository().getConfiguration();
        BugzillaVersion bugzillaVersion = installedVersion = rc != null ? rc.getInstalledVersion() : null;
        boolean bl = installedVersion != null ? installedVersion.compareMajorMinorOnly(BugzillaVersion.BUGZILLA_3_2) < 0 : (oldRepository = false);
        if (oldRepository) {
            TaskAttribute rta = m.getLocalTaskData().getRoot();
            TaskAttribute ta = rta.getMappedAttribute(BugzillaOperation.reassign.getInputId());
            return ta != null;
        }
        return true;
    }

    boolean canAssignToDefault() {
        BugzillaVersion installedVersion;
        NbTaskDataModel m = this.getModel();
        if (m == null) {
            return false;
        }
        BugzillaConfiguration rc = this.getRepository().getConfiguration();
        BugzillaVersion bugzillaVersion = installedVersion = rc != null ? rc.getInstalledVersion() : null;
        boolean pre4 = installedVersion != null ? installedVersion.compareMajorMinorOnly(BugzillaVersion.BUGZILLA_3_0) <= 0 : false;
        TaskData taskData = m.getLocalTaskData();
        if (pre4) {
            return BugzillaOperation.reassignbycomponent.getInputId() != null ? taskData.getRoot().getMappedAttribute(BugzillaOperation.reassignbycomponent.getInputId()) != null : false;
        }
        TaskAttribute ta = taskData.getRoot().getAttribute(BugzillaAttribute.SET_DEFAULT_ASSIGNEE.getKey());
        return ta != null;
    }

    boolean hasTimeTracking() {
        NbTaskDataModel m = this.getModel();
        return m != null && m.getLocalTaskData().getRoot().getMappedAttribute(BugzillaAttribute.ACTUAL_TIME.getKey()) != null;
    }

    void reassign(String user) {
        NbTaskDataModel m = this.getModel();
        this.setOperation(BugzillaOperation.reassign);
        TaskAttribute rta = m.getLocalTaskData().getRoot();
        TaskAttribute ta = rta.getMappedAttribute(BugzillaOperation.reassign.getInputId());
        if (ta != null) {
            this.setValue(m, ta, user);
        }
        if ((ta = rta.getMappedAttribute(BugzillaAttribute.ASSIGNED_TO.getKey())) != null) {
            this.setValue(m, ta, user);
        }
    }

    void verify() {
        this.setOperation(BugzillaOperation.verify);
    }

    void close() {
        this.setOperation(BugzillaOperation.close);
    }

    void reopen() {
        this.setOperation(BugzillaOperation.reopen);
    }

    private void setOperation(BugzillaOperation operation) {
        NbTaskDataModel m = this.getModel();
        TaskAttributeMapper mapper = m.getLocalTaskData().getAttributeMapper();
        for (TaskOperation op : mapper.getTaskOperations(m.getLocalTaskData().getRoot())) {
            if (!op.getOperationId().equals(operation.toString())) continue;
            this.setOperation(op);
            return;
        }
        this.setOperation(BugzillaOperation.none);
    }

    private void setOperation(TaskOperation operation) {
        NbTaskDataModel m = this.getModel();
        TaskAttribute rta = m.getLocalTaskData().getRoot();
        TaskAttribute ta = rta.getMappedAttribute("task.common.operation");
        m.getLocalTaskData().getAttributeMapper().setTaskOperation(ta, operation);
        m.attributeChanged(ta);
    }

    List<Attachment> getAttachments() {
        List attrs;
        NbTaskDataModel m = this.getModel();
        List list = attrs = m == null ? null : m.getLocalTaskData().getAttributeMapper().getAttributesByType(m.getLocalTaskData(), "attachment");
        if (attrs == null) {
            return Collections.emptyList();
        }
        ArrayList<Attachment> attachments = new ArrayList<Attachment>(attrs.size());
        for (TaskAttribute taskAttribute : attrs) {
            attachments.add(new Attachment(taskAttribute));
        }
        return attachments;
    }

    public void addAttachment(File file, String comment, String desc, String contentType, boolean patch) {
        assert (!EventQueue.isDispatchThread()) : "Accessing remote host. Do not call in awt";
        FileTaskAttachmentSource attachmentSource = new FileTaskAttachmentSource(file);
        if (contentType == null) {
            String ct = FileUtil.getMIMEType((FileObject)FileUtil.toFileObject((File)(file = FileUtil.normalizeFile((File)file))));
            contentType = ct != null && !"content/unknown".equals(ct) ? ct : FileTaskAttachmentSource.getContentTypeFromFilename((String)file.getName());
        }
        attachmentSource.setContentType(contentType);
        TaskData repositoryTaskData = this.getRepositoryTaskData();
        if (!(repositoryTaskData != null || this.synchronizeTask() && (repositoryTaskData = this.getRepositoryTaskData()) != null)) {
            return;
        }
        TaskAttribute attAttribute = new TaskAttribute(repositoryTaskData.getRoot(), "attachment");
        TaskAttributeMapper mapper = attAttribute.getTaskData().getAttributeMapper();
        TaskAttribute a = attAttribute.createMappedAttribute("task.common.attachment.description");
        a.setValue(desc);
        a = attAttribute.createMappedAttribute("task.common.attachment.patch");
        mapper.setBooleanValue(a, Boolean.valueOf(patch));
        a = attAttribute.createMappedAttribute("task.common.attachment.ctype");
        a.setValue(contentType);
        AddAttachmentCommand cmd = new AddAttachmentCommand(this.getID(), this.repository, comment, attachmentSource, file, attAttribute);
        this.repository.getExecutor().execute(cmd);
        if (!cmd.hasFailed()) {
            this.refresh(true);
        }
    }

    Comment[] getComments() {
        final ArrayList comments = new ArrayList();
        this.runWithModelLoaded(new Runnable(){

            @Override
            public void run() {
                List attrs;
                NbTaskDataModel m = BugzillaIssue.this.getModel();
                List list = attrs = m == null ? null : m.getLocalTaskData().getAttributeMapper().getAttributesByType(m.getLocalTaskData(), "comment");
                if (attrs != null) {
                    for (TaskAttribute taskAttribute : attrs) {
                        comments.add(new Comment(taskAttribute));
                    }
                }
            }
        });
        return comments.toArray(new Comment[comments.size()]);
    }

    public void addComment(final String comment, final boolean close) {
        assert (!EventQueue.isDispatchThread()) : "Accessing remote host. Do not call in awt";
        if (comment == null && !close) {
            return;
        }
        this.refresh();
        this.runWithModelLoaded(new Runnable(){

            @Override
            public void run() {
                if (close) {
                    Bugzilla.LOG.log(Level.FINER, "resolving issue #{0} as fixed", new Object[]{BugzillaIssue.this.getID()});
                    BugzillaIssue.this.resolve(BugzillaIssue.RESOLVE_FIXED);
                    if (BugzillaUtil.isNbRepository(BugzillaIssue.this.repository)) {
                        Properties p = System.getProperties();
                        Enumeration<Object> keys = p.keys();
                        LinkedList<String> keyList = new LinkedList<String>();
                        while (keys.hasMoreElements()) {
                            Object key = keys.nextElement();
                            if (!key.toString().startsWith(BugzillaIssue.VCSHOOK_BUGZILLA_FIELD)) continue;
                            keyList.add(key.toString());
                        }
                        for (String key : keyList) {
                            String fieldName = key.substring(BugzillaIssue.VCSHOOK_BUGZILLA_FIELD.length());
                            String value = p.getProperty(key);
                            IssueField issueField = BugzillaIssue.this.repository.getConfiguration().getField(fieldName);
                            if (issueField != null) {
                                if (issueField.isReadOnly()) {
                                    Bugzilla.LOG.log(Level.WARNING, "field [{0}] is read-only.", new Object[]{BugzillaIssue.this.repository.getUrl(), fieldName});
                                    continue;
                                }
                                BugzillaIssue.this.setFieldValue(issueField, value);
                                continue;
                            }
                            Bugzilla.LOG.log(Level.WARNING, "Repsitory [{0}] has no field [{1}]", new Object[]{BugzillaIssue.this.repository.getUrl(), fieldName});
                        }
                    }
                }
                if (comment != null) {
                    BugzillaIssue.this.addComment(comment);
                }
                BugzillaIssue.this.submitAndRefresh();
            }
        });
    }

    public void addComment(final String comment) {
        if (comment != null && !comment.isEmpty()) {
            this.runWithModelLoaded(new Runnable(){

                @Override
                public void run() {
                    Bugzilla.LOG.log(Level.FINER, "adding comment [{0}] to issue #{1}", new Object[]{comment, BugzillaIssue.this.getID()});
                    TaskAttribute ta = BugzillaIssue.this.getModel().getLocalTaskData().getRoot().getMappedAttribute(IssueField.COMMENT.getKey());
                    String value = ta.getValue();
                    value = value == null || value.trim().isEmpty() ? comment : value + "\n\n" + comment;
                    BugzillaIssue.this.setValue(BugzillaIssue.this.getModel(), ta, value);
                }
            });
        }
    }

    private void setDueDateAndSubmit(final Date date) {
        this.refresh();
        this.runWithModelLoaded(new Runnable(){

            @Override
            public void run() {
                if (date == null) {
                    BugzillaIssue.this.setFieldValue(IssueField.DEADLINE, "");
                } else {
                    BugzillaIssue.this.setFieldValue(IssueField.DEADLINE, DUE_DATE_FORMAT.format(date));
                }
                BugzillaIssue.this.submitAndRefresh();
            }
        });
    }

    public void attachPatch(File file, String description, boolean isPatch) {
        isPatch = !file.getName().endsWith(".hg");
        this.addAttachment(file, null, description, null, isPatch);
    }

    private void prepareSubmit() {
        if (this.initialProduct != null) {
            TaskAttribute ta = this.getModel().getLocalTaskData().getRoot().getMappedAttribute(BugzillaAttribute.CONFIRM_PRODUCT_CHANGE.getKey());
            if (ta == null) {
                ta = BugzillaTaskDataHandler.createAttribute((TaskAttribute)this.getModel().getLocalTaskData().getRoot(), (BugzillaAttribute)BugzillaAttribute.CONFIRM_PRODUCT_CHANGE);
            }
            this.setValue(this.getModel(), ta, "1");
        }
    }

    public boolean submitAndRefresh() {
        final boolean[] result = new boolean[1];
        this.runWithModelLoaded(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            public void run() {
                if (!9.$assertionsDisabled && EventQueue.isDispatchThread()) {
                    throw new AssertionError((Object)"Accessing remote host. Do not call in awt");
                }
                BugzillaIssue.access$1500(BugzillaIssue.this);
                addIDELog = this.fixAttachLog();
                newAttachments = BugzillaIssue.access$1600(BugzillaIssue.this);
                if (!newAttachments.isEmpty()) {
                    BugzillaIssue.access$1700(BugzillaIssue.this, Collections.emptyList());
                }
                wasNew = BugzillaIssue.this.isNew();
                try {
                    if (!BugzillaIssue.access$1800(BugzillaIssue.this)) {
                        result[0] = false;
                        return;
                    }
                    BugzillaIssue.access$1900(BugzillaIssue.this);
                    submitCmd = MylynSupport.getInstance().getCommandFactory().createSubmitTaskCommand(BugzillaIssue.access$2000(BugzillaIssue.this));
                }
                catch (CoreException ex) {
                    Bugzilla.LOG.log(Level.WARNING, null, ex);
                    result[0] = false;
                    return;
                }
                BugzillaIssue.access$1200(BugzillaIssue.this).getExecutor().execute((BugtrackingCommand)submitCmd);
                if (!submitCmd.hasFailed()) {
                    BugzillaIssue.access$2100(BugzillaIssue.this, submitCmd.getSubmittedTask());
                }
                if (!wasNew) {
                    BugzillaIssue.this.refresh();
                    if (BugzillaIssue.access$2200(BugzillaIssue.this) && !submitCmd.hasFailed()) {
                        try {
                            dupe = BugzillaIssue.access$1200(BugzillaIssue.this).getIssueCache().getIssue(BugzillaIssue.this.getFieldValue(IssueField.DUPLICATE_ID));
                            if (dupe == null) ** GOTO lbl57
                            dupe.refresh();
                        }
                        finally {
                            BugzillaIssue.access$2202(BugzillaIssue.this, false);
                        }
                    }
                } else {
                    rr = submitCmd.getRepositoryResponse();
                    if (!submitCmd.hasFailed()) {
                        BugzillaIssue.access$2300(BugzillaIssue.this);
                        BugzillaIssue.access$500(BugzillaIssue.this);
                        BugzillaIssue.access$2400(BugzillaIssue.this);
                        id = BugzillaIssue.this.getID();
                        BugzillaIssue.access$1200(BugzillaIssue.this).getIssueCache().setIssue(id, BugzillaIssue.this);
                        Bugzilla.LOG.log(Level.FINE, "created issue #{0}", id);
                        BugzillaIssue.access$1200(BugzillaIssue.this).refreshAllQueries();
                    } else {
                        Bugzilla.LOG.log(Level.FINE, "submiting failed");
                        if (rr != null) {
                            Bugzilla.LOG.log(Level.FINE, "repository response {0}", rr.getReposonseKind());
                        } else {
                            Bugzilla.LOG.log(Level.FINE, "no repository response available");
                        }
                    }
                }
lbl57:
                // 6 sources

                if (submitCmd.hasFailed()) {
                    result[0] = false;
                    needSave = false;
                    if (addIDELog) {
                        BugzillaIssue.this.setFieldValue(IssueField.NB_ATTACH_IDE_LOG, "1");
                        needSave = true;
                    }
                    if (!newAttachments.isEmpty()) {
                        BugzillaIssue.access$2500(BugzillaIssue.this, newAttachments);
                        needSave = true;
                    }
                    if (needSave) {
                        BugzillaIssue.access$2600(BugzillaIssue.this);
                    }
                    return;
                }
                if (addIDELog && (f = new File(Places.getUserDirectory(), "var/log/messages.log")).isFile()) {
                    BugzillaIssue.this.addAttachment(f, "", Bundle.MSG_LOG_FILE_DESC(), "text/plain", false);
                }
                if (!newAttachments.isEmpty()) {
                    for (AttachmentsPanel.AttachmentInfo attachment : newAttachments) {
                        if (!attachment.getFile().isFile()) continue;
                        if (attachment.getDescription().trim().length() == 0) {
                            attachment.setDescription(Bundle.BugzillaIssue_attachment_noDescription());
                        }
                        BugzillaIssue.this.addAttachment(attachment.getFile(), null, attachment.getDescription(), attachment.getContentType(), attachment.isPatch());
                    }
                }
                StatusDisplayer.getDefault().setStatusText(Bundle.MSG_BugzillaIssue_statusBar_submitted(BugzillaIssue.this.getDisplayName()));
                BugzillaIssue.this.setUpToDate(true, false);
                result[0] = true;
            }

            private boolean fixAttachLog() {
                String val = BugzillaIssue.this.getFieldValue(IssueField.NB_ATTACH_IDE_LOG);
                BugzillaIssue.this.getModel().getLocalTaskData().getRoot().removeAttribute(IssueField.NB_ATTACH_IDE_LOG.getKey());
                return "1".equals(val);
            }
        });
        return result[0];
    }

    void updateModelAndRefresh() {
        this.runWithModelLoaded(new Runnable(){

            @Override
            public void run() {
                BugzillaIssue.this.updateModel();
                BugzillaIssue.this.refresh();
            }
        });
    }

    public boolean refresh() {
        assert (!EventQueue.isDispatchThread()) : "Accessing remote host. Do not call in awt";
        return this.refresh(false);
    }

    private boolean refresh(boolean afterSubmitRefresh) {
        assert (!EventQueue.isDispatchThread()) : "Accessing remote host. Do not call in awt";
        boolean synced = this.synchronizeTask();
        if (!this.loading) {
            this.refreshViewData(afterSubmitRefresh);
        }
        return synced;
    }

    private void refreshViewData(boolean force) {
        if (this.controller != null) {
            this.controller.refreshViewData(force);
        }
    }

    Map<String, TaskOperation> getAvailableOperations() {
        if (this.availableOperations == null) {
            HashMap<String, TaskOperation> operations = new HashMap<String, TaskOperation>(5);
            NbTaskDataModel model = this.getModel();
            List allOperations = model.getLocalTaskData().getAttributeMapper().getAttributesByType(model.getLocalTaskData(), "operation");
            for (TaskAttribute operation : allOperations) {
                if (!operation.getId().startsWith("task.common.operation-")) continue;
                operations.put(operation.getId().substring("task.common.operation-".length()), TaskOperation.createFrom((TaskAttribute)operation));
            }
            this.availableOperations = operations;
        }
        return this.availableOperations;
    }

    boolean isResolveAvailable() {
        Map<String, TaskOperation> operations = this.getAvailableOperations();
        return operations.containsKey(BugzillaOperation.resolve.toString());
    }

    private String getMappedValue(TaskAttribute a, String key) {
        TaskAttribute ma = a.getMappedAttribute(key);
        if (ma != null) {
            return ma.getValue();
        }
        return null;
    }

    public void setUpToDate(boolean seen) {
        this.setUpToDate(seen, true);
    }

    private boolean updateTooltip() {
        boolean addNewLine;
        String displayName = this.getDisplayName();
        if (displayName.startsWith("#")) {
            displayName = displayName.replaceFirst("#", "");
        }
        String oldTooltip = this.tooltip;
        NbTask.SynchronizationState state = this.getSynchronizationState();
        URL iconPath = this.getStateIcon(state);
        String iconCode = "";
        if (iconPath != null) {
            iconCode = "<img src=\"" + iconPath + "\">&nbsp;";
        }
        String stateName = this.getStateDisplayName(state);
        String priorityLabel = NbBundle.getMessage(BugzillaIssue.class, (String)"CTL_Issue_Priority_Title");
        String priority = this.getRepositoryFieldValue(IssueField.PRIORITY);
        URL priorityIcon = BugzillaConfig.getInstance().getPriorityIconURL(priority);
        boolean showIssueType = BugzillaUtil.showIssueType(this.repository);
        String typeLabel = NbBundle.getMessage(BugzillaIssue.class, (String)(showIssueType ? "LBL_Type" : "CTL_Issue_Severity_Title"));
        String type = showIssueType ? this.getRepositoryFieldValue(IssueField.ISSUE_TYPE) : this.getRepositoryFieldValue(IssueField.SEVERITY);
        String productLabel = NbBundle.getMessage(BugzillaIssue.class, (String)"CTL_Issue_Product_Title");
        String product = this.getRepositoryFieldValue(IssueField.PRODUCT);
        String componentLabel = NbBundle.getMessage(BugzillaIssue.class, (String)"CTL_Issue_Component_Title");
        String component = this.getRepositoryFieldValue(IssueField.COMPONENT);
        String assigneeLabel = NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_Assigned");
        String assignee = this.getRepositoryFieldValue(IssueField.ASSIGNED_TO);
        String statusLabel = NbBundle.getMessage(BugzillaIssue.class, (String)"CTL_Issue_Status_Title");
        String status = this.getRepositoryFieldValue(IssueField.STATUS);
        String resolution = this.getRepositoryFieldValue(IssueField.RESOLUTION);
        if (resolution != null && !resolution.trim().isEmpty()) {
            status = status + "/" + resolution;
        }
        String scheduledLabel = NbBundle.getMessage(BugzillaIssue.class, (String)"CTL_Issue_Scheduled_Title");
        String scheduled = this.getScheduleDisplayString();
        String dueLabel = NbBundle.getMessage(BugzillaIssue.class, (String)"CTL_Issue_Due_Title");
        String due = this.getDueDisplayString();
        String estimateLabel = NbBundle.getMessage(BugzillaIssue.class, (String)"CTL_Issue_Estimate_Title");
        String estimate = this.getEstimateDisplayString();
        String fieldTable = "<table><tr><td><b>" + priorityLabel + ":</b></td><td><img src=\"" + priorityIcon + "\">&nbsp;" + priority + "</td><td style=\"padding-left:25px;\"><b>" + typeLabel + ":</b></td><td>" + type + "</td></tr>" + "<tr><td><b>" + productLabel + ":</b></td><td>" + product + "</td><td style=\"padding-left:25px;\"><b>" + componentLabel + ":</b></td><td>" + component + "</td></tr>" + "<tr><td><b>" + assigneeLabel + ":</b></td><td colspan=\"3\">" + assignee + "</td></tr>" + "<tr><td><b>" + statusLabel + ":</b></td><td colspan=\"3\">" + status + "</td></tr>";
        if (!scheduled.isEmpty()) {
            fieldTable = fieldTable + "<tr><td><b>" + scheduledLabel + ":</b></td><td colspan=\"3\">" + scheduled + "</td></tr>";
        }
        boolean bl = addNewLine = !due.isEmpty() || !estimate.isEmpty();
        if (addNewLine) {
            fieldTable = fieldTable + "<tr>";
        }
        if (!due.isEmpty()) {
            fieldTable = fieldTable + "<tr><td><b>" + dueLabel + ":</b></td><td>" + due + "</td>";
        }
        if (!estimate.isEmpty()) {
            fieldTable = fieldTable + "<td style=\"padding-left:25px;\"><b>" + estimateLabel + ":</b></td><td>" + estimate + "</td>";
        }
        if (addNewLine) {
            fieldTable = fieldTable + "</tr>";
        }
        fieldTable = fieldTable + "</table>";
        StringBuilder sb = new StringBuilder("<html>");
        sb.append("<b>").append(displayName).append("</b><br>");
        if (stateName != null && !stateName.isEmpty()) {
            sb.append("<p style=\"padding:5px;\">").append(iconCode).append(stateName).append("</p>");
        }
        sb.append("<hr>");
        sb.append(fieldTable);
        sb.append("</html>");
        this.tooltip = sb.toString();
        return !oldTooltip.equals(this.tooltip);
    }

    private URL getStateIcon(NbTask.SynchronizationState state) {
        URL iconPath = null;
        if (state.equals((Object)NbTask.SynchronizationState.CONFLICT)) {
            iconPath = ICON_CONFLICT_PATH;
        } else if (state.equals((Object)NbTask.SynchronizationState.INCOMING) || state.equals((Object)NbTask.SynchronizationState.INCOMING_NEW)) {
            iconPath = ICON_REMOTE_PATH;
        } else if (state.equals((Object)NbTask.SynchronizationState.OUTGOING) || state.equals((Object)NbTask.SynchronizationState.OUTGOING_NEW)) {
            iconPath = ICON_UNSUBMITTED_PATH;
        }
        return iconPath;
    }

    private String getStateDisplayName(NbTask.SynchronizationState state) {
        String displayName = "";
        if (state.equals((Object)NbTask.SynchronizationState.CONFLICT)) {
            displayName = NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_ConflictShort");
        } else if (state.equals((Object)NbTask.SynchronizationState.INCOMING)) {
            displayName = NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_RemoteShort");
        } else if (state.equals((Object)NbTask.SynchronizationState.INCOMING_NEW)) {
            displayName = NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_RemoteNewShort");
        } else if (state.equals((Object)NbTask.SynchronizationState.OUTGOING)) {
            displayName = NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_UnsubmittedShort");
        } else if (state.equals((Object)NbTask.SynchronizationState.OUTGOING_NEW)) {
            displayName = NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_UnsubmittedNewShort");
        }
        return displayName;
    }

    private boolean updateRecentChanges() {
        String oldChanges;
        block18: {
            oldChanges = this.recentChanges;
            this.recentChanges = "";
            NbTask.SynchronizationState syncState = this.getSynchronizationState();
            if (syncState == NbTask.SynchronizationState.INCOMING_NEW) {
                this.recentChanges = NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_NEW_STATUS");
            } else if (syncState == NbTask.SynchronizationState.INCOMING || syncState == NbTask.SynchronizationState.CONFLICT) {
                try {
                    NbTaskDataState taskDataState = this.getNbTask().getTaskDataState();
                    if (taskDataState == null) break block18;
                    TaskData repositoryData = taskDataState.getRepositoryData();
                    TaskData lastReadData = taskDataState.getLastReadData();
                    ArrayList<IssueField> changedFields = new ArrayList<IssueField>();
                    for (IssueField f : this.getRepository().getConfiguration().getFields()) {
                        if (f == IssueField.MODIFICATION || f == IssueField.REPORTER_NAME || f == IssueField.QA_CONTACT_NAME || f == IssueField.ASSIGNED_TO_NAME) continue;
                        String value = BugzillaIssue.getFieldValue(repositoryData, f);
                        String seenValue = BugzillaIssue.getFieldValue(lastReadData, f);
                        if (value.trim().equals(seenValue.trim())) continue;
                        changedFields.add(f);
                    }
                    int changedCount = changedFields.size();
                    if (changedCount == 1) {
                        String ret = null;
                        for (IssueField changedField : changedFields) {
                            if (changedField == IssueField.SUMMARY) {
                                ret = NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_SUMMARY_CHANGED_STATUS");
                                continue;
                            }
                            if (changedField == IssueField.CC) {
                                ret = NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_CC_FIELD_CHANGED_STATUS");
                                continue;
                            }
                            if (changedField == IssueField.KEYWORDS) {
                                ret = NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_KEYWORDS_CHANGED_STATUS");
                                continue;
                            }
                            if (changedField == IssueField.DEPENDS_ON || changedField == IssueField.BLOCKS) {
                                ret = NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_DEPENDENCE_CHANGED_STATUS");
                                continue;
                            }
                            if (changedField == IssueField.COMMENT_COUNT) {
                                String value = BugzillaIssue.getFieldValue(repositoryData, changedField);
                                String seenValue = BugzillaIssue.getFieldValue(lastReadData, changedField);
                                if (seenValue.equals("")) {
                                    seenValue = "0";
                                }
                                int count = 0;
                                try {
                                    count = Integer.parseInt(value) - Integer.parseInt(seenValue);
                                }
                                catch (NumberFormatException ex) {
                                    Bugzilla.LOG.log(Level.WARNING, ret, ex);
                                }
                                ret = NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_COMMENTS_CHANGED", (Object[])new Object[]{count});
                                continue;
                            }
                            if (changedField == IssueField.ATTACHEMENT_COUNT) {
                                ret = NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_ATTACHMENTS_CHANGED");
                                continue;
                            }
                            ret = NbBundle.getMessage(BugzillaIssue.class, (String)"LBL_CHANGED_TO", (Object[])new Object[]{changedField.getDisplayName(), BugzillaIssue.getFieldValue(repositoryData, changedField)});
                        }
                        this.recentChanges = ret;
                        break block18;
                    }
                    for (IssueField changedField : changedFields) {
                        String key = changedField == IssueField.SUMMARY ? "LBL_CHANGES_INCL_SUMMARY" : (changedField == IssueField.PRIORITY ? "LBL_CHANGES_INCL_PRIORITY" : (changedField == IssueField.SEVERITY ? "LBL_CHANGES_INCL_SEVERITY" : (changedField == IssueField.ISSUE_TYPE ? "LBL_CHANGES_INCL_ISSUE_TYPE" : (changedField == IssueField.PRODUCT ? "LBL_CHANGES_INCL_PRODUCT" : (changedField == IssueField.COMPONENT ? "LBL_CHANGES_INCL_COMPONENT" : (changedField == IssueField.PLATFORM ? "LBL_CHANGES_INCL_PLATFORM" : (changedField == IssueField.VERSION ? "LBL_CHANGES_INCL_VERSION" : (changedField == IssueField.MILESTONE ? "LBL_CHANGES_INCL_MILESTONE" : (changedField == IssueField.KEYWORDS ? "LBL_CHANGES_INCL_KEYWORDS" : (changedField == IssueField.URL ? "LBL_CHANGES_INCL_URL" : (changedField == IssueField.ASSIGNED_TO ? "LBL_CHANGES_INCL_ASSIGNEE" : (changedField == IssueField.QA_CONTACT ? "LBL_CHANGES_INCL_QA_CONTACT" : (changedField == IssueField.DEPENDS_ON || changedField == IssueField.BLOCKS ? "LBL_CHANGES_INCLUSIVE_DEPENDENCE" : "LBL_CHANGES")))))))))))));
                        this.recentChanges = NbBundle.getMessage(BugzillaIssue.class, (String)key, (Object[])new Object[]{changedCount});
                    }
                }
                catch (CoreException ex) {
                    Bugzilla.LOG.log(Level.WARNING, null, ex);
                }
            }
        }
        return !oldChanges.equals(this.recentChanges);
    }

    protected void modelSaved(NbTaskDataModel model) {
        if (this.controller != null) {
            this.controller.modelStateChanged(model.isDirty(), model.hasOutgoingChanged());
        }
    }

    protected String getSummary(TaskData taskData) {
        return BugzillaIssue.getFieldValue(taskData, IssueField.SUMMARY);
    }

    protected void attributeChanged(NbTaskDataModel.NbTaskDataModelEvent event, NbTaskDataModel model) {
        if (this.controller != null) {
            this.controller.modelStateChanged(model.isDirty(), model.isDirty() || !model.getChangedAttributes().isEmpty());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean synchronizeTask() {
        try {
            NbTask task;
            NbTask nbTask = task = this.getNbTask();
            synchronized (nbTask) {
                Bugzilla.LOG.log(Level.FINE, "refreshing issue #{0}", task.getTaskId());
                SynchronizeTasksCommand cmd = MylynSupport.getInstance().getCommandFactory().createSynchronizeTasksCommand(this.getRepository().getTaskRepository(), Collections.singleton(task));
                this.getRepository().getExecutor().execute((BugtrackingCommand)cmd);
                return !cmd.hasFailed();
            }
        }
        catch (CoreException ex) {
            Bugzilla.LOG.log(Level.WARNING, null, ex);
            return false;
        }
    }

    boolean save() {
        return this.saveChanges();
    }

    private void setValue(NbTaskDataModel model, TaskAttribute ta, String value) {
        TaskData repositoryTaskData = model.getRepositoryTaskData();
        if (value.isEmpty() && repositoryTaskData != null) {
            TaskAttribute a = repositoryTaskData.getRoot().getAttribute(ta.getId());
            if (a == null || a.getValues().isEmpty()) {
                ta.clearValues();
            } else {
                ta.setValue(value);
            }
        } else {
            ta.setValue(value);
        }
        model.attributeChanged(ta);
    }

    boolean setUnsubmittedAttachments(List<AttachmentsPanel.AttachmentInfo> newAttachments) {
        return super.setNewAttachments(newAttachments);
    }

    List<AttachmentsPanel.AttachmentInfo> getUnsubmittedAttachments() {
        return this.getNewAttachments();
    }

    void setTaskPrivateNotes(String notes) {
        super.setPrivateNotes(notes);
        if (this.controller != null) {
            this.controller.modelStateChanged(true, this.hasLocalEdits());
        }
    }

    public void setTaskDueDate(final Date date, final boolean persistChange) {
        this.runWithModelLoaded(new Runnable(){

            @Override
            public void run() {
                if (BugzillaIssue.this.hasTimeTracking()) {
                    BugzillaIssue.this.setDueDateAndSubmit(date);
                } else {
                    BugzillaIssue.this.setDueDate(date, persistChange);
                    if (BugzillaIssue.this.controller != null) {
                        BugzillaIssue.this.controller.modelStateChanged(BugzillaIssue.this.hasUnsavedChanges(), BugzillaIssue.this.hasLocalEdits());
                    }
                    if (persistChange) {
                        BugzillaIssue.this.dataChanged();
                    }
                }
            }
        });
    }

    public void setTaskScheduleDate(IssueScheduleInfo date, boolean persistChange) {
        super.setScheduleDate(date, persistChange);
        if (this.controller != null) {
            this.controller.modelStateChanged(this.hasUnsavedChanges(), this.hasLocalEdits());
        }
        if (persistChange) {
            this.dataChanged();
        }
    }

    public void setTaskEstimate(int estimate, boolean persistChange) {
        super.setEstimate(estimate, persistChange);
        if (this.controller != null) {
            this.controller.modelStateChanged(this.hasUnsavedChanges(), this.hasLocalEdits());
        }
        if (persistChange) {
            this.dataChanged();
        }
    }

    public boolean discardLocalEdits() {
        final boolean[] retval = new boolean[1];
        this.runWithModelLoaded(new Runnable(){

            @Override
            public void run() {
                BugzillaIssue.this.clearUnsavedChanges();
                retval[0] = BugzillaIssue.this.cancelChanges();
                if (BugzillaIssue.this.controller != null) {
                    BugzillaIssue.this.controller.modelStateChanged(BugzillaIssue.this.hasUnsavedChanges(), BugzillaIssue.this.hasLocalEdits());
                    BugzillaIssue.this.controller.refreshViewData(false);
                }
            }
        });
        return retval[0];
    }

    public String getPriority() {
        return this.getRepositoryFieldValue(IssueField.PRIORITY);
    }

    protected void taskDataUpdated() {
        this.availableOperations = null;
        this.ensureConfigurationUptodate();
        Bugzilla.getInstance().getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                BugzillaIssue.this.dataChanged();
            }
        });
    }

    private void dataChanged() {
        this.updateTooltip();
        this.fireDataChanged();
        this.refreshViewData(false);
    }

    protected void taskModified(boolean syncStateChanged) {
        if (this.updateRecentChanges() | this.updateTooltip()) {
            this.fireDataChanged();
        }
        if (syncStateChanged) {
            this.fireStatusChanged();
        }
    }

    void fireChangeEvent() {
        this.fireChanged();
    }

    static /* synthetic */ void access$1500(BugzillaIssue x0) {
        x0.prepareSubmit();
    }

    static /* synthetic */ List access$1600(BugzillaIssue x0) {
        return x0.getNewAttachments();
    }

    static /* synthetic */ boolean access$1700(BugzillaIssue x0, List x1) {
        return x0.setNewAttachments(x1);
    }

    static /* synthetic */ boolean access$1800(BugzillaIssue x0) {
        return x0.saveChanges();
    }

    static /* synthetic */ void access$1900(BugzillaIssue x0) {
        x0.fireChanged();
    }

    static /* synthetic */ NbTaskDataModel access$2000(BugzillaIssue x0) {
        return x0.getModel();
    }

    static /* synthetic */ void access$2100(BugzillaIssue x0, NbTask x1) {
        x0.taskSubmitted(x1);
    }

    static /* synthetic */ boolean access$2200(BugzillaIssue x0) {
        return x0.wasDuplicated;
    }

    static /* synthetic */ boolean access$2202(BugzillaIssue x0, boolean x1) {
        x0.wasDuplicated = x1;
        return x0.wasDuplicated;
    }

    static /* synthetic */ boolean access$2300(BugzillaIssue x0) {
        return x0.updateRecentChanges();
    }

    static /* synthetic */ void access$2400(BugzillaIssue x0) {
        x0.fireDataChanged();
    }

    static /* synthetic */ boolean access$2500(BugzillaIssue x0, List x1) {
        return x0.setNewAttachments(x1);
    }

    static /* synthetic */ boolean access$2600(BugzillaIssue x0) {
        return x0.saveChanges();
    }

    class Attachment
    extends AttachmentsPanel.AbstractAttachment {
        private final String desc;
        private final String filename;
        private final String author;
        private final String authorName;
        private final Date date;
        private final String id;
        private final String contentType;
        private final String isDeprected;
        private final String size;
        private final String isPatch;
        private final String url;

        public Attachment(TaskAttribute ta) {
            this.id = ta.getValue();
            Date d = null;
            String s = "";
            try {
                s = BugzillaIssue.this.getMappedValue(ta, "task.common.attachment.date");
                if (s != null && !s.trim().equals("")) {
                    d = CC_DATE_FORMAT.parse(s);
                }
            }
            catch (ParseException ex) {
                Bugzilla.LOG.log(Level.SEVERE, s, ex);
            }
            this.date = d;
            this.filename = BugzillaIssue.this.getMappedValue(ta, "filename");
            this.desc = BugzillaIssue.this.getMappedValue(ta, "task.common.attachment.description");
            TaskAttribute authorAttr = ta.getMappedAttribute("task.common.attachment.author");
            if (authorAttr != null) {
                this.author = authorAttr.getValue();
                TaskAttribute nameAttr = authorAttr.getMappedAttribute("task.common.person.name");
                this.authorName = nameAttr != null ? nameAttr.getValue() : null;
            } else {
                authorAttr = ta.getTaskData().getRoot().getMappedAttribute(IssueField.REPORTER.getKey());
                if (authorAttr != null) {
                    this.author = authorAttr.getValue();
                    TaskAttribute nameAttr = authorAttr.getMappedAttribute("task.common.person.name");
                    this.authorName = nameAttr != null ? nameAttr.getValue() : null;
                } else {
                    this.authorName = null;
                    this.author = null;
                }
            }
            this.contentType = BugzillaIssue.this.getMappedValue(ta, "task.common.attachment.ctype");
            this.isDeprected = BugzillaIssue.this.getMappedValue(ta, "task.common.attachment.deprecated");
            this.isPatch = BugzillaIssue.this.getMappedValue(ta, "task.common.attachment.patch");
            this.size = BugzillaIssue.this.getMappedValue(ta, "task.common.attachment.size");
            this.url = BugzillaIssue.this.getMappedValue(ta, "task.common.attachment.url");
        }

        public boolean isPatch() {
            return "1".equals(this.isPatch);
        }

        public String getAuthorName() {
            return this.authorName;
        }

        public String getAuthor() {
            return this.author;
        }

        public Date getDate() {
            return this.date;
        }

        public String getDesc() {
            return this.desc;
        }

        public String getFilename() {
            return this.filename;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getId() {
            return this.id;
        }

        public boolean isDeprecated() {
            return "1".equals(this.isDeprected);
        }

        public String getSize() {
            return this.size;
        }

        public String getUrl() {
            return this.url;
        }

        public void getAttachementData(OutputStream os) {
            assert (!EventQueue.isDispatchThread()) : "Accessing remote host. Do not call in awt";
            BugzillaIssue.this.repository.getExecutor().execute(new GetAttachmentCommand(BugzillaIssue.this.repository, this.id, os));
        }

        public void open() {
            super.open();
        }
    }

    class Comment {
        private final Date when;
        private final String author;
        private final String authorName;
        private final Long number;
        private final String text;
        private final Double worked;

        public Comment(TaskAttribute a) {
            Date d = null;
            String s = "";
            try {
                s = BugzillaIssue.this.getMappedValue(a, "task.common.comment.date");
                if (s != null && !s.trim().equals("")) {
                    d = CC_DATE_FORMAT.parse(s);
                }
            }
            catch (ParseException ex) {
                Bugzilla.LOG.log(Level.SEVERE, s, ex);
            }
            this.when = d;
            TaskAttribute authorAttr = a.getMappedAttribute("task.common.comment.author");
            if (authorAttr != null) {
                this.author = authorAttr.getValue();
                TaskAttribute nameAttr = authorAttr.getMappedAttribute("task.common.person.name");
                this.authorName = nameAttr != null ? nameAttr.getValue() : null;
            } else {
                this.authorName = null;
                this.author = null;
            }
            String n = BugzillaIssue.this.getMappedValue(a, "task.common.comment.number");
            this.number = n != null ? Long.valueOf(Long.parseLong(n)) : null;
            this.text = BugzillaIssue.this.getMappedValue(a, "task.common.comment.text");
            String workedString = BugzillaIssue.this.getMappedValue(a, BugzillaAttribute.WORK_TIME.getKey());
            double dbWorked = 0.0;
            if (workedString == null || workedString.isEmpty()) {
                dbWorked = 0.0;
            } else {
                try {
                    dbWorked = Double.parseDouble(workedString);
                }
                catch (NumberFormatException e) {
                    Bugzilla.LOG.log(Level.WARNING, "WORK_TIME time for comment " + this.number + " is " + workedString, e);
                    dbWorked = 0.0;
                }
            }
            this.worked = dbWorked;
        }

        public Long getNumber() {
            return this.number;
        }

        public String getText() {
            return this.text;
        }

        public Date getWhen() {
            return this.when;
        }

        public String getAuthor() {
            return this.author;
        }

        public String getAuthorName() {
            return this.authorName;
        }

        public Double getWorked() {
            return this.worked;
        }
    }
}

