/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.hints;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ReplaceWithPragmaOnce
implements Fix {
    private final BaseDocument doc;
    private final int guardBlockStart;
    private final int guardBlockEnd;

    public ReplaceWithPragmaOnce(Document doc, int guardBlockStart, int guardBlockEnd) {
        this.doc = (BaseDocument)doc;
        this.guardBlockStart = guardBlockStart;
        this.guardBlockEnd = guardBlockEnd;
    }

    public String getText() {
        return NbBundle.getMessage(ReplaceWithPragmaOnce.class, (String)"HINT_Pragma");
    }

    public ChangeInfo implement() throws Exception {
        Position startPosition = NbDocument.createPosition((Document)this.doc, (int)this.guardBlockStart, (Position.Bias)Position.Bias.Forward);
        Position endPosition = NbDocument.createPosition((Document)this.doc, (int)this.guardBlockEnd, (Position.Bias)Position.Bias.Backward);
        final AtomicInteger result = new AtomicInteger(-1);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TokenSequence docTokenSequence = CndLexerUtilities.getCppTokenSequence((Document)ReplaceWithPragmaOnce.this.doc, (int)ReplaceWithPragmaOnce.this.doc.getLength(), (boolean)false, (boolean)true);
                if (docTokenSequence == null) {
                    return;
                }
                docTokenSequence.moveEnd();
                while (docTokenSequence.movePrevious()) {
                    if (!(docTokenSequence.token().id() instanceof CppTokenId)) continue;
                    CppTokenId tokenId = (CppTokenId)docTokenSequence.token().id();
                    if (tokenId.equals((Object)CppTokenId.PREPROCESSOR_DIRECTIVE)) {
                        TokenSequence preprocTokenSequence = docTokenSequence.embedded(CppTokenId.languagePreproc());
                        if (preprocTokenSequence == null) {
                            return;
                        }
                        preprocTokenSequence.moveStart();
                        while (preprocTokenSequence.moveNext()) {
                            if (!((CppTokenId)preprocTokenSequence.token().id()).equals((Object)CppTokenId.PREPROCESSOR_ENDIF)) continue;
                            result.set(preprocTokenSequence.offset());
                            return;
                        }
                        continue;
                    }
                    if (tokenId.primaryCategory().equals("whitespace") || tokenId.primaryCategory().equals("comment")) continue;
                    return;
                }
            }
        };
        FutureTask<AtomicInteger> atomicOffset = new FutureTask<AtomicInteger>(runnable, result);
        this.doc.render(atomicOffset);
        try {
            int lastOffset = atomicOffset.get().get();
            if (lastOffset != -1) {
                Position startEndifPosition = NbDocument.createPosition((Document)this.doc, (int)(--lastOffset), (Position.Bias)Position.Bias.Forward);
                Position endEndifPosition = NbDocument.createPosition((Document)this.doc, (int)this.doc.getLength(), (Position.Bias)Position.Bias.Backward);
                this.doc.replace(startPosition.getOffset(), endPosition.getOffset() - startPosition.getOffset(), "#pragma once", null);
                this.doc.replace(startEndifPosition.getOffset(), endEndifPosition.getOffset() - startEndifPosition.getOffset(), "", null);
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }
}

