/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.control;

import java.awt.EventQueue;
import java.awt.Frame;
import java.io.File;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.RecordSession;
import org.parosproxy.paros.extension.AbstractDialog;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SessionListener;
import org.parosproxy.paros.view.View;
import org.parosproxy.paros.view.WaitMessageDialog;
import org.zaproxy.zap.model.IllegalContextNameException;
import org.zaproxy.zap.view.ContextExportDialog;
import org.zaproxy.zap.view.PersistSessionDialog;
import org.zaproxy.zap.view.SessionTableSelectDialog;

public class MenuFileControl
implements SessionListener {
    private static Logger log = Logger.getLogger(MenuFileControl.class);
    private View view = null;
    private Model model = null;
    private Control control = null;
    private WaitMessageDialog waitMessageDialog = null;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");

    public MenuFileControl(Model model, View view, Control control) {
        this.view = view;
        this.model = model;
        this.control = control;
    }

    public void exit() {
        this.control.exit(false, null);
    }

    public void newSession(boolean bl) throws ClassNotFoundException, Exception {
        Object object;
        if (bl) {
            if (this.model.getSession().isNewState()) {
                if (this.view.showConfirmDialog(Constant.messages.getString("menu.file.discardSession")) != 0) {
                    return;
                }
                this.control.discardSession();
            } else if (this.view.showConfirmDialog(Constant.messages.getString("menu.file.closeSession")) != 0) {
                return;
            }
        }
        int n = this.model.getOptionsParam().getDatabaseParam().getNewSessionOption();
        if (this.model.getOptionsParam().getDatabaseParam().isNewSessionPrompt()) {
            object = new PersistSessionDialog(View.getSingleton().getMainFrame());
            switch (n) {
                case 1: {
                    ((PersistSessionDialog)object).setTimestampChosen();
                    break;
                }
                case 2: {
                    ((PersistSessionDialog)object).setPersistChosen();
                    break;
                }
                case 3: {
                    ((PersistSessionDialog)object).setTemporaryChosen();
                    break;
                }
            }
            ((AbstractDialog)object).setVisible(true);
            n = ((PersistSessionDialog)object).isTimestampChosen() ? 1 : (((PersistSessionDialog)object).isPersistChosen() ? 2 : 3);
            this.model.getOptionsParam().getDatabaseParam().setNewSessionOption(n);
            this.model.getOptionsParam().getDatabaseParam().setNewSessionPrompt(!((PersistSessionDialog)object).isDontAskAgain());
        }
        switch (n) {
            case 1: {
                object = this.getTimestampFilename();
                if (object != null) {
                    this.newSession((String)object);
                    break;
                }
                this.control.newSession();
                break;
            }
            case 2: {
                this.control.newSession();
                this.saveAsSession();
                break;
            }
            default: {
                this.control.newSession();
            }
        }
    }

    private String getTimestampFilename() {
        File file = new File(Constant.getZapHome(), "sessions");
        if (!file.exists() && !file.mkdirs()) {
            return null;
        }
        String string = this.dateFormat.format(new Date());
        File file2 = new File(file, string + ".session");
        return file2.getAbsolutePath();
    }

    public boolean newSession(String string) {
        final Object[] objectArray = new Object[]{Boolean.TRUE};
        this.waitMessageDialog = this.view.getWaitMessageDialog(Constant.messages.getString("menu.file.newSession.wait.dialogue"));
        this.control.newSession(string, new SessionListener(){

            @Override
            public void sessionSnapshot(Exception exception) {
            }

            @Override
            public void sessionSaved(final Exception exception) {
                if (EventQueue.isDispatchThread()) {
                    if (exception == null) {
                        MenuFileControl.this.setTitle();
                        MenuFileControl.this.view.getSiteTreePanel().getTreeSite().setModel(MenuFileControl.this.model.getSession().getSiteTree());
                    } else {
                        MenuFileControl.this.view.showWarningDialog(Constant.messages.getString("menu.file.newSession.error"));
                        log.error((Object)("Error creating session file " + MenuFileControl.this.model.getSession().getFileName()), (Throwable)exception);
                        objectArray[0] = Boolean.FALSE;
                    }
                    if (MenuFileControl.this.waitMessageDialog != null) {
                        MenuFileControl.this.waitMessageDialog.setVisible(false);
                        MenuFileControl.this.waitMessageDialog = null;
                    }
                } else {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.sessionSaved(exception);
                        }
                    });
                }
            }

            @Override
            public void sessionOpened(File file, Exception exception) {
            }
        });
        this.waitMessageDialog.setVisible(true);
        return objectArray[0] == Boolean.TRUE;
    }

    public boolean openSession(String string) {
        final Object[] objectArray = new Object[]{Boolean.TRUE};
        File file = new File(string);
        this.waitMessageDialog = this.view.getWaitMessageDialog(Constant.messages.getString("menu.file.loadSession"));
        log.info((Object)("opening session file " + file.getAbsolutePath()));
        this.control.openSession(file, new SessionListener(){

            @Override
            public void sessionSnapshot(Exception exception) {
            }

            @Override
            public void sessionSaved(Exception exception) {
            }

            @Override
            public void sessionOpened(final File file, final Exception exception) {
                if (EventQueue.isDispatchThread()) {
                    if (exception != null) {
                        MenuFileControl.this.view.showWarningDialog(Constant.messages.getString("menu.file.openSession.error"));
                        log.error((Object)("error opening session file " + MenuFileControl.this.model.getSession().getFileName()), (Throwable)exception);
                        objectArray[0] = Boolean.FALSE;
                    }
                    MenuFileControl.this.view.getSiteTreePanel().getTreeSite().setModel(MenuFileControl.this.model.getSession().getSiteTree());
                    MenuFileControl.this.setTitle();
                    if (MenuFileControl.this.waitMessageDialog != null) {
                        MenuFileControl.this.waitMessageDialog.setVisible(false);
                        MenuFileControl.this.waitMessageDialog = null;
                    }
                } else {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.sessionOpened(file, exception);
                        }
                    });
                }
            }
        });
        this.waitMessageDialog.setVisible(true);
        return objectArray[0] == Boolean.TRUE;
    }

    public void openSession() {
        if ("hsqldb".equals(this.model.getDb().getType())) {
            this.openFileBasedSession();
        } else {
            this.openDbBasedSession();
        }
    }

    private void openFileBasedSession() {
        JFileChooser jFileChooser = new JFileChooser(this.model.getOptionsParam().getUserDirectory());
        jFileChooser.setFileHidingEnabled(false);
        File file = null;
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.isFile() && file.getName().endsWith(".session");
            }

            @Override
            public String getDescription() {
                return Constant.messages.getString("file.format.zap.session");
            }
        });
        int n = jFileChooser.showOpenDialog(this.view.getMainFrame());
        if (n == 0) {
            try {
                file = jFileChooser.getSelectedFile();
                if (file == null) {
                    return;
                }
                this.model.getOptionsParam().setUserDirectory(jFileChooser.getCurrentDirectory());
                log.info((Object)("opening session file " + file.getAbsolutePath()));
                this.waitMessageDialog = this.view.getWaitMessageDialog(Constant.messages.getString("menu.file.loadSession"));
                this.control.openSession(file, (SessionListener)this);
                this.waitMessageDialog.setVisible(true);
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private void openDbBasedSession() {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (RecordSession recordSession : this.model.getDb().getTableSession().listSessions()) {
                arrayList.add("" + recordSession.getSessionId());
            }
            SessionTableSelectDialog sessionTableSelectDialog = new SessionTableSelectDialog((Frame)View.getSingleton().getMainFrame(), arrayList);
            sessionTableSelectDialog.setVisible(true);
            if (sessionTableSelectDialog.getSelectedSession() != null) {
                this.waitMessageDialog = this.view.getWaitMessageDialog(Constant.messages.getString("menu.file.loadSession"));
                this.control.openSession(sessionTableSelectDialog.getSelectedSession(), (SessionListener)this);
                this.waitMessageDialog.setVisible(true);
            }
        }
        catch (DatabaseException databaseException) {
            log.error((Object)databaseException.getMessage(), (Throwable)databaseException);
        }
    }

    public void saveSession() {
        Session session = this.model.getSession();
        if (session.isNewState()) {
            this.view.showWarningDialog("Please use Save As...");
            return;
        }
        try {
            this.waitMessageDialog = this.view.getWaitMessageDialog(Constant.messages.getString("menu.file.savingSession"));
            this.control.saveSession(session.getFileName(), this);
            log.info((Object)("saving session file " + session.getFileName()));
            if (this.waitMessageDialog != null) {
                this.waitMessageDialog.setVisible(true);
            }
        }
        catch (Exception exception) {
            this.view.showWarningDialog(Constant.messages.getString("menu.file.savingSession.error"));
            log.error((Object)("error saving session file " + session.getFileName()));
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    public void saveAsSession() {
        Session session = this.model.getSession();
        JFileChooser jFileChooser = new JFileChooser(this.model.getOptionsParam().getUserDirectory());
        File file = new File(session.getSessionName());
        if (session.getFileName() != null && session.getFileName().trim().length() > 0) {
            file = new File(session.getFileName());
        }
        jFileChooser.setSelectedFile(file);
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.isFile() && file.getName().endsWith(".session");
            }

            @Override
            public String getDescription() {
                return Constant.messages.getString("file.format.zap.session");
            }
        });
        File file2 = null;
        int n = jFileChooser.showSaveDialog(this.view.getMainFrame());
        if (n == 0) {
            file2 = jFileChooser.getSelectedFile();
            if (file2 == null) {
                return;
            }
            this.model.getOptionsParam().setUserDirectory(jFileChooser.getCurrentDirectory());
            String string = file2.getAbsolutePath();
            if (!string.endsWith(".session")) {
                string = string + ".session";
            }
            try {
                this.waitMessageDialog = this.view.getWaitMessageDialog(Constant.messages.getString("menu.file.savingSession"));
                this.control.saveSession(string, this);
                log.info((Object)("save as session file " + session.getFileName()));
                this.waitMessageDialog.setVisible(true);
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    public void saveSnapshot() {
        Object object;
        Session session = this.model.getSession();
        JFileChooser jFileChooser = new JFileChooser(this.model.getOptionsParam().getUserDirectory());
        File file = new File(session.getSessionName());
        if (session.getFileName() != null && session.getFileName().trim().length() > 0) {
            object = StringUtils.removeEnd((String)session.getFileName(), (String)".session");
            object = (String)object + "-" + this.dateFormat.format(new Date()) + ".session";
            file = new File((String)object);
        }
        jFileChooser.setSelectedFile(file);
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.isFile() && file.getName().endsWith(".session");
            }

            @Override
            public String getDescription() {
                return Constant.messages.getString("file.format.zap.session");
            }
        });
        object = null;
        int n = jFileChooser.showSaveDialog(this.view.getMainFrame());
        if (n == 0) {
            object = jFileChooser.getSelectedFile();
            if (object == null) {
                return;
            }
            this.model.getOptionsParam().setUserDirectory(jFileChooser.getCurrentDirectory());
            String string = ((File)object).getAbsolutePath();
            if (!string.endsWith(".session")) {
                string = string + ".session";
            }
            try {
                this.waitMessageDialog = this.view.getWaitMessageDialog(Constant.messages.getString("menu.file.savingSnapshot"));
                this.control.snapshotSession(string, this);
                log.info((Object)("Snapshotting: " + session.getFileName() + " as " + string));
                this.waitMessageDialog.setVisible(true);
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private void setTitle() {
        StringBuilder stringBuilder = new StringBuilder(this.model.getSession().getSessionName());
        if (!this.model.getSession().isNewState()) {
            File file = new File(this.model.getSession().getFileName());
            stringBuilder.append(" - ").append(file.getName().replaceAll(".session\\z", ""));
        }
        this.view.getMainFrame().setTitle(stringBuilder.toString());
    }

    public void properties() {
        View.getSingleton().showSessionDialog(this.model.getSession(), null);
        this.setTitle();
    }

    @Override
    public void sessionOpened(File file, Exception exception) {
        if (exception == null) {
            this.setTitle();
        } else {
            this.view.showWarningDialog(Constant.messages.getString("menu.file.openSession.errorFile"));
            if (file != null) {
                log.error((Object)("Error opening session file " + file.getAbsolutePath()), (Throwable)exception);
            } else {
                log.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
        if (this.waitMessageDialog != null) {
            this.waitMessageDialog.setVisible(false);
            this.waitMessageDialog = null;
        }
    }

    @Override
    public void sessionSaved(Exception exception) {
        if (exception == null) {
            this.setTitle();
        } else {
            this.view.showWarningDialog(Constant.messages.getString("menu.file.savingSession.error"));
            log.error((Object)("error saving session file " + this.model.getSession().getFileName()), (Throwable)exception);
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
        if (this.waitMessageDialog != null) {
            this.waitMessageDialog.setVisible(false);
            this.waitMessageDialog = null;
        }
    }

    @Override
    public void sessionSnapshot(Exception exception) {
        if (exception != null) {
            this.view.showWarningDialog(Constant.messages.getString("menu.file.snapshotSession.error"));
            log.error((Object)("error saving snapshot file " + this.model.getSession().getFileName()), (Throwable)exception);
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
        if (this.waitMessageDialog != null) {
            this.waitMessageDialog.setVisible(false);
            this.waitMessageDialog = null;
        }
    }

    public void importContext() {
        JFileChooser jFileChooser = new JFileChooser(Constant.getContextsDir());
        File file = null;
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.isFile() && file.getName().endsWith(".context");
            }

            @Override
            public String getDescription() {
                return Constant.messages.getString("file.format.zap.context");
            }
        });
        int n = jFileChooser.showOpenDialog(View.getSingleton().getMainFrame());
        if (n == 0) {
            try {
                file = jFileChooser.getSelectedFile();
                if (file == null || !file.exists()) {
                    return;
                }
                Model.getSingleton().getSession().importContext(file);
                View.getSingleton().showSessionDialog(Model.getSingleton().getSession(), Constant.messages.getString("context.list"), true);
            }
            catch (IllegalContextNameException illegalContextNameException) {
                String string = illegalContextNameException.getReason() == IllegalContextNameException.Reason.EMPTY_NAME ? Constant.messages.getString("context.error.name.empty") : (illegalContextNameException.getReason() == IllegalContextNameException.Reason.DUPLICATED_NAME ? Constant.messages.getString("context.error.name.duplicated") : Constant.messages.getString("context.error.name.unknown"));
                View.getSingleton().showWarningDialog(MessageFormat.format(Constant.messages.getString("context.import.error"), string));
            }
            catch (Exception exception) {
                log.debug((Object)exception.getMessage(), (Throwable)exception);
                View.getSingleton().showWarningDialog(MessageFormat.format(Constant.messages.getString("context.import.error"), exception.getMessage()));
            }
        }
    }

    public void exportContext() {
        ContextExportDialog contextExportDialog = new ContextExportDialog(View.getSingleton().getMainFrame());
        contextExportDialog.setVisible(true);
    }
}

