/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.model;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.httpclient.URI;
import org.apache.log4j.Logger;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.RecordAlert;
import org.parosproxy.paros.db.RecordHistory;
import org.parosproxy.paros.db.RecordTag;
import org.parosproxy.paros.db.TableAlert;
import org.parosproxy.paros.db.TableHistory;
import org.parosproxy.paros.db.TableTag;
import org.parosproxy.paros.model.HttpMessageCachedData;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;

public class HistoryReference {
    public static final int TYPE_TEMPORARY = 0;
    @Deprecated
    public static final int TYPE_MANUAL = 1;
    public static final int TYPE_PROXIED = 1;
    public static final int TYPE_ZAP_USER = 15;
    public static final int TYPE_SPIDER = 2;
    public static final int TYPE_SCANNER = 3;
    public static final int TYPE_HIDDEN = 6;
    public static final int TYPE_BRUTE_FORCE = 7;
    public static final int TYPE_FUZZER = 8;
    public static final int TYPE_SPIDER_TASK = 9;
    public static final int TYPE_SPIDER_AJAX = 10;
    public static final int TYPE_AUTHENTICATION = 11;
    public static final int TYPE_ACCESS_CONTROL = 13;
    public static final int TYPE_ZEST_SCRIPT = 12;
    @Deprecated
    public static final int TYPE_RESERVED_11 = 12;
    public static final int TYPE_SCANNER_TEMPORARY = 14;
    private static final Set<Integer> TEMPORARY_HISTORY_TYPES = new HashSet<Integer>();
    public static final Set<Integer> DEFAULT_TEMPORARY_HISTORY_TYPES;
    public static final int TYPE_PROXY_CONNECT = 16;
    public static final int TYPE_SEQUENCE_TEMPORARY = 17;
    public static final int TYPE_SPIDER_AJAX_TEMPORARY = 18;
    public static final int TYPE_SPIDER_TEMPORARY = 19;
    private static DecimalFormat decimalFormat;
    private static TableHistory staticTableHistory;
    private static TableTag staticTableTag;
    private static TableAlert staticTableAlert;
    private int historyId = 0;
    private int historyType = 1;
    private SiteNode siteNode = null;
    private String display = null;
    private long sessionId = 0L;
    private ArrayList<String> icons = null;
    private ArrayList<Boolean> clearIfManual = null;
    private Set<Alert> alerts;
    private List<String> tags = new ArrayList<String>();
    private boolean webSocketUpgrade;
    private static Logger log;
    private HttpMessageCachedData httpMessageCachedData;

    public long getSessionId() {
        return this.sessionId;
    }

    public HistoryReference(int n) throws HttpMalformedHeaderException, DatabaseException {
        RecordHistory recordHistory = null;
        this.icons = new ArrayList();
        this.clearIfManual = new ArrayList();
        recordHistory = staticTableHistory.read(n);
        if (recordHistory == null) {
            throw new HttpMalformedHeaderException();
        }
        HttpMessage httpMessage = recordHistory.getHttpMessage();
        List<RecordTag> list = staticTableTag.getTagsForHistoryID(n);
        for (RecordTag recordTag : list) {
            this.tags.add(recordTag.getTag());
        }
        this.build(recordHistory.getSessionId(), recordHistory.getHistoryId(), recordHistory.getHistoryType(), httpMessage);
    }

    public HistoryReference(Session session, int n, HttpMessage httpMessage) throws HttpMalformedHeaderException, DatabaseException {
        RecordHistory recordHistory = null;
        this.icons = new ArrayList();
        this.clearIfManual = new ArrayList();
        recordHistory = staticTableHistory.write(session.getSessionId(), n, httpMessage);
        this.build(session.getSessionId(), recordHistory.getHistoryId(), recordHistory.getHistoryType(), httpMessage);
        httpMessage.setHistoryRef(this);
        List<RecordTag> list = staticTableTag.getTagsForHistoryID(this.historyId);
        for (RecordTag object2 : list) {
            this.tags.add(object2.getTag());
        }
        List<RecordAlert> list2 = staticTableAlert.getAlertsBySourceHistoryId(this.historyId);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            RecordAlert recordAlert = (RecordAlert)iterator.next();
            this.addAlert(new Alert(recordAlert, this));
        }
    }

    public ArrayList<Boolean> getClearIfManual() {
        return this.clearIfManual;
    }

    public ArrayList<String> getCustomIcons() {
        return this.icons;
    }

    public void setCustomIcon(String string, boolean bl) {
        this.icons.add(string);
        this.clearIfManual.add(bl);
    }

    private void build(long l, int n, int n2, HttpMessage httpMessage) {
        this.sessionId = l;
        this.historyId = n;
        this.historyType = n2;
        this.webSocketUpgrade = httpMessage.isWebSocketUpgrade();
        if (n2 == 1 || n2 == 15) {
            this.display = this.getDisplay(httpMessage);
        }
        httpMessage.setHistoryRef(this);
        this.httpMessageCachedData = new HttpMessageCachedData(httpMessage);
    }

    public static void setTableHistory(TableHistory tableHistory) {
        staticTableHistory = tableHistory;
    }

    public static void setTableTag(TableTag tableTag) {
        staticTableTag = tableTag;
    }

    public static void setTableAlert(TableAlert tableAlert) {
        staticTableAlert = tableAlert;
    }

    public int getHistoryId() {
        return this.historyId;
    }

    public HttpMessage getHttpMessage() throws HttpMalformedHeaderException, DatabaseException {
        RecordHistory recordHistory = staticTableHistory.read(this.historyId);
        if (recordHistory == null) {
            throw new HttpMalformedHeaderException("No history reference for id " + this.historyId + " type=" + this.historyType);
        }
        recordHistory.getHttpMessage().setHistoryRef(this);
        return recordHistory.getHttpMessage();
    }

    public URI getURI() {
        return this.httpMessageCachedData.getUri();
    }

    public String toString() {
        if (this.display != null) {
            return this.display;
        }
        HttpMessage httpMessage = null;
        try {
            httpMessage = this.getHttpMessage();
            this.display = this.getDisplay(httpMessage);
        }
        catch (HttpMalformedHeaderException httpMalformedHeaderException) {
            this.display = "";
        }
        catch (DatabaseException databaseException) {
            this.display = "";
        }
        return this.display;
    }

    public int getHistoryType() {
        return this.historyType;
    }

    public void delete() {
        if (this.historyId > 0) {
            try {
                staticTableTag.deleteTagsForHistoryID(this.historyId);
                staticTableHistory.delete(this.historyId);
            }
            catch (DatabaseException databaseException) {
                log.error((Object)databaseException.getMessage(), (Throwable)databaseException);
            }
        }
    }

    public SiteNode getSiteNode() {
        return this.siteNode;
    }

    public void setSiteNode(SiteNode siteNode) {
        this.siteNode = siteNode;
    }

    private String getDisplay(HttpMessage httpMessage) {
        StringBuilder stringBuilder = new StringBuilder(Integer.toString(this.historyId));
        stringBuilder.append(' ');
        stringBuilder.append(httpMessage.getRequestHeader().getPrimeHeader());
        if (!httpMessage.getResponseHeader().isEmpty()) {
            stringBuilder.append(" \t=> ").append(httpMessage.getResponseHeader().getPrimeHeader());
            stringBuilder.append("\t [").append(decimalFormat.format((double)httpMessage.getTimeElapsedMillis() / 1000.0)).append(" s]");
        }
        return stringBuilder.toString();
    }

    public void addTag(String string) {
        try {
            staticTableTag.insert(this.historyId, string);
            this.tags.add(string);
        }
        catch (DatabaseException databaseException) {
            log.error((Object)databaseException.getMessage(), (Throwable)databaseException);
        }
    }

    public void deleteTag(String string) {
        try {
            staticTableTag.delete(this.historyId, string);
            this.tags.remove(string);
        }
        catch (DatabaseException databaseException) {
            log.error((Object)databaseException.getMessage(), (Throwable)databaseException);
        }
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setNote(String string) {
        try {
            staticTableHistory.updateNote(this.historyId, string);
            this.httpMessageCachedData.setNote(string != null && string.length() > 0);
        }
        catch (DatabaseException databaseException) {
            log.error((Object)databaseException.getMessage(), (Throwable)databaseException);
        }
    }

    public void loadAlerts() {
        try {
            List<RecordAlert> list = staticTableAlert.getAlertsBySourceHistoryId(this.historyId);
            for (RecordAlert recordAlert : list) {
                this.addAlert(new Alert(recordAlert, this));
            }
        }
        catch (DatabaseException databaseException) {
            log.error((Object)databaseException.getMessage(), (Throwable)databaseException);
        }
    }

    public synchronized boolean addAlert(Alert alert) {
        if (this.alerts == null) {
            this.alerts = new HashSet<Alert>();
        }
        boolean bl = false;
        if (this.alerts.add(alert)) {
            alert.setHistoryRef(this);
            bl = true;
        }
        if (this.siteNode != null) {
            this.siteNode.addAlert(alert);
        }
        return bl;
    }

    public synchronized void updateAlert(Alert alert) {
        if (this.alerts == null) {
            return;
        }
        for (Alert alert2 : this.alerts) {
            if (alert2.getAlertId() != alert.getAlertId()) continue;
            this.alerts.remove(alert2);
            this.alerts.add(alert);
            if (this.siteNode != null) {
                this.siteNode.updateAlert(alert);
            }
            return;
        }
    }

    public synchronized void deleteAlert(Alert alert) {
        if (this.alerts != null) {
            this.alerts.remove(alert);
            if (this.siteNode != null) {
                this.siteNode.deleteAlert(alert);
            }
        }
    }

    public synchronized void deleteAllAlerts() {
        if (this.alerts != null) {
            this.alerts.clear();
        }
    }

    public synchronized boolean hasAlert(Alert alert) {
        if (this.alerts == null) {
            return false;
        }
        return this.alerts.contains(alert);
    }

    public synchronized boolean hasAlerts() {
        if (this.alerts == null) {
            return false;
        }
        return !this.alerts.isEmpty();
    }

    public int getHighestAlert() {
        int n = -1;
        if (this.alerts == null) {
            return n;
        }
        for (Alert alert : this.alerts) {
            if (alert.getConfidence() == 0 || alert.getRisk() <= n) continue;
            n = alert.getRisk();
        }
        return n;
    }

    public synchronized List<Alert> getAlerts() {
        if (this.alerts == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Alert>(this.alerts);
    }

    public String getMethod() {
        return this.httpMessageCachedData.getMethod();
    }

    public int getStatusCode() {
        return this.httpMessageCachedData.getStatusCode();
    }

    public String getReason() {
        return this.httpMessageCachedData.getReason();
    }

    public int getRtt() {
        return this.httpMessageCachedData.getRtt();
    }

    public void setTags(Vector<String> vector) {
        this.tags = vector;
    }

    public boolean hasNote() {
        return this.httpMessageCachedData.hasNote();
    }

    public long getTimeSentMillis() {
        return this.httpMessageCachedData.getTimeSentMillis();
    }

    public long getTimeReceivedMillis() {
        return this.httpMessageCachedData.getTimeReceivedMillis();
    }

    public boolean isWebSocketUpgrade() {
        return this.webSocketUpgrade;
    }

    public int getRequestHeaderLength() {
        return this.httpMessageCachedData.getRequestHeaderLength();
    }

    public int getRequestBodyLength() {
        return this.httpMessageCachedData.getRequestBodyLength();
    }

    public int getResponseHeaderLength() {
        return this.httpMessageCachedData.getResponseHeaderLength();
    }

    public int getResponseBodyLength() {
        return this.httpMessageCachedData.getResponseBodyLength();
    }

    public String getRequestBody() {
        String string = this.httpMessageCachedData.getRequestBody();
        if (string == null) {
            try {
                string = this.getHttpMessage().getRequestBody().toString();
                this.httpMessageCachedData.setRequestBody(string);
            }
            catch (DatabaseException | HttpMalformedHeaderException exception) {
                log.error((Object)("Failed to reload request body from database with history ID: " + this.historyId), (Throwable)exception);
                string = "";
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTemporaryType(int n) {
        Set<Integer> set = TEMPORARY_HISTORY_TYPES;
        synchronized (set) {
            TEMPORARY_HISTORY_TYPES.add(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTemporaryType(int n) {
        Integer n2 = n;
        if (DEFAULT_TEMPORARY_HISTORY_TYPES.contains(n2)) {
            return;
        }
        Set<Integer> set = TEMPORARY_HISTORY_TYPES;
        synchronized (set) {
            TEMPORARY_HISTORY_TYPES.remove(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Integer> getTemporaryTypes() {
        Set<Integer> set = TEMPORARY_HISTORY_TYPES;
        synchronized (set) {
            return new HashSet<Integer>(TEMPORARY_HISTORY_TYPES);
        }
    }

    static {
        decimalFormat = new DecimalFormat("##0.###");
        staticTableHistory = null;
        staticTableTag = null;
        staticTableAlert = null;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(0);
        hashSet.add(14);
        hashSet.add(11);
        hashSet.add(9);
        hashSet.add(17);
        hashSet.add(18);
        hashSet.add(19);
        DEFAULT_TEMPORARY_HISTORY_TYPES = Collections.unmodifiableSet(hashSet);
        TEMPORARY_HISTORY_TYPES.addAll(DEFAULT_TEMPORARY_HISTORY_TYPES);
        log = Logger.getLogger(HistoryReference.class);
    }
}

