/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.view;

import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamDialog;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.parosproxy.paros.view.View;

public class OptionsDialog
extends AbstractParamDialog {
    private static final long serialVersionUID = -4374132178769109917L;
    private JButton[] extraButtons = null;

    public OptionsDialog() {
        this.initialize();
    }

    public OptionsDialog(Frame frame, boolean bl, String string) throws HeadlessException {
        super((Window)frame, bl, string, Constant.messages.getString("options.dialog.rootName"));
        this.initialize();
    }

    private void initialize() {
        this.setSize(750, 584);
    }

    @Override
    public JButton[] getExtraButtons() {
        if (this.extraButtons == null) {
            JButton jButton = new JButton(Constant.messages.getString("options.dialog.reset.button"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (View.getSingleton().showConfirmDialog(OptionsDialog.this, Constant.messages.getString("options.dialog.reset.warn")) == 0) {
                        try {
                            OptionsParam optionsParam = Model.getSingleton().getOptionsParam();
                            Constant.getInstance().copyDefaultConfigs(new File(Constant.getInstance().FILE_CONFIG), true);
                            optionsParam.load(Constant.getInstance().FILE_CONFIG);
                            optionsParam.reloadConfigParamSets();
                            optionsParam.resetAll();
                            for (AbstractParamPanel abstractParamPanel : OptionsDialog.this.getPanels()) {
                                abstractParamPanel.reset();
                            }
                            OptionsDialog.this.initParam(optionsParam);
                        }
                        catch (Exception exception) {
                            View.getSingleton().showWarningDialog(Constant.messages.getString("options.dialog.reset.error", exception.getMessage()));
                        }
                    }
                }
            });
            this.extraButtons = new JButton[]{jButton};
        }
        return this.extraButtons;
    }
}

