/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.eventBus;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;
import org.zaproxy.zap.eventBus.Event;
import org.zaproxy.zap.eventBus.EventBus;
import org.zaproxy.zap.eventBus.EventConsumer;
import org.zaproxy.zap.eventBus.EventPublisher;

public class SimpleEventBus
implements EventBus {
    private Map<String, RegisteredPublisher> nameToPublisher = new HashMap<String, RegisteredPublisher>();
    private List<RegisteredConsumer> danglingConsumers = new ArrayList<RegisteredConsumer>();
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock(true);
    private final Lock regMgmtLock = this.rwLock.writeLock();
    private final Lock publishLock = this.rwLock.readLock();
    private static Logger log = Logger.getLogger(SimpleEventBus.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerPublisher(EventPublisher eventPublisher, String[] stringArray) {
        if (eventPublisher == null) {
            throw new InvalidParameterException("Publisher must not be null");
        }
        if (stringArray == null || stringArray.length == 0) {
            throw new InvalidParameterException("At least one event type must be specified");
        }
        this.regMgmtLock.lock();
        try {
            if (this.nameToPublisher.get(eventPublisher.getPublisherName()) != null) {
                throw new InvalidParameterException("Publisher with name " + eventPublisher.getPublisherName() + " already registered by " + this.nameToPublisher.get(eventPublisher.getPublisherName()).getPublisher().getClass().getCanonicalName());
            }
            log.debug((Object)("registerPublisher " + eventPublisher.getPublisherName()));
            RegisteredPublisher registeredPublisher = new RegisteredPublisher(eventPublisher, stringArray);
            this.nameToPublisher.put(eventPublisher.getPublisherName(), registeredPublisher);
            for (RegisteredConsumer registeredConsumer : this.danglingConsumers) {
                if (!registeredConsumer.getPublisherName().equals(eventPublisher.getPublisherName())) continue;
                registeredPublisher.addComsumer(registeredConsumer);
                this.danglingConsumers.remove(registeredConsumer);
                break;
            }
        }
        finally {
            this.regMgmtLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterPublisher(EventPublisher eventPublisher) {
        if (eventPublisher == null) {
            throw new InvalidParameterException("Publisher must not be null");
        }
        this.regMgmtLock.lock();
        try {
            log.debug((Object)("unregisterPublisher " + eventPublisher.getPublisherName()));
            RegisteredPublisher registeredPublisher = this.nameToPublisher.remove(eventPublisher.getPublisherName());
            if (registeredPublisher == null) {
                throw new InvalidParameterException("Publisher with name " + eventPublisher.getPublisherName() + " not registered");
            }
        }
        finally {
            this.regMgmtLock.unlock();
        }
    }

    @Override
    public void registerConsumer(EventConsumer eventConsumer, String string) {
        this.registerConsumer(eventConsumer, string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerConsumer(EventConsumer eventConsumer, String string, String[] stringArray) {
        if (eventConsumer == null) {
            throw new InvalidParameterException("Consumer must not be null");
        }
        this.regMgmtLock.lock();
        try {
            log.debug((Object)("registerConsumer " + eventConsumer.getClass().getCanonicalName() + " for " + string));
            RegisteredPublisher registeredPublisher = this.nameToPublisher.get(string);
            if (registeredPublisher == null) {
                this.danglingConsumers.add(new RegisteredConsumer(eventConsumer, stringArray, string));
            } else {
                registeredPublisher.addComsumer(eventConsumer, stringArray);
            }
        }
        finally {
            this.regMgmtLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterConsumer(EventConsumer eventConsumer, String string) {
        block6: {
            if (eventConsumer == null) {
                throw new InvalidParameterException("Consumer must not be null");
            }
            this.regMgmtLock.lock();
            try {
                log.debug((Object)("unregisterConsumer " + eventConsumer.getClass().getCanonicalName() + " for " + string));
                RegisteredPublisher registeredPublisher = this.nameToPublisher.get(string);
                if (registeredPublisher != null) {
                    registeredPublisher.removeComsumer(eventConsumer);
                    break block6;
                }
                for (RegisteredConsumer registeredConsumer : this.danglingConsumers) {
                    if (!registeredConsumer.getConsumer().equals(eventConsumer)) continue;
                    this.danglingConsumers.remove(registeredConsumer);
                    break;
                }
            }
            finally {
                this.regMgmtLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publishSyncEvent(EventPublisher eventPublisher, Event event) {
        if (eventPublisher == null) {
            throw new InvalidParameterException("Publisher must not be null");
        }
        this.publishLock.lock();
        try {
            RegisteredPublisher registeredPublisher = this.nameToPublisher.get(eventPublisher.getPublisherName());
            if (registeredPublisher == null) {
                throw new InvalidParameterException("Publisher not registered: " + eventPublisher.getPublisherName());
            }
            log.debug((Object)("publishSyncEvent " + event.getEventType() + " from " + eventPublisher.getPublisherName()));
            boolean bl = false;
            for (String string : registeredPublisher.getEventTypes()) {
                if (!event.getEventType().equals(string)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new InvalidParameterException("Event type: " + event.getEventType() + " not registered for publisher: " + eventPublisher.getPublisherName());
            }
            for (RegisteredConsumer registeredConsumer : registeredPublisher.getConsumers()) {
                String[] stringArray = registeredConsumer.getEventTypes();
                boolean bl2 = false;
                if (stringArray == null) {
                    bl2 = true;
                } else {
                    for (String string : stringArray) {
                        if (!event.getEventType().equals(string)) continue;
                        bl2 = true;
                        break;
                    }
                }
                if (!bl2) continue;
                try {
                    registeredConsumer.getConsumer().eventReceived(event);
                }
                catch (Exception exception) {
                    log.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        }
        finally {
            this.publishLock.unlock();
        }
    }

    private static class RegisteredPublisher {
        private EventPublisher publisher;
        private String[] eventTypes;
        private List<RegisteredConsumer> consumers = new ArrayList<RegisteredConsumer>();

        public RegisteredPublisher(EventPublisher eventPublisher, String[] stringArray) {
            this.publisher = eventPublisher;
            this.eventTypes = stringArray;
        }

        public EventPublisher getPublisher() {
            return this.publisher;
        }

        public String[] getEventTypes() {
            return this.eventTypes;
        }

        public List<RegisteredConsumer> getConsumers() {
            return this.consumers;
        }

        public void addComsumer(RegisteredConsumer registeredConsumer) {
            this.consumers.add(registeredConsumer);
        }

        public void addComsumer(EventConsumer eventConsumer, String[] stringArray) {
            this.consumers.add(new RegisteredConsumer(eventConsumer, stringArray));
        }

        public void removeComsumer(EventConsumer eventConsumer) {
            for (RegisteredConsumer registeredConsumer : this.consumers) {
                if (!registeredConsumer.getConsumer().equals(eventConsumer)) continue;
                this.consumers.remove(registeredConsumer);
                return;
            }
        }
    }

    private static class RegisteredConsumer {
        private EventConsumer consumer;
        private String[] eventTypes;
        private String publisherName;

        public RegisteredConsumer(EventConsumer eventConsumer, String[] stringArray) {
            this.consumer = eventConsumer;
            this.eventTypes = stringArray;
        }

        public RegisteredConsumer(EventConsumer eventConsumer, String[] stringArray, String string) {
            this.consumer = eventConsumer;
            this.eventTypes = stringArray;
            this.publisherName = string;
        }

        public EventConsumer getConsumer() {
            return this.consumer;
        }

        public String[] getEventTypes() {
            return this.eventTypes;
        }

        public String getPublisherName() {
            return this.publisherName;
        }
    }
}

