/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.alert;

import org.apache.commons.configuration.ConversionException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.common.AbstractParam;

public class AlertParam
extends AbstractParam {
    private static final Logger LOGGER = Logger.getLogger(AlertParam.class);
    private static final String PARAM_BASE_KEY = "alert";
    private static final String PARAM_MERGE_RELATED_ISSUES = "alert.mergeissues";
    private static final String PARAM_MAXIMUM_INSTANCES = "alert.maxInstances";
    private static final String PARAM_OVERRIDES_FILENAME = "alert.overridesFilename";
    private static final int DEFAULT_MAXIMUM_INSTANCES = 20;
    private int maximumInstances = 20;
    private boolean mergeRelatedIssues = true;
    private String overridesFilename;

    @Override
    protected void parse() {
        try {
            this.maximumInstances = this.getConfig().getInt(PARAM_MAXIMUM_INSTANCES, 20);
        }
        catch (ConversionException conversionException) {
            LOGGER.error((Object)("Failed to load the \"Maximum instances\" configuration: " + conversionException.getMessage()), (Throwable)conversionException);
        }
        try {
            this.mergeRelatedIssues = this.getConfig().getBoolean(PARAM_MERGE_RELATED_ISSUES, true);
        }
        catch (ConversionException conversionException) {
            LOGGER.error((Object)("Failed to load the \"old format\" configuration: " + conversionException.getMessage()), (Throwable)conversionException);
        }
        try {
            this.overridesFilename = this.getConfig().getString(PARAM_OVERRIDES_FILENAME, "");
        }
        catch (ConversionException conversionException) {
            LOGGER.error((Object)("Failed to load the \"Overrides filename\" configuration: " + conversionException.getMessage()), (Throwable)conversionException);
        }
    }

    public void setMaximumInstances(int n) {
        if (this.maximumInstances != n) {
            this.maximumInstances = n;
            this.getConfig().setProperty(PARAM_MAXIMUM_INSTANCES, (Object)n);
        }
    }

    public int getMaximumInstances() {
        return this.maximumInstances;
    }

    public boolean isMergeRelatedIssues() {
        return this.mergeRelatedIssues;
    }

    public void setMergeRelatedIssues(boolean bl) {
        if (this.mergeRelatedIssues != bl) {
            this.mergeRelatedIssues = bl;
            this.getConfig().setProperty(PARAM_MERGE_RELATED_ISSUES, (Object)bl);
        }
    }

    public String getOverridesFilename() {
        return this.overridesFilename;
    }

    public void setOverridesFilename(String string) {
        this.overridesFilename = string;
        this.getConfig().setProperty(PARAM_OVERRIDES_FILENAME, (Object)string);
    }
}

