/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;
import org.parosproxy.paros.common.AbstractParam;
import org.zaproxy.zap.extension.api.ExtensionAPI;
import org.zaproxy.zap.extension.api.ZapApiIgnore;
import org.zaproxy.zap.network.DomainMatcher;

public class OptionsParamApi
extends AbstractParam {
    private static final Logger LOGGER = Logger.getLogger(OptionsParamApi.class);
    public static final String ENABLED = "api.enabled";
    public static final String UI_ENABLED = "api.uienabled";
    public static final String SECURE_ONLY = "api.secure";
    public static final String API_KEY = "api.key";
    private static final String DISABLE_KEY = "api.disablekey";
    private static final String INC_ERROR_DETAILS = "api.incerrordetails";
    private static final String AUTOFILL_KEY = "api.autofillkey";
    private static final String ENABLE_JSONP = "api.enablejsonp";
    private static final String NO_KEY_FOR_SAFE_OPS = "api.nokeyforsafeops";
    private static final String REPORT_PERM_ERRORS = "api.reportpermerrors";
    private static final String NONCE_TTL_IN_SECS = "api.noncettlsecs";
    private static final String PROXY_PERMITTED_ADDRS_KEY = "api.addrs";
    private static final String ADDRESS_KEY = "api.addrs.addr";
    private static final String ADDRESS_VALUE_KEY = "name";
    private static final String ADDRESS_REGEX_KEY = "regex";
    private static final String ADDRESS_ENABLED_KEY = "enabled";
    private static final String CONFIRM_REMOVE_ADDRESS = "api.addrs.confirmRemoveAddr";
    private static final int DEFAULT_NONCE_TTL_IN_SECS = 300;
    private boolean enabled = true;
    private boolean uiEnabled = true;
    private boolean secureOnly;
    private boolean disableKey;
    private boolean incErrorDetails;
    private boolean autofillKey;
    private boolean enableJSONP;
    private boolean noKeyForSafeOps;
    private boolean reportPermErrors;
    private boolean confirmRemovePermittedAddress = true;
    private List<DomainMatcher> permittedAddresses = new ArrayList<DomainMatcher>(0);
    private List<DomainMatcher> permittedAddressesEnabled = new ArrayList<DomainMatcher>(0);
    private int nonceTimeToLiveInSecs = 300;
    private String key = "";

    @Override
    protected void parse() {
        this.enabled = this.getBooleanFromConfig(ENABLED, true);
        this.uiEnabled = this.getBooleanFromConfig(UI_ENABLED, true);
        this.secureOnly = this.getBooleanFromConfig(SECURE_ONLY, false);
        this.disableKey = this.getBooleanFromConfig(DISABLE_KEY, false);
        this.incErrorDetails = this.getBooleanFromConfig(INC_ERROR_DETAILS, false);
        this.autofillKey = this.getBooleanFromConfig(AUTOFILL_KEY, false);
        this.enableJSONP = this.getBooleanFromConfig(ENABLE_JSONP, false);
        this.noKeyForSafeOps = this.getBooleanFromConfig(NO_KEY_FOR_SAFE_OPS, false);
        this.reportPermErrors = this.getBooleanFromConfig(REPORT_PERM_ERRORS, false);
        this.nonceTimeToLiveInSecs = this.getIntFromConfig(NONCE_TTL_IN_SECS, 300);
        try {
            this.key = this.getConfig().getString(API_KEY, "");
        }
        catch (ConversionException conversionException) {
            LOGGER.warn((Object)("Failed to load the option '" + this.key + "' caused by:"), (Throwable)conversionException);
            this.key = "";
        }
        this.loadPermittedAddresses();
        try {
            this.confirmRemovePermittedAddress = this.getConfig().getBoolean(CONFIRM_REMOVE_ADDRESS, true);
        }
        catch (ConversionException conversionException) {
            LOGGER.error((Object)("Error while loading the confirm remove permitted address option: " + conversionException.getMessage()), (Throwable)conversionException);
        }
    }

    private boolean getBooleanFromConfig(String string, boolean bl) {
        try {
            return this.getConfig().getBoolean(string, bl);
        }
        catch (ConversionException conversionException) {
            LOGGER.warn((Object)("Failed to load the option '" + string + "' caused by:"), (Throwable)conversionException);
            return bl;
        }
    }

    private int getIntFromConfig(String string, int n) {
        try {
            return this.getConfig().getInteger(string, Integer.valueOf(n));
        }
        catch (ConversionException conversionException) {
            LOGGER.warn((Object)("Failed to load the option '" + string + "' caused by:"), (Throwable)conversionException);
            return n;
        }
    }

    @Override
    public OptionsParamApi clone() {
        return (OptionsParamApi)super.clone();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        this.getConfig().setProperty(ENABLED, (Object)bl);
    }

    public boolean isUiEnabled() {
        return this.uiEnabled;
    }

    public void setUiEnabled(boolean bl) {
        this.uiEnabled = bl;
        this.getConfig().setProperty(UI_ENABLED, (Object)bl);
    }

    public boolean isSecureOnly() {
        return this.secureOnly;
    }

    public void setSecureOnly(boolean bl) {
        this.secureOnly = bl;
        this.getConfig().setProperty(SECURE_ONLY, (Object)bl);
    }

    public boolean isDisableKey() {
        return this.disableKey;
    }

    public void setDisableKey(boolean bl) {
        this.disableKey = bl;
        this.getConfig().setProperty(DISABLE_KEY, (Object)bl);
    }

    public boolean isIncErrorDetails() {
        return this.incErrorDetails;
    }

    public void setIncErrorDetails(boolean bl) {
        this.incErrorDetails = bl;
        this.getConfig().setProperty(INC_ERROR_DETAILS, (Object)bl);
    }

    public boolean isAutofillKey() {
        return this.autofillKey;
    }

    public void setAutofillKey(boolean bl) {
        this.autofillKey = bl;
        this.getConfig().setProperty(AUTOFILL_KEY, (Object)bl);
    }

    public boolean isEnableJSONP() {
        return this.enableJSONP;
    }

    public void setEnableJSONP(boolean bl) {
        this.enableJSONP = bl;
        this.getConfig().setProperty(ENABLE_JSONP, (Object)bl);
    }

    public boolean isNoKeyForSafeOps() {
        return this.noKeyForSafeOps;
    }

    public void setNoKeyForSafeOps(boolean bl) {
        this.noKeyForSafeOps = bl;
        this.getConfig().setProperty(NO_KEY_FOR_SAFE_OPS, (Object)bl);
    }

    public boolean isReportPermErrors() {
        return this.reportPermErrors;
    }

    public void setReportPermErrors(boolean bl) {
        this.reportPermErrors = bl;
        this.getConfig().setProperty(REPORT_PERM_ERRORS, (Object)bl);
    }

    @ZapApiIgnore
    public int getNonceTimeToLiveInSecs() {
        return this.nonceTimeToLiveInSecs;
    }

    protected String getRealKey() {
        return this.key;
    }

    protected String getKey() {
        if (this.isDisableKey()) {
            return "";
        }
        if (this.key == null || this.key.length() == 0) {
            this.key = ExtensionAPI.generateApiKey();
            if (this.getConfig() != null) {
                this.getConfig().setProperty(API_KEY, (Object)this.key);
                try {
                    this.getConfig().save();
                }
                catch (ConfigurationException configurationException) {
                    // empty catch block
                }
            }
        }
        return this.key;
    }

    public void setKey(String string) {
        this.key = string;
        this.getConfig().setProperty(API_KEY, (Object)string);
    }

    public boolean isPermittedAddress(String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        for (DomainMatcher domainMatcher : this.permittedAddressesEnabled) {
            if (!domainMatcher.matches(string)) continue;
            return true;
        }
        return false;
    }

    @ZapApiIgnore
    public List<DomainMatcher> getPermittedAddresses() {
        return this.permittedAddresses;
    }

    @ZapApiIgnore
    public List<DomainMatcher> getPermittedAddressesEnabled() {
        return this.permittedAddressesEnabled;
    }

    public void setPermittedAddresses(List<DomainMatcher> list) {
        if (list == null || list.isEmpty()) {
            ((HierarchicalConfiguration)this.getConfig()).clearTree(ADDRESS_KEY);
            this.permittedAddresses = Collections.emptyList();
            this.permittedAddressesEnabled = Collections.emptyList();
            return;
        }
        this.permittedAddresses = new ArrayList<DomainMatcher>(list);
        ((HierarchicalConfiguration)this.getConfig()).clearTree(ADDRESS_KEY);
        int n = list.size();
        ArrayList<DomainMatcher> arrayList = new ArrayList<DomainMatcher>(n);
        for (int i = 0; i < n; ++i) {
            String string = "api.addrs.addr(" + i + ").";
            DomainMatcher domainMatcher = list.get(i);
            this.getConfig().setProperty(string + ADDRESS_VALUE_KEY, (Object)domainMatcher.getValue());
            this.getConfig().setProperty(string + ADDRESS_REGEX_KEY, (Object)domainMatcher.isRegex());
            this.getConfig().setProperty(string + ADDRESS_ENABLED_KEY, (Object)domainMatcher.isEnabled());
            if (!domainMatcher.isEnabled()) continue;
            arrayList.add(domainMatcher);
        }
        arrayList.trimToSize();
        this.permittedAddressesEnabled = arrayList;
    }

    private void loadPermittedAddresses() {
        List list = ((HierarchicalConfiguration)this.getConfig()).configurationsAt(ADDRESS_KEY);
        this.permittedAddresses = new ArrayList<DomainMatcher>(list.size());
        ArrayList<DomainMatcher> arrayList = new ArrayList<DomainMatcher>(list.size());
        for (HierarchicalConfiguration hierarchicalConfiguration : list) {
            String string = hierarchicalConfiguration.getString(ADDRESS_VALUE_KEY, "");
            if (string.isEmpty()) {
                LOGGER.warn((Object)"Failed to read a permitted address entry, required value is empty.");
                continue;
            }
            DomainMatcher domainMatcher = null;
            boolean bl = hierarchicalConfiguration.getBoolean(ADDRESS_REGEX_KEY, false);
            if (bl) {
                try {
                    Pattern pattern = DomainMatcher.createPattern(string);
                    domainMatcher = new DomainMatcher(pattern);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    LOGGER.error((Object)("Failed to read a permitted address entry with regex: " + string), (Throwable)illegalArgumentException);
                }
            } else {
                domainMatcher = new DomainMatcher(string);
            }
            if (domainMatcher == null) continue;
            domainMatcher.setEnabled(hierarchicalConfiguration.getBoolean(ADDRESS_ENABLED_KEY, true));
            this.permittedAddresses.add(domainMatcher);
            if (!domainMatcher.isEnabled()) continue;
            arrayList.add(domainMatcher);
        }
        arrayList.trimToSize();
        if (this.permittedAddresses.size() == 0) {
            Object object = new DomainMatcher("127.0.0.1");
            this.permittedAddresses.add((DomainMatcher)object);
            arrayList.add((DomainMatcher)object);
            object = new DomainMatcher("localhost");
            this.permittedAddresses.add((DomainMatcher)object);
            arrayList.add((DomainMatcher)object);
            object = new DomainMatcher("zap");
            this.permittedAddresses.add((DomainMatcher)object);
            arrayList.add((DomainMatcher)object);
        }
        this.permittedAddressesEnabled = arrayList;
    }

    @ZapApiIgnore
    public boolean isConfirmRemovePermittedAddress() {
        return this.confirmRemovePermittedAddress;
    }

    @ZapApiIgnore
    public void setConfirmRemovePermittedAddress(boolean bl) {
        this.confirmRemovePermittedAddress = bl;
        this.getConfig().setProperty(CONFIRM_REMOVE_ADDRESS, (Object)this.confirmRemovePermittedAddress);
    }
}

