/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.brk;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.zaproxy.zap.extension.brk.BreakpointManagementInterface;
import org.zaproxy.zap.extension.brk.BreakpointMessageInterface;
import org.zaproxy.zap.extension.httppanel.Message;

public class BreakpointMessageHandler2 {
    private static final Logger LOGGER = Logger.getLogger(BreakpointMessageHandler2.class);
    protected static final Object SEMAPHORE = new Object();
    protected final BreakpointManagementInterface breakMgmt;
    protected List<BreakpointMessageInterface> enabledBreakpoints;
    private List<String> enabledKeyBreakpoints = new ArrayList<String>();

    public List<String> getEnabledKeyBreakpoints() {
        return this.enabledKeyBreakpoints;
    }

    public void setEnabledKeyBreakpoints(List<String> list) {
        this.enabledKeyBreakpoints = list;
    }

    public BreakpointMessageHandler2(BreakpointManagementInterface breakpointManagementInterface) {
        this.breakMgmt = breakpointManagementInterface;
    }

    public void setEnabledBreakpoints(List<BreakpointMessageInterface> list) {
        this.enabledBreakpoints = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessageReceivedFromClient(Message message, boolean bl) {
        if (!this.isBreakpoint(message, true, bl)) {
            return true;
        }
        this.breakMgmt.breakpointHit();
        Object object = SEMAPHORE;
        synchronized (object) {
            if (this.breakMgmt.isHoldMessage(message)) {
                this.setBreakDisplay(message, true);
                this.waitUntilContinue(message, true);
            }
        }
        this.breakMgmt.clearAndDisableRequest();
        return !this.breakMgmt.isToBeDropped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessageReceivedFromServer(Message message, boolean bl) {
        if (!this.isBreakpoint(message, false, bl)) {
            return true;
        }
        this.breakMgmt.breakpointHit();
        Object object = SEMAPHORE;
        synchronized (object) {
            if (this.breakMgmt.isHoldMessage(message)) {
                this.setBreakDisplay(message, false);
                this.waitUntilContinue(message, false);
            }
        }
        this.breakMgmt.clearAndDisableResponse();
        return !this.breakMgmt.isToBeDropped();
    }

    private void setBreakDisplay(Message message, boolean bl) {
        this.breakMgmt.setMessage(message, bl);
        this.breakMgmt.breakpointDisplayed();
    }

    private void waitUntilContinue(Message message, boolean bl) {
        while (this.breakMgmt.isHoldMessage(message)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                LOGGER.warn((Object)interruptedException.getMessage(), (Throwable)interruptedException);
            }
        }
        this.breakMgmt.saveMessage(bl);
    }

    public boolean isBreakpoint(Message message, boolean bl, boolean bl2) {
        if (message.isForceIntercept()) {
            return true;
        }
        if (bl2 && !message.isInScope()) {
            return false;
        }
        if (this.isBreakOnAllRequests(message, bl)) {
            return true;
        }
        if (this.isBreakOnAllResponses(message, bl)) {
            return true;
        }
        if (this.isBreakOnStepping(message, bl)) {
            return true;
        }
        return this.isBreakOnEnabledBreakpoint(message, bl, bl2);
    }

    protected boolean isBreakOnAllRequests(Message message, boolean bl) {
        return bl && this.breakMgmt.isBreakRequest();
    }

    protected boolean isBreakOnAllResponses(Message message, boolean bl) {
        return !bl && this.breakMgmt.isBreakResponse();
    }

    protected boolean isBreakOnStepping(Message message, boolean bl) {
        return this.breakMgmt.isStepping();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isBreakOnEnabledBreakpoint(Message message, boolean bl, boolean bl2) {
        if (this.enabledBreakpoints.isEmpty()) {
            return false;
        }
        List<BreakpointMessageInterface> list = this.enabledBreakpoints;
        synchronized (list) {
            for (BreakpointMessageInterface breakpointMessageInterface : this.enabledBreakpoints) {
                if (!breakpointMessageInterface.match(message, bl, bl2)) continue;
                return true;
            }
        }
        return false;
    }
}

