/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.stats;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.OptionsChangedListener;
import org.parosproxy.paros.model.OptionsParam;
import org.zaproxy.zap.extension.stats.InMemoryStats;
import org.zaproxy.zap.extension.stats.OptionsStatsPanel;
import org.zaproxy.zap.extension.stats.StatsAPI;
import org.zaproxy.zap.extension.stats.StatsParam;
import org.zaproxy.zap.extension.stats.Statsd;
import org.zaproxy.zap.utils.Stats;

public class ExtensionStats
extends ExtensionAdaptor
implements OptionsChangedListener {
    public static final String NAME = "ExtensionStats";
    private InMemoryStats inMemStats;
    private Statsd statsd;
    private OptionsStatsPanel optionsStatsPanel;
    private StatsParam statsParam;
    private static final Logger LOG = Logger.getLogger(ExtensionStats.class);

    public ExtensionStats() {
        this.initialize();
    }

    private void initialize() {
        this.setName(NAME);
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        extensionHook.addOptionsChangedListener(this);
        extensionHook.addOptionsParamSet(this.getStatsParam());
        if (this.getView() != null) {
            extensionHook.getHookView().addOptionPanel(this.getOptionsStatsPanel());
        }
        StatsAPI statsAPI = new StatsAPI(this);
        extensionHook.addApiImplementor(statsAPI);
        statsAPI.addApiOptions(this.getStatsParam());
    }

    @Override
    public void optionsLoaded() {
        this.optionsChanged();
    }

    private OptionsStatsPanel getOptionsStatsPanel() {
        if (this.optionsStatsPanel == null) {
            this.optionsStatsPanel = new OptionsStatsPanel();
        }
        return this.optionsStatsPanel;
    }

    private StatsParam getStatsParam() {
        if (this.statsParam == null) {
            this.statsParam = new StatsParam();
        }
        return this.statsParam;
    }

    @Override
    public boolean isCore() {
        return true;
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("stats.desc");
    }

    @Override
    public URL getURL() {
        try {
            return new URL("http://www.owasp.org/index.php/ZAP");
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public boolean supportsDb(String string) {
        return true;
    }

    @Override
    public void optionsChanged(OptionsParam optionsParam) {
        this.optionsChanged();
    }

    private void optionsChanged() {
        boolean bl;
        boolean bl2;
        boolean bl3 = bl2 = this.inMemStats != null;
        if (bl2 != this.getStatsParam().isInMemoryEnabled()) {
            if (!bl2) {
                LOG.info((Object)"Start recording in memory stats");
                this.inMemStats = new InMemoryStats();
                Stats.addListener(this.inMemStats);
            } else {
                LOG.info((Object)"Stop recording in memory stats");
                Stats.removeListener(this.inMemStats);
                this.inMemStats.allCleared();
                this.inMemStats = null;
            }
        }
        boolean bl4 = bl = this.statsd != null;
        if (bl != this.getStatsParam().isStatsdEnabled()) {
            if (!bl) {
                LOG.info((Object)"Start sending stats to statsd server");
                try {
                    this.statsd = this.newStatsD(this.getStatsParam());
                    Stats.addListener(this.statsd);
                }
                catch (Exception exception) {
                    LOG.error((Object)exception.getMessage(), (Throwable)exception);
                }
            } else {
                LOG.info((Object)"Stop sending stats to statsd server");
                Stats.removeListener(this.statsd);
                this.statsd = null;
            }
        } else if (bl) {
            if (!StringUtils.equals((String)this.getStatsParam().getStatsdHost(), (String)this.statsd.getHost()) || this.getStatsParam().getStatsdPort() != this.statsd.getPort()) {
                LOG.info((Object)"Restart sending stats to statsd server");
                try {
                    Stats.removeListener(this.statsd);
                    this.statsd = this.newStatsD(this.getStatsParam());
                    Stats.addListener(this.statsd);
                }
                catch (Exception exception) {
                    LOG.error((Object)exception.getMessage(), (Throwable)exception);
                }
            } else if (!StringUtils.equals((String)this.getStatsParam().getStatsdPrefix(), (String)this.statsd.getPrefix())) {
                this.statsd.setPrefix(this.getStatsParam().getStatsdPrefix());
            }
        }
    }

    private Statsd newStatsD(StatsParam statsParam) throws UnknownHostException, IOException {
        return new Statsd(statsParam.getStatsdHost(), statsParam.getStatsdPort(), statsParam.getStatsdPrefix());
    }

    public InMemoryStats getInMemoryStats() {
        return this.inMemStats;
    }
}

