/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.model;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteMap;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.authentication.AuthenticationMethod;
import org.zaproxy.zap.authentication.ManualAuthenticationMethodType;
import org.zaproxy.zap.extension.authorization.AuthorizationDetectionMethod;
import org.zaproxy.zap.extension.authorization.BasicAuthorizationDetectionMethod;
import org.zaproxy.zap.model.IllegalContextNameException;
import org.zaproxy.zap.model.ParameterParser;
import org.zaproxy.zap.model.StandardParameterParser;
import org.zaproxy.zap.model.StructuralNode;
import org.zaproxy.zap.model.StructuralNodeModifier;
import org.zaproxy.zap.model.StructuralSiteNode;
import org.zaproxy.zap.model.Tech;
import org.zaproxy.zap.model.TechSet;
import org.zaproxy.zap.session.CookieBasedSessionManagementMethodType;
import org.zaproxy.zap.session.SessionManagementMethod;

public class Context {
    public static final String CONTEXT_CONFIG = "context";
    public static final String CONTEXT_CONFIG_NAME = "context.name";
    public static final String CONTEXT_CONFIG_DESC = "context.desc";
    public static final String CONTEXT_CONFIG_INSCOPE = "context.inscope";
    public static final String CONTEXT_CONFIG_INC_REGEXES = "context.incregexes";
    public static final String CONTEXT_CONFIG_EXC_REGEXES = "context.excregexes";
    public static final String CONTEXT_CONFIG_TECH = "context.tech";
    public static final String CONTEXT_CONFIG_TECH_INCLUDE = "context.tech.include";
    public static final String CONTEXT_CONFIG_TECH_EXCLUDE = "context.tech.exclude";
    public static final String CONTEXT_CONFIG_URLPARSER = "context.urlparser";
    public static final String CONTEXT_CONFIG_URLPARSER_CLASS = "context.urlparser.class";
    public static final String CONTEXT_CONFIG_URLPARSER_CONFIG = "context.urlparser.config";
    public static final String CONTEXT_CONFIG_POSTPARSER = "context.postparser";
    public static final String CONTEXT_CONFIG_POSTPARSER_CLASS = "context.postparser.class";
    public static final String CONTEXT_CONFIG_POSTPARSER_CONFIG = "context.postparser.config";
    public static final String CONTEXT_CONFIG_DATA_DRIVEN_NODES = "context.ddns";
    private static Logger log = Logger.getLogger(Context.class);
    private Session session;
    private int index;
    private String name;
    private String description = "";
    private List<String> includeInRegexs = new ArrayList<String>();
    private List<String> excludeFromRegexs = new ArrayList<String>();
    private List<Pattern> includeInPatterns = new ArrayList<Pattern>();
    private List<Pattern> excludeFromPatterns = new ArrayList<Pattern>();
    private List<StructuralNodeModifier> dataDrivenNodes = new ArrayList<StructuralNodeModifier>();
    private AuthenticationMethod authenticationMethod = null;
    private SessionManagementMethod sessionManagementMethod;
    private AuthorizationDetectionMethod authorizationDetectionMethod;
    private TechSet techSet = new TechSet(Tech.builtInTech);
    private boolean inScope = true;
    private ParameterParser urlParamParser = new StandardParameterParser();
    private ParameterParser postParamParser = new StandardParameterParser();

    public Context(Session session, int n) {
        this.session = session;
        this.index = n;
        this.name = String.valueOf(n);
        this.sessionManagementMethod = new CookieBasedSessionManagementMethodType.CookieBasedSessionManagementMethod(n);
        this.authenticationMethod = new ManualAuthenticationMethodType.ManualAuthenticationMethod(n);
        this.authorizationDetectionMethod = new BasicAuthorizationDetectionMethod(null, null, null, BasicAuthorizationDetectionMethod.LogicalOperator.AND);
        this.urlParamParser.setContext(this);
        this.postParamParser.setContext(this);
    }

    public boolean isIncludedInScope(SiteNode siteNode) {
        if (!this.inScope) {
            return false;
        }
        return this.isIncluded(siteNode);
    }

    public boolean isIncluded(SiteNode siteNode) {
        if (siteNode == null) {
            return false;
        }
        return this.isIncluded(siteNode.getHierarchicNodeName());
    }

    public boolean isIncluded(String string) {
        if (string == null) {
            return false;
        }
        if (string.indexOf("?") > 0) {
            string = string.substring(0, string.indexOf("?"));
        }
        for (Pattern pattern : this.includeInPatterns) {
            if (!pattern.matcher(string).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean isExcludedFromScope(SiteNode siteNode) {
        if (!this.inScope) {
            return false;
        }
        return this.isExcluded(siteNode);
    }

    public boolean isExcluded(SiteNode siteNode) {
        if (siteNode == null) {
            return false;
        }
        return this.isExcluded(siteNode.getHierarchicNodeName());
    }

    public boolean isExcluded(String string) {
        if (string == null) {
            return false;
        }
        if (string.indexOf("?") > 0) {
            string = string.substring(0, string.indexOf("?"));
        }
        for (Pattern pattern : this.excludeFromPatterns) {
            if (!pattern.matcher(string).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean isInContext(HistoryReference historyReference) {
        if (historyReference == null) {
            return false;
        }
        if (historyReference.getSiteNode() != null) {
            return this.isInContext(historyReference.getSiteNode());
        }
        try {
            return this.isInContext(historyReference.getURI().toString());
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            return false;
        }
    }

    public boolean isInContext(SiteNode siteNode) {
        if (siteNode == null) {
            return false;
        }
        return this.isInContext(siteNode.getHierarchicNodeName());
    }

    public boolean isInContext(String string) {
        if (string.indexOf("?") > 0) {
            string = string.substring(0, string.indexOf("?"));
        }
        if (!this.isIncluded(string)) {
            return false;
        }
        return !this.isExcluded(string);
    }

    public List<SiteNode> getNodesInContextFromSiteTree() {
        LinkedList<SiteNode> linkedList = new LinkedList<SiteNode>();
        SiteNode siteNode = (SiteNode)this.session.getSiteTree().getRoot();
        this.fillNodesInContext(siteNode, linkedList);
        return linkedList;
    }

    public boolean hasNodesInContextFromSiteTree() {
        return this.hasNodesInContext((SiteNode)this.session.getSiteTree().getRoot());
    }

    private boolean hasNodesInContext(SiteNode siteNode) {
        Enumeration<TreeNode> enumeration = siteNode.children();
        while (enumeration.hasMoreElements()) {
            SiteNode siteNode2 = (SiteNode)enumeration.nextElement();
            if (this.isInContext(siteNode2)) {
                return true;
            }
            if (!this.hasNodesInContext(siteNode2)) continue;
            return true;
        }
        return false;
    }

    public List<SiteNode> getTopNodesInContextFromSiteTree() {
        LinkedList<SiteNode> linkedList = new LinkedList<SiteNode>();
        SiteNode siteNode = (SiteNode)this.session.getSiteTree().getRoot();
        Enumeration<TreeNode> enumeration = siteNode.children();
        while (enumeration.hasMoreElements()) {
            SiteNode siteNode2 = (SiteNode)enumeration.nextElement();
            if (!this.isContainsNodesInContext(siteNode2)) continue;
            linkedList.add(siteNode2);
        }
        return linkedList;
    }

    private void fillNodesInContext(SiteNode siteNode, List<SiteNode> list) {
        Enumeration<TreeNode> enumeration = siteNode.children();
        while (enumeration.hasMoreElements()) {
            SiteNode siteNode2 = (SiteNode)enumeration.nextElement();
            if (this.isInContext(siteNode2)) {
                list.add(siteNode2);
            }
            this.fillNodesInContext(siteNode2, list);
        }
    }

    private boolean isContainsNodesInContext(SiteNode siteNode) {
        if (this.isInContext(siteNode)) {
            return true;
        }
        Enumeration<TreeNode> enumeration = siteNode.children();
        while (enumeration.hasMoreElements()) {
            SiteNode siteNode2 = (SiteNode)enumeration.nextElement();
            if (!this.isContainsNodesInContext(siteNode2)) continue;
            return true;
        }
        return false;
    }

    public List<String> getIncludeInContextRegexs() {
        return Collections.unmodifiableList(this.includeInRegexs);
    }

    private static void validateRegexs(List<String> list) {
        for (String string : list) {
            Context.validateRegex(string);
        }
    }

    private static void validateRegex(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The regular expression must not be null.");
        }
        String string2 = string.trim();
        if (!string2.isEmpty()) {
            Pattern.compile(string2, 2);
        }
    }

    public void setIncludeInContextRegexs(List<String> list) {
        Context.validateRegexs(list);
        if (this.includeInRegexs.size() == list.size()) {
            boolean bl = false;
            for (int i = 0; i < this.includeInRegexs.size(); ++i) {
                if (this.includeInRegexs.get(i).equals(list.get(i))) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return;
            }
        }
        this.includeInRegexs.clear();
        this.includeInPatterns.clear();
        for (String string : list) {
            if ((string = string.trim()).length() <= 0) continue;
            Pattern pattern = Pattern.compile(string, 2);
            this.includeInRegexs.add(string);
            this.includeInPatterns.add(pattern);
        }
    }

    public void excludeFromContext(SiteNode siteNode, boolean bl) throws Exception {
        this.excludeFromContext(new StructuralSiteNode(siteNode), bl);
    }

    public void excludeFromContext(StructuralNode structuralNode, boolean bl) throws Exception {
        this.addExcludeFromContextRegex(structuralNode.getRegexPattern(bl));
    }

    public void addIncludeInContextRegex(String string) {
        Context.validateRegex(string);
        this.includeInPatterns.add(Pattern.compile(string, 2));
        this.includeInRegexs.add(string);
    }

    public List<String> getExcludeFromContextRegexs() {
        return Collections.unmodifiableList(this.excludeFromRegexs);
    }

    public void setExcludeFromContextRegexs(List<String> list) {
        Context.validateRegexs(list);
        if (this.excludeFromRegexs.size() == list.size()) {
            boolean bl = false;
            for (int i = 0; i < this.excludeFromRegexs.size(); ++i) {
                if (this.excludeFromRegexs.get(i).equals(list.get(i))) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return;
            }
        }
        this.excludeFromRegexs.clear();
        this.excludeFromPatterns.clear();
        for (String string : list) {
            if ((string = string.trim()).length() <= 0) continue;
            Pattern pattern = Pattern.compile(string, 2);
            this.excludeFromPatterns.add(pattern);
            this.excludeFromRegexs.add(string);
        }
    }

    public void addExcludeFromContextRegex(String string) {
        Context.validateRegex(string);
        this.excludeFromPatterns.add(Pattern.compile(string, 2));
        this.excludeFromRegexs.add(string);
    }

    public void save() {
        this.session.saveContext(this);
    }

    public TechSet getTechSet() {
        return this.techSet;
    }

    public void setTechSet(TechSet techSet) {
        this.techSet = techSet;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalContextNameException(IllegalContextNameException.Reason.EMPTY_NAME, "The context name must not be null nor empty.");
        }
        this.name = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isInScope() {
        return this.inScope;
    }

    public void setInScope(boolean bl) {
        this.inScope = bl;
    }

    public AuthenticationMethod getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setAuthenticationMethod(AuthenticationMethod authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    public SessionManagementMethod getSessionManagementMethod() {
        return this.sessionManagementMethod;
    }

    public void setSessionManagementMethod(SessionManagementMethod sessionManagementMethod) {
        this.sessionManagementMethod = sessionManagementMethod;
    }

    public AuthorizationDetectionMethod getAuthorizationDetectionMethod() {
        return this.authorizationDetectionMethod;
    }

    public void setAuthorizationDetectionMethod(AuthorizationDetectionMethod authorizationDetectionMethod) {
        this.authorizationDetectionMethod = authorizationDetectionMethod;
    }

    public ParameterParser getUrlParamParser() {
        return this.urlParamParser;
    }

    public void setUrlParamParser(ParameterParser parameterParser) {
        this.urlParamParser = parameterParser;
    }

    public ParameterParser getPostParamParser() {
        return this.postParamParser;
    }

    public void setPostParamParser(ParameterParser parameterParser) {
        this.postParamParser = parameterParser;
    }

    public void restructureSiteTree() {
        if (!View.isInitialised() || EventQueue.isDispatchThread()) {
            this.restructureSiteTreeEventHandler();
        } else {
            try {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Context.this.restructureSiteTreeEventHandler();
                    }
                });
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private void restructureSiteTreeEventHandler() {
        log.debug((Object)("Restructure site tree for context: " + this.getName()));
        List<SiteNode> list = this.getTopNodesInContextFromSiteTree();
        for (SiteNode siteNode : list) {
            this.checkNode(siteNode);
        }
    }

    private boolean checkNode(SiteNode siteNode) {
        int n = siteNode.getChildCount();
        int n2 = 0;
        for (SiteNode object : this.getChildren(siteNode)) {
            if (!this.checkNode(object)) continue;
            ++n2;
        }
        if (this.isInContext(siteNode)) {
            SiteMap siteMap = this.session.getSiteTree();
            HistoryReference historyReference = siteNode.getHistoryReference();
            try {
                SiteNode exception = "POST".equals(historyReference.getMethod()) ? siteMap.findNode(historyReference.getHttpMessage()) : siteMap.findNode(historyReference.getURI());
                if (!(exception != null && siteNode.getHierarchicNodeName().equals(exception.getHierarchicNodeName()) || siteNode.isDataDriven())) {
                    this.moveNode(siteMap, siteNode);
                    return true;
                }
                if (n2 > 0 && n2 == n && siteNode.getChildCount() == 0 && historyReference.getHistoryType() == 0) {
                    this.deleteNode(siteMap, siteNode);
                    return true;
                }
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
        return false;
    }

    private List<SiteNode> getChildren(SiteNode siteNode) {
        int n = siteNode.getChildCount();
        if (n == 0) {
            return Collections.emptyList();
        }
        ArrayList<SiteNode> arrayList = new ArrayList<SiteNode>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add((SiteNode)siteNode.getChildAt(i));
        }
        return arrayList;
    }

    private void moveNode(SiteMap siteMap, SiteNode siteNode) {
        List<Alert> list = siteNode.getAlerts();
        this.deleteNode(siteMap, siteNode);
        SiteNode siteNode2 = siteMap.addPath(siteNode.getHistoryReference());
        log.debug((Object)("Moved node " + siteNode.getHierarchicNodeName() + " to " + siteNode2.getHierarchicNodeName()));
        for (Alert alert : list) {
            siteNode2.addAlert(alert);
        }
    }

    private void deleteNode(SiteMap siteMap, SiteNode siteNode) {
        log.debug((Object)("Deleting node " + siteNode.getHierarchicNodeName()));
        siteNode.deleteAlerts(siteNode.getAlerts());
        siteMap.removeNodeFromParent(siteNode);
        siteMap.removeHistoryReference(siteNode.getHistoryReference().getHistoryId());
    }

    public List<StructuralNodeModifier> getDataDrivenNodes() {
        ArrayList<StructuralNodeModifier> arrayList = new ArrayList<StructuralNodeModifier>(this.dataDrivenNodes.size());
        for (StructuralNodeModifier structuralNodeModifier : this.dataDrivenNodes) {
            arrayList.add(structuralNodeModifier.clone());
        }
        return arrayList;
    }

    public void setDataDrivenNodes(List<StructuralNodeModifier> list) {
        this.dataDrivenNodes = list;
    }

    public void addDataDrivenNodes(StructuralNodeModifier structuralNodeModifier) {
        this.dataDrivenNodes.add(structuralNodeModifier.clone());
    }

    public String getDefaultDDNName() {
        int n = 1;
        while (true) {
            boolean bl = false;
            String string = "DDN" + n;
            for (StructuralNodeModifier structuralNodeModifier : this.dataDrivenNodes) {
                if (!structuralNodeModifier.getName().equals(string)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return string;
            }
            ++n;
        }
    }

    public Context duplicate() {
        Context context = new Context(this.session, this.getIndex());
        context.description = this.description;
        context.name = this.name;
        context.includeInRegexs = new ArrayList<String>(this.includeInRegexs);
        context.includeInPatterns = new ArrayList<Pattern>(this.includeInPatterns);
        context.excludeFromRegexs = new ArrayList<String>(this.excludeFromRegexs);
        context.excludeFromPatterns = new ArrayList<Pattern>(this.excludeFromPatterns);
        context.inScope = this.inScope;
        context.techSet = new TechSet(this.techSet);
        context.authenticationMethod = this.authenticationMethod.clone();
        context.sessionManagementMethod = this.sessionManagementMethod.clone();
        context.urlParamParser = this.urlParamParser.clone();
        context.postParamParser = this.postParamParser.clone();
        context.authorizationDetectionMethod = this.authorizationDetectionMethod.clone();
        context.dataDrivenNodes = this.getDataDrivenNodes();
        return context;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.index;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Context context = (Context)object;
        return this.index == context.index;
    }
}

