/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider;

import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.net.ssl.SSLException;
import net.htmlparser.jericho.Source;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.parosproxy.paros.network.HttpResponseHeader;
import org.zaproxy.zap.spider.Spider;
import org.zaproxy.zap.spider.filters.ParseFilter;
import org.zaproxy.zap.spider.parser.SpiderParser;

public class SpiderTask
implements Runnable {
    private Spider parent;
    private HistoryReference reference;
    private int depth;
    private ExtensionHistory extHistory = null;
    private static final Logger log = Logger.getLogger(SpiderTask.class);

    public SpiderTask(Spider spider, URI uRI, int n, String string) {
        this(spider, null, uRI, n, string, null);
    }

    public SpiderTask(Spider spider, URI uRI, URI uRI2, int n, String string) {
        this(spider, uRI, uRI2, n, string, null);
    }

    public SpiderTask(Spider spider, URI uRI, int n, String string, String string2) {
        this(spider, null, uRI, n, string, string2);
    }

    public SpiderTask(Spider spider, URI uRI, URI uRI2, int n, String string, String string2) {
        this.parent = spider;
        this.depth = n;
        if (log.isDebugEnabled()) {
            log.debug((Object)("New task submitted for uri: " + uRI2));
        }
        try {
            HttpRequestHeader httpRequestHeader = new HttpRequestHeader(string, uRI2, "HTTP/1.1", spider.getConnectionParam());
            if (uRI != null && spider.getSpiderParam().isSendRefererHeader()) {
                httpRequestHeader.setHeader("Referer", uRI.toString());
            }
            HttpMessage httpMessage = new HttpMessage(httpRequestHeader);
            if (string2 != null) {
                httpMessage.getRequestHeader().setContentLength(string2.length());
                httpMessage.setRequestBody(string2);
            }
            this.reference = new HistoryReference(spider.getModel().getSession(), 9, httpMessage);
        }
        catch (HttpMalformedHeaderException httpMalformedHeaderException) {
            log.error((Object)("Error while building HttpMessage for uri: " + uRI2), (Throwable)httpMalformedHeaderException);
        }
        catch (DatabaseException databaseException) {
            log.error((Object)("Error while persisting HttpMessage for uri: " + uRI2), (Throwable)databaseException);
        }
    }

    @Override
    public void run() {
        HttpMessage httpMessage;
        if (this.reference == null) {
            log.warn((Object)("Null URI. Skipping crawling task: " + this));
            this.parent.postTaskExecution();
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Spider Task Started. Processing uri at depth " + this.depth + " using already constructed message:  " + this.reference.getURI()));
        }
        if (this.parent.isStopped()) {
            log.debug((Object)"Spider process is stopped. Skipping crawling task...");
            this.deleteHistoryReference();
            this.parent.postTaskExecution();
            return;
        }
        this.parent.preTaskExecution();
        try {
            httpMessage = this.prepareHttpMessage();
        }
        catch (Exception exception) {
            log.error((Object)"Failed to prepare HTTP message: ", (Throwable)exception);
            this.parent.postTaskExecution();
            return;
        }
        try {
            this.fetchResource(httpMessage);
        }
        catch (Exception exception) {
            this.setErrorResponse(httpMessage, exception);
            this.parent.notifyListenersReadURI(httpMessage);
            this.parent.postTaskExecution();
            return;
        }
        if (this.parent.isStopped()) {
            log.debug((Object)"Spider process is stopped. Skipping crawling task...");
            this.parent.postTaskExecution();
            return;
        }
        this.parent.checkPauseAndWait();
        boolean bl = false;
        for (ParseFilter parseFilter : this.parent.getController().getParseFilters()) {
            if (!parseFilter.isFiltered(httpMessage)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resource fetched, but will not be parsed due to a ParseFilter rule: " + httpMessage.getRequestHeader().getURI()));
            }
            bl = true;
            break;
        }
        if (!bl) {
            this.parent.notifyListenersReadURI(httpMessage);
        }
        if (this.parent.isStopped()) {
            log.debug((Object)"Spider process is stopped. Skipping crawling task...");
            this.parent.postTaskExecution();
            return;
        }
        this.parent.checkPauseAndWait();
        if (!bl && this.depth < this.parent.getSpiderParam().getMaxDepth()) {
            this.processResource(httpMessage);
        }
        this.parent.postTaskExecution();
        log.debug((Object)"Spider Task finished.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpMessage prepareHttpMessage() throws HttpMalformedHeaderException, DatabaseException {
        HttpMessage httpMessage;
        try {
            httpMessage = this.reference.getHttpMessage();
        }
        finally {
            this.deleteHistoryReference();
        }
        httpMessage.getRequestHeader().setHeader("If-Modified-Since", null);
        httpMessage.getRequestHeader().setHeader("If-None-Match", null);
        if (this.parent.getSpiderParam().getUserAgent() != null) {
            httpMessage.getRequestHeader().setHeader("User-Agent", this.parent.getSpiderParam().getUserAgent());
        }
        if (this.parent.getScanUser() != null) {
            httpMessage.setRequestingUser(this.parent.getScanUser());
        }
        return httpMessage;
    }

    private void deleteHistoryReference() {
        if (this.reference == null) {
            return;
        }
        if (this.getExtensionHistory() != null) {
            this.getExtensionHistory().delete(this.reference);
            this.reference = null;
        }
    }

    private void setErrorResponse(HttpMessage httpMessage, Exception exception) {
        StringBuilder stringBuilder = new StringBuilder(250);
        if (exception instanceof SSLException) {
            stringBuilder.append(Constant.messages.getString("network.ssl.error.connect"));
            stringBuilder.append(httpMessage.getRequestHeader().getURI().toString()).append('\n');
            stringBuilder.append(Constant.messages.getString("network.ssl.error.exception")).append(exception.getMessage()).append('\n');
            stringBuilder.append(Constant.messages.getString("network.ssl.error.exception.rootcause")).append(ExceptionUtils.getRootCauseMessage((Throwable)exception)).append('\n');
            stringBuilder.append(Constant.messages.getString("network.ssl.error.help", Constant.messages.getString("network.ssl.error.help.url")));
            stringBuilder.append("\n\nStack Trace:\n");
            for (String string : ExceptionUtils.getRootCauseStackTrace((Throwable)exception)) {
                stringBuilder.append(string).append('\n');
            }
        } else {
            stringBuilder.append(exception.getClass().getName()).append(": ").append(exception.getLocalizedMessage()).append("\n\nStack Trace:\n");
            for (String string : ExceptionUtils.getRootCauseStackTrace((Throwable)exception)) {
                stringBuilder.append(string).append('\n');
            }
        }
        String string = stringBuilder.toString();
        try {
            HttpResponseHeader httpResponseHeader = new HttpResponseHeader("HTTP/1.1 400 ZAP IO Error");
            httpResponseHeader.setHeader("Content-Type", "text/plain; charset=UTF-8");
            httpResponseHeader.setHeader("Content-Length", Integer.toString(string.getBytes(StandardCharsets.UTF_8).length));
            httpMessage.setResponseHeader(httpResponseHeader);
            httpMessage.setResponseBody(string);
        }
        catch (HttpMalformedHeaderException httpMalformedHeaderException) {
            log.error((Object)"Failed to create error response:", (Throwable)httpMalformedHeaderException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResource(HttpMessage httpMessage) {
        List<SpiderParser> list = this.parent.getController().getParsers();
        Source source = new Source((CharSequence)httpMessage.getResponseBody().toString());
        String string = null;
        try {
            string = httpMessage.getRequestHeader().getURI().getPath();
        }
        catch (URIException uRIException) {
        }
        finally {
            if (string == null) {
                string = "";
            }
        }
        boolean bl = false;
        for (SpiderParser spiderParser : list) {
            if (spiderParser.canParseResource(httpMessage, string, bl)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Parser " + spiderParser + " can parse resource '" + string + "'"));
                }
                if (!spiderParser.parseResource(httpMessage, source, this.depth)) continue;
                bl = true;
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Parser " + spiderParser + " cannot parse resource '" + string + "'"));
        }
    }

    private ExtensionHistory getExtensionHistory() {
        if (this.extHistory == null) {
            this.extHistory = (ExtensionHistory)Control.getSingleton().getExtensionLoader().getExtension("ExtensionHistory");
        }
        return this.extHistory;
    }

    private void fetchResource(HttpMessage httpMessage) throws IOException {
        if (this.parent.getHttpSender() == null) {
            return;
        }
        try {
            this.parent.getHttpSender().sendAndReceive(httpMessage);
        }
        catch (ConnectException connectException) {
            log.debug((Object)("Failed to connect to: " + httpMessage.getRequestHeader().getURI()), (Throwable)connectException);
            throw connectException;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            log.debug((Object)("Socket timeout: " + httpMessage.getRequestHeader().getURI()), (Throwable)socketTimeoutException);
            throw socketTimeoutException;
        }
        catch (SocketException socketException) {
            log.debug((Object)("Socket exception: " + httpMessage.getRequestHeader().getURI()), (Throwable)socketException);
            throw socketException;
        }
        catch (UnknownHostException unknownHostException) {
            log.debug((Object)("Unknown host: " + httpMessage.getRequestHeader().getURI()), (Throwable)unknownHostException);
            throw unknownHostException;
        }
        catch (Exception exception) {
            log.error((Object)("An error occurred while fetching the resource [" + httpMessage.getRequestHeader().getURI() + "]: " + exception.getMessage()), (Throwable)exception);
            throw exception;
        }
    }

    void cleanup() {
        this.deleteHistoryReference();
    }
}

