/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.Frame;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.SiteNode;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.StructuralSiteNode;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.view.StandardFieldsDialog;

public class ContextCreateDialog
extends StandardFieldsDialog {
    private static final long serialVersionUID = 1L;
    private static final String NAME_FIELD = "context.label.name";
    private static final String DESC_FIELD = "context.label.desc";
    private static final String TOP_NODE = "context.label.top";
    private static final String IN_SCOPE_FIELD = "context.inscope.label";
    private SiteNode topNode = null;

    public ContextCreateDialog(Frame frame) {
        super(frame, "context.create.title", DisplayUtils.getScaledDimension(400, 300));
        this.addTextField(NAME_FIELD, null);
        this.addNodeSelectField(TOP_NODE, null, false, false);
        this.addMultilineField(DESC_FIELD, "");
        this.addCheckBoxField(IN_SCOPE_FIELD, true);
    }

    @Override
    public void siteNodeSelected(String string, SiteNode siteNode) {
        this.topNode = siteNode;
        if (siteNode != null && this.isEmptyField(NAME_FIELD)) {
            this.setFieldValue(NAME_FIELD, siteNode.getNodeName());
        }
    }

    @Override
    public void save() {
        Context context = Model.getSingleton().getSession().getNewContext(this.getStringValue(NAME_FIELD));
        context.setDescription(this.getStringValue(DESC_FIELD));
        context.setInScope(this.getBoolValue(IN_SCOPE_FIELD));
        if (this.topNode != null) {
            try {
                context.addIncludeInContextRegex(new StructuralSiteNode(this.topNode).getRegexPattern());
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
        }
        Model.getSingleton().getSession().saveContext(context);
    }

    @Override
    public String validateFields() {
        if (this.isEmptyField(NAME_FIELD)) {
            return Constant.messages.getString("context.create.warning.noname");
        }
        if (Model.getSingleton().getSession().getContext(this.getStringValue(NAME_FIELD)) != null) {
            return Constant.messages.getString("context.error.name.duplicated");
        }
        return null;
    }
}

