/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SortOrder;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.ParameterParser;
import org.zaproxy.zap.model.StandardParameterParser;
import org.zaproxy.zap.model.StructuralNodeModifier;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.AbstractContextPropertiesPanel;
import org.zaproxy.zap.view.AbstractMultipleOptionsBaseTablePanel;
import org.zaproxy.zap.view.LayoutHelper;
import org.zaproxy.zap.view.StandardFieldsDialog;
import org.zaproxy.zap.view.StructuralNodeModifiersTableModel;

public class ContextStructurePanel
extends AbstractContextPropertiesPanel {
    private static final String PANEL_NAME = Constant.messages.getString("context.struct.title");
    private static final long serialVersionUID = -1L;
    private StructuralNodeModifiersTableModel ddnTableModel;
    private JPanel panelSession = null;
    private ZapTextField urlKvPairSeparators = null;
    private ZapTextField urlKeyValueSeparators = null;
    private ZapTextField postKeyValueSeparators = null;
    private ZapTextField postKvPairSeparators = null;

    public static String getPanelName(int n) {
        return n + ": " + PANEL_NAME;
    }

    public ContextStructurePanel(Context context) {
        super(context.getIndex());
        this.setLayout(new CardLayout());
        this.setName(ContextStructurePanel.getPanelName(this.getContextIndex()));
        this.add((Component)this.getPanel(), this.getPanel().getName());
    }

    private JPanel getPanel() {
        if (this.panelSession == null) {
            this.panelSession = new JPanel();
            this.panelSession.setLayout(new GridBagLayout());
            this.panelSession.setName("SessionStructure");
            this.panelSession.setLayout(new GridBagLayout());
            this.panelSession.add((Component)new JLabel(Constant.messages.getString("context.struct.label.url.kvpsep")), LayoutHelper.getGBC(0, 0, 1, 1.0));
            this.panelSession.add((Component)this.getUrlKvPairSeparators(), LayoutHelper.getGBC(1, 0, 1, 1.0, new Insets(2, 0, 2, 0)));
            this.panelSession.add((Component)new JLabel(Constant.messages.getString("context.struct.label.url.kvsep")), LayoutHelper.getGBC(0, 1, 1, 1.0));
            this.panelSession.add((Component)this.getUrlKeyValueSeparators(), LayoutHelper.getGBC(1, 1, 1, 1.0, new Insets(2, 0, 2, 0)));
            this.panelSession.add((Component)new JLabel(Constant.messages.getString("context.struct.label.post.kvpsep")), LayoutHelper.getGBC(0, 2, 1, 1.0));
            this.panelSession.add((Component)this.getPostKvPairSeparators(), LayoutHelper.getGBC(1, 2, 1, 1.0, new Insets(2, 0, 2, 0)));
            this.panelSession.add((Component)new JLabel(Constant.messages.getString("context.struct.label.post.kvsep")), LayoutHelper.getGBC(0, 3, 1, 1.0));
            this.panelSession.add((Component)this.getPostKeyValueSeparators(), LayoutHelper.getGBC(1, 3, 1, 1.0, new Insets(2, 0, 2, 0)));
            this.panelSession.add((Component)new JLabel(Constant.messages.getString("context.struct.label.struct")), LayoutHelper.getGBC(0, 4, 1, 1.0));
            this.ddnTableModel = new StructuralNodeModifiersTableModel();
            DataDrivenNodesMultipleOptionsPanel dataDrivenNodesMultipleOptionsPanel = new DataDrivenNodesMultipleOptionsPanel(this.ddnTableModel);
            this.panelSession.add((Component)dataDrivenNodesMultipleOptionsPanel, LayoutHelper.getGBC(0, 5, 2, 1.0, 1.0));
        }
        return this.panelSession;
    }

    private ZapTextField getUrlKvPairSeparators() {
        if (this.urlKvPairSeparators == null) {
            this.urlKvPairSeparators = new ZapTextField();
        }
        return this.urlKvPairSeparators;
    }

    private ZapTextField getUrlKeyValueSeparators() {
        if (this.urlKeyValueSeparators == null) {
            this.urlKeyValueSeparators = new ZapTextField();
        }
        return this.urlKeyValueSeparators;
    }

    private ZapTextField getPostKeyValueSeparators() {
        if (this.postKeyValueSeparators == null) {
            this.postKeyValueSeparators = new ZapTextField();
        }
        return this.postKeyValueSeparators;
    }

    private ZapTextField getPostKvPairSeparators() {
        if (this.postKvPairSeparators == null) {
            this.postKvPairSeparators = new ZapTextField();
        }
        return this.postKvPairSeparators;
    }

    @Override
    public void initContextData(Session session, Context context) {
        StandardParameterParser standardParameterParser;
        ParameterParser parameterParser = context.getUrlParamParser();
        ParameterParser parameterParser2 = context.getPostParamParser();
        this.ddnTableModel.setStructuralNodeModifiers(context.getDataDrivenNodes());
        if (parameterParser instanceof StandardParameterParser) {
            standardParameterParser = (StandardParameterParser)parameterParser;
            this.getUrlKvPairSeparators().setText(standardParameterParser.getKeyValuePairSeparators());
            this.getUrlKeyValueSeparators().setText(standardParameterParser.getKeyValueSeparators());
            for (String string : standardParameterParser.getStructuralParameters()) {
                this.ddnTableModel.addStructuralNodeModifier(new StructuralNodeModifier(StructuralNodeModifier.Type.StructuralParameter, null, string));
            }
        }
        if (parameterParser2 instanceof StandardParameterParser) {
            standardParameterParser = (StandardParameterParser)parameterParser2;
            this.getPostKvPairSeparators().setText(standardParameterParser.getKeyValuePairSeparators());
            this.getPostKeyValueSeparators().setText(standardParameterParser.getKeyValueSeparators());
        }
    }

    @Override
    public void validateContextData(Session session) throws Exception {
        if (this.urlKvPairSeparators.getText().length() == 0) {
            throw new IllegalArgumentException(Constant.messages.getString("context.struct.warning.stdparser.nokvpsep"));
        }
        if (this.urlKeyValueSeparators.getText().length() == 0) {
            throw new IllegalArgumentException(Constant.messages.getString("context.struct.warning.stdparser.nokvsep"));
        }
        for (char c : this.urlKvPairSeparators.getText().toCharArray()) {
            if (!this.urlKeyValueSeparators.getText().contains("" + c)) continue;
            throw new IllegalArgumentException(Constant.messages.getString("context.struct.warning.stdparser.dup"));
        }
        if (this.postKvPairSeparators.getText().length() == 0) {
            throw new IllegalArgumentException(Constant.messages.getString("context.struct.warning.stdparser.nokvpsep"));
        }
        if (this.postKeyValueSeparators.getText().length() == 0) {
            throw new IllegalArgumentException(Constant.messages.getString("context.struct.warning.stdparser.nokvsep"));
        }
        for (char c : this.postKvPairSeparators.getText().toCharArray()) {
            if (!this.postKeyValueSeparators.getText().contains("" + c)) continue;
            throw new IllegalArgumentException(Constant.messages.getString("context.struct.warning.stdparser.dup"));
        }
    }

    private void saveToContext(Context context, boolean bl) {
        Object object;
        ParameterParser parameterParser = context.getUrlParamParser();
        ParameterParser parameterParser2 = context.getPostParamParser();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<StructuralNodeModifier> arrayList2 = new ArrayList<StructuralNodeModifier>();
        for (StructuralNodeModifier structuralNodeModifier : this.ddnTableModel.getElements()) {
            if (structuralNodeModifier.getType().equals((Object)StructuralNodeModifier.Type.StructuralParameter)) {
                arrayList.add(structuralNodeModifier.getName());
                continue;
            }
            arrayList2.add(structuralNodeModifier);
        }
        if (parameterParser instanceof StandardParameterParser) {
            object = (StandardParameterParser)parameterParser;
            ((StandardParameterParser)object).setKeyValuePairSeparators(this.getUrlKvPairSeparators().getText());
            ((StandardParameterParser)object).setKeyValueSeparators(this.getUrlKeyValueSeparators().getText());
            ((StandardParameterParser)object).setStructuralParameters(arrayList);
            context.setUrlParamParser((ParameterParser)object);
            ((StandardParameterParser)object).setContext(context);
        }
        if (parameterParser2 instanceof StandardParameterParser) {
            object = (StandardParameterParser)parameterParser2;
            ((StandardParameterParser)object).setKeyValuePairSeparators(this.getPostKvPairSeparators().getText());
            ((StandardParameterParser)object).setKeyValueSeparators(this.getPostKeyValueSeparators().getText());
            context.setPostParamParser((ParameterParser)object);
            ((StandardParameterParser)object).setContext(context);
        }
        context.setDataDrivenNodes(arrayList2);
        if (bl) {
            context.restructureSiteTree();
        }
    }

    @Override
    public void saveContextData(Session session) throws Exception {
        Context context = session.getContext(this.getContextIndex());
        this.saveToContext(context, true);
    }

    @Override
    public void saveTemporaryContextData(Context context) {
        this.saveToContext(context, false);
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.context-struct";
    }

    public static class StructuralModifierDialog
    extends StandardFieldsDialog {
        private static final long serialVersionUID = 1L;
        private static final String FIELD_TYPE = "context.ddn.dialog.type";
        private static final String FIELD_NAME = "context.ddn.dialog.name";
        private static final String FIELD_REGEX = "context.ddn.dialog.regex";
        private static final String VALUE_TYPE_DATA = "context.ddn.dialog.type.data";
        private static final String VALUE_TYPE_STRUCT = "context.ddn.dialog.type.struct";
        private StructuralNodeModifier.Type type = StructuralNodeModifier.Type.StructuralParameter;
        private StructuralNodeModifier ddn = null;
        private boolean ro = false;

        public StructuralModifierDialog(JDialog jDialog, String string, Dimension dimension) {
            super((Window)jDialog, string, dimension, true);
        }

        public StructuralNodeModifier showDialog(StructuralNodeModifier structuralNodeModifier) {
            String string = "";
            String string2 = "";
            this.ddn = structuralNodeModifier;
            if (structuralNodeModifier != null) {
                this.type = structuralNodeModifier.getType();
                if (structuralNodeModifier.getPattern() != null) {
                    string = structuralNodeModifier.getPattern().pattern();
                }
                string2 = structuralNodeModifier.getName();
                this.ro = true;
                this.addReadOnlyField(FIELD_NAME, this.getModVal(this.type), false);
            } else {
                this.addComboField(FIELD_TYPE, new String[]{Constant.messages.getString(VALUE_TYPE_STRUCT), Constant.messages.getString(VALUE_TYPE_DATA)}, this.getModVal(this.type));
                this.addFieldListener(FIELD_TYPE, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        StructuralModifierDialog.this.setFieldStates();
                    }
                });
            }
            this.addTextField(FIELD_NAME, string2);
            this.addTextField(FIELD_REGEX, string);
            this.setFieldStates();
            this.setVisible(true);
            return this.ddn;
        }

        private void setFieldStates() {
            if (!this.ro) {
                this.type = Constant.messages.getString(VALUE_TYPE_STRUCT).equals(this.getStringValue(FIELD_TYPE)) ? StructuralNodeModifier.Type.StructuralParameter : StructuralNodeModifier.Type.DataDrivenNode;
            }
            this.getField(FIELD_REGEX).setEnabled(StructuralNodeModifier.Type.DataDrivenNode.equals((Object)this.type));
        }

        private String getModVal(StructuralNodeModifier.Type type) {
            switch (type) {
                case StructuralParameter: {
                    return Constant.messages.getString(VALUE_TYPE_STRUCT);
                }
                case DataDrivenNode: {
                    return Constant.messages.getString(VALUE_TYPE_DATA);
                }
            }
            return "";
        }

        @Override
        public void save() {
            this.ddn = new StructuralNodeModifier(this.type, Pattern.compile(this.getStringValue(FIELD_REGEX)), this.getStringValue(FIELD_NAME));
        }

        @Override
        public String validateFields() {
            if (!this.getStringValue(FIELD_NAME).matches("[A-Za-z0-9_]+")) {
                return Constant.messages.getString("context.ddn.dialog.error.name");
            }
            if (StructuralNodeModifier.Type.DataDrivenNode.equals((Object)this.type)) {
                if (this.isEmptyField(FIELD_REGEX)) {
                    return Constant.messages.getString("context.ddn.dialog.error.regex");
                }
                if (!this.getStringValue(FIELD_REGEX).matches(".*\\(.*\\).*\\(.*\\).*")) {
                    return Constant.messages.getString("context.ddn.dialog.error.regex");
                }
                try {
                    Pattern.compile(this.getStringValue(FIELD_REGEX));
                }
                catch (Exception exception) {
                    return Constant.messages.getString("context.ddn.dialog.error.regex");
                }
            }
            return null;
        }
    }

    public static class DataDrivenNodesMultipleOptionsPanel
    extends AbstractMultipleOptionsBaseTablePanel<StructuralNodeModifier> {
        private static final long serialVersionUID = -7216673905642941770L;
        private static final String REMOVE_DIALOG_TITLE = Constant.messages.getString("context.ddn.dialog.remove.title");
        private static final String REMOVE_DIALOG_TEXT = Constant.messages.getString("context.ddn.dialog.remove.text");
        private static final String REMOVE_DIALOG_CONFIRM_BUTTON_LABEL = Constant.messages.getString("all.button.remove");
        private static final String REMOVE_DIALOG_CANCEL_BUTTON_LABEL = Constant.messages.getString("all.button.cancel");
        private static final String REMOVE_DIALOG_CHECKBOX_LABEL = Constant.messages.getString("all.prompt.dontshow");

        public DataDrivenNodesMultipleOptionsPanel(StructuralNodeModifiersTableModel structuralNodeModifiersTableModel) {
            super(structuralNodeModifiersTableModel);
            this.getTable().getColumnExt(0).setPreferredWidth(50);
            this.getTable().getColumnExt(1).setPreferredWidth(50);
            this.getTable().getColumnExt(2).setPreferredWidth(200);
            this.getTable().setSortOrder(1, SortOrder.ASCENDING);
        }

        @Override
        public StructuralNodeModifier showAddDialogue() {
            StructuralModifierDialog structuralModifierDialog = new StructuralModifierDialog(View.getSingleton().getSessionDialog(), "context.ddn.dialog.add.title", new Dimension(500, 200));
            return structuralModifierDialog.showDialog(null);
        }

        @Override
        public StructuralNodeModifier showModifyDialogue(StructuralNodeModifier structuralNodeModifier) {
            StructuralModifierDialog structuralModifierDialog = new StructuralModifierDialog(View.getSingleton().getSessionDialog(), "context.ddn.dialog.modify.title", new Dimension(500, 200));
            return structuralModifierDialog.showDialog(structuralNodeModifier);
        }

        @Override
        public boolean showRemoveDialogue(StructuralNodeModifier structuralNodeModifier) {
            JCheckBox jCheckBox = new JCheckBox(REMOVE_DIALOG_CHECKBOX_LABEL);
            Object[] objectArray = new Object[]{REMOVE_DIALOG_TEXT, " ", jCheckBox};
            int n = JOptionPane.showOptionDialog(View.getSingleton().getMainFrame(), objectArray, REMOVE_DIALOG_TITLE, 2, 3, null, new String[]{REMOVE_DIALOG_CONFIRM_BUTTON_LABEL, REMOVE_DIALOG_CANCEL_BUTTON_LABEL}, null);
            if (n == 0) {
                this.setRemoveWithoutConfirmation(jCheckBox.isSelected());
                return true;
            }
            return false;
        }
    }
}

