/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.LoggingEvent;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.utils.FontUtils;
import org.zaproxy.zap.utils.ZapTextArea;
import org.zaproxy.zap.view.BackgroundImagePanel;
import org.zaproxy.zap.view.LayoutHelper;

public class SplashScreen
extends JFrame {
    private static final String TIPS_PREFIX = "tips";
    private static final String TIPS_TIP_PREFIX = "tips.tip.";
    private static final Logger LOGGER = Logger.getLogger(SplashScreen.class);
    private static final long serialVersionUID = 1L;
    private static final char NEWLINE = '\n';
    private JScrollPane logScrollPane = null;
    private JScrollPane tipsScrollPane = null;
    private JProgressBar loadProgressBar = null;
    private ZapTextArea logPanel = null;
    private ZapTextArea tipsPanel = null;
    private List<String> tipsAndTricks = null;
    private final Random random = new Random();
    private boolean tipsLoaded = false;
    private double currentPerc;
    private SplashOutputWriter splashOutputWriter;

    public SplashScreen() {
        this.setSize(DisplayUtils.getScaledDimension(420, 420));
        this.setLocationRelativeTo(null);
        this.setTitle("OWASP ZAP");
        this.setIconImages(DisplayUtils.getZapIconImages());
        BackgroundImagePanel backgroundImagePanel = new BackgroundImagePanel();
        backgroundImagePanel.setPreferredSize(DisplayUtils.getScaledDimension(420, 420));
        backgroundImagePanel.setLayout(new GridBagLayout());
        backgroundImagePanel.setBackgroundImage(SplashScreen.class.getResource("/resource/zap-splash-background.png"));
        Border border = BorderFactory.createEtchedBorder(0);
        Border border2 = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        backgroundImagePanel.setBorder(BorderFactory.createCompoundBorder(border, border2));
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("OWASP ZAP");
        jLabel2.setFont(FontUtils.getFont(1, FontUtils.Size.huge));
        jLabel2.setVisible(true);
        jLabel2.setName("lblProgramName");
        jLabel.setText(Constant.PROGRAM_VERSION);
        jLabel.setFont(FontUtils.getFont(FontUtils.Size.much_larger));
        jLabel.setName("lblVersion");
        backgroundImagePanel.add((Component)jLabel2, LayoutHelper.getGBC(0, 0, 2, 1.0));
        backgroundImagePanel.add((Component)jLabel, LayoutHelper.getGBC(0, 1, 2, 1.0, new Insets(0, 8, 0, 8)));
        backgroundImagePanel.add((Component)this.getLoadingJProgressBar(), LayoutHelper.getGBC(0, 2, 1, 1.0, new Insets(56, 0, 24, 0)));
        backgroundImagePanel.add(Box.createHorizontalGlue(), LayoutHelper.getGBC(1, 2, 1, 1.0));
        backgroundImagePanel.add((Component)this.getTipsJScrollPane(), LayoutHelper.getGBC(0, 3, 2, 1.0, 1.0));
        backgroundImagePanel.add((Component)this.getLogJScrollPane(), LayoutHelper.getGBC(0, 4, 2, 1.0, 0.5));
        this.add(backgroundImagePanel);
        this.pack();
        this.splashOutputWriter = new SplashOutputWriter();
        Logger.getRootLogger().addAppender((Appender)this.splashOutputWriter);
        this.setVisible(true);
    }

    public void setLoadingCompletion(double d) {
        this.currentPerc = d;
        this.updateLoadingJProgressBar();
    }

    public void addLoadingCompletion(double d) {
        this.currentPerc += d;
        this.updateLoadingJProgressBar();
    }

    private void updateLoadingJProgressBar() {
        if (!EventQueue.isDispatchThread()) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SplashScreen.this.updateLoadingJProgressBar();
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
                LOGGER.error((Object)"Failed to update progress bar: ", (Throwable)invocationTargetException);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return;
        }
        if (this.currentPerc > 100.0) {
            this.currentPerc = 100.0;
        } else if (this.currentPerc < 0.0) {
            this.currentPerc = 0.0;
        }
        this.getLoadingJProgressBar().setValue((int)this.currentPerc);
    }

    private JProgressBar getLoadingJProgressBar() {
        if (this.loadProgressBar == null) {
            this.loadProgressBar = new JProgressBar();
            this.loadProgressBar.setPreferredSize(DisplayUtils.getScaledDimension(100, 12));
            this.loadProgressBar.setMinimum(0);
            this.loadProgressBar.setMaximum(100);
            this.loadProgressBar.setValue(50);
            this.setLoadingCompletion(0.0);
        }
        return this.loadProgressBar;
    }

    private JScrollPane getLogJScrollPane() {
        if (this.logScrollPane == null) {
            this.logScrollPane = new JScrollPane();
            this.logScrollPane.setViewportView(this.getLogPanel());
        }
        return this.logScrollPane;
    }

    private JScrollPane getTipsJScrollPane() {
        if (this.tipsScrollPane == null) {
            this.tipsScrollPane = new JScrollPane();
            this.tipsScrollPane.setViewportView(this.getTipsPanel());
        }
        return this.tipsScrollPane;
    }

    private ZapTextArea getLogPanel() {
        if (this.logPanel == null) {
            this.logPanel = new ZapTextArea();
            this.logPanel.setEditable(false);
            this.logPanel.setLineWrap(true);
            this.logPanel.setName("");
            this.logPanel.append(Constant.messages.getString("start.splash.start"));
        }
        return this.logPanel;
    }

    private ZapTextArea getTipsPanel() {
        if (this.tipsPanel == null) {
            this.tipsPanel = new ZapTextArea();
            this.tipsPanel.setEditable(false);
            this.tipsPanel.setLineWrap(true);
            this.tipsPanel.setWrapStyleWord(true);
            this.tipsPanel.setName("");
            this.tipsPanel.append(Constant.messages.getString("start.splash.tips.loading"));
            this.displayRandomTip();
        }
        return this.tipsPanel;
    }

    private void displayRandomTip() {
        if (this.tipsLoaded || this.getTipsAndTricks() == null) {
            return;
        }
        if (this.getTipsAndTricks().isEmpty()) {
            this.getTipsPanel().setText(Constant.messages.getString("start.splash.tips.none"));
            this.tipsLoaded = true;
            return;
        }
        this.getTipsPanel().setText(Constant.messages.getString("start.splash.tips.title"));
        this.getTipsPanel().append(this.getRandomTip());
        this.tipsLoaded = true;
    }

    public void close() {
        Logger.getRootLogger().removeAppender((Appender)this.splashOutputWriter);
        this.dispose();
    }

    public void appendMsg(final String string) {
        if (!EventQueue.isDispatchThread()) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SplashScreen.this.appendMsg(string);
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
                LOGGER.error((Object)"Failed to append message: ", (Throwable)invocationTargetException);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return;
        }
        this.displayRandomTip();
        this.getLogPanel().append(string);
        JScrollBar jScrollBar = this.getLogJScrollPane().getVerticalScrollBar();
        jScrollBar.setValue(jScrollBar.getMaximum());
    }

    private List<String> getTipsAndTricks() {
        if (this.tipsAndTricks == null) {
            ResourceBundle resourceBundle = Constant.messages.getMessageBundle(TIPS_PREFIX);
            if (resourceBundle == null) {
                return null;
            }
            this.tipsAndTricks = new ArrayList<String>();
            Enumeration<String> enumeration = resourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                if (!string.startsWith(TIPS_TIP_PREFIX)) continue;
                this.tipsAndTricks.add(resourceBundle.getString(string));
            }
        }
        return this.tipsAndTricks;
    }

    private String getRandomTip() {
        return this.getTipsAndTricks().get(this.random.nextInt(this.getTipsAndTricks().size()));
    }

    private class SplashOutputWriter
    extends WriterAppender {
        private SplashOutputWriter() {
        }

        public void append(final LoggingEvent loggingEvent) {
            String string;
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SplashOutputWriter.this.append(loggingEvent);
                    }
                });
                return;
            }
            if (loggingEvent.getLevel().equals((Object)Level.INFO)) {
                String string2 = loggingEvent.getRenderedMessage();
                if (string2 != null) {
                    SplashScreen.this.appendMsg("INFO: " + string2 + '\n');
                }
            } else if (loggingEvent.getLevel().equals((Object)Level.ERROR) && (string = loggingEvent.getRenderedMessage()) != null) {
                SplashScreen.this.appendMsg("ERROR: " + string + '\n');
            }
        }
    }
}

