/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.popup;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.view.messagecontainer.MessageContainer;
import org.zaproxy.zap.view.messagecontainer.http.HttpMessageContainer;
import org.zaproxy.zap.view.messagecontainer.http.SelectableHttpMessagesContainer;
import org.zaproxy.zap.view.messagecontainer.http.SingleHttpMessageContainer;
import org.zaproxy.zap.view.popup.ExtensionPopupMenuComponent;
import org.zaproxy.zap.view.popup.ExtensionPopupMenuItemMessageContainer;

public abstract class PopupMenuItemHttpMessageContainer
extends ExtensionPopupMenuItemMessageContainer {
    private static final long serialVersionUID = -4769111731197641466L;
    private static final Logger logger = Logger.getLogger(PopupMenuItemHttpMessageContainer.class);
    private Invoker invoker = null;
    private HttpMessageContainer httpMessageContainer = null;
    private final boolean multiSelect;

    public PopupMenuItemHttpMessageContainer(String string) {
        this(string, false);
    }

    public PopupMenuItemHttpMessageContainer(String string, boolean bl) {
        super(string);
        this.multiSelect = bl;
        this.addActionListener(new PerformActionsActionListener());
    }

    protected boolean isMultiSelect() {
        return this.multiSelect;
    }

    protected Invoker getInvoker() {
        return this.invoker;
    }

    @Override
    public boolean isEnableForMessageContainer(MessageContainer<?> messageContainer) {
        this.resetState();
        if (!(messageContainer instanceof HttpMessageContainer)) {
            return false;
        }
        HttpMessageContainer httpMessageContainer = (HttpMessageContainer)messageContainer;
        if (!this.isEnable(httpMessageContainer)) {
            return false;
        }
        this.invoker = PopupMenuItemHttpMessageContainer.getInvoker(httpMessageContainer);
        if (!this.isEnableForInvoker(this.invoker, httpMessageContainer)) {
            this.invoker = null;
            return false;
        }
        boolean bl = this.isButtonEnabledForHttpMessageContainerState(httpMessageContainer);
        if (bl && !this.isSafe()) {
            Control.Mode mode = Control.getSingleton().getMode();
            if (mode.equals((Object)Control.Mode.protect)) {
                bl = this.isSelectedMessagesInSessionScope(httpMessageContainer);
            } else if (mode.equals((Object)Control.Mode.safe)) {
                bl = false;
            }
        }
        if (bl) {
            this.httpMessageContainer = httpMessageContainer;
        }
        this.setEnabled(bl);
        return true;
    }

    @Override
    public void dismissed(ExtensionPopupMenuComponent extensionPopupMenuComponent) {
        super.dismissed(extensionPopupMenuComponent);
        if (this != extensionPopupMenuComponent) {
            this.resetState();
        }
    }

    private void resetState() {
        this.invoker = null;
        this.httpMessageContainer = null;
    }

    protected boolean isEnable(HttpMessageContainer httpMessageContainer) {
        return httpMessageContainer instanceof SelectableHttpMessagesContainer || httpMessageContainer instanceof SingleHttpMessageContainer;
    }

    private static Invoker getInvoker(HttpMessageContainer httpMessageContainer) {
        Invoker invoker;
        switch (httpMessageContainer.getName()) {
            case "History Table": {
                invoker = Invoker.HISTORY_PANEL;
                break;
            }
            case "treeSite": {
                invoker = Invoker.SITES_PANEL;
                break;
            }
            case "treeAlert": {
                invoker = Invoker.ALERTS_PANEL;
                break;
            }
            case "SearchHttpMessageContainer": {
                invoker = Invoker.SEARCH_PANEL;
                break;
            }
            case "SpiderHttpMessageContainer": {
                invoker = Invoker.SPIDER_PANEL;
                break;
            }
            case "ActiveScanMessageContainer": {
                invoker = Invoker.ACTIVE_SCANNER_PANEL;
                break;
            }
            case "ForcedBrowseMessageContainer": {
                invoker = Invoker.FORCED_BROWSE_PANEL;
                break;
            }
            case "fuzz.httpfuzzerResultsContentPanel": {
                invoker = Invoker.FUZZER_PANEL;
                break;
            }
            default: {
                invoker = Invoker.UNKNOWN;
            }
        }
        return invoker;
    }

    protected boolean isEnableForInvoker(Invoker invoker, HttpMessageContainer httpMessageContainer) {
        return true;
    }

    protected boolean isButtonEnabledForHttpMessageContainerState(HttpMessageContainer httpMessageContainer) {
        boolean bl = this.isButtonEnabledForNumberOfSelectedMessages(httpMessageContainer);
        if (bl) {
            bl = this.isButtonEnabledForSelectedMessages(httpMessageContainer);
        }
        return bl;
    }

    protected boolean isButtonEnabledForNumberOfSelectedMessages(HttpMessageContainer httpMessageContainer) {
        return this.isButtonEnabledForNumberOfSelectedMessages(this.getNumberOfSelectedMessages(httpMessageContainer));
    }

    protected boolean isButtonEnabledForSelectedMessages(HttpMessageContainer httpMessageContainer) {
        return this.isButtonEnabledForSelectedMessages(this.getSelectedMessages(httpMessageContainer));
    }

    protected int getNumberOfSelectedMessages(HttpMessageContainer httpMessageContainer) {
        if (httpMessageContainer instanceof SelectableHttpMessagesContainer) {
            return ((SelectableHttpMessagesContainer)httpMessageContainer).getNumberOfSelectedMessages();
        }
        if (httpMessageContainer instanceof SingleHttpMessageContainer) {
            return ((SingleHttpMessageContainer)httpMessageContainer).isEmpty() ? 0 : 1;
        }
        return 0;
    }

    protected boolean isButtonEnabledForNumberOfSelectedMessages(int n) {
        if (n == 0) {
            return false;
        }
        return n <= 1 || this.isMultiSelect();
    }

    protected List<HttpMessage> getSelectedMessages(HttpMessageContainer httpMessageContainer) {
        SingleHttpMessageContainer singleHttpMessageContainer;
        if (httpMessageContainer instanceof SelectableHttpMessagesContainer) {
            return ((SelectableHttpMessagesContainer)httpMessageContainer).getSelectedMessages();
        }
        if (httpMessageContainer instanceof SingleHttpMessageContainer && !(singleHttpMessageContainer = (SingleHttpMessageContainer)httpMessageContainer).isEmpty()) {
            ArrayList<HttpMessage> arrayList = new ArrayList<HttpMessage>(1);
            arrayList.add((HttpMessage)((SingleHttpMessageContainer)httpMessageContainer).getMessage());
            return arrayList;
        }
        return Collections.emptyList();
    }

    protected boolean isButtonEnabledForSelectedMessages(List<HttpMessage> list) {
        for (HttpMessage httpMessage : list) {
            if (httpMessage == null || this.isButtonEnabledForSelectedHttpMessage(httpMessage)) continue;
            return false;
        }
        return true;
    }

    protected boolean isButtonEnabledForSelectedHttpMessage(HttpMessage httpMessage) {
        return true;
    }

    protected boolean isSelectedMessagesInSessionScope(HttpMessageContainer httpMessageContainer) {
        for (HttpMessage httpMessage : this.getSelectedMessages(httpMessageContainer)) {
            if (httpMessage == null || httpMessage.isInScope()) continue;
            return false;
        }
        return true;
    }

    protected void performActions(HttpMessageContainer httpMessageContainer) {
        this.performActions(this.getSelectedMessages(httpMessageContainer));
    }

    protected void performActions(List<HttpMessage> list) {
        for (HttpMessage httpMessage : list) {
            if (httpMessage == null) continue;
            this.performAction(httpMessage);
        }
    }

    protected abstract void performAction(HttpMessage var1);

    private class PerformActionsActionListener
    implements ActionListener {
        private PerformActionsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("actionPerformed " + (PopupMenuItemHttpMessageContainer.this.invoker != null ? PopupMenuItemHttpMessageContainer.this.invoker.name() : "null invoker") + " " + actionEvent.getActionCommand()));
            }
            try {
                PopupMenuItemHttpMessageContainer.this.performActions(PopupMenuItemHttpMessageContainer.this.httpMessageContainer);
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
            PopupMenuItemHttpMessageContainer.this.resetState();
        }
    }

    protected static enum Invoker {
        SITES_PANEL,
        HISTORY_PANEL,
        ALERTS_PANEL,
        ACTIVE_SCANNER_PANEL,
        SEARCH_PANEL,
        SPIDER_PANEL,
        FUZZER_PANEL,
        FORCED_BROWSE_PANEL,
        UNKNOWN;

    }
}

