/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.geom.Point2D;
import java.lang.ref.WeakReference;
import sun.awt.AWTAccessor;
import sun.awt.AWTIcon32_security_icon_bw16_png;
import sun.awt.AWTIcon32_security_icon_bw24_png;
import sun.awt.AWTIcon32_security_icon_bw32_png;
import sun.awt.AWTIcon32_security_icon_bw48_png;
import sun.awt.AWTIcon32_security_icon_interim16_png;
import sun.awt.AWTIcon32_security_icon_interim24_png;
import sun.awt.AWTIcon32_security_icon_interim32_png;
import sun.awt.AWTIcon32_security_icon_interim48_png;
import sun.awt.AWTIcon32_security_icon_yellow16_png;
import sun.awt.AWTIcon32_security_icon_yellow24_png;
import sun.awt.AWTIcon32_security_icon_yellow32_png;
import sun.awt.AWTIcon32_security_icon_yellow48_png;
import sun.awt.AWTIcon64_security_icon_bw16_png;
import sun.awt.AWTIcon64_security_icon_bw24_png;
import sun.awt.AWTIcon64_security_icon_bw32_png;
import sun.awt.AWTIcon64_security_icon_bw48_png;
import sun.awt.AWTIcon64_security_icon_interim16_png;
import sun.awt.AWTIcon64_security_icon_interim24_png;
import sun.awt.AWTIcon64_security_icon_interim32_png;
import sun.awt.AWTIcon64_security_icon_interim48_png;
import sun.awt.AWTIcon64_security_icon_yellow16_png;
import sun.awt.AWTIcon64_security_icon_yellow24_png;
import sun.awt.AWTIcon64_security_icon_yellow32_png;
import sun.awt.AWTIcon64_security_icon_yellow48_png;
import sun.awt.IconInfo;
import sun.awt.SunToolkit;
import sun.awt.X11.InfoWindow;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XEvent;
import sun.awt.X11.XExposeEvent;
import sun.awt.X11.XNETProtocol;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XUnmapEvent;
import sun.awt.X11.XWM;
import sun.awt.X11.XWMHints;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibWrapper;

class XWarningWindow
extends XWindow {
    private static final int SHOWING_DELAY = 330;
    private static final int HIDING_DELAY = 2000;
    private final Window ownerWindow;
    private WeakReference<XWindowPeer> ownerPeer;
    private long parentWindow;
    private static final String OWNER = "OWNER";
    private InfoWindow.Tooltip tooltip;
    private volatile int currentIcon = 0;
    private int currentSize = -1;
    private static IconInfo[][] icons;
    private final Runnable hidingTask = new Runnable(){

        @Override
        public void run() {
            XWarningWindow.this.xSetVisible(false);
        }
    };
    private final Runnable showingTask = new Runnable(){

        @Override
        public void run() {
            if (!XWarningWindow.this.isVisible()) {
                XWarningWindow.this.xSetVisible(true);
                XWarningWindow.this.updateIconSize();
                XWindowPeer peer = (XWindowPeer)XWarningWindow.this.ownerPeer.get();
                if (peer != null) {
                    peer.repositionSecurityWarning();
                }
            }
            XWarningWindow.this.repaint();
            if (XWarningWindow.this.currentIcon > 0) {
                XWarningWindow.this.currentIcon--;
                XToolkit.schedule(XWarningWindow.this.showingTask, 330L);
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IconInfo getSecurityIconInfo(int size, int num) {
        Class<XWarningWindow> clazz = XWarningWindow.class;
        synchronized (XWarningWindow.class) {
            if (icons == null) {
                icons = new IconInfo[4][3];
                if (XlibWrapper.dataModel == 32) {
                    XWarningWindow.icons[0][0] = new IconInfo(AWTIcon32_security_icon_bw16_png.security_icon_bw16_png);
                    XWarningWindow.icons[0][1] = new IconInfo(AWTIcon32_security_icon_interim16_png.security_icon_interim16_png);
                    XWarningWindow.icons[0][2] = new IconInfo(AWTIcon32_security_icon_yellow16_png.security_icon_yellow16_png);
                    XWarningWindow.icons[1][0] = new IconInfo(AWTIcon32_security_icon_bw24_png.security_icon_bw24_png);
                    XWarningWindow.icons[1][1] = new IconInfo(AWTIcon32_security_icon_interim24_png.security_icon_interim24_png);
                    XWarningWindow.icons[1][2] = new IconInfo(AWTIcon32_security_icon_yellow24_png.security_icon_yellow24_png);
                    XWarningWindow.icons[2][0] = new IconInfo(AWTIcon32_security_icon_bw32_png.security_icon_bw32_png);
                    XWarningWindow.icons[2][1] = new IconInfo(AWTIcon32_security_icon_interim32_png.security_icon_interim32_png);
                    XWarningWindow.icons[2][2] = new IconInfo(AWTIcon32_security_icon_yellow32_png.security_icon_yellow32_png);
                    XWarningWindow.icons[3][0] = new IconInfo(AWTIcon32_security_icon_bw48_png.security_icon_bw48_png);
                    XWarningWindow.icons[3][1] = new IconInfo(AWTIcon32_security_icon_interim48_png.security_icon_interim48_png);
                    XWarningWindow.icons[3][2] = new IconInfo(AWTIcon32_security_icon_yellow48_png.security_icon_yellow48_png);
                } else {
                    XWarningWindow.icons[0][0] = new IconInfo(AWTIcon64_security_icon_bw16_png.security_icon_bw16_png);
                    XWarningWindow.icons[0][1] = new IconInfo(AWTIcon64_security_icon_interim16_png.security_icon_interim16_png);
                    XWarningWindow.icons[0][2] = new IconInfo(AWTIcon64_security_icon_yellow16_png.security_icon_yellow16_png);
                    XWarningWindow.icons[1][0] = new IconInfo(AWTIcon64_security_icon_bw24_png.security_icon_bw24_png);
                    XWarningWindow.icons[1][1] = new IconInfo(AWTIcon64_security_icon_interim24_png.security_icon_interim24_png);
                    XWarningWindow.icons[1][2] = new IconInfo(AWTIcon64_security_icon_yellow24_png.security_icon_yellow24_png);
                    XWarningWindow.icons[2][0] = new IconInfo(AWTIcon64_security_icon_bw32_png.security_icon_bw32_png);
                    XWarningWindow.icons[2][1] = new IconInfo(AWTIcon64_security_icon_interim32_png.security_icon_interim32_png);
                    XWarningWindow.icons[2][2] = new IconInfo(AWTIcon64_security_icon_yellow32_png.security_icon_yellow32_png);
                    XWarningWindow.icons[3][0] = new IconInfo(AWTIcon64_security_icon_bw48_png.security_icon_bw48_png);
                    XWarningWindow.icons[3][1] = new IconInfo(AWTIcon64_security_icon_interim48_png.security_icon_interim48_png);
                    XWarningWindow.icons[3][2] = new IconInfo(AWTIcon64_security_icon_yellow48_png.security_icon_yellow48_png);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            int sizeIndex = size % icons.length;
            return icons[sizeIndex][num % icons[sizeIndex].length];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIconSize() {
        int newSize = -1;
        if (this.ownerWindow != null) {
            Insets insets = this.ownerWindow.getInsets();
            int max = Math.max(insets.top, Math.max(insets.bottom, Math.max(insets.left, insets.right)));
            newSize = max < 24 ? 0 : (max < 32 ? 1 : (max < 48 ? 2 : 3));
        }
        if (newSize == -1) {
            newSize = 0;
        }
        XToolkit.awtLock();
        try {
            if (newSize != this.currentSize) {
                this.currentSize = newSize;
                IconInfo ico = XWarningWindow.getSecurityIconInfo(this.currentSize, 0);
                XlibWrapper.SetBitmapShape(XToolkit.getDisplay(), this.getWindow(), ico.getWidth(), ico.getHeight(), ico.getIntData());
                AWTAccessor.getWindowAccessor().setSecurityWarningSize(this.ownerWindow, ico.getWidth(), ico.getHeight());
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    private IconInfo getSecurityIconInfo() {
        this.updateIconSize();
        return XWarningWindow.getSecurityIconInfo(this.currentSize, this.currentIcon);
    }

    XWarningWindow(Window ownerWindow, long parentWindow, XWindowPeer ownerPeer) {
        super(new XCreateWindowParams(new Object[]{"target", ownerWindow, OWNER, parentWindow}));
        this.ownerWindow = ownerWindow;
        this.parentWindow = parentWindow;
        this.tooltip = new InfoWindow.Tooltip(null, this.getTarget(), new InfoWindow.Tooltip.LiveArguments(){

            @Override
            public boolean isDisposed() {
                return XWarningWindow.this.isDisposed();
            }

            @Override
            public Rectangle getBounds() {
                return XWarningWindow.this.getBounds();
            }

            @Override
            public String getTooltipString() {
                return XWarningWindow.this.ownerWindow.getWarningString();
            }
        });
        this.ownerPeer = new WeakReference<XWindowPeer>(ownerPeer);
    }

    private void requestNoTaskbar() {
        XNETProtocol netProtocol = XWM.getWM().getNETProtocol();
        if (netProtocol != null) {
            netProtocol.requestState(this, netProtocol.XA_NET_WM_STATE_SKIP_TASKBAR, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void postInit(XCreateWindowParams params) {
        super.postInit(params);
        XToolkit.awtLock();
        try {
            XWM.setMotifDecor(this, false, 0, 0);
            XWM.setOLDecor(this, false, 0);
            long parentWindow = (Long)params.get(OWNER);
            XlibWrapper.XSetTransientFor(XToolkit.getDisplay(), this.getWindow(), parentWindow);
            XWMHints hints = this.getWMHints();
            hints.set_flags(hints.get_flags() | 1L | 2L);
            hints.set_input(false);
            hints.set_initial_state(1);
            XlibWrapper.XSetWMHints(XToolkit.getDisplay(), this.getWindow(), hints.pData);
            this.initWMProtocols();
            this.requestNoTaskbar();
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public void reposition(int x, int y, int w, int h) {
        Point2D point = AWTAccessor.getWindowAccessor().calculateSecurityWarningPosition(this.ownerWindow, x, y, w, h);
        this.reshape((int)point.getX(), (int)point.getY(), this.getWidth(), this.getHeight());
    }

    @Override
    protected String getWMName() {
        return "Warning window";
    }

    @Override
    public Graphics getGraphics() {
        if (this.surfaceData == null || this.ownerWindow == null) {
            return null;
        }
        return this.getGraphics(this.surfaceData, this.getColor(), this.getBackground(), this.getFont());
    }

    void paint(Graphics g, int x, int y, int width, int height) {
        g.drawImage(this.getSecurityIconInfo().getImage(), 0, 0, null);
    }

    String getWarningString() {
        return this.ownerWindow.getWarningString();
    }

    @Override
    int getWidth() {
        return this.getSecurityIconInfo().getWidth();
    }

    @Override
    int getHeight() {
        return this.getSecurityIconInfo().getHeight();
    }

    Color getBackground() {
        return SystemColor.window;
    }

    Color getColor() {
        return Color.black;
    }

    Font getFont() {
        return this.ownerWindow.getFont();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void repaint() {
        Rectangle bounds = this.getBounds();
        Graphics g = this.getGraphics();
        try {
            this.paint(g, 0, 0, bounds.width, bounds.height);
        }
        finally {
            g.dispose();
        }
    }

    @Override
    public void handleExposeEvent(XEvent xev) {
        super.handleExposeEvent(xev);
        XExposeEvent xe = xev.get_xexpose();
        final int x = xe.get_x();
        final int y = xe.get_y();
        final int width = xe.get_width();
        final int height = xe.get_height();
        SunToolkit.executeOnEventHandlerThread(this.target, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Graphics g = XWarningWindow.this.getGraphics();
                try {
                    XWarningWindow.this.paint(g, x, y, width, height);
                }
                finally {
                    g.dispose();
                }
            }
        });
    }

    @Override
    protected boolean isEventDisabled(XEvent e) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withdraw() {
        XEvent req = new XEvent();
        try {
            long root;
            XToolkit.awtLock();
            try {
                root = XlibWrapper.RootWindow(XToolkit.getDisplay(), this.getScreenNumber());
            }
            finally {
                XToolkit.awtUnlock();
            }
            req.set_type(18);
            XUnmapEvent umev = req.get_xunmap();
            umev.set_event(root);
            umev.set_window(this.getWindow());
            umev.set_from_configure(false);
            XToolkit.awtLock();
            try {
                XlibWrapper.XSendEvent(XToolkit.getDisplay(), root, false, 0x180000L, req.pData);
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        finally {
            req.dispose();
        }
    }

    @Override
    protected void stateChanged(long time, int oldState, int newState) {
        if (newState == 3) {
            super.xSetVisible(false);
            this.withdraw();
        }
    }

    @Override
    protected void setMouseAbove(boolean above) {
        super.setMouseAbove(above);
        XWindowPeer p = (XWindowPeer)this.ownerPeer.get();
        if (p != null) {
            p.updateSecurityWarningVisibility();
        }
    }

    @Override
    protected void enterNotify(long window) {
        super.enterNotify(window);
        if (window == this.getWindow()) {
            this.tooltip.enter();
        }
    }

    @Override
    protected void leaveNotify(long window) {
        super.leaveNotify(window);
        if (window == this.getWindow()) {
            this.tooltip.exit();
        }
    }

    @Override
    public void xSetVisible(boolean visible) {
        super.xSetVisible(visible);
        this.requestNoTaskbar();
    }

    public void setSecurityWarningVisible(boolean visible, boolean doSchedule) {
        if (visible) {
            XToolkit.remove(this.hidingTask);
            XToolkit.remove(this.showingTask);
            this.currentIcon = this.isVisible() ? 0 : 3;
            if (doSchedule) {
                XToolkit.schedule(this.showingTask, 1L);
            } else {
                this.showingTask.run();
            }
        } else {
            XToolkit.remove(this.showingTask);
            XToolkit.remove(this.hidingTask);
            if (!this.isVisible()) {
                return;
            }
            if (doSchedule) {
                XToolkit.schedule(this.hidingTask, 2000L);
            } else {
                this.hidingTask.run();
            }
        }
    }
}

