/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import org.jfree.layouting.input.style.keys.border.BorderStyle;
import org.jfree.layouting.renderer.border.Border;
import org.jfree.layouting.renderer.border.BorderEdge;
import org.jfree.layouting.renderer.border.RenderLength;
import org.jfree.layouting.renderer.model.BoxDefinition;
import org.jfree.layouting.renderer.model.ComputedLayoutProperties;
import org.jfree.layouting.renderer.model.ParagraphRenderBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.model.table.TableCellRenderBox;
import org.jfree.layouting.renderer.model.table.TableRenderBox;
import org.jfree.layouting.renderer.model.table.TableRowRenderBox;
import org.jfree.layouting.renderer.model.table.TableSectionRenderBox;
import org.jfree.layouting.renderer.model.table.cols.TableColumn;
import org.jfree.layouting.renderer.model.table.cols.TableColumnModel;
import org.jfree.layouting.renderer.process.IterateVisualProcessStep;

public class ComputeStaticPropertiesStep
extends IterateVisualProcessStep {
    private LogicalPageBox root;

    public void compute(LogicalPageBox logicalPageBox) {
        this.root = logicalPageBox;
        this.startProcessing(logicalPageBox);
        this.root = null;
    }

    protected void processParagraphChilds(ParagraphRenderBox paragraphRenderBox) {
        this.startProcessing(paragraphRenderBox.getPool());
    }

    protected boolean startBlockLevelBox(RenderBox renderBox) {
        if (renderBox.getComputedLayoutProperties() != null) {
            return true;
        }
        RenderLength renderLength = this.computeBlockContextWidth(renderBox);
        long l = renderLength.resolve(0L);
        BoxDefinition boxDefinition = renderBox.getBoxDefinition();
        ComputedLayoutProperties computedLayoutProperties = new ComputedLayoutProperties();
        if (renderBox instanceof TableCellRenderBox) {
            this.computeBorder(boxDefinition, computedLayoutProperties, l);
            RenderLength renderLength2 = boxDefinition.getPreferredWidth();
            if (renderLength2 == RenderLength.AUTO) {
                TableCellRenderBox tableCellRenderBox = (TableCellRenderBox)renderBox;
                TableColumnModel tableColumnModel = tableCellRenderBox.getTable().getColumnModel();
                int n = tableCellRenderBox.getColumnIndex();
                if (n < 0) {
                    throw new IllegalStateException("Table has not been validated yet.");
                }
                int n2 = n + tableCellRenderBox.getColSpan();
                if (n2 >= tableColumnModel.getColumnCount()) {
                    computedLayoutProperties.setBlockContextWidth(renderLength);
                    computedLayoutProperties.setComputedWidth(RenderLength.AUTO);
                    renderBox.setComputedLayoutProperties(computedLayoutProperties);
                } else {
                    long l2 = 0L;
                    for (int i = n; i < n2; ++i) {
                        TableColumn tableColumn = tableColumnModel.getColumn(i);
                        RenderLength renderLength3 = tableColumn.getDefinedWidth();
                        if (renderLength3 == RenderLength.AUTO) {
                            l2 = -1L;
                            break;
                        }
                        l2 += renderLength3.resolve(l);
                    }
                    if (l2 > 0L) {
                        computedLayoutProperties.setBlockContextWidth(renderLength);
                        computedLayoutProperties.setComputedWidth(new RenderLength(l2, false));
                        renderBox.setComputedLayoutProperties(computedLayoutProperties);
                    } else {
                        computedLayoutProperties.setBlockContextWidth(renderLength);
                        computedLayoutProperties.setComputedWidth(RenderLength.AUTO);
                        renderBox.setComputedLayoutProperties(computedLayoutProperties);
                    }
                }
            } else {
                computedLayoutProperties.setBlockContextWidth(renderLength);
                computedLayoutProperties.setComputedWidth(renderLength2.resolveToRenderLength(l));
                renderBox.setComputedLayoutProperties(computedLayoutProperties);
            }
            return true;
        }
        if (renderBox instanceof TableRowRenderBox || renderBox instanceof TableSectionRenderBox) {
            computedLayoutProperties.setBlockContextWidth(renderLength);
            computedLayoutProperties.setComputedWidth(renderLength);
            renderBox.setComputedLayoutProperties(computedLayoutProperties);
            return true;
        }
        this.computeBorder(boxDefinition, computedLayoutProperties, l);
        computedLayoutProperties.setMarginTop(boxDefinition.getMarginTop().resolve(l));
        computedLayoutProperties.setMarginBottom(boxDefinition.getMarginBottom().resolve(l));
        RenderLength renderLength4 = boxDefinition.getMarginLeft();
        RenderLength renderLength5 = boxDefinition.getMarginRight();
        RenderLength renderLength6 = boxDefinition.getPreferredWidth();
        if (renderLength6 != RenderLength.AUTO) {
            if (renderLength4 != RenderLength.AUTO && renderLength5 != RenderLength.AUTO) {
                long l3;
                long l4;
                long l5 = renderLength4.resolve(l);
                if (l5 + (l4 = renderLength5.resolve(l)) + (l3 = renderLength6.resolve(l)) == l) {
                    computedLayoutProperties.setMarginLeft(l5);
                    computedLayoutProperties.setMarginRight(l4);
                } else if (renderBox.isDirectionLTR()) {
                    computedLayoutProperties.setMarginLeft(l5);
                    computedLayoutProperties.setMarginRight(l - l5 - l3);
                } else {
                    computedLayoutProperties.setMarginLeft(l - l4 - l3);
                    computedLayoutProperties.setMarginRight(l4);
                }
                computedLayoutProperties.setBlockContextWidth(renderLength);
                computedLayoutProperties.setComputedWidth(new RenderLength(l3, false));
                renderBox.setComputedLayoutProperties(computedLayoutProperties);
                return true;
            }
            if (renderLength4 == RenderLength.AUTO && renderLength5 != RenderLength.AUTO) {
                long l6 = renderLength5.resolve(l);
                long l7 = renderLength6.resolve(l);
                computedLayoutProperties.setMarginLeft(l - l6 - l7);
                computedLayoutProperties.setMarginRight(l6);
                computedLayoutProperties.setBlockContextWidth(renderLength);
                computedLayoutProperties.setComputedWidth(new RenderLength(l7, false));
                renderBox.setComputedLayoutProperties(computedLayoutProperties);
                return true;
            }
            if (renderLength4 != RenderLength.AUTO && renderLength5 == RenderLength.AUTO) {
                long l8 = renderLength4.resolve(l);
                long l9 = renderLength6.resolve(l);
                computedLayoutProperties.setMarginLeft(l8);
                computedLayoutProperties.setMarginRight(l - l8 - l9);
                computedLayoutProperties.setBlockContextWidth(renderLength);
                computedLayoutProperties.setComputedWidth(new RenderLength(l9, false));
                renderBox.setComputedLayoutProperties(computedLayoutProperties);
                return true;
            }
        } else {
            long l10 = renderLength4.resolve(l);
            long l11 = renderLength5.resolve(l);
            computedLayoutProperties.setMarginLeft(l10);
            computedLayoutProperties.setMarginRight(l11);
            if (renderBox instanceof TableRenderBox) {
                computedLayoutProperties.setBlockContextWidth(renderLength);
                computedLayoutProperties.setComputedWidth(RenderLength.AUTO);
                renderBox.setComputedLayoutProperties(computedLayoutProperties);
            } else if (renderLength == RenderLength.AUTO) {
                computedLayoutProperties.setBlockContextWidth(renderLength);
                computedLayoutProperties.setComputedWidth(RenderLength.AUTO);
                renderBox.setComputedLayoutProperties(computedLayoutProperties);
            } else {
                computedLayoutProperties.setBlockContextWidth(renderLength);
                computedLayoutProperties.setComputedWidth(new RenderLength(l - l10 - l11, false));
                renderBox.setComputedLayoutProperties(computedLayoutProperties);
            }
            return true;
        }
        long l12 = renderLength6.resolve(l);
        long l13 = l - l12;
        long l14 = l13 / 2L;
        computedLayoutProperties.setMarginLeft(l14);
        computedLayoutProperties.setMarginRight(l13 - l14);
        computedLayoutProperties.setBlockContextWidth(renderLength);
        computedLayoutProperties.setComputedWidth(new RenderLength(l12, false));
        renderBox.setComputedLayoutProperties(computedLayoutProperties);
        return true;
    }

    protected void processBlockLevelNode(RenderNode renderNode) {
        RenderLength renderLength = this.computeBlockContextWidth(renderNode);
        ComputedLayoutProperties computedLayoutProperties = new ComputedLayoutProperties();
        computedLayoutProperties.setBlockContextWidth(renderLength);
        computedLayoutProperties.setComputedWidth(RenderLength.AUTO);
        renderNode.setComputedLayoutProperties(computedLayoutProperties);
    }

    protected boolean startInlineLevelBox(RenderBox renderBox) {
        if (renderBox.getComputedLayoutProperties() != null) {
            return true;
        }
        RenderLength renderLength = this.computeBlockContextWidth(renderBox);
        long l = renderLength.resolve(0L);
        BoxDefinition boxDefinition = renderBox.getBoxDefinition();
        ComputedLayoutProperties computedLayoutProperties = new ComputedLayoutProperties();
        this.computeBorder(boxDefinition, computedLayoutProperties, l);
        computedLayoutProperties.setMarginTop(0L);
        computedLayoutProperties.setMarginBottom(0L);
        computedLayoutProperties.setMarginLeft(boxDefinition.getMarginLeft().resolve(l));
        computedLayoutProperties.setMarginRight(boxDefinition.getMarginRight().resolve(l));
        computedLayoutProperties.setBlockContextWidth(renderLength);
        computedLayoutProperties.setComputedWidth(RenderLength.AUTO);
        renderBox.setComputedLayoutProperties(computedLayoutProperties);
        return true;
    }

    protected void processInlineLevelNode(RenderNode renderNode) {
        if (renderNode.getComputedLayoutProperties() != null) {
            return;
        }
        RenderLength renderLength = this.computeBlockContextWidth(renderNode);
        ComputedLayoutProperties computedLayoutProperties = new ComputedLayoutProperties();
        computedLayoutProperties.setBlockContextWidth(renderLength);
        computedLayoutProperties.setComputedWidth(RenderLength.AUTO);
        renderNode.setComputedLayoutProperties(computedLayoutProperties);
    }

    private void computeBorder(BoxDefinition boxDefinition, ComputedLayoutProperties computedLayoutProperties, long l) {
        Border border = boxDefinition.getBorder();
        computedLayoutProperties.setBorderTop(this.resolveBorderEdge(l, border.getTop()));
        computedLayoutProperties.setBorderLeft(this.resolveBorderEdge(l, border.getLeft()));
        computedLayoutProperties.setBorderBottom(this.resolveBorderEdge(l, border.getBottom()));
        computedLayoutProperties.setBorderRight(this.resolveBorderEdge(l, border.getRight()));
        computedLayoutProperties.setPaddingTop(boxDefinition.getPaddingTop().resolve(l));
        computedLayoutProperties.setPaddingLeft(boxDefinition.getPaddingLeft().resolve(l));
        computedLayoutProperties.setPaddingBottom(boxDefinition.getPaddingBottom().resolve(l));
        computedLayoutProperties.setPaddingRight(boxDefinition.getPaddingRight().resolve(l));
    }

    protected RenderLength computeBlockContextWidth(RenderNode renderNode) {
        RenderBox renderBox = renderNode.getParentBlockContext();
        if (renderBox == null) {
            return new RenderLength(this.root.getPageWidth(), false);
        }
        ComputedLayoutProperties computedLayoutProperties = renderBox.getComputedLayoutProperties();
        return computedLayoutProperties.getComputedWidth();
    }

    private long resolveBorderEdge(long l, BorderEdge borderEdge) {
        if (BorderStyle.NONE.equals(borderEdge.getBorderStyle())) {
            return 0L;
        }
        return borderEdge.getWidth().resolve(l);
    }
}

