// -*- c++ -*-
// Generated by gmmproc 2.42.0 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_MEMORY_H
#define _GSTREAMERMM_MEMORY_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gst.h>
#include <gstreamermm/miniobject.h>


namespace Gst
{

/** @addtogroup gstreamermmEnums gstreamermm Enums and Flags */

/** 
 *  @var MemoryFlags MEMORY_FLAG_READONLY
 *  Memory is readonly. It is not allowed to map the memory with Gst::MAP_WRITE.
 * 
 *  @var MemoryFlags MEMORY_FLAG_NO_SHARE
 *  Memory must not be shared. Copies will have to be made when this memory needs to be shared between buffers.
 * 
 *  @var MemoryFlags MEMORY_FLAG_ZERO_PREFIXED
 *  The memory prefix is filled with 0 bytes.
 * 
 *  @var MemoryFlags MEMORY_FLAG_ZERO_PADDED
 *  The memory padding is filled with 0 bytes.
 * 
 *  @var MemoryFlags MEMORY_FLAG_PHYSICALLY_CONTIGUOUS
 *  The memory is physically contiguous. Since 1.2.
 * 
 *  @var MemoryFlags MEMORY_FLAG_NOT_MAPPABLE
 *  The memory can't be mapped via gst_memory_map() without any preconditions. Since 1.2.
 * 
 *  @var MemoryFlags MEMORY_FLAG_LAST
 *  First flag that can be used for custom purposes.
 * 
 *  @enum MemoryFlags
 * 
 * Flags for wrapped memory.
 * @ingroup gstreamermmEnums
 * @par Bitwise operators:
 * <tt>%MemoryFlags operator|(MemoryFlags, MemoryFlags)</tt><br>
 * <tt>%MemoryFlags operator&(MemoryFlags, MemoryFlags)</tt><br>
 * <tt>%MemoryFlags operator^(MemoryFlags, MemoryFlags)</tt><br>
 * <tt>%MemoryFlags operator~(MemoryFlags)</tt><br>
 * <tt>%MemoryFlags& operator|=(MemoryFlags&, MemoryFlags)</tt><br>
 * <tt>%MemoryFlags& operator&=(MemoryFlags&, MemoryFlags)</tt><br>
 * <tt>%MemoryFlags& operator^=(MemoryFlags&, MemoryFlags)</tt><br>
 */
enum MemoryFlags
{
  MEMORY_FLAG_READONLY = GST_MINI_OBJECT_FLAG_LOCK_READONLY,
  MEMORY_FLAG_NO_SHARE = (GST_MINI_OBJECT_FLAG_LAST << 0),
  MEMORY_FLAG_ZERO_PREFIXED = (GST_MINI_OBJECT_FLAG_LAST << 1),
  MEMORY_FLAG_ZERO_PADDED = (GST_MINI_OBJECT_FLAG_LAST << 2),
  MEMORY_FLAG_PHYSICALLY_CONTIGUOUS = (GST_MINI_OBJECT_FLAG_LAST << 3),
  MEMORY_FLAG_NOT_MAPPABLE = (GST_MINI_OBJECT_FLAG_LAST << 4),
  MEMORY_FLAG_LAST = (GST_MINI_OBJECT_FLAG_LAST << 16)
};

/** @ingroup gstreamermmEnums */
inline MemoryFlags operator|(MemoryFlags lhs, MemoryFlags rhs)
  { return static_cast<MemoryFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline MemoryFlags operator&(MemoryFlags lhs, MemoryFlags rhs)
  { return static_cast<MemoryFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline MemoryFlags operator^(MemoryFlags lhs, MemoryFlags rhs)
  { return static_cast<MemoryFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline MemoryFlags operator~(MemoryFlags flags)
  { return static_cast<MemoryFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gstreamermmEnums */
inline MemoryFlags& operator|=(MemoryFlags& lhs, MemoryFlags rhs)
  { return (lhs = static_cast<MemoryFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline MemoryFlags& operator&=(MemoryFlags& lhs, MemoryFlags rhs)
  { return (lhs = static_cast<MemoryFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline MemoryFlags& operator^=(MemoryFlags& lhs, MemoryFlags rhs)
  { return (lhs = static_cast<MemoryFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gst


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::MemoryFlags> : public Glib::Value_Flags<Gst::MemoryFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{


/**
 * GstMemory is a lightweight refcounted object that wraps a region of memory.
 * They are typically used to manage the data of a #GstBuffer.
 *
 * A GstMemory object has an allocated region of memory of maxsize. The maximum
 * size does not change during the lifetime of the memory object. The memory
 * also has an offset and size property that specifies the valid range of memory
 * in the allocated region.
 *
 */
class Memory : public MiniObject
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Memory CppObjectType;
  typedef GstMemory BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Increment the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void reference()   const;

  /** Decrement the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void unreference() const;

  ///Provides access to the underlying C instance.
  GstMemory*       gobj();

  ///Provides access to the underlying C instance.
  const GstMemory* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstMemory* gobj_copy() const;

protected:
  // Do not derive this.  Gst::Memory can neither be constructed nor deleted.
  Memory();
  void operator delete(void*, std::size_t);

private:
  // noncopyable
  Memory(const Memory&);
  Memory& operator=(const Memory&);


public:

  /*
   * Allocate a new memory block that wraps the given @data.
   *
   * @param flags: Gst::MemoryFlags.
   * @param data Data to wrap.
   * @param maxsize Allocated size of @data.
   * @param offset Offset in @data.
   * @param size Size of valid data.
   *
   * @returns a new #Gst::Memory.
   */
  static Glib::RefPtr<Memory> create(Gst::MemoryFlags flags, gpointer data, gsize maxsize, gsize offset, gsize size);

   gsize get_maxsize() const;
    gsize get_align() const;
    gsize get_offset() const;
    gsize get_size() const;
 

};

}//namespace Gst


namespace Glib
{

  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::Memory
   */
  Glib::RefPtr<Gst::Memory> wrap(GstMemory* object, bool take_copy = false);

} // namespace Glib


#endif /* _GSTREAMERMM_MEMORY_H */

