/*
 *   Copyright 2015 Marco Martin <mart@kde.org>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License as
 *   published by the Free Software Foundation; either version 2, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU Library General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

import QtQuick 2.0
import QtGraphicalEffects 1.0
import org.kde.kirigami 2.0

Item {
    id: root
    property string source
    property alias smooth: image.smooth
    property bool active: false
    property bool valid: image.status == Image.Ready 
    property bool selected: false

    implicitWidth: image.source != "" ? Units.iconSizes.smallMedium : 0
    implicitHeight: image.source != "" ? Units.iconSizes.smallMedium : 0

    Image {
        id: image
        anchors.fill: parent
        source: root.source != "" ? (root.source.indexOf(".") === -1 ? "./icons/" + root.source + ".svg" : root.source) : root.source
        sourceSize.width: root.width
        sourceSize.height: root.height
    }
    ColorOverlay {

        anchors.fill: parent
        source: image
        color: Theme.highlightedTextColor
        cached: true
        visible: root.selected && root.valid
    }
}
