/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.computed.box;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.box.BoxStyleKeys;
import org.jfree.layouting.input.style.keys.box.DisplayModel;
import org.jfree.layouting.input.style.keys.box.DisplayRole;
import org.jfree.layouting.input.style.keys.box.Floating;
import org.jfree.layouting.input.style.keys.positioning.PositioningStyleKeys;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.resolver.computed.ConstantsResolveHandler;

public class FloatResolveHandler
extends ConstantsResolveHandler {
    public FloatResolveHandler() {
        this.addNormalizeValue(Floating.BOTTOM);
        this.addNormalizeValue(Floating.LEFT);
        this.addNormalizeValue(Floating.END);
        this.addNormalizeValue(Floating.INSIDE);
        this.addNormalizeValue(Floating.IN_COLUMN);
        this.addNormalizeValue(Floating.MID_COLUMN);
        this.addNormalizeValue(Floating.NONE);
        this.addNormalizeValue(Floating.OUTSIDE);
        this.addNormalizeValue(Floating.RIGHT);
        this.addNormalizeValue(Floating.START);
        this.addNormalizeValue(Floating.TOP);
        this.setFallback(Floating.NONE);
    }

    public StyleKey[] getRequiredStyles() {
        return new StyleKey[]{BoxStyleKeys.DISPLAY_ROLE, PositioningStyleKeys.POSITION};
    }

    public void resolve(LayoutProcess layoutProcess, LayoutElement layoutElement, StyleKey styleKey) {
        LayoutContext layoutContext = layoutElement.getLayoutContext();
        CSSValue cSSValue = layoutContext.getValue(BoxStyleKeys.DISPLAY_ROLE);
        CSSValue cSSValue2 = DisplayRole.NONE.equals(cSSValue) ? Floating.NONE : this.resolveValue(layoutProcess, layoutElement, styleKey);
        if (!Floating.NONE.equals(cSSValue2)) {
            layoutContext.setValue(BoxStyleKeys.DISPLAY_MODEL, DisplayModel.BLOCK_INSIDE);
            layoutContext.setValue(BoxStyleKeys.DISPLAY_ROLE, DisplayRole.BLOCK);
        }
        layoutContext.setValue(styleKey, Floating.NONE);
    }
}

