/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.server.ThreadInfo;
import org.netbeans.lib.profiler.server.system.Timers;

abstract class SamplingThread
extends Thread {
    private static final boolean isSolaris = Platform.isSolaris();
    private static final boolean isLinux = Platform.isLinux();
    private static final boolean isUnix = isSolaris || isLinux;
    private static final int VIOLATION_THRESHOLD = 10;
    private static final boolean DEBUG = false;
    private volatile boolean terminated;
    private int count;
    private int samplingInterval;

    SamplingThread(int n) {
        ThreadInfo.addProfilerServerThread(this);
        this.setPriority(10);
        this.setDaemon(true);
        this.samplingInterval = n;
        if (isSolaris) {
            this.samplingInterval *= 1000000;
        } else if (isLinux) {
            this.samplingInterval *= 1000;
        }
    }

    public void run() {
        int n = this.samplingInterval;
        int n2 = this.samplingInterval * 5 / 4;
        int n3 = this.samplingInterval / 10;
        int n4 = 10;
        long l = Timers.getCurrentTimeInCounts();
        while (!this.terminated) {
            if (!isUnix) {
                try {
                    Thread.sleep(this.samplingInterval);
                }
                catch (InterruptedException interruptedException) {}
            } else {
                long l2 = Timers.getCurrentTimeInCounts();
                Timers.osSleep((int)n);
                l2 = Timers.getCurrentTimeInCounts() - l2;
                if (l2 > (long)n2 && n > n3) {
                    if (n4 > 0) {
                        --n4;
                    } else {
                        n = n * 95 / 100;
                        n4 = 10;
                    }
                }
            }
            this.sample();
        }
    }

    abstract void sample();

    void terminate() {
        this.terminated = true;
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

