/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.host.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ping {
    static int RMIREGISTRY_PORT = 1099;
    int port = RMIREGISTRY_PORT;
    List<InetAddress> foundHosts;

    public List<InetAddress> getActiveHosts() throws InterruptedException, IOException {
        this.port = RMIREGISTRY_PORT;
        InetAddress localAdd = InetAddress.getLocalHost();
        byte[] addr = localAdd.getAddress();
        this.foundHosts = new ArrayList<InetAddress>();
        Connector connector = new Connector();
        connector.start();
        for (int i = 1; i < 255; ++i) {
            addr[addr.length - 1] = (byte)i;
            Target t = new Target(InetAddress.getByAddress(addr), this.port);
            connector.add(t);
        }
        Thread.sleep(2000L);
        connector.shutdown();
        connector.join();
        this.foundHosts.remove(localAdd);
        return this.foundHosts;
    }

    static class Connector
    extends Thread {
        Selector sel;
        LinkedList pending = new LinkedList();
        volatile boolean shutdown = false;

        Connector() throws IOException {
            this.sel = Selector.open();
            this.setName("Connector");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(Target t) {
            SocketChannel sc = null;
            try {
                sc = SocketChannel.open();
                sc.configureBlocking(false);
                sc.connect(t.address);
                t.channel = sc;
                t.connectStart = System.currentTimeMillis();
                LinkedList linkedList = this.pending;
                synchronized (linkedList) {
                    this.pending.add(t);
                }
                this.sel.wakeup();
            }
            catch (IOException x) {
                if (sc != null) {
                    try {
                        sc.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                t.failure = true;
                t.done();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void processPendingTargets() throws IOException {
            LinkedList linkedList = this.pending;
            synchronized (linkedList) {
                while (this.pending.size() > 0) {
                    Target t = (Target)this.pending.removeFirst();
                    try {
                        t.channel.register(this.sel, 8, t);
                    }
                    catch (IOException x) {
                        t.channel.close();
                        t.failure = true;
                        t.done();
                    }
                }
                return;
            }
        }

        void processSelectedKeys() throws IOException {
            Iterator<SelectionKey> i = this.sel.selectedKeys().iterator();
            while (i.hasNext()) {
                SelectionKey sk = i.next();
                i.remove();
                Target t = (Target)sk.attachment();
                SocketChannel sc = (SocketChannel)sk.channel();
                try {
                    if (!sc.finishConnect()) continue;
                    sk.cancel();
                    t.connectFinish = System.currentTimeMillis();
                    sc.close();
                    t.done();
                }
                catch (IOException x) {
                    sc.close();
                    t.failure = true;
                    t.done();
                }
            }
        }

        void shutdown() {
            this.shutdown = true;
            this.sel.wakeup();
        }

        public void run() {
            while (true) {
                try {
                    do {
                        int n;
                        if ((n = this.sel.select()) > 0) {
                            this.processSelectedKeys();
                        }
                        this.processPendingTargets();
                    } while (!this.shutdown);
                    this.sel.close();
                    return;
                }
                catch (IOException x) {
                    x.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    class Target {
        InetSocketAddress address;
        SocketChannel channel;
        boolean failure;
        long connectStart;
        long connectFinish = 0L;
        Boolean status;

        Target(InetAddress host, int port) {
            this.address = new InetSocketAddress(host, port);
        }

        private void done() {
            this.status = this.connectFinish != 0L;
            if (this.status.booleanValue()) {
                Ping.this.foundHosts.add(this.address.getAddress());
            }
        }

        private void status() {
            if (this.status == null) {
                System.out.println("Status: " + this.address.getAddress().getHostAddress() + " no status");
            } else {
                System.out.println("Status: " + this.address.getHostName() + " " + this.status);
            }
        }
    }
}

