/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.xerces.impl.xs.SchemaGrammar;

public class XSGrammarBucket {
    private Hashtable fGrammarRegistry = new Hashtable();
    private SchemaGrammar fNoNSGrammar = null;

    public SchemaGrammar getGrammar(String string) {
        if (string == null) {
            return this.fNoNSGrammar;
        }
        return (SchemaGrammar)this.fGrammarRegistry.get(string);
    }

    public void putGrammar(SchemaGrammar schemaGrammar) {
        if (schemaGrammar.getTargetNamespace() == null) {
            this.fNoNSGrammar = schemaGrammar;
        } else {
            this.fGrammarRegistry.put(schemaGrammar.getTargetNamespace(), schemaGrammar);
        }
    }

    public void putGrammar(String string, SchemaGrammar schemaGrammar) {
        if (string == null) {
            this.fNoNSGrammar = schemaGrammar;
        } else {
            this.fGrammarRegistry.put(string, schemaGrammar);
        }
    }

    public SchemaGrammar[] getGrammars() {
        int n = this.fGrammarRegistry.size() + (this.fNoNSGrammar == null ? 0 : 1);
        SchemaGrammar[] schemaGrammarArray = new SchemaGrammar[n];
        Enumeration enumeration = this.fGrammarRegistry.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            schemaGrammarArray[n2++] = (SchemaGrammar)enumeration.nextElement();
        }
        if (this.fNoNSGrammar != null) {
            schemaGrammarArray[n - 1] = this.fNoNSGrammar;
        }
        return schemaGrammarArray;
    }

    public void reset() {
        this.fNoNSGrammar = null;
        this.fGrammarRegistry.clear();
    }
}

