/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.parosproxy.paros.core.scanner.VariantAbstractRPCQuery;

public class VariantXMLQuery
extends VariantAbstractRPCQuery {
    public static final String XML_CONTENT_TYPE = "text/xml";
    public static final String XML_APP_CONTENT_TYPE = "application/xml";
    public static final String SOAP2_CONTENT_TYPE = "application/soap+xml";
    private static final String attRegex = "(\\S+)\\s*=\\s*((?:\"[^\"\\&\\<]*\")|(?:'[^'\\&\\<]*'))";
    private static final String tagRegex = "\\<([\\_\\:A-Za-z][\\_\\:A-Za-z0-9\\-\\.]*)\\s*[^\\>]*\\>((?:\\<\\!\\[CDATA\\[(?:.(?<!\\]\\]>))*\\]\\]>)|(?:[^\\<\\&]*))\\<\\/[\\_\\:A-Za-z][\\_\\:A-Za-z0-9\\-\\.]*\\s*\\>";
    private Pattern attPattern = Pattern.compile("(\\S+)\\s*=\\s*((?:\"[^\"\\&\\<]*\")|(?:'[^'\\&\\<]*'))");
    private Pattern tagPattern = Pattern.compile("\\<([\\_\\:A-Za-z][\\_\\:A-Za-z0-9\\-\\.]*)\\s*[^\\>]*\\>((?:\\<\\!\\[CDATA\\[(?:.(?<!\\]\\]>))*\\]\\]>)|(?:[^\\<\\&]*))\\<\\/[\\_\\:A-Za-z][\\_\\:A-Za-z0-9\\-\\.]*\\s*\\>");

    @Override
    public boolean isValidContentType(String string) {
        return string.startsWith(XML_CONTENT_TYPE) || string.startsWith(SOAP2_CONTENT_TYPE) || string.startsWith(XML_APP_CONTENT_TYPE);
    }

    @Override
    public String getEscapedValue(String string, boolean bl) {
        return StringEscapeUtils.escapeXml((String)string);
    }

    @Override
    public String getUnescapedValue(String string) {
        return StringEscapeUtils.unescapeXml((String)string);
    }

    @Override
    public void parseContent(String string) {
        int n;
        int n2;
        Matcher matcher = this.attPattern.matcher(string);
        while (matcher.find()) {
            n2 = matcher.start(2) + 1;
            n = matcher.end(2) - 1;
            this.addParameter(matcher.group(1), n2, n, false, false);
        }
        matcher = this.tagPattern.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group(2);
            n2 = matcher.start(2);
            n = matcher.end(2);
            string2 = string2.startsWith("<![CDATA[") && string2.endsWith("]]>") ? string2.substring(9, string2.length() - 3) : this.getUnescapedValue(string2);
            this.addParameter(matcher.group(1), n2, n, false, string2);
        }
    }
}

