/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.network;

import org.zaproxy.zap.network.DefaultHttpRedirectionValidator;
import org.zaproxy.zap.network.HttpRedirectionValidator;

public class HttpRequestConfig {
    private final boolean followRedirects;
    private final HttpRedirectionValidator redirectionValidator;

    HttpRequestConfig(boolean bl, HttpRedirectionValidator httpRedirectionValidator) {
        this.followRedirects = bl;
        this.redirectionValidator = httpRedirectionValidator;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public HttpRedirectionValidator getRedirectionValidator() {
        return this.redirectionValidator;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(HttpRequestConfig httpRequestConfig) {
        if (httpRequestConfig == null) {
            throw new IllegalArgumentException("Parameter configuration must not be null.");
        }
        return new Builder(httpRequestConfig);
    }

    public static class Builder {
        private boolean followRedirects;
        private HttpRedirectionValidator redirectionValidator;

        private Builder() {
            this.followRedirects = false;
            this.redirectionValidator = DefaultHttpRedirectionValidator.INSTANCE;
        }

        private Builder(HttpRequestConfig httpRequestConfig) {
            this.followRedirects = httpRequestConfig.isFollowRedirects();
            this.redirectionValidator = httpRequestConfig.getRedirectionValidator();
        }

        public Builder setFollowRedirects(boolean bl) {
            this.followRedirects = bl;
            return this;
        }

        public Builder setRedirectionValidator(HttpRedirectionValidator httpRedirectionValidator) {
            if (httpRedirectionValidator == null) {
                throw new IllegalArgumentException("Parameter redirectionValidator must not be null.");
            }
            this.redirectionValidator = httpRedirectionValidator;
            this.followRedirects = true;
            return this;
        }

        public HttpRequestConfig build() {
            return new HttpRequestConfig(this.followRedirects, this.redirectionValidator);
        }
    }
}

