/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider.filters;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.spider.DomainAlwaysInScopeMatcher;
import org.zaproxy.zap.spider.filters.FetchFilter;

public class DefaultFetchFilter
extends FetchFilter {
    private Set<String> scopes = new LinkedHashSet<String>();
    private List<DomainAlwaysInScopeMatcher> domainsAlwaysInScope = Collections.emptyList();
    private List<String> excludeList = null;
    private Context scanContext;

    @Override
    public FetchFilter.FetchStatus checkFilter(URI uRI) {
        log.debug((Object)("Checking: " + uRI));
        String string = uRI.getScheme();
        if (string == null || !string.equalsIgnoreCase("http") && !string.equalsIgnoreCase("https")) {
            return FetchFilter.FetchStatus.ILLEGAL_PROTOCOL;
        }
        try {
            if (this.scanContext != null) {
                if (!this.scanContext.isInContext(uRI.toString())) {
                    return FetchFilter.FetchStatus.OUT_OF_CONTEXT;
                }
            } else {
                String string2 = uRI.getHost();
                if (!this.isDomainInScope(string2) && !this.isDomainAlwaysInScope(string2)) {
                    return FetchFilter.FetchStatus.OUT_OF_SCOPE;
                }
            }
            if (this.isExcluded(uRI.toString())) {
                return FetchFilter.FetchStatus.USER_RULES;
            }
        }
        catch (URIException uRIException) {
            log.warn((Object)("Error while fetching host for uri: " + uRI), (Throwable)uRIException);
            return FetchFilter.FetchStatus.OUT_OF_SCOPE;
        }
        return FetchFilter.FetchStatus.VALID;
    }

    private boolean isExcluded(String string) {
        if (this.excludeList == null || this.excludeList.isEmpty()) {
            return false;
        }
        for (String string2 : this.excludeList) {
            if (!string.matches(string2)) continue;
            return true;
        }
        return false;
    }

    private boolean isDomainInScope(String string) {
        for (String string2 : this.scopes) {
            if (!string.matches(string2)) continue;
            return true;
        }
        return false;
    }

    private boolean isDomainAlwaysInScope(String string) {
        for (DomainAlwaysInScopeMatcher domainAlwaysInScopeMatcher : this.domainsAlwaysInScope) {
            if (!domainAlwaysInScopeMatcher.matches(string)) continue;
            return true;
        }
        return false;
    }

    public void addScopeRegex(String string) {
        this.scopes.add(string);
    }

    public void setDomainsAlwaysInScope(List<DomainAlwaysInScopeMatcher> list) {
        this.domainsAlwaysInScope = list == null || list.isEmpty() ? Collections.emptyList() : list;
    }

    public void setExcludeRegexes(List<String> list) {
        this.excludeList = list;
    }

    public void setScanContext(Context context) {
        this.scanContext = context;
    }
}

