/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider.parser;

import java.io.ByteArrayInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.htmlparser.jericho.Source;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpStatusCode;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.zaproxy.zap.spider.SpiderParam;
import org.zaproxy.zap.spider.parser.SpiderParser;
import org.zaproxy.zap.utils.XmlUtils;

public class SpiderSitemapXMLParser
extends SpiderParser {
    private Pattern SITEMAP_XML_FILENAME_PATTERN = Pattern.compile("/sitemap\\.xml$");
    private static final Pattern xmlPattern = Pattern.compile("^<\\?xml\\s+version\\s*=\\s*\"[0-9.]+\"\\s+encoding\\s*=\\s*\"[^\"]+\"\\s*\\?>");
    private SpiderParam params;
    private static DocumentBuilder dBuilder;
    private static XPathExpression xpathLocationExpression;

    public SpiderSitemapXMLParser(SpiderParam spiderParam) {
        if (spiderParam == null) {
            throw new IllegalArgumentException("Parameter params must not be null.");
        }
        this.params = spiderParam;
    }

    @Override
    public boolean parseResource(HttpMessage httpMessage, Source source, int n) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Parsing a sitemap.xml resource...");
        }
        if (httpMessage == null || !this.params.isParseSitemapXml() || !httpMessage.getResponseHeader().isXml() || HttpStatusCode.isClientError(httpMessage.getResponseHeader().getStatusCode()) || HttpStatusCode.isServerError(httpMessage.getResponseHeader().getStatusCode())) {
            return false;
        }
        byte[] byArray = httpMessage.getResponseBody().getBytes();
        String string = httpMessage.getRequestHeader().getURI().toString();
        Matcher matcher = xmlPattern.matcher(new String(byArray));
        if (matcher.find()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"The format matches XML");
            }
            try {
                Document document = dBuilder.parse(new InputSource(new ByteArrayInputStream(byArray)));
                NodeList nodeList = (NodeList)xpathLocationExpression.evaluate(document, XPathConstants.NODESET);
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    this.processURL(httpMessage, n, nodeList.item(i).getNodeValue(), string);
                }
            }
            catch (Exception exception) {
                log.error((Object)"An error occurred trying to parse sitemap.xml", (Throwable)exception);
                return false;
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("The content of the response from '" + string + "' does not match the expected content for a sitemap.xml file. Ignoring it."));
        }
        return false;
    }

    @Override
    public boolean canParseResource(HttpMessage httpMessage, String string, boolean bl) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("canParseResource called on '" + string + "'"));
        }
        Matcher matcher = this.SITEMAP_XML_FILENAME_PATTERN.matcher(string);
        return matcher.find();
    }

    static {
        try {
            dBuilder = XmlUtils.newXxeDisabledDocumentBuilderFactory().newDocumentBuilder();
            XPath xPath = XPathFactory.newInstance().newXPath();
            xpathLocationExpression = xPath.compile("/urlset/url/loc/text()");
        }
        catch (ParserConfigurationException | XPathExpressionException exception) {
            log.error((Object)exception);
        }
    }
}

