/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.profile;

import java.lang.reflect.InvocationTargetException;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.runtime.profile.ProfilingService;
import org.jruby.runtime.profile.builtin.BuiltinProfilingService;
import org.jruby.util.JRubyClassLoader;

public class ProfilingServiceLookup {
    private final Ruby runtime;
    private ProfilingService service;

    public ProfilingServiceLookup(Ruby runtime) {
        if (runtime == null) {
            throw new IllegalArgumentException("Given runtime must not be null.");
        }
        this.runtime = runtime;
    }

    public ProfilingService getService() {
        return this.service == null ? this.newProfiler() : this.service;
    }

    private Ruby getRuntime() {
        return this.runtime;
    }

    private RubyInstanceConfig getConfig() {
        return this.getRuntime().getInstanceConfig();
    }

    private RubyInstanceConfig.ProfilingMode getProfilingMode() {
        return this.getConfig().getProfilingMode();
    }

    private String getServiceClassName() {
        return this.getConfig().getProfilingService();
    }

    private synchronized ProfilingService newProfiler() {
        if (this.service == null) {
            switch (this.getProfilingMode()) {
                case SERVICE: {
                    if (this.getServiceClassName() == null || this.getServiceClassName().trim().isEmpty()) {
                        throw new RuntimeException("No profiling service property found.");
                    }
                    this.service = this.newServiceInstance();
                    break;
                }
                default: {
                    this.service = new BuiltinProfilingService(this.runtime);
                }
            }
        }
        return this.service;
    }

    private ProfilingService newServiceInstance() {
        Class<? extends ProfilingService> clazz = this.loadServiceClass();
        try {
            return clazz.getConstructor(Ruby.class).newInstance(this.runtime);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Can't create service service. " + e.getClass().getSimpleName() + ": " + e.getMessage());
        }
    }

    private Class<? extends ProfilingService> loadServiceClass() {
        JRubyClassLoader cl = this.getRuntime().getJRubyClassLoader();
        try {
            return cl.loadClass(this.getServiceClassName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Can't load service service class. " + e.getClass().getSimpleName() + ": " + e.getMessage());
        }
    }
}

