/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldcaps;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class FieldCapabilitiesResponse
extends ActionResponse
implements ToXContent {
    private Map<String, Map<String, FieldCapabilities>> responseMap;

    FieldCapabilitiesResponse(Map<String, Map<String, FieldCapabilities>> responseMap) {
        this.responseMap = responseMap;
    }

    FieldCapabilitiesResponse() {
        this.responseMap = Collections.emptyMap();
    }

    public Map<String, Map<String, FieldCapabilities>> get() {
        return this.responseMap;
    }

    public Map<String, FieldCapabilities> getField(String field) {
        return this.responseMap.get(field);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.responseMap = in.readMap(StreamInput::readString, FieldCapabilitiesResponse::readField);
    }

    private static Map<String, FieldCapabilities> readField(StreamInput in) throws IOException {
        return in.readMap(StreamInput::readString, FieldCapabilities::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeMap(this.responseMap, StreamOutput::writeString, FieldCapabilitiesResponse::writeField);
    }

    private static void writeField(StreamOutput out, Map<String, FieldCapabilities> map) throws IOException {
        out.writeMap(map, StreamOutput::writeString, (valueOut, fc) -> fc.writeTo(valueOut));
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("fields", this.responseMap);
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldCapabilitiesResponse that = (FieldCapabilitiesResponse)o;
        return this.responseMap.equals(that.responseMap);
    }

    public int hashCode() {
        return this.responseMap.hashCode();
    }
}

