/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public enum ShapeRelation implements Writeable
{
    INTERSECTS("intersects"),
    DISJOINT("disjoint"),
    WITHIN("within"),
    CONTAINS("contains");

    private final String relationName;

    private ShapeRelation(String relationName) {
        this.relationName = relationName;
    }

    public static ShapeRelation readFromStream(StreamInput in) throws IOException {
        int ordinal = in.readVInt();
        if (ordinal < 0 || ordinal >= ShapeRelation.values().length) {
            throw new IOException("Unknown ShapeRelation ordinal [" + ordinal + "]");
        }
        return ShapeRelation.values()[ordinal];
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.ordinal());
    }

    public static ShapeRelation getRelationByName(String name) {
        name = name.toLowerCase(Locale.ENGLISH);
        for (ShapeRelation relation : ShapeRelation.values()) {
            if (!relation.relationName.equals(name)) continue;
            return relation;
        }
        return null;
    }

    public String getRelationName() {
        return this.relationName;
    }
}

