/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class DocsStats
implements Streamable,
ToXContent {
    long count = 0L;
    long deleted = 0L;

    public DocsStats() {
    }

    public DocsStats(long count, long deleted) {
        this.count = count;
        this.deleted = deleted;
    }

    public void add(DocsStats docsStats) {
        if (docsStats == null) {
            return;
        }
        this.count += docsStats.count;
        this.deleted += docsStats.deleted;
    }

    public long getCount() {
        return this.count;
    }

    public long getDeleted() {
        return this.deleted;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.count = in.readVLong();
        this.deleted = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.count);
        out.writeVLong(this.deleted);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("docs");
        builder.field("count", this.count);
        builder.field("deleted", this.deleted);
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final String DOCS = "docs";
        static final String COUNT = "count";
        static final String DELETED = "deleted";

        Fields() {
        }
    }
}

