/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.cacheops;

import java.util.ArrayList;
import java.util.List;
import org.gradle.cache.internal.cacheops.CacheOperation;

class CacheOperationStack {
    private final List<CacheOperation> operations = new ArrayList<CacheOperation>();

    CacheOperationStack() {
    }

    public CacheOperationStack pushLongRunningOperation() {
        this.operations.add(0, new CacheOperation(true));
        return this;
    }

    public void popLongRunningOperation() {
        this.pop(true);
    }

    public boolean isInCacheAction() {
        return !this.operations.isEmpty() && !this.operations.get((int)0).longRunningOperation;
    }

    public boolean isInLongRunningOperation() {
        return !this.operations.isEmpty() && !this.isInCacheAction();
    }

    public CacheOperationStack pushCacheAction() {
        this.operations.add(0, new CacheOperation(false));
        return this;
    }

    public CacheOperation popCacheAction() {
        return this.pop(false);
    }

    private CacheOperation pop(boolean longRunningOperation) {
        this.checkNotEmpty();
        CacheOperation operation = this.operations.remove(0);
        if (operation.longRunningOperation == longRunningOperation) {
            return operation;
        }
        throw new IllegalStateException(String.format("Unexpected operation %s at the top of the stack.", operation));
    }

    private void checkNotEmpty() {
        if (this.operations.isEmpty()) {
            throw new IllegalStateException("Operation stack is empty.");
        }
    }

    public boolean isEmpty() {
        return this.operations.isEmpty();
    }
}

