/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.tasks;

import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.hash.HashCode;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildCacheKeyInputs {
    private final String taskClass;
    private final HashCode classLoaderHash;
    private final List<HashCode> actionClassLoaderHashes;
    private final ImmutableSortedMap<String, HashCode> inputHashes;
    private final ImmutableSortedSet<String> outputPropertyNames;

    public BuildCacheKeyInputs(String taskClass, HashCode classLoaderHash, List<HashCode> actionClassLoaderHashes, ImmutableSortedMap<String, HashCode> inputHashes, ImmutableSortedSet<String> outputPropertyNames) {
        this.taskClass = taskClass;
        this.inputHashes = inputHashes;
        this.classLoaderHash = classLoaderHash;
        this.actionClassLoaderHashes = actionClassLoaderHashes;
        this.outputPropertyNames = outputPropertyNames;
    }

    public String getTaskClass() {
        return this.taskClass;
    }

    public Map<String, HashCode> getInputHashes() {
        return this.inputHashes;
    }

    @Nullable
    public HashCode getClassLoaderHash() {
        return this.classLoaderHash;
    }

    public List<HashCode> getActionClassLoaderHashes() {
        return this.actionClassLoaderHashes;
    }

    public Set<String> getOutputPropertyNames() {
        return this.outputPropertyNames;
    }

    public String toString() {
        return "BuildCacheKeyInputs{classLoaderHash=" + this.classLoaderHash + ", actionsClassLoaderHash=" + this.actionClassLoaderHashes + ", inputHashes=" + this.inputHashes + ", outputPropertyNames=" + this.outputPropertyNames + '}';
    }
}

