/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.naming.SuggestedName;
import org.jetbrains.kotlin.js.translate.context.DeclarationExporterKt;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.StaticContext;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J\u0016\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0018\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010#\u001a\u00020\u00172\u0006\u0010!\u001a\u00020$2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/js/translate/context/DeclarationExporter;", "", "context", "Lorg/jetbrains/kotlin/js/translate/context/StaticContext;", "(Lorg/jetbrains/kotlin/js/translate/context/StaticContext;)V", "getContext", "()Lorg/jetbrains/kotlin/js/translate/context/StaticContext;", "exportedDeclarations", "", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "localPackageNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "objectLikeKinds", "", "Lorg/jetbrains/kotlin/descriptors/ClassKind;", "statements", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "getStatements", "()Ljava/util/List;", "assign", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "qualifier", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "expression", "export", "force", "", "exportObject", "declaration", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "exportProperty", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "getLocalPackageReference", "packageName", "kotlin-compiler"})
public final class DeclarationExporter {
    private final Set<ClassKind> objectLikeKinds;
    private final Set<MemberDescriptor> exportedDeclarations;
    private final Map<FqName, JsName> localPackageNames;
    @NotNull
    private final List<JsStatement> statements;
    @NotNull
    private final StaticContext context;

    @NotNull
    public final List<JsStatement> getStatements() {
        return this.statements;
    }

    public final void export(@NotNull MemberDescriptor descriptor2, boolean force) {
        JsExpression qualifier;
        JsExpression jsExpression;
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        if (this.exportedDeclarations.contains(descriptor2)) {
            return;
        }
        if (descriptor2 instanceof ConstructorDescriptor && ((ConstructorDescriptor)descriptor2).isPrimary()) {
            return;
        }
        if (AnnotationsUtils.isNativeObject(descriptor2) || AnnotationsUtils.isLibraryObject(descriptor2)) {
            return;
        }
        if (AnnotationUtilKt.isInlineOnlyOrReifiable(descriptor2)) {
            return;
        }
        SuggestedName suggestedName = this.context.getNameSuggestion().suggest(descriptor2);
        if (suggestedName == null) {
            return;
        }
        SuggestedName suggestedName2 = suggestedName;
        DeclarationDescriptor container2 = suggestedName2.getScope();
        if (!DeclarationExporterKt.access$shouldBeExported(descriptor2, force)) {
            return;
        }
        this.exportedDeclarations.add(descriptor2);
        if (container2 instanceof PackageFragmentDescriptor) {
            jsExpression = this.getLocalPackageReference(((PackageFragmentDescriptor)container2).getFqName());
        } else if (DescriptorUtils.isObject(container2)) {
            JsExpression jsExpression2 = JsAstUtils.prototypeOf(this.context.getInnerNameForDescriptor(container2).makeRef());
            jsExpression = jsExpression2;
            Intrinsics.checkExpressionValueIsNotNull(jsExpression2, "JsAstUtils.prototypeOf(c\u2026tor(container).makeRef())");
        } else {
            JsNameRef jsNameRef = this.context.getInnerNameForDescriptor(container2).makeRef();
            Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "context.getInnerNameForD\u2026ptor(container).makeRef()");
            jsExpression = qualifier = (JsExpression)jsNameRef;
        }
        if (descriptor2 instanceof ClassDescriptor && this.objectLikeKinds.contains((Object)((ClassDescriptor)descriptor2).getKind())) {
            this.exportObject((ClassDescriptor)descriptor2, qualifier);
        } else if (descriptor2 instanceof PropertyDescriptor && container2 instanceof PackageFragmentDescriptor) {
            this.exportProperty((PropertyDescriptor)descriptor2, qualifier);
        } else {
            DeclarationDescriptor declarationDescriptor = descriptor2;
            JsNameRef jsNameRef = this.context.getInnerNameForDescriptor(descriptor2).makeRef();
            Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "context.getInnerNameForD\u2026tor(descriptor).makeRef()");
            this.assign(declarationDescriptor, qualifier, jsNameRef);
        }
    }

    private final void assign(DeclarationDescriptor descriptor2, JsExpression qualifier, JsExpression expression) {
        JsName propertyName = this.context.getNameForDescriptor(descriptor2);
        if (!(MetadataProperties.getStaticRef(propertyName) != null || expression instanceof JsNameRef && ((JsNameRef)expression).getName() == propertyName)) {
            MetadataProperties.setStaticRef(propertyName, expression);
        }
        Collection collection = this.statements;
        JsStatement jsStatement = JsAstUtils.assignment(new JsNameRef(propertyName, qualifier), expression).makeStmt();
        collection.add(jsStatement);
    }

    private final void exportObject(ClassDescriptor declaration, JsExpression qualifier) {
        JsName name2 = this.context.getNameForDescriptor(declaration);
        Collection collection = this.statements;
        JsStatement jsStatement = JsAstUtils.defineGetter(this.context.getProgram(), qualifier, name2.getIdent(), this.context.getNameForObjectInstance(declaration).makeRef());
        collection.add(jsStatement);
    }

    private final void exportProperty(PropertyDescriptor declaration, JsExpression qualifier) {
        JsExpression jsExpression;
        Object accessToField;
        boolean simpleProperty;
        JsObjectLiteral propertyLiteral = new JsObjectLiteral(true);
        String name2 = this.context.getNameForDescriptor(declaration).getIdent();
        boolean bl = simpleProperty = JsDescriptorUtils.isSimpleFinalProperty(declaration) && !TranslationUtils.shouldAccessViaFunctions((CallableDescriptor)declaration);
        if (simpleProperty) {
            accessToField = new JsReturn(this.context.getInnerNameForDescriptor(declaration).makeRef());
            jsExpression = new JsFunction((JsScope)this.context.getRootFunction().getScope(), new JsBlock((JsStatement)accessToField), declaration + " getter");
        } else {
            PropertyGetterDescriptor propertyGetterDescriptor = declaration.getGetter();
            if (propertyGetterDescriptor == null) {
                Intrinsics.throwNpe();
            }
            JsNameRef jsNameRef = this.context.getInnerNameForDescriptor(propertyGetterDescriptor).makeRef();
            Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "context.getInnerNameForD\u2026ation.getter!!).makeRef()");
            jsExpression = jsNameRef;
        }
        JsExpression getterBody = jsExpression;
        accessToField = propertyLiteral.getPropertyInitializers();
        Object object = new JsPropertyInitializer(new JsNameRef("get"), getterBody);
        accessToField.add(object);
        if (declaration.isVar()) {
            JsExpression jsExpression2;
            if (simpleProperty) {
                List statements = new ArrayList();
                JsFunction function2 = new JsFunction((JsScope)this.context.getRootFunction().getScope(), new JsBlock(statements), declaration + " setter");
                JsName valueName = function2.getScope().declareTemporaryName("value");
                Collection collection = function2.getParameters();
                JsNode jsNode = new JsParameter(valueName);
                collection.add(jsNode);
                collection = statements;
                jsNode = JsAstUtils.assignment(this.context.getInnerNameForDescriptor(declaration).makeRef(), valueName.makeRef()).makeStmt();
                collection.add(jsNode);
                jsExpression2 = function2;
            } else {
                PropertySetterDescriptor propertySetterDescriptor = declaration.getSetter();
                if (propertySetterDescriptor == null) {
                    Intrinsics.throwNpe();
                }
                JsNameRef jsNameRef = this.context.getInnerNameForDescriptor(propertySetterDescriptor).makeRef();
                Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "context.getInnerNameForD\u2026ation.setter!!).makeRef()");
                jsExpression2 = jsNameRef;
            }
            JsExpression setterBody = jsExpression2;
            object = propertyLiteral.getPropertyInitializers();
            JsPropertyInitializer jsPropertyInitializer = new JsPropertyInitializer(new JsNameRef("set"), setterBody);
            object.add(jsPropertyInitializer);
        }
        Collection collection = this.statements;
        object = JsAstUtils.defineProperty(qualifier, name2, propertyLiteral, this.context.getProgram()).makeStmt();
        collection.add(object);
    }

    private final JsExpression getLocalPackageReference(FqName packageName) {
        if (packageName.isRoot()) {
            JsNameRef jsNameRef = this.context.getRootFunction().getScope().declareName(Namer.getRootPackageName()).makeRef();
            Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "context.rootFunction.sco\u2026tPackageName()).makeRef()");
            return jsNameRef;
        }
        JsName name2 = this.localPackageNames.get(packageName);
        if (name2 == null) {
            name2 = this.context.getRootFunction().getScope().declareTemporaryName("package$" + packageName.shortName().asString());
            this.localPackageNames.put(packageName, name2);
            FqName fqName2 = packageName.parent();
            Intrinsics.checkExpressionValueIsNotNull(fqName2, "packageName.parent()");
            JsExpression parentRef = this.getLocalPackageReference(fqName2);
            JsNameRef selfRef = new JsNameRef(packageName.shortName().asString(), parentRef);
            JsBinaryOperation rhs = JsAstUtils.or(selfRef, JsAstUtils.assignment(selfRef.deepCopy(), new JsObjectLiteral(false)));
            JsVars jsVars = JsAstUtils.newVar(name2, rhs);
            Intrinsics.checkExpressionValueIsNotNull(jsVars, "JsAstUtils.newVar(name, rhs)");
            this.statements.add(jsVars);
        }
        JsNameRef jsNameRef = name2.makeRef();
        Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "name.makeRef()");
        return jsNameRef;
    }

    @NotNull
    public final StaticContext getContext() {
        return this.context;
    }

    public DeclarationExporter(@NotNull StaticContext context) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.context = context;
        this.objectLikeKinds = SetsKt.setOf(new ClassKind[]{ClassKind.OBJECT, ClassKind.ENUM_ENTRY});
        DeclarationExporter declarationExporter = this;
        Object object = new LinkedHashSet();
        declarationExporter.exportedDeclarations = object;
        declarationExporter = this;
        declarationExporter.localPackageNames = object = (Map)new LinkedHashMap();
        declarationExporter = this;
        declarationExporter.statements = object = (List)new ArrayList();
    }
}

