#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: graphviz
version: 2999.18.1.2
id: graphviz-2999.18.1.2-6Ckf7xTKGny54CLgVeh5av
key: graphviz-2999.18.1.2-6Ckf7xTKGny54CLgVeh5av
license: BSD3
copyright: Matthew Sackman, Ivan Lazar Miljenovic
maintainer: Ivan.Miljenovic@gmail.com
stability: Beta
homepage: http://projects.haskell.org/graphviz/
synopsis: Bindings to Graphviz for graph visualisation.
description:
    This library provides bindings for the Dot language used by the
    Graphviz (<http://graphviz.org/>) suite of programs for visualising
    graphs, as well as functions to call those programs.
    .
    Main features of the graphviz library include:
    .
    * Almost complete coverage of all Graphviz attributes and syntax.
    .
    * Support for specifying clusters.
    .
    * The ability to use a custom node type.
    .
    * Functions for running a Graphviz layout tool with all specified
    output types.
    .
    * The ability to not only generate but also parse Dot code with two
    options: strict and liberal (in terms of ordering of statements).
    .
    * Functions to convert FGL graphs and other graph-like data structures
    to Dot code - including support to group them into clusters - with a
    high degree of customisation by specifying which attributes to use
    and limited support for the inverse operation.
    .
    * Round-trip support for passing an FGL graph through Graphviz to
    augment node and edge labels with positional information, etc.
category: Graphs, Graphics
author: Matthew Sackman, Ivan Lazar Miljenovic
exposed: True
exposed-modules:
    Data.GraphViz Data.GraphViz.Types Data.GraphViz.Types.Canonical
    Data.GraphViz.Types.Generalised Data.GraphViz.Types.Graph
    Data.GraphViz.Types.Monadic Data.GraphViz.Parsing
    Data.GraphViz.Printing Data.GraphViz.Commands
    Data.GraphViz.Commands.IO Data.GraphViz.Attributes
    Data.GraphViz.Attributes.Complete Data.GraphViz.Attributes.Colors
    Data.GraphViz.Attributes.Colors.X11
    Data.GraphViz.Attributes.Colors.Brewer
    Data.GraphViz.Attributes.Colors.SVG Data.GraphViz.Attributes.HTML
    Data.GraphViz.PreProcessing Data.GraphViz.Exception
    Data.GraphViz.Algorithms Data.GraphViz.Attributes.Internal
    Data.GraphViz.Internal.Util Data.GraphViz.Internal.State
    Data.GraphViz.Types.Internal.Common
hidden-modules: Data.GraphViz.Algorithms.Clustering
                Data.GraphViz.Attributes.Arrows
                Data.GraphViz.Attributes.ColorScheme Data.GraphViz.Attributes.Same
                Data.GraphViz.Attributes.Values Data.GraphViz.Commands.Available
                Data.GraphViz.Types.State
abi: d2be5a0c6db1be8b2216b27361afa1e6
trusted: False
import-dirs: /usr/lib/ghc-8.0.2/site-local/graphviz-2999.18.1.2
library-dirs: /usr/lib/ghc-8.0.2/site-local/graphviz-2999.18.1.2
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.0.2/graphviz-2999.18.1.2
hs-libraries: HSgraphviz-2999.18.1.2-6Ckf7xTKGny54CLgVeh5av
depends:
    base-4.9.1.0 bytestring-0.10.8.1
    colour-2.3.3-7zspnmhVLMd3uThUzy60rY containers-0.5.7.1
    directory-1.3.0.0 dlist-0.8.0.3-BHFBNaw8k6n9WiaUNzoXpk
    fgl-5.5.3.1-6LdDICWL6Ze3rGuqhKrQHQ filepath-1.4.1.1
    polyparse-1.12-2dxp3MdYSYOEcDgRo6TZWF process-1.4.3.0
    temporary-1.2.1-JeTWp1TBc5gLAbmEVNVXbt
    text-1.2.2.2-3ENqlljngKa6xj1Go2fVWq transformers-0.5.2.0
    wl-pprint-text-1.1.1.0-FBPbbR9kXrMlZrUe0NuB4
haddock-interfaces: /usr/share/doc/haskell-graphviz/html/graphviz.haddock
haddock-html: /usr/share/doc/haskell-graphviz/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
