/*
 * Decompiled with CFR 0.152.
 */
package javajs.img;

import java.io.BufferedInputStream;
import java.io.IOException;
import javajs.util.Rdr;

public class BMPDecoder {
    private BufferedInputStream bis;
    private byte[] temp;

    /*
     * Enabled aggressive exception aggregation
     */
    public Object[] decodeWindowsBMP(byte[] bytes) {
        try {
            boolean isYReversed;
            int bitsPerPixel;
            int imageHeight;
            int imageWidth;
            this.bis = Rdr.getBIS(bytes);
            this.temp = new byte[4];
            if (this.readByte() != 66 || this.readByte() != 77) {
                return null;
            }
            this.readInt();
            this.readShort();
            this.readShort();
            this.readInt();
            int nColors = 0;
            int imageSize = 0;
            int headerSize = this.readInt();
            switch (headerSize) {
                case 12: {
                    imageWidth = this.readShort();
                    imageHeight = this.readShort();
                    this.readShort();
                    bitsPerPixel = this.readShort();
                    break;
                }
                case 40: {
                    imageWidth = this.readInt();
                    imageHeight = this.readInt();
                    this.readShort();
                    bitsPerPixel = this.readShort();
                    int ncompression = this.readInt();
                    if (ncompression != 0) {
                        System.out.println("BMP Compression is :" + ncompression + " -- aborting");
                        return null;
                    }
                    imageSize = this.readInt();
                    this.readInt();
                    this.readInt();
                    nColors = this.readInt();
                    this.readInt();
                    break;
                }
                default: {
                    System.out.println("BMP Header unrecognized, length=" + headerSize + " -- aborting");
                    return null;
                }
            }
            boolean bl = isYReversed = imageHeight < 0;
            if (isYReversed) {
                imageHeight = -imageHeight;
            }
            int nPixels = imageHeight * imageWidth;
            int bytesPerPixel = bitsPerPixel / 8;
            int n = nColors = nColors > 0 ? nColors : 1 << bitsPerPixel;
            int npad = (bytesPerPixel == 4 ? 0 : (imageSize == 0 ? 4 - imageWidth % 4 : imageSize / imageHeight - imageWidth * bytesPerPixel)) % 4;
            int[] buf = new int[nPixels];
            int dpt = isYReversed ? imageWidth : -imageWidth;
            int pt0 = isYReversed ? 0 : nPixels + dpt;
            int pt1 = isYReversed ? nPixels : dpt;
            switch (bitsPerPixel) {
                case 24: 
                case 32: {
                    int pt = pt0;
                    while (pt != pt1) {
                        int i = 0;
                        while (i < imageWidth) {
                            buf[pt + i] = this.readColor(bytesPerPixel);
                            ++i;
                        }
                        pt += dpt;
                        this.pad(npad);
                    }
                    break;
                }
                case 8: {
                    int[] palette = new int[nColors];
                    int i = 0;
                    while (i < nColors) {
                        palette[i] = this.readColor(4);
                        ++i;
                    }
                    int pt = pt0;
                    while (pt != pt1) {
                        int i2 = 0;
                        while (i2 < imageWidth) {
                            buf[pt + i2] = palette[this.readByte()];
                            ++i2;
                        }
                        pt += dpt;
                        this.pad(npad);
                    }
                    break;
                }
                case 4: {
                    npad = (4 - (imageWidth + 1) / 2 % 4) % 4;
                    int[] palette = new int[nColors];
                    int i = 0;
                    while (i < nColors) {
                        palette[i] = this.readColor(4);
                        ++i;
                    }
                    int b4 = 0;
                    int pt = pt0;
                    while (pt != pt1) {
                        int i3 = 0;
                        int shift = 4;
                        while (i3 < imageWidth) {
                            buf[pt + i3] = palette[(shift == 4 ? this.readByte() : b4) >> shift & 0xF];
                            ++i3;
                            shift = 4 - shift;
                        }
                        pt += dpt;
                        this.pad(npad);
                    }
                    break;
                }
                case 1: {
                    int color1 = this.readColor(3);
                    int color2 = this.readColor(3);
                    npad = (4 - (imageWidth + 7) / 8 % 4) % 4;
                    int b = 0;
                    int pt = pt0;
                    while (pt != pt1) {
                        int i = 0;
                        int bpt = -1;
                        while (i < imageWidth) {
                            if (bpt < 0) {
                                b = this.readByte();
                                bpt = 7;
                            }
                            buf[pt + i] = (b & 1 << bpt) == 0 ? color1 : color2;
                            ++i;
                            --bpt;
                        }
                        pt += dpt;
                        this.pad(npad);
                    }
                    break;
                }
                default: {
                    System.out.println("Not a 32-, 24-, 8-, 4-, or 1-bit Windows Bitmap, aborting...");
                    return null;
                }
            }
            return new Object[]{buf, imageWidth, imageHeight};
        }
        catch (Exception e) {
            System.out.println("Caught exception in loadbitmap!");
            return null;
        }
    }

    private boolean pad(int npad) throws IOException {
        int i = 0;
        while (i < npad) {
            this.readByte();
            ++i;
        }
        return true;
    }

    private int readColor(int n) throws IOException {
        this.bis.read(this.temp, 0, n);
        return 0xFF000000 | (this.temp[2] & 0xFF) << 16 | (this.temp[1] & 0xFF) << 8 | this.temp[0] & 0xFF;
    }

    private int readInt() throws IOException {
        this.bis.read(this.temp, 0, 4);
        return (this.temp[3] & 0xFF) << 24 | (this.temp[2] & 0xFF) << 16 | (this.temp[1] & 0xFF) << 8 | this.temp[0] & 0xFF;
    }

    private int readShort() throws IOException {
        this.bis.read(this.temp, 0, 2);
        return (this.temp[1] & 0xFF) << 8 | this.temp[0] & 0xFF;
    }

    private int readByte() throws IOException {
        this.bis.read(this.temp, 0, 1);
        return this.temp[0] & 0xFF;
    }
}

