/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import javajs.api.EigenInterface;
import javajs.util.V3;

public class Eigen
implements EigenInterface {
    private int n = 3;
    private double[] d;
    private double[] e;
    private double[][] V;

    public Eigen set(int n) {
        this.n = n;
        this.V = new double[n][n];
        this.d = new double[n];
        this.e = new double[n];
        return this;
    }

    @Override
    public Eigen setM(double[][] m) {
        this.set(m.length);
        this.calc(m);
        return this;
    }

    @Override
    public double[] getEigenvalues() {
        return this.d;
    }

    @Override
    public void fillFloatArrays(V3[] eigenVectors, float[] eigenValues) {
        int i = 0;
        while (i < 3) {
            if (eigenVectors != null) {
                if (eigenVectors[i] == null) {
                    eigenVectors[i] = new V3();
                }
                eigenVectors[i].set((float)this.V[0][i], (float)this.V[1][i], (float)this.V[2][i]);
            }
            if (eigenValues != null) {
                eigenValues[i] = (float)this.d[i];
            }
            ++i;
        }
    }

    @Override
    public float[][] getEigenvectorsFloatTransposed() {
        float[][] f = new float[this.n][this.n];
        int i = this.n;
        while (--i >= 0) {
            int j = this.n;
            while (--j >= 0) {
                f[j][i] = (float)this.V[i][j];
            }
        }
        return f;
    }

    public void calc(double[][] A) {
        int i = 0;
        while (i < this.n) {
            int j = 0;
            while (j < this.n) {
                this.V[i][j] = A[i][j];
                ++j;
            }
            ++i;
        }
        this.tred2();
        this.tql2();
    }

    public double[] getRealEigenvalues() {
        return this.d;
    }

    public double[] getImagEigenvalues() {
        return this.e;
    }

    private void tred2() {
        int j = 0;
        while (j < this.n) {
            this.d[j] = this.V[this.n - 1][j];
            ++j;
        }
        int i = this.n - 1;
        while (i > 0) {
            double scale = 0.0;
            double h = 0.0;
            int k = 0;
            while (k < i) {
                scale += Math.abs(this.d[k]);
                ++k;
            }
            if (scale == 0.0) {
                this.e[i] = this.d[i - 1];
                int j2 = 0;
                while (j2 < i) {
                    this.d[j2] = this.V[i - 1][j2];
                    this.V[i][j2] = 0.0;
                    this.V[j2][i] = 0.0;
                    ++j2;
                }
            } else {
                k = 0;
                while (k < i) {
                    int n = k;
                    this.d[n] = this.d[n] / scale;
                    h += this.d[k] * this.d[k];
                    ++k;
                }
                double f = this.d[i - 1];
                double g = Math.sqrt(h);
                if (f > 0.0) {
                    g = -g;
                }
                this.e[i] = scale * g;
                h -= f * g;
                this.d[i - 1] = f - g;
                int j3 = 0;
                while (j3 < i) {
                    this.e[j3] = 0.0;
                    ++j3;
                }
                j3 = 0;
                while (j3 < i) {
                    this.V[j3][i] = f = this.d[j3];
                    g = this.e[j3] + this.V[j3][j3] * f;
                    int k2 = j3 + 1;
                    while (k2 <= i - 1) {
                        g += this.V[k2][j3] * this.d[k2];
                        int n = k2;
                        this.e[n] = this.e[n] + this.V[k2][j3] * f;
                        ++k2;
                    }
                    this.e[j3] = g;
                    ++j3;
                }
                f = 0.0;
                j3 = 0;
                while (j3 < i) {
                    int n = j3;
                    this.e[n] = this.e[n] / h;
                    f += this.e[j3] * this.d[j3];
                    ++j3;
                }
                double hh = f / (h + h);
                int j4 = 0;
                while (j4 < i) {
                    int n = j4;
                    this.e[n] = this.e[n] - hh * this.d[j4];
                    ++j4;
                }
                j4 = 0;
                while (j4 < i) {
                    f = this.d[j4];
                    g = this.e[j4];
                    int k3 = j4;
                    while (k3 <= i - 1) {
                        double[] dArray = this.V[k3];
                        int n = j4;
                        dArray[n] = dArray[n] - (f * this.e[k3] + g * this.d[k3]);
                        ++k3;
                    }
                    this.d[j4] = this.V[i - 1][j4];
                    this.V[i][j4] = 0.0;
                    ++j4;
                }
            }
            this.d[i] = h;
            --i;
        }
        i = 0;
        while (i < this.n - 1) {
            this.V[this.n - 1][i] = this.V[i][i];
            this.V[i][i] = 1.0;
            double h = this.d[i + 1];
            if (h != 0.0) {
                int k = 0;
                while (k <= i) {
                    this.d[k] = this.V[k][i + 1] / h;
                    ++k;
                }
                int j5 = 0;
                while (j5 <= i) {
                    double g = 0.0;
                    int k4 = 0;
                    while (k4 <= i) {
                        g += this.V[k4][i + 1] * this.V[k4][j5];
                        ++k4;
                    }
                    k4 = 0;
                    while (k4 <= i) {
                        double[] dArray = this.V[k4];
                        int n = j5;
                        dArray[n] = dArray[n] - g * this.d[k4];
                        ++k4;
                    }
                    ++j5;
                }
            }
            int k = 0;
            while (k <= i) {
                this.V[k][i + 1] = 0.0;
                ++k;
            }
            ++i;
        }
        j = 0;
        while (j < this.n) {
            this.d[j] = this.V[this.n - 1][j];
            this.V[this.n - 1][j] = 0.0;
            ++j;
        }
        this.V[this.n - 1][this.n - 1] = 1.0;
        this.e[0] = 0.0;
    }

    private void tql2() {
        int i = 1;
        while (i < this.n) {
            this.e[i - 1] = this.e[i];
            ++i;
        }
        this.e[this.n - 1] = 0.0;
        double f = 0.0;
        double tst1 = 0.0;
        double eps = Math.pow(2.0, -52.0);
        int l = 0;
        while (l < this.n) {
            tst1 = Math.max(tst1, Math.abs(this.d[l]) + Math.abs(this.e[l]));
            int m = l;
            while (m < this.n) {
                if (Math.abs(this.e[m]) <= eps * tst1) break;
                ++m;
            }
            if (m > l) {
                int iter = 0;
                do {
                    double c;
                    ++iter;
                    double g = this.d[l];
                    double p = (this.d[l + 1] - g) / (2.0 * this.e[l]);
                    double r = Eigen.hypot(p, 1.0);
                    if (p < 0.0) {
                        r = -r;
                    }
                    this.d[l] = this.e[l] / (p + r);
                    this.d[l + 1] = this.e[l] * (p + r);
                    double dl1 = this.d[l + 1];
                    double h = g - this.d[l];
                    int i2 = l + 2;
                    while (i2 < this.n) {
                        int n = i2++;
                        this.d[n] = this.d[n] - h;
                    }
                    f += h;
                    p = this.d[m];
                    double c2 = c = 1.0;
                    double c3 = c;
                    double el1 = this.e[l + 1];
                    double s = 0.0;
                    double s2 = 0.0;
                    int i3 = m - 1;
                    while (i3 >= l) {
                        c3 = c2;
                        c2 = c;
                        s2 = s;
                        g = c * this.e[i3];
                        h = c * p;
                        r = Eigen.hypot(p, this.e[i3]);
                        this.e[i3 + 1] = s * r;
                        s = this.e[i3] / r;
                        c = p / r;
                        p = c * this.d[i3] - s * g;
                        this.d[i3 + 1] = h + s * (c * g + s * this.d[i3]);
                        int k = 0;
                        while (k < this.n) {
                            h = this.V[k][i3 + 1];
                            this.V[k][i3 + 1] = s * this.V[k][i3] + c * h;
                            this.V[k][i3] = c * this.V[k][i3] - s * h;
                            ++k;
                        }
                        --i3;
                    }
                    p = -s * s2 * c3 * el1 * this.e[l] / dl1;
                    this.e[l] = s * p;
                    this.d[l] = c * p;
                } while (Math.abs(this.e[l]) > eps * tst1);
            }
            this.d[l] = this.d[l] + f;
            this.e[l] = 0.0;
            ++l;
        }
        int i4 = 0;
        while (i4 < this.n - 1) {
            int k = i4;
            double p = this.d[i4];
            int j = i4 + 1;
            while (j < this.n) {
                if (this.d[j] < p) {
                    k = j;
                    p = this.d[j];
                }
                ++j;
            }
            if (k != i4) {
                this.d[k] = this.d[i4];
                this.d[i4] = p;
                j = 0;
                while (j < this.n) {
                    p = this.V[j][i4];
                    this.V[j][i4] = this.V[j][k];
                    this.V[j][k] = p;
                    ++j;
                }
            }
            ++i4;
        }
    }

    private static double hypot(double a, double b) {
        double r;
        if (Math.abs(a) > Math.abs(b)) {
            r = b / a;
            r = Math.abs(a) * Math.sqrt(1.0 + r * r);
        } else if (b != 0.0) {
            r = a / b;
            r = Math.abs(b) * Math.sqrt(1.0 + r * r);
        } else {
            r = 0.0;
        }
        return r;
    }
}

