/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.layer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.IEnabledStateUpdating;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public final class LayerVisibilityAction
extends AbstractAction
implements IEnabledStateUpdating,
Layer.LayerAction {
    private static final String DIALOGS_LAYERLIST = "dialogs/layerlist";
    private static final int SLIDER_STEPS = 100;
    private static final int SLIDER_WHEEL_INCREMENT = 5;
    private static final double MAX_SHARPNESS_FACTOR = 2.0;
    private static final double MAX_COLORFUL_FACTOR = 2.0;
    private final LayerListDialog.LayerListModel model;
    private final JPopupMenu popup;
    private SideButton sideButton;
    private final JPanel content = new JPanel();
    final OpacitySlider opacitySlider = new OpacitySlider();
    private final ArrayList<LayerVisibilityMenuEntry> sliders = new ArrayList();

    public LayerVisibilityAction(LayerListDialog.LayerListModel layerListModel) {
        this.model = layerListModel;
        this.popup = new JPopupMenu();
        this.popup.addMouseWheelListener(InputEvent::consume);
        this.popup.add(this.content);
        this.content.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.content.setLayout(new GridBagLayout());
        new ImageProvider(DIALOGS_LAYERLIST, "visibility").getResource().attachImageIcon(this, true);
        this.putValue("ShortDescription", I18n.tr("Change visibility of the selected layer.", new Object[0]));
        this.addContentEntry(new VisibilityCheckbox());
        this.addContentEntry(this.opacitySlider);
        this.addContentEntry(new ColorfulnessSlider());
        this.addContentEntry(new GammaFilterSlider());
        this.addContentEntry(new SharpnessSlider());
        this.addContentEntry(new ColorSelector(layerListModel::getSelectedLayers));
    }

    private void addContentEntry(LayerVisibilityMenuEntry layerVisibilityMenuEntry) {
        this.content.add((Component)layerVisibilityMenuEntry.getPanel(), GBC.eop().fill(2));
        this.sliders.add(layerVisibilityMenuEntry);
    }

    void setVisibleFlag(boolean bl) {
        for (Layer layer : this.model.getSelectedLayers()) {
            layer.setVisible(bl);
        }
        this.updateValues();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.updateValues();
        if (actionEvent.getSource() == this.sideButton) {
            this.popup.show(this.sideButton, 0, this.sideButton.getHeight());
        } else {
            this.popup.show(Main.parent, Main.parent.getWidth() / 2, (Main.parent.getHeight() - this.popup.getHeight()) / 2);
        }
    }

    void updateValues() {
        List<Layer> list = this.model.getSelectedLayers();
        boolean bl = true;
        boolean bl2 = true;
        for (Layer object : list) {
            bl &= object.isVisible();
            bl2 &= !object.isVisible();
        }
        for (LayerVisibilityMenuEntry layerVisibilityMenuEntry : this.sliders) {
            layerVisibilityMenuEntry.updateLayers(list, bl, bl2);
        }
    }

    @Override
    public boolean supportLayers(List<Layer> list) {
        return !list.isEmpty();
    }

    @Override
    public Component createMenuComponent() {
        return new JMenuItem(this);
    }

    @Override
    public void updateEnabledState() {
        this.setEnabled(!this.model.getSelectedLayers().isEmpty());
    }

    public void setCorrespondingSideButton(SideButton sideButton) {
        this.sideButton = sideButton;
    }

    private static class ColorSelector
    extends JPanel
    implements LayerVisibilityMenuEntry {
        private static final Border NORMAL_BORDER = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        private static final Border SELECTED_BORDER = BorderFactory.createLineBorder(Color.BLACK, 2);
        private static final Color[] COLORS = new Color[]{Color.RED, Color.ORANGE, Color.YELLOW, Color.GREEN, Color.BLUE, Color.CYAN, Color.GRAY};
        private final Supplier<List<Layer>> layerSupplier;
        private final HashMap<Color, JPanel> panels = new HashMap();

        ColorSelector(Supplier<List<Layer>> supplier) {
            super(new GridBagLayout());
            this.layerSupplier = supplier;
            this.add((Component)new JLabel(I18n.tr("Color", new Object[0])), GBC.eol().insets(34, 0, 0, 0));
            for (Color color : COLORS) {
                this.addPanelForColor(color);
            }
        }

        private void addPanelForColor(final Color color) {
            JPanel jPanel = new JPanel();
            jPanel.setBackground(color);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.setBorder(NORMAL_BORDER);
            jPanel2.add(jPanel);
            jPanel2.setMinimumSize(new Dimension(20, 20));
            jPanel2.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    List list = (List)layerSupplier.get();
                    for (Layer layer : list) {
                        if (!(layer instanceof GpxLayer)) continue;
                        layer.getColorProperty().put(color);
                    }
                    this.highlightColor(color);
                }
            });
            this.add((Component)jPanel2, GBC.std().weight(1.0, 1.0).fill().insets(5));
            this.panels.put(color, jPanel2);
            List list = this.layerSupplier.get().stream().map(layer -> layer.getColorProperty().get()).distinct().collect(Collectors.toList());
            if (list.size() == 1) {
                this.highlightColor((Color)list.get(0));
            }
        }

        @Override
        public void updateLayers(List<Layer> list, boolean bl, boolean bl2) {
            List list2 = list.stream().filter(layer -> layer instanceof GpxLayer).map(layer -> ((GpxLayer)layer).getColorProperty().get()).distinct().collect(Collectors.toList());
            if (list2.size() == 1) {
                this.setVisible(true);
                this.highlightColor((Color)list2.get(0));
            } else if (list2.size() > 1) {
                this.setVisible(true);
                this.highlightColor(null);
            } else {
                this.setVisible(false);
            }
        }

        private void highlightColor(Color color) {
            JPanel jPanel2;
            this.panels.values().forEach(jPanel -> jPanel.setBorder(NORMAL_BORDER));
            if (color != null && (jPanel2 = this.panels.get(color)) != null) {
                jPanel2.setBorder(SELECTED_BORDER);
            }
            this.repaint();
        }

        @Override
        public JComponent getPanel() {
            return this;
        }
    }

    private class ColorfulnessSlider
    extends AbstractFilterSlider<ImageryLayer> {
        ColorfulnessSlider() {
            super(0.0, 2.0, ImageryLayer.class);
            this.slider.setToolTipText(I18n.tr("Adjust colorfulness of the layer.", new Object[0]));
        }

        @Override
        protected void updateSliderWhileEnabled(Collection<? extends Layer> collection, boolean bl) {
            this.setRealValue(((ImageryLayer)collection.iterator().next()).getFilterSettings().getColorfulness());
        }

        @Override
        protected void applyValueToLayer(ImageryLayer imageryLayer) {
            imageryLayer.getFilterSettings().setColorfulness(this.getRealValue());
        }

        @Override
        public ImageIcon getIcon() {
            return ImageProvider.get(LayerVisibilityAction.DIALOGS_LAYERLIST, "colorfulness");
        }

        @Override
        public String getLabel() {
            return I18n.tr("Colorfulness", new Object[0]);
        }
    }

    private class SharpnessSlider
    extends AbstractFilterSlider<ImageryLayer> {
        SharpnessSlider() {
            super(0.0, 2.0, ImageryLayer.class);
            this.slider.setToolTipText(I18n.tr("Adjust sharpness/blur value of the layer.", new Object[0]));
        }

        @Override
        protected void updateSliderWhileEnabled(Collection<? extends Layer> collection, boolean bl) {
            this.setRealValue(((ImageryLayer)collection.iterator().next()).getFilterSettings().getSharpenLevel());
        }

        @Override
        protected void applyValueToLayer(ImageryLayer imageryLayer) {
            imageryLayer.getFilterSettings().setSharpenLevel(this.getRealValue());
        }

        @Override
        public ImageIcon getIcon() {
            return ImageProvider.get(LayerVisibilityAction.DIALOGS_LAYERLIST, "sharpness");
        }

        @Override
        public String getLabel() {
            return I18n.tr("Sharpness", new Object[0]);
        }
    }

    private class GammaFilterSlider
    extends AbstractFilterSlider<ImageryLayer> {
        GammaFilterSlider() {
            super(-1.0, 1.0, ImageryLayer.class);
            this.slider.setToolTipText(I18n.tr("Adjust gamma value of the layer.", new Object[0]));
        }

        @Override
        protected void updateSliderWhileEnabled(Collection<? extends Layer> collection, boolean bl) {
            double d = ((ImageryLayer)collection.iterator().next()).getFilterSettings().getGamma();
            this.setRealValue(this.mapGammaToInterval(d));
        }

        @Override
        protected void applyValueToLayer(ImageryLayer imageryLayer) {
            imageryLayer.getFilterSettings().setGamma(this.mapIntervalToGamma(this.getRealValue()));
        }

        @Override
        public ImageIcon getIcon() {
            return ImageProvider.get(LayerVisibilityAction.DIALOGS_LAYERLIST, "gamma");
        }

        @Override
        public String getLabel() {
            return I18n.tr("Gamma", new Object[0]);
        }

        private double mapIntervalToGamma(double d) {
            return (1.0 + d) / (1.0 - d);
        }

        private double mapGammaToInterval(double d) {
            return (d - 1.0) / (d + 1.0);
        }
    }

    class OpacitySlider
    extends AbstractFilterSlider<Layer> {
        OpacitySlider() {
            super(0.0, 1.0, Layer.class);
            this.slider.setToolTipText(I18n.tr("Adjust opacity of the layer.", new Object[0]));
        }

        @Override
        protected void onStateChanged() {
            if (this.getRealValue() <= 0.001 && !this.slider.getValueIsAdjusting()) {
                LayerVisibilityAction.this.setVisibleFlag(false);
            } else {
                super.onStateChanged();
            }
        }

        @Override
        protected void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (!this.isEnabled() && !this.filterLayers(LayerVisibilityAction.this.model.getSelectedLayers()).isEmpty() && mouseWheelEvent.getPreciseWheelRotation() < 0.0) {
                mouseWheelEvent.consume();
                LayerVisibilityAction.this.setVisibleFlag(true);
            } else {
                super.mouseWheelMoved(mouseWheelEvent);
            }
        }

        @Override
        protected void applyValueToLayer(Layer layer) {
            layer.setOpacity(this.getRealValue());
        }

        @Override
        protected void updateSliderWhileEnabled(Collection<? extends Layer> collection, boolean bl) {
            double d = 0.0;
            for (Layer layer : collection) {
                d += layer.getOpacity();
            }
            if ((d /= (double)collection.size()) == 0.0) {
                d = 1.0;
                LayerVisibilityAction.this.setVisibleFlag(true);
            }
            this.setRealValue(d);
        }

        @Override
        public String getLabel() {
            return I18n.tr("Opacity", new Object[0]);
        }

        @Override
        public ImageIcon getIcon() {
            return ImageProvider.get(LayerVisibilityAction.DIALOGS_LAYERLIST, "transparency");
        }

        @Override
        public String toString() {
            return "OpacitySlider [getRealValue()=" + this.getRealValue() + ']';
        }
    }

    private abstract class AbstractFilterSlider<T extends Layer>
    extends JPanel
    implements LayerVisibilityMenuEntry {
        private final double minValue;
        private final double maxValue;
        private final Class<T> layerClassFilter;
        protected final JSlider slider;

        AbstractFilterSlider(double d, double d2, Class<T> clazz) {
            super(new GridBagLayout());
            this.slider = new JSlider(0);
            this.minValue = d;
            this.maxValue = d2;
            this.layerClassFilter = clazz;
            this.add((Component)new JLabel(this.getIcon()), GBC.std().span(1, 2).insets(0, 0, 5, 0));
            this.add((Component)new JLabel(this.getLabel()), GBC.eol().insets(5, 0, 5, 0));
            this.add((Component)this.slider, GBC.eol());
            this.addMouseWheelListener(this::mouseWheelMoved);
            this.slider.setMaximum(100);
            int n = this.convertFromRealValue(1.0);
            this.slider.setMinorTickSpacing(n);
            this.slider.setMajorTickSpacing(n);
            this.slider.setPaintTicks(true);
            this.slider.addChangeListener(changeEvent -> this.onStateChanged());
        }

        protected void onStateChanged() {
            Collection<T> collection = this.filterLayers(LayerVisibilityAction.this.model.getSelectedLayers());
            for (Layer layer : collection) {
                this.applyValueToLayer(layer);
            }
        }

        protected void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            mouseWheelEvent.consume();
            if (!this.isEnabled()) {
                return;
            }
            double d = -1.0 * mouseWheelEvent.getPreciseWheelRotation();
            double d2 = (double)this.slider.getValue() + d * 5.0;
            d2 = d < 0.0 ? Math.floor(d2) : Math.ceil(d2);
            this.slider.setValue(Utils.clamp((int)d2, this.slider.getMinimum(), this.slider.getMaximum()));
        }

        abstract void applyValueToLayer(T var1);

        protected double getRealValue() {
            return this.convertToRealValue(this.slider.getValue());
        }

        protected double convertToRealValue(int n) {
            double d = (double)n / 100.0;
            return d * this.maxValue + (1.0 - d) * this.minValue;
        }

        protected void setRealValue(double d) {
            this.slider.setValue(this.convertFromRealValue(d));
        }

        protected int convertFromRealValue(double d) {
            int n = (int)((d - this.minValue) / (this.maxValue - this.minValue) * 100.0 + 0.5);
            return Utils.clamp(n, this.slider.getMinimum(), this.slider.getMaximum());
        }

        public abstract ImageIcon getIcon();

        public abstract String getLabel();

        @Override
        public void updateLayers(List<Layer> list, boolean bl, boolean bl2) {
            Collection<T> collection = this.filterLayers(list);
            this.setVisible(!collection.isEmpty());
            if (!collection.stream().anyMatch(Layer::isVisible)) {
                this.slider.setEnabled(false);
            } else {
                this.slider.setEnabled(true);
                this.updateSliderWhileEnabled(collection, bl2);
            }
        }

        protected Collection<T> filterLayers(List<Layer> list) {
            return Utils.filteredCollection(list, this.layerClassFilter);
        }

        protected abstract void updateSliderWhileEnabled(Collection<? extends Layer> var1, boolean var2);

        @Override
        public JComponent getPanel() {
            return this;
        }
    }

    private class VisibilityCheckbox
    extends JCheckBox
    implements LayerVisibilityMenuEntry {
        VisibilityCheckbox() {
            super(I18n.tr("Show layer", new Object[0]));
            Icon icon = UIManager.getIcon("CheckBox.icon");
            int n = icon == null ? 20 : icon.getIconWidth();
            this.setBorder(BorderFactory.createEmptyBorder(0, Math.max(29 - n, 0), 0, 0));
            this.addChangeListener(changeEvent -> LayerVisibilityAction.this.setVisibleFlag(this.isSelected()));
        }

        @Override
        public void updateLayers(List<Layer> list, boolean bl, boolean bl2) {
            this.setEnabled(!list.isEmpty());
            this.setSelected(bl && !bl2);
        }

        @Override
        public JComponent getPanel() {
            return this;
        }
    }

    private static interface LayerVisibilityMenuEntry {
        public void updateLayers(List<Layer> var1, boolean var2, boolean var3);

        public JComponent getPanel();
    }
}

