/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.draw;

import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.Optional;
import java.util.stream.Stream;

public enum SymbolShape {
    SQUARE("square", 4, 0.7853981633974483),
    CIRCLE("circle", 1, 0.0),
    TRIANGLE("triangle", 3, 1.5707963267948966),
    PENTAGON("pentagon", 5, 1.5707963267948966),
    HEXAGON("hexagon", 6, 0.0),
    HEPTAGON("heptagon", 7, 1.5707963267948966),
    OCTAGON("octagon", 8, 0.39269908169872414),
    NONAGON("nonagon", 9, 1.5707963267948966),
    DECAGON("decagon", 10, 0.0);

    private final String name;
    final int sides;
    final double rotation;

    private SymbolShape(String string2, int n2, double d) {
        this.name = string2;
        this.sides = n2;
        this.rotation = d;
    }

    public Shape shapeAround(double d, double d2, double d3) {
        Shape shape;
        double d4 = d3 / 2.0;
        switch (this) {
            case SQUARE: {
                shape = new Rectangle2D.Double(d - d4, d2 - d4, d3, d3);
                break;
            }
            case CIRCLE: {
                shape = new Ellipse2D.Double(d - d4, d2 - d4, d3, d3);
                break;
            }
            default: {
                shape = this.buildPolygon(d, d2, d4);
            }
        }
        return shape;
    }

    private Shape buildPolygon(double d, double d2, double d3) {
        GeneralPath generalPath = new GeneralPath();
        for (int i = 0; i < this.sides; ++i) {
            double d4 = Math.PI * 2 / (double)this.sides * (double)i - this.rotation;
            double d5 = d + d3 * Math.cos(d4);
            double d6 = d2 + d3 * Math.sin(d4);
            if (i == 0) {
                generalPath.moveTo(d5, d6);
                continue;
            }
            generalPath.lineTo(d5, d6);
        }
        generalPath.closePath();
        return generalPath;
    }

    public int getSides() {
        return this.sides;
    }

    public double getRotation() {
        return this.rotation;
    }

    public String getName() {
        return this.name;
    }

    public static Optional<SymbolShape> forName(String string) {
        return Stream.of(SymbolShape.values()).filter(symbolShape -> string.equals(symbolShape.name)).findAny();
    }
}

