/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.configuration.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.caching.BuildCacheServiceFactory;
import org.gradle.caching.configuration.BuildCache;
import org.gradle.caching.configuration.internal.BuildCacheConfigurationInternal;
import org.gradle.caching.configuration.internal.BuildCacheServiceRegistration;
import org.gradle.caching.configuration.internal.DefaultBuildCacheServiceRegistration;
import org.gradle.caching.local.DirectoryBuildCache;
import org.gradle.internal.Actions;
import org.gradle.internal.Cast;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.SingleMessageLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBuildCacheConfiguration
implements BuildCacheConfigurationInternal {
    public static final String BUILD_CACHE_CAN_PULL = "org.gradle.cache.tasks.pull";
    public static final String BUILD_CACHE_CAN_PUSH = "org.gradle.cache.tasks.push";
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultBuildCacheConfiguration.class);
    private final Instantiator instantiator;
    private BuildCache local;
    private BuildCache remote;
    private final boolean pullDisabled;
    private final boolean pushDisabled;
    private final Set<BuildCacheServiceRegistration> registrations;

    public DefaultBuildCacheConfiguration(Instantiator instantiator, List<BuildCacheServiceRegistration> allBuiltInBuildCacheServices, StartParameter startParameter) {
        this.instantiator = instantiator;
        this.registrations = Sets.newHashSet(allBuiltInBuildCacheServices);
        this.pullDisabled = DefaultBuildCacheConfiguration.isDisabled(startParameter, BUILD_CACHE_CAN_PULL);
        this.pushDisabled = DefaultBuildCacheConfiguration.isDisabled(startParameter, BUILD_CACHE_CAN_PUSH);
        this.local = DefaultBuildCacheConfiguration.createLocalCacheConfiguration(instantiator, DirectoryBuildCache.class);
    }

    @Override
    public BuildCache getLocal() {
        return this.local;
    }

    @Override
    public <T extends BuildCache> T local(Class<T> type) {
        return this.local(type, Actions.doNothing());
    }

    @Override
    public <T extends BuildCache> T local(Class<T> type, Action<? super T> configuration) {
        if (!type.isInstance(this.local)) {
            if (this.local != null) {
                LOGGER.info("Replacing local build cache type {} with {}", (Object)this.local.getClass().getCanonicalName(), (Object)type.getCanonicalName());
            }
            this.local = DefaultBuildCacheConfiguration.createLocalCacheConfiguration(this.instantiator, type);
        }
        BuildCache configurationObject = (BuildCache)Cast.uncheckedCast((Object)this.local);
        configuration.execute((Object)configurationObject);
        return (T)configurationObject;
    }

    @Override
    public void local(Action<? super BuildCache> configuration) {
        configuration.execute((Object)this.local);
    }

    @Override
    public BuildCache getRemote() {
        return this.remote;
    }

    @Override
    public <T extends BuildCache> T remote(Class<T> type) {
        return this.remote(type, Actions.doNothing());
    }

    @Override
    public <T extends BuildCache> T remote(Class<T> type, Action<? super T> configuration) {
        if (!type.isInstance(this.remote)) {
            if (this.remote != null) {
                LOGGER.info("Replacing remote build cache type {} with {}", (Object)this.remote.getClass().getCanonicalName(), (Object)type.getCanonicalName());
            }
            this.remote = DefaultBuildCacheConfiguration.createRemoteCacheConfiguration(this.instantiator, type);
        }
        BuildCache configurationObject = (BuildCache)Cast.uncheckedCast((Object)this.remote);
        configuration.execute((Object)configurationObject);
        return (T)configurationObject;
    }

    @Override
    public void remote(Action<? super BuildCache> configuration) {
        if (this.remote == null) {
            throw new IllegalStateException("A type for the remote build cache must be configured first.");
        }
        configuration.execute((Object)this.remote);
    }

    private static <T extends BuildCache> T createLocalCacheConfiguration(Instantiator instantiator, Class<T> type) {
        T local = DefaultBuildCacheConfiguration.createBuildCacheConfiguration(instantiator, type);
        local.setPush(true);
        return local;
    }

    private static <T extends BuildCache> T createRemoteCacheConfiguration(Instantiator instantiator, Class<T> type) {
        T remote = DefaultBuildCacheConfiguration.createBuildCacheConfiguration(instantiator, type);
        remote.setPush(false);
        return remote;
    }

    private static <T extends BuildCache> T createBuildCacheConfiguration(Instantiator instantiator, Class<T> type) {
        return (T)((BuildCache)instantiator.newInstance(type, new Object[0]));
    }

    @Override
    public <T extends BuildCache> void registerBuildCacheService(Class<T> configurationType, Class<? extends BuildCacheServiceFactory<? super T>> buildCacheServiceFactoryType) {
        Preconditions.checkNotNull(configurationType, (Object)"configurationType cannot be null.");
        Preconditions.checkNotNull(buildCacheServiceFactoryType, (Object)"buildCacheServiceFactoryType cannot be null.");
        this.registrations.add(new DefaultBuildCacheServiceRegistration(configurationType, buildCacheServiceFactoryType));
    }

    @Override
    public <T extends BuildCache> Class<? extends BuildCacheServiceFactory<T>> getBuildCacheServiceFactoryType(Class<T> configurationType) {
        for (BuildCacheServiceRegistration registration : this.registrations) {
            Class<? extends BuildCache> registeredConfigurationType = registration.getConfigurationType();
            if (!registeredConfigurationType.isAssignableFrom(configurationType)) continue;
            Class<? extends BuildCacheServiceFactory<?>> buildCacheServiceFactoryType = registration.getFactoryType();
            LOGGER.info("Found {} registered for {}", buildCacheServiceFactoryType, registeredConfigurationType);
            return (Class)Cast.uncheckedCast(buildCacheServiceFactoryType);
        }
        throw new IllegalArgumentException(String.format("No build cache service factory for configuration type '%s' could be found.", configurationType.getSuperclass().getCanonicalName()));
    }

    @Override
    public boolean isPushDisabled() {
        return this.pushDisabled;
    }

    @Override
    public boolean isPullDisabled() {
        return this.pullDisabled;
    }

    private static boolean isDisabled(StartParameter startParameter, String property) {
        String value = startParameter.getSystemPropertiesArgs().get(property);
        if (value == null) {
            value = System.getProperty(property);
        }
        if (value == null) {
            return false;
        }
        SingleMessageLogger.nagUserOfDiscontinuedProperty((String)property, (String)"Use the build cache DSL instead.");
        value = value.toLowerCase().trim();
        return value.equals("false");
    }
}

