/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.xmlimpl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.xmlimpl.Namespace;
import org.mozilla.javascript.xmlimpl.XMLLibImpl;

class NamespaceHelper {
    private XMLLibImpl lib;
    private final Map prefixToURI = new HashMap();
    private final Map uriToPrefix = new HashMap();
    private final Set undeclared = new HashSet();

    private NamespaceHelper(XMLLibImpl xMLLibImpl) {
        this.lib = xMLLibImpl;
        this.prefixToURI.put("", "");
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("");
        this.uriToPrefix.put("", hashSet);
    }

    private void declareNamespace(String string, String string2, ObjArray objArray) {
        Set set = (HashSet<String>)this.uriToPrefix.get(string2);
        if (set == null) {
            set = new HashSet<String>();
            this.uriToPrefix.put(string2, set);
        }
        if (!set.contains(string)) {
            String string3 = (String)this.prefixToURI.get(string);
            set.add(string);
            this.prefixToURI.put(string, string2);
            if (objArray != null) {
                objArray.add(new Namespace(this.lib, string, string2));
            }
            if (string3 != null) {
                set = (Set)this.uriToPrefix.get(string3);
                set.remove(string);
            }
        }
    }

    private void processName(XmlCursor xmlCursor, ObjArray objArray) {
        QName qName = xmlCursor.getName();
        String string = qName.getNamespaceURI();
        Set set = (Set)this.uriToPrefix.get(string);
        if (set == null || set.size() == 0) {
            this.undeclared.add(string);
            if (objArray != null) {
                objArray.add(new Namespace(this.lib, string));
            }
        }
    }

    private void update(XmlCursor xmlCursor, ObjArray objArray) {
        xmlCursor.push();
        while (xmlCursor.toNextToken().isAnyAttr()) {
            if (!xmlCursor.isNamespace()) continue;
            QName qName = xmlCursor.getName();
            String string = qName.getLocalPart();
            String string2 = qName.getNamespaceURI();
            this.declareNamespace(string, string2, objArray);
        }
        xmlCursor.pop();
        this.processName(xmlCursor, objArray);
        xmlCursor.push();
        boolean bl = xmlCursor.toFirstAttribute();
        while (bl) {
            this.processName(xmlCursor, objArray);
            bl = xmlCursor.toNextAttribute();
        }
        xmlCursor.pop();
    }

    public static Object[] inScopeNamespaces(XMLLibImpl xMLLibImpl, XmlCursor xmlCursor) {
        Object object;
        ObjArray objArray = new ObjArray();
        NamespaceHelper namespaceHelper = new NamespaceHelper(xMLLibImpl);
        xmlCursor.push();
        int n = 0;
        while (xmlCursor.hasPrevToken()) {
            if (xmlCursor.isContainer()) {
                xmlCursor.push();
                ++n;
            }
            xmlCursor.toParent();
        }
        for (int i = 0; i < n; ++i) {
            xmlCursor.pop();
            namespaceHelper.update(xmlCursor, null);
        }
        Iterator iterator = namespaceHelper.prefixToURI.entrySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            Namespace namespace = new Namespace(xMLLibImpl, (String)object.getKey(), (String)object.getValue());
            objArray.add(namespace);
        }
        iterator = namespaceHelper.undeclared.iterator();
        while (iterator.hasNext()) {
            object = new Namespace(xMLLibImpl, (String)((Object)iterator.next()));
            objArray.add(object);
        }
        xmlCursor.pop();
        return objArray.toArray();
    }

    static Namespace getNamespace(XMLLibImpl xMLLibImpl, XmlCursor xmlCursor, Object[] objectArray) {
        Serializable serializable;
        String string;
        String string2;
        if (xmlCursor.isProcinst()) {
            string2 = "";
            string = "";
        } else {
            serializable = xmlCursor.getName();
            string2 = ((QName)serializable).getNamespaceURI();
            string = ((QName)serializable).getPrefix();
        }
        if (objectArray == null) {
            return new Namespace(xMLLibImpl, string, string2);
        }
        serializable = null;
        for (int i = 0; i != objectArray.length; ++i) {
            String string3;
            Namespace namespace = (Namespace)objectArray[i];
            if (namespace == null || !(string3 = namespace.uri()).equals(string2)) continue;
            if (string.equals(namespace.prefix())) {
                serializable = namespace;
                break;
            }
            if (serializable != null && (((Namespace)serializable).prefix() != null || namespace.prefix() == null)) continue;
            serializable = namespace;
        }
        if (serializable == null) {
            serializable = new Namespace(xMLLibImpl, string, string2);
        }
        return serializable;
    }

    public static Object[] namespaceDeclarations(XMLLibImpl xMLLibImpl, XmlCursor xmlCursor) {
        ObjArray objArray = new ObjArray();
        NamespaceHelper namespaceHelper = new NamespaceHelper(xMLLibImpl);
        xmlCursor.push();
        int n = 0;
        while (xmlCursor.hasPrevToken()) {
            if (xmlCursor.isContainer()) {
                xmlCursor.push();
                ++n;
            }
            xmlCursor.toParent();
        }
        for (int i = 0; i < n - 1; ++i) {
            xmlCursor.pop();
            namespaceHelper.update(xmlCursor, null);
        }
        if (n > 0) {
            xmlCursor.pop();
            namespaceHelper.update(xmlCursor, objArray);
        }
        xmlCursor.pop();
        return objArray.toArray();
    }

    public static Map getAllNamespaces(XMLLibImpl xMLLibImpl, XmlCursor xmlCursor) {
        NamespaceHelper namespaceHelper = new NamespaceHelper(xMLLibImpl);
        xmlCursor.push();
        int n = 0;
        while (xmlCursor.hasPrevToken()) {
            if (xmlCursor.isContainer()) {
                xmlCursor.push();
                ++n;
            }
            xmlCursor.toParent();
        }
        for (int i = 0; i < n; ++i) {
            xmlCursor.pop();
            namespaceHelper.update(xmlCursor, null);
        }
        xmlCursor.pop();
        return namespaceHelper.prefixToURI;
    }

    public static void getNamespaces(XmlCursor xmlCursor, Map map) {
        xmlCursor.push();
        while (xmlCursor.toNextToken().isAnyAttr()) {
            if (!xmlCursor.isNamespace()) continue;
            QName qName = xmlCursor.getName();
            String string = qName.getLocalPart();
            String string2 = qName.getNamespaceURI();
            map.put(string, string2);
        }
        xmlCursor.pop();
    }

    public static void removeNamespace(XmlCursor xmlCursor, String string) {
        xmlCursor.push();
        while (xmlCursor.toNextToken().isAnyAttr()) {
            QName qName;
            if (!xmlCursor.isNamespace() || !(qName = xmlCursor.getName()).getLocalPart().equals(string)) continue;
            xmlCursor.removeXml();
            break;
        }
        xmlCursor.pop();
    }
}

