/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.util.Supplier;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.ParsedScrollId;
import org.elasticsearch.action.search.ReduceSearchPhaseException;
import org.elasticsearch.action.search.ScrollIdForNode;
import org.elasticsearch.action.search.SearchActionListener;
import org.elasticsearch.action.search.SearchPhase;
import org.elasticsearch.action.search.SearchPhaseController;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.search.TransportSearchHelper;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.internal.InternalScrollSearchRequest;
import org.elasticsearch.search.internal.InternalSearchResponse;

abstract class SearchScrollAsyncAction<T extends SearchPhaseResult>
implements Runnable {
    protected final Logger logger;
    protected final ActionListener<SearchResponse> listener;
    protected final ParsedScrollId scrollId;
    protected final DiscoveryNodes nodes;
    protected final SearchPhaseController searchPhaseController;
    protected final SearchScrollRequest request;
    private final long startTime;
    private final List<ShardSearchFailure> shardFailures = new ArrayList<ShardSearchFailure>();
    private final AtomicInteger successfulOps;

    protected SearchScrollAsyncAction(ParsedScrollId scrollId, Logger logger, DiscoveryNodes nodes, ActionListener<SearchResponse> listener, SearchPhaseController searchPhaseController, SearchScrollRequest request) {
        this.startTime = System.currentTimeMillis();
        this.scrollId = scrollId;
        this.successfulOps = new AtomicInteger(scrollId.getContext().length);
        this.logger = logger;
        this.listener = listener;
        this.nodes = nodes;
        this.searchPhaseController = searchPhaseController;
        this.request = request;
    }

    private long buildTookInMillis() {
        return Math.max(1L, System.currentTimeMillis() - this.startTime);
    }

    @Override
    public final void run() {
        ScrollIdForNode[] context = this.scrollId.getContext();
        if (context.length == 0) {
            this.listener.onFailure(new SearchPhaseExecutionException("query", "no nodes to search on", ShardSearchFailure.EMPTY_ARRAY));
            return;
        }
        final CountDown counter = new CountDown(this.scrollId.getContext().length);
        for (int i = 0; i < context.length; ++i) {
            final ScrollIdForNode target = context[i];
            DiscoveryNode node = this.nodes.get(target.getNode());
            final int shardIndex = i;
            if (node != null) {
                InternalScrollSearchRequest internalRequest = TransportSearchHelper.internalScrollSearchRequest(target.getScrollId(), this.request);
                SearchActionListener searchActionListener = new SearchActionListener<T>(null, shardIndex){

                    @Override
                    protected void setSearchShardTarget(T response) {
                        assert (((SearchPhaseResult)response).getSearchShardTarget() != null) : "search shard target must not be null";
                    }

                    @Override
                    protected void innerOnResponse(T result) {
                        assert (shardIndex == ((SearchPhaseResult)result).getShardIndex()) : "shard index mismatch: " + shardIndex + " but got: " + ((SearchPhaseResult)result).getShardIndex();
                        SearchScrollAsyncAction.this.onFirstPhaseResult(shardIndex, result);
                        if (counter.countDown()) {
                            SearchPhase phase = SearchScrollAsyncAction.this.moveToNextPhase();
                            try {
                                phase.run();
                            }
                            catch (Exception e) {
                                SearchScrollAsyncAction.this.listener.onFailure(new SearchPhaseExecutionException(phase.getName(), "Phase failed", e, ShardSearchFailure.EMPTY_ARRAY));
                            }
                        }
                    }

                    @Override
                    public void onFailure(Exception t) {
                        SearchScrollAsyncAction.this.onShardFailure("query", shardIndex, counter, target.getScrollId(), t, null, (Supplier<SearchPhase>)((Supplier)SearchScrollAsyncAction.this::moveToNextPhase));
                    }
                };
                this.executeInitialPhase(node, internalRequest, searchActionListener);
                continue;
            }
            this.onShardFailure("query", shardIndex, counter, target.getScrollId(), new IllegalStateException("node [" + target.getNode() + "] is not available"), null, (Supplier<SearchPhase>)((Supplier)this::moveToNextPhase));
        }
    }

    synchronized ShardSearchFailure[] buildShardFailures() {
        if (this.shardFailures.isEmpty()) {
            return ShardSearchFailure.EMPTY_ARRAY;
        }
        return this.shardFailures.toArray(new ShardSearchFailure[this.shardFailures.size()]);
    }

    private synchronized void addShardFailure(ShardSearchFailure failure) {
        this.shardFailures.add(failure);
    }

    protected abstract void executeInitialPhase(DiscoveryNode var1, InternalScrollSearchRequest var2, SearchActionListener<T> var3);

    protected abstract SearchPhase moveToNextPhase();

    protected abstract void onFirstPhaseResult(int var1, T var2);

    protected SearchPhase sendResponsePhase(final SearchPhaseController.ReducedQueryPhase queryPhase, final AtomicArray<? extends SearchPhaseResult> fetchResults) {
        return new SearchPhase("fetch"){

            @Override
            public void run() throws IOException {
                SearchScrollAsyncAction.this.sendResponse(queryPhase, fetchResults);
            }
        };
    }

    protected final void sendResponse(SearchPhaseController.ReducedQueryPhase queryPhase, AtomicArray<? extends SearchPhaseResult> fetchResults) {
        try {
            InternalSearchResponse internalResponse = this.searchPhaseController.merge(true, queryPhase, fetchResults.asList(), fetchResults::get);
            String scrollId = null;
            if (this.request.scroll() != null) {
                scrollId = this.request.scrollId();
            }
            this.listener.onResponse(new SearchResponse(internalResponse, scrollId, this.scrollId.getContext().length, this.successfulOps.get(), this.buildTookInMillis(), this.buildShardFailures()));
        }
        catch (Exception e) {
            this.listener.onFailure(new ReduceSearchPhaseException("fetch", "inner finish failed", e, this.buildShardFailures()));
        }
    }

    protected void onShardFailure(String phaseName, int shardIndex, CountDown counter, long searchId, Exception failure, @Nullable SearchShardTarget searchShardTarget, Supplier<SearchPhase> nextPhaseSupplier) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(() -> new ParameterizedMessage("[{}] Failed to execute {} phase", (Object)searchId, (Object)phaseName), (Throwable)failure);
        }
        this.addShardFailure(new ShardSearchFailure(failure, searchShardTarget));
        int successfulOperations = this.successfulOps.decrementAndGet();
        assert (successfulOperations >= 0) : "successfulOperations must be >= 0 but was: " + successfulOperations;
        if (counter.countDown()) {
            if (this.successfulOps.get() == 0) {
                this.listener.onFailure(new SearchPhaseExecutionException(phaseName, "all shards failed", failure, this.buildShardFailures()));
            } else {
                SearchPhase phase = (SearchPhase)nextPhaseSupplier.get();
                try {
                    phase.run();
                }
                catch (Exception e) {
                    e.addSuppressed(failure);
                    this.listener.onFailure(new SearchPhaseExecutionException(phase.getName(), "Phase failed", e, ShardSearchFailure.EMPTY_ARRAY));
                }
            }
        }
    }
}

