/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.util;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public final class Statistic {
    private volatile transient long count;
    private volatile transient long max;
    private volatile transient long min;
    private volatile transient long total;
    private static TreeMap statisticMap = new TreeMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Statistic createEntry(String useCase) {
        TreeMap treeMap = statisticMap;
        synchronized (treeMap) {
            Statistic statistic = null;
            if (statisticMap.containsKey(useCase)) {
                statistic = (Statistic)statisticMap.get(useCase);
            } else {
                statistic = new Statistic();
                statisticMap.put(useCase, statistic);
            }
            return statistic;
        }
    }

    public static long getTimeMeasure() {
        return System.currentTimeMillis();
    }

    private Statistic() {
        this.clear();
    }

    public final void add(long sampleValue) {
        if (sampleValue > 0L) {
            if (sampleValue > this.max) {
                this.max = sampleValue;
            }
            if (sampleValue < this.min || this.min == 0L) {
                this.min = sampleValue;
            }
            this.total += sampleValue;
            ++this.count;
        }
    }

    public void clear() {
        this.count = 0L;
        this.max = 0L;
        this.min = 0L;
        this.total = 0L;
    }

    public static final void clearAll() {
        Iterator iterator = statisticMap.values().iterator();
        while (iterator.hasNext()) {
            ((Statistic)iterator.next()).clear();
        }
    }

    public static final void dump(PrintWriter out) {
        for (Map.Entry e : statisticMap.entrySet()) {
            Statistic s = (Statistic)e.getValue();
            if (s.count <= 0L) continue;
            out.println("Use-Case: " + e.getKey());
            out.println("  Count  = " + s.count);
            out.println("  Min    = " + s.min);
            out.println("  Max    = " + s.max);
            out.println("  Average= " + (double)s.total / (double)s.count);
            out.println("  Total  = " + s.total);
        }
        out.flush();
    }
}

