/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import org.elasticsearch.index.analysis.AnalyzerScope;

public class NamedAnalyzer
extends DelegatingAnalyzerWrapper {
    private final String name;
    private final AnalyzerScope scope;
    private final Analyzer analyzer;
    private final int positionIncrementGap;
    static final Analyzer.ReuseStrategy ERROR_STRATEGY = new Analyzer.ReuseStrategy(){

        public Analyzer.TokenStreamComponents getReusableComponents(Analyzer a, String f) {
            throw new IllegalStateException("NamedAnalyzer cannot be wrapped with a wrapper, only a delegator");
        }

        public void setReusableComponents(Analyzer a, String f, Analyzer.TokenStreamComponents c) {
            throw new IllegalStateException("NamedAnalyzer cannot be wrapped with a wrapper, only a delegator");
        }
    };

    public NamedAnalyzer(NamedAnalyzer analyzer, int positionIncrementGap) {
        this(analyzer.name(), analyzer.scope(), analyzer.analyzer(), positionIncrementGap);
    }

    public NamedAnalyzer(String name, AnalyzerScope scope, Analyzer analyzer) {
        this(name, scope, analyzer, Integer.MIN_VALUE);
    }

    public NamedAnalyzer(String name, AnalyzerScope scope, Analyzer analyzer, int positionIncrementGap) {
        super(ERROR_STRATEGY);
        this.name = name;
        this.scope = scope;
        this.analyzer = analyzer;
        this.positionIncrementGap = positionIncrementGap;
    }

    public String name() {
        return this.name;
    }

    public AnalyzerScope scope() {
        return this.scope;
    }

    public Analyzer analyzer() {
        return this.analyzer;
    }

    protected Analyzer getWrappedAnalyzer(String fieldName) {
        return this.analyzer;
    }

    public int getPositionIncrementGap(String fieldName) {
        if (this.positionIncrementGap != Integer.MIN_VALUE) {
            return this.positionIncrementGap;
        }
        return super.getPositionIncrementGap(fieldName);
    }

    public String toString() {
        return "analyzer name[" + this.name + "], analyzer [" + this.analyzer + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NamedAnalyzer)) {
            return false;
        }
        NamedAnalyzer that = (NamedAnalyzer)((Object)o);
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public void close() {
        super.close();
        if (this.scope == AnalyzerScope.INDEX) {
            this.analyzer.close();
        }
    }
}

