/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.rest.action.RestStatusToXContentListener;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.StoredFieldsContext;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.search.suggest.SuggestBuilder;
import org.elasticsearch.search.suggest.SuggestBuilders;
import org.elasticsearch.search.suggest.term.TermSuggestionBuilder;

public class RestSearchAction
extends BaseRestHandler {
    public static final String TYPED_KEYS_PARAM = "typed_keys";
    private static final Set<String> RESPONSE_PARAMS = Collections.singleton("typed_keys");

    public RestSearchAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_search", this);
        controller.registerHandler(RestRequest.Method.POST, "/_search", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_search", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_search", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_search", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_search", this);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        SearchRequest searchRequest = new SearchRequest();
        request.withContentOrSourceParamParserOrNull(parser -> RestSearchAction.parseSearchRequest(searchRequest, request, parser));
        return channel -> client.search(searchRequest, new RestStatusToXContentListener<SearchResponse>((RestChannel)channel));
    }

    public static void parseSearchRequest(SearchRequest searchRequest, RestRequest request, XContentParser requestContentParser) throws IOException {
        if (searchRequest.source() == null) {
            searchRequest.source(new SearchSourceBuilder());
        }
        searchRequest.indices(Strings.splitStringByCommaToArray(request.param("index")));
        if (requestContentParser != null) {
            QueryParseContext context = new QueryParseContext(requestContentParser);
            searchRequest.source().parseXContent(context);
        }
        int batchedReduceSize = request.paramAsInt("batched_reduce_size", searchRequest.getBatchedReduceSize());
        searchRequest.setBatchedReduceSize(batchedReduceSize);
        String searchType = request.param("search_type");
        if ("query_and_fetch".equals(searchType) || "dfs_query_and_fetch".equals(searchType)) {
            throw new IllegalArgumentException("Unsupported search type [" + searchType + "]");
        }
        searchRequest.searchType(searchType);
        RestSearchAction.parseSearchSource(searchRequest.source(), request);
        searchRequest.requestCache(request.paramAsBoolean("request_cache", null));
        String scroll = request.param("scroll");
        if (scroll != null) {
            searchRequest.scroll(new Scroll(TimeValue.parseTimeValue(scroll, null, "scroll")));
        }
        searchRequest.types(Strings.splitStringByCommaToArray(request.param("type")));
        searchRequest.routing(request.param("routing"));
        searchRequest.preference(request.param("preference"));
        searchRequest.indicesOptions(IndicesOptions.fromRequest(request, searchRequest.indicesOptions()));
    }

    private static void parseSearchSource(SearchSourceBuilder searchSourceBuilder, RestRequest request) {
        String suggestField;
        String sStats;
        String sSorts;
        FetchSourceContext fetchSourceContext;
        String sDocValueFields;
        int size;
        int from;
        QueryBuilder queryBuilder = RestActions.urlParamsToQueryBuilder(request);
        if (queryBuilder != null) {
            searchSourceBuilder.query(queryBuilder);
        }
        if ((from = request.paramAsInt("from", -1)) != -1) {
            searchSourceBuilder.from(from);
        }
        if ((size = request.paramAsInt("size", -1)) != -1) {
            searchSourceBuilder.size(size);
        }
        if (request.hasParam("explain")) {
            searchSourceBuilder.explain(request.paramAsBoolean("explain", null));
        }
        if (request.hasParam("version")) {
            searchSourceBuilder.version(request.paramAsBoolean("version", null));
        }
        if (request.hasParam("timeout")) {
            searchSourceBuilder.timeout(request.paramAsTime("timeout", null));
        }
        if (request.hasParam("terminate_after")) {
            int terminateAfter = request.paramAsInt("terminate_after", 0);
            if (terminateAfter < 0) {
                throw new IllegalArgumentException("terminateAfter must be > 0");
            }
            if (terminateAfter > 0) {
                searchSourceBuilder.terminateAfter(terminateAfter);
            }
        }
        if (request.param("fields") != null) {
            throw new IllegalArgumentException("The parameter [" + SearchSourceBuilder.FIELDS_FIELD + "] is no longer supported, please use [" + SearchSourceBuilder.STORED_FIELDS_FIELD + "] to retrieve stored fields or _source filtering if the field is not stored");
        }
        StoredFieldsContext storedFieldsContext = StoredFieldsContext.fromRestRequest(SearchSourceBuilder.STORED_FIELDS_FIELD.getPreferredName(), request);
        if (storedFieldsContext != null) {
            searchSourceBuilder.storedFields(storedFieldsContext);
        }
        if ((sDocValueFields = request.param("docvalue_fields")) == null) {
            sDocValueFields = request.param("fielddata_fields");
        }
        if (sDocValueFields != null && Strings.hasText(sDocValueFields)) {
            String[] sFields;
            for (String field : sFields = Strings.splitStringByCommaToArray(sDocValueFields)) {
                searchSourceBuilder.docValueField(field);
            }
        }
        if ((fetchSourceContext = FetchSourceContext.parseFromRestRequest(request)) != null) {
            searchSourceBuilder.fetchSource(fetchSourceContext);
        }
        if (request.hasParam("track_scores")) {
            searchSourceBuilder.trackScores(request.paramAsBoolean("track_scores", false));
        }
        if ((sSorts = request.param("sort")) != null) {
            String[] sorts;
            for (String sort : sorts = Strings.splitStringByCommaToArray(sSorts)) {
                int delimiter = sort.lastIndexOf(":");
                if (delimiter != -1) {
                    String sortField = sort.substring(0, delimiter);
                    String reverse = sort.substring(delimiter + 1);
                    if ("asc".equals(reverse)) {
                        searchSourceBuilder.sort(sortField, SortOrder.ASC);
                        continue;
                    }
                    if (!"desc".equals(reverse)) continue;
                    searchSourceBuilder.sort(sortField, SortOrder.DESC);
                    continue;
                }
                searchSourceBuilder.sort(sort);
            }
        }
        if ((sStats = request.param("stats")) != null) {
            searchSourceBuilder.stats(Arrays.asList(Strings.splitStringByCommaToArray(sStats)));
        }
        if ((suggestField = request.param("suggest_field")) != null) {
            String suggestText = request.param("suggest_text", request.param("q"));
            int suggestSize = request.paramAsInt("suggest_size", 5);
            String suggestMode = request.param("suggest_mode");
            searchSourceBuilder.suggest(new SuggestBuilder().addSuggestion(suggestField, ((TermSuggestionBuilder)((TermSuggestionBuilder)SuggestBuilders.termSuggestion(suggestField).text(suggestText)).size(suggestSize)).suggestMode(TermSuggestionBuilder.SuggestMode.resolve(suggestMode))));
        }
    }

    @Override
    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }
}

